/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DebugLog;
import cerent.cms.route.DropPath;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.InvalidCircuitPath;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.CircuitOptDir;
import java.util.Iterator;
import java.util.LinkedList;

public class OchncPathFilter
extends PathFilter {
    boolean isBidirectional = false;
    RoutePrefs revPrefs;

    public OchncPathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        super(routePrefs, iGranularityFilter);
        if (routePrefs.getDirectionality() == 3) {
            this.isBidirectional = true;
        }
        if (!routePrefs.getOptDirRoute()) {
            routePrefs.getLog().getDebugLog().info("OchncPathFilter - Adding required link to fwd prefs");
            routePrefs.addFirstDwdmLink();
        }
        if (this.isBidirectional) {
            this.revPrefs = routePrefs.getReversePrefs();
        }
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        CircuitPath circuitPath = super.getCircuitPath();
        NoRoute noRoute = null;
        if (this.isBidirectional) {
            try {
                this.prefs.getLog().getDebugLog().info(" ===================== ");
                DropPath dropPath = this.computeReversePath(circuitPath.getPathLinks());
                this.prefs.getLog().getDebugLog().info(" ===================== ");
                try {
                    this.prefs.getLog().getDebugLog().info(" ===================== ");
                    circuitPath.setReverseDropPath(dropPath);
                    this.prefs.getLog().getDebugLog().info(" ===================== ");
                    LinkedList linkedList = circuitPath.getDropPath().getSpans();
                    LinkedList linkedList2 = circuitPath.getReverseDropPath().getSpans();
                    if (linkedList.size() != linkedList2.size()) {
                        noRoute = new NoRoute("Forward and reverse spans have different paths.\n==================\nForward path:\n------------\n" + circuitPath.getDropPath().prettyString() + "\n==================\n" + "Reverse path:\n" + "------------\n" + circuitPath.getReverseDropPath().prettyString());
                    } else {
                        Iterator iterator = linkedList.iterator();
                        int n = -1;
                        while (n == -1 && iterator.hasNext()) {
                            INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                            if (!iNetLinkSpan.getSrc().equals(this.prefs.getSrc())) continue;
                            n = iNetLinkSpan.getLink().getSrcSlotNumber();
                        }
                        iterator = linkedList2.iterator();
                        int n2 = -1;
                        while (n2 == -1 && iterator.hasNext()) {
                            INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                            if (!iNetLinkSpan.getDst().equals(this.prefs.getSrc())) continue;
                            n2 = iNetLinkSpan.getLink().getDstSlotNumber();
                        }
                        if (n != n2) {
                            throw new NoRoute("Cannot use the computed path since forward path originates from slot " + n + "of node " + this.prefs.getSrc().prettyString() + ",but reverse path terminates on slot " + n2 + ".\n==================\n" + "Forward path:\n" + "------------\n" + circuitPath.getDropPath().prettyString() + "\n==================\n" + "Reverse path:\n" + "------------\n" + circuitPath.getReverseDropPath().prettyString());
                        }
                    }
                }
                catch (InvalidCircuitPath invalidCircuitPath) {
                    this.prefs.getLog().getDebugLog().info("Reverse Drop Path already set");
                    throw new NoRoute(invalidCircuitPath.getMessage(), this.prefs.getLog().getDetailedLog());
                }
            }
            catch (NoRoute noRoute2) {
                this.prefs.getLog().getDebugLog().info("No reverse Path exists for one of the segments");
                throw noRoute2;
            }
        }
        if (noRoute != null) {
            throw noRoute;
        }
        return circuitPath;
    }

    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        INetLink iNetLink;
        DebugLog debugLog = this.prefs.getLog().getDebugLog();
        if (this.isBidirectional && this.prefs.getOptDirRoute() && (iNetLink = sptLink.getLink()) instanceof DwdmNetLink) {
            DwdmNetLink dwdmNetLink;
            DwdmNetLink dwdmNetLink2 = (DwdmNetLink)iNetLink;
            if (dwdmNetLink2.getOptLinkDir() == this.prefs.getcktOptDir() && !(dwdmNetLink = dwdmNetLink2.getOppositeLink()).availBW(this.revPrefs)) {
                throw new xLinkNotUsable("Unavailable Channel between " + this.revPrefs.getSrc().prettyString() + " and " + this.revPrefs.getDst().prettyString() + (this.revPrefs.getOptDirRoute() ? " optdir: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(this.revPrefs.getcktOptDir()) : ""));
            }
            if (debugLog.on()) {
                debugLog.println(" ===================== ");
            }
        }
        return super.isUsable(sptLink);
    }

    protected DropPath computeReversePath(LinkedList linkedList) throws NoRoute {
        CircuitPath circuitPath = null;
        AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(this.revPrefs);
        circuitPath = autoRouteRequestor.getCircuitPath();
        return circuitPath.getDropPath();
    }
}

