/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.CircuitPath;
import cerent.cms.route.DropPath;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.InvalidCircuitPath;
import cerent.cms.route.MemberPath;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.Spt;
import cerent.cms.route.SptLink;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.util.ILabel;
import java.util.Iterator;
import java.util.LinkedList;

public class PathFilter
implements IPathFilter {
    protected RoutePrefs prefs;
    protected IGranularityFilter gFilter;

    public PathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        this.prefs = routePrefs;
        this.gFilter = iGranularityFilter;
    }

    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        if (sptLink.getLink().getLinksList().size() > 1 && !this.prefs.getTunnelsAllowed()) {
            throw new xLinkNotUsable("Path Filter: Tunnels are not allowed for this path computation");
        }
        if (!this.prefs.isOchncCircuit() && !this.prefs.isOchTrailTunnelCircuit() && sptLink.getLink() instanceof DwdmNetLink) {
            throw new xLinkNotUsable("DWDM Link can be used only for Optical Channel circuits");
        }
        if (!this.prefs.isOchTrailTunnelCircuit() && !this.prefs.isOchTrailCircuit() && sptLink.getLink() instanceof VirtualNetLink) {
            throw new xLinkNotUsable("PPC Link can be used only for OchTrail/Tunnel circuits");
        }
        if (!this.prefs.isOchTrailCircuit() && sptLink.getLink() instanceof OchTrailTunnelNetLink) {
            throw new xLinkNotUsable("OTT Link can be used only for OchTrail circuits");
        }
        if (this.prefs.isOchncCircuit() && !(sptLink.getLink() instanceof DwdmNetLink)) {
            throw new xLinkNotUsable("Optical Channel circuits can be supported only on DWDM Links");
        }
        if (this.prefs.isOchTrailTunnelCircuit() && !(sptLink.getLink() instanceof VirtualNetLink) && !(sptLink.getLink() instanceof DwdmNetLink)) {
            throw new xLinkNotUsable("OChTrail Tunnel circuits can be supported only on PPC/DWDM Links");
        }
        if (this.prefs.isOchTrailCircuit() && !(sptLink.getLink() instanceof VirtualNetLink) && !(sptLink.getLink() instanceof OchTrailTunnelNetLink)) {
            throw new xLinkNotUsable("OChTrail circuits can be supported only on PPC/OTT Links");
        }
        if (!this.prefs.getPathOnly() && sptLink.getLink() instanceof OscNetLink) {
            throw new xLinkNotUsable("OSC Link can be used only for OverHead circuits");
        }
        return this.gFilter.isUsable(sptLink);
    }

    public boolean isUsableByParent(SptLink sptLink) throws xLinkNotUsable {
        return true;
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        LinkedList linkedList = this.getPathLinks();
        return this.buildCircuitPath(linkedList);
    }

    protected CircuitPath buildCircuitPath(LinkedList linkedList) {
        CircuitPath circuitPath = new CircuitPath(this.prefs);
        DropPath dropPath = new DropPath(circuitPath);
        try {
            circuitPath.setDropPath(dropPath);
        }
        catch (InvalidCircuitPath invalidCircuitPath) {
            this.prefs.getLog().getDebugLog().info("Invalid Drop Path");
        }
        MemberPath[] memberPathArray = new MemberPath[this.prefs.getMemberCount()];
        for (int i = 0; i < this.prefs.getMemberCount(); ++i) {
            memberPathArray[i] = new MemberPath(dropPath);
            dropPath.addMemberPath(memberPathArray[i]);
            LinkedList linkedList2 = this.computeCircuitPathSegments(linkedList, i);
            memberPathArray[i].addPathSegments(linkedList2);
            memberPathArray[i].setMemberPrefs(this.prefs.getActiveDropPrefs().getActiveMemberGroupPrefs().getActiveMember());
        }
        this.prefs.getLog().getDebugLog().info(circuitPath.prettyString());
        return circuitPath;
    }

    protected LinkedList computeCircuitPathSegments(LinkedList linkedList, int n) {
        LinkedList<PathSegment> linkedList2 = new LinkedList<PathSegment>();
        PathSegment pathSegment = new PathSegment(this.prefs.getSrc(), this.prefs.getDst());
        LinkedList<NetLinkSpan> linkedList3 = new LinkedList<NetLinkSpan>();
        Iterator iterator = linkedList.iterator();
        Object var7_7 = null;
        while (iterator.hasNext()) {
            SptLink sptLink = (SptLink)iterator.next();
            ILabelSet iLabelSet = sptLink.getSrcLabelSet();
            ILabelSet iLabelSet2 = sptLink.getDstLabelSet();
            ILabel[] iLabelArray = iLabelSet.getLabels(this.prefs.getMemberCount());
            ILabel[] iLabelArray2 = iLabelSet2.getLabels(this.prefs.getMemberCount());
            NetLinkSpan netLinkSpan = new NetLinkSpan(sptLink.getLink(), sptLink.getLink().getReverseLink(), iLabelArray[n], iLabelArray2[n]);
            linkedList3.add(netLinkSpan);
        }
        if (linkedList != null) {
            pathSegment.setPrimary(linkedList3);
            linkedList2.add(pathSegment);
        }
        return linkedList2;
    }

    public LinkedList getPathLinks() throws NoRoute {
        Spt spt = new Spt(this.prefs, this);
        spt.computeRoute();
        return spt.getPathLinks();
    }

    public INetElement[] getReachableNodes() {
        Spt spt = new Spt(this.prefs, this);
        return spt.computeReachableNodes();
    }
}

