/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.BrLineProtectedPathFilter;
import cerent.cms.route.DriPathFilter;
import cerent.cms.route.DriSecondaryPathFilter;
import cerent.cms.route.FullyLineProtectedPathFilter;
import cerent.cms.route.FullyUnprotectedPathFilter;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.OchncPathFilter;
import cerent.cms.route.PathFilter;
import cerent.cms.route.PreemptiblePathFilter;
import cerent.cms.route.ProtectedPathFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.UnprotectedPathFilter;

public class PathFilterFactory {
    public static IPathFilter create(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        if (routePrefs.isOchncCircuit() || routePrefs.isOchTrailTunnelCircuit()) {
            return new OchncPathFilter(routePrefs, iGranularityFilter);
        }
        if (routePrefs.isOchTrailCircuit()) {
            if (routePrefs.getPathProt() == 1) {
                return new ProtectedPathFilter(routePrefs, iGranularityFilter);
            }
            return new PathFilter(routePrefs, iGranularityFilter);
        }
        switch (routePrefs.getPathProt()) {
            case 8: {
                return new PathFilter(routePrefs, iGranularityFilter);
            }
            case 4: {
                return new PreemptiblePathFilter(routePrefs, iGranularityFilter);
            }
            case 3: {
                return new FullyUnprotectedPathFilter(routePrefs, iGranularityFilter);
            }
            case 2: {
                return new UnprotectedPathFilter(routePrefs, iGranularityFilter);
            }
            case 6: {
                return new FullyLineProtectedPathFilter(routePrefs, iGranularityFilter);
            }
            case 7: {
                return new BrLineProtectedPathFilter(routePrefs, iGranularityFilter);
            }
            case 5: {
                return new DriPathFilter(routePrefs, iGranularityFilter);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                return new DriSecondaryPathFilter(routePrefs, iGranularityFilter);
            }
        }
        return new ProtectedPathFilter(routePrefs, iGranularityFilter);
    }
}

