/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.INetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class PathSegment {
    private LinkedList primary = new LinkedList();
    private LinkedList alternate = new LinkedList();
    private LinkedList dri = new LinkedList();
    INetElement src;
    INetElement dst;

    public PathSegment() {
    }

    public PathSegment(INetElement iNetElement, INetElement iNetElement2) {
        this();
        this.src = iNetElement;
        this.dst = iNetElement2;
    }

    public INetElement getSrc() {
        return this.src;
    }

    public INetElement getAlternateSrc() {
        if (this.alternate.isEmpty()) {
            return null;
        }
        return ((INetLinkSpan)this.alternate.get(0)).getSrc();
    }

    public INetElement getDst() {
        return this.dst;
    }

    public INetElement getAlternateDst() {
        if (this.alternate.isEmpty()) {
            return null;
        }
        return ((INetLinkSpan)this.alternate.get(this.alternate.size() - 1)).getDst();
    }

    public boolean isProtected() {
        return this.isPathProtected() || this.isLineProtected();
    }

    public boolean isPathProtected() {
        return !this.alternate.isEmpty();
    }

    public boolean isLineProtected() {
        if (this.isPathProtected()) {
            return false;
        }
        Iterator iterator = this.primary.iterator();
        while (iterator.hasNext()) {
            INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
            if (iNetLinkSpan.getLink().isFullyLineProtected()) continue;
            return false;
        }
        return true;
    }

    public void setSrc(INetElement iNetElement) {
        this.src = iNetElement;
    }

    public void setDst(INetElement iNetElement) {
        this.dst = iNetElement;
    }

    public LinkedList getPrimary() {
        return this.primary;
    }

    public LinkedList getPrimaryLinks() {
        return this.getSegmentLinks(this.primary);
    }

    public LinkedList getAlternate() {
        return this.alternate;
    }

    public LinkedList getAlternateLinks() {
        return this.getSegmentLinks(this.alternate);
    }

    public LinkedList getDri() {
        return this.dri;
    }

    public LinkedList getDriLinks() {
        return this.getSegmentLinks(this.dri);
    }

    private LinkedList getSegmentLinks(LinkedList linkedList) {
        LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
        if (linkedList == null) {
            return linkedList2;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
            INetLink iNetLink = iNetLinkSpan.getLink();
            linkedList2.add(iNetLink);
        }
        return linkedList2;
    }

    public LinkedList getDriLinkSpans() {
        return this.getSegmentLinkSpans(this.dri);
    }

    private LinkedList getSegmentLinkSpans(LinkedList linkedList) {
        LinkedList<INetLinkSpan> linkedList2 = new LinkedList<INetLinkSpan>();
        if (linkedList == null) {
            return linkedList2;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
            linkedList2.add(iNetLinkSpan);
        }
        return linkedList2;
    }

    public void setPrimary(LinkedList linkedList) {
        if (linkedList == null) {
            return;
        }
        this.primary = linkedList;
        if (linkedList.size() != 0) {
            INetLinkSpan iNetLinkSpan = (INetLinkSpan)linkedList.get(0);
            this.src = iNetLinkSpan.getLink().getSrc();
            iNetLinkSpan = (INetLinkSpan)linkedList.get(linkedList.size() - 1);
            this.dst = iNetLinkSpan.getLink().getDst();
        }
    }

    public void setAlternate(LinkedList linkedList) {
        if (linkedList == null) {
            return;
        }
        this.alternate = linkedList;
    }

    public void setDri(LinkedList linkedList) {
        if (linkedList == null) {
            return;
        }
        this.dri.addAll(linkedList);
    }

    public String prettyString() {
        return "\n\tPrimary   : " + this.prettyString(this.primary) + "\n\tAlternate : " + this.prettyString(this.alternate) + "\n\tDRI       : " + this.prettyString(this.dri);
    }

    private String prettyString(List list) {
        String string = "";
        if (list == null || list.isEmpty()) {
            return "NULL";
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
            string = string + "\n\t" + iNetLinkSpan.prettyString();
        }
        return string;
    }

    protected boolean contains(INetElement iNetElement) {
        return this.getSrc() == iNetElement || this.getDst() == iNetElement;
    }
}

