/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkPhysicalType;
import cerent.cms.model.ILinkType;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.INetLinkType;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.LinkPhysicalType;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetLinkType;
import cerent.cms.model.NetProtectionType;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.HoLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.ISrg;
import cerent.cms.route.LoLabelSet;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NodeSrg;
import cerent.cms.route.PortSrg;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SlotSrg;
import cerent.cms.route.SrgList;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractNetLink
extends CmsObservable
implements INetLink,
IObserver {
    static final short NOT_BLSR = -1;
    static final short ANY_BLSR = -1;
    static final short NO_SLOT = -1;
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    protected static final ILoAditModel[] ILoAditModelArrayTemplate = new ILoAditModel[0];
    protected Network net;
    protected ILinkModel linkModel;
    protected INetElement src;
    protected INetElement dst;
    protected ArrayList nodesList;
    protected ArrayList linksList;
    protected boolean srcExtendable;
    protected boolean dstExtendable;
    protected boolean deleted;
    protected int srcSlot = 0;
    protected int[] srcPort = new int[0];
    protected int dstSlot = 0;
    protected int[] dstPort = new int[0];
    protected boolean sdccLink;
    protected int topoId;
    protected Topology topology;
    protected Integer sla;
    protected SDebug db;
    protected static SDebug dbg = new SDebug("NetLink");
    private long timestamp;

    protected AbstractNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n) {
        this.net = network;
        this.linkModel = iLinkModel;
        this.src = iNetElement;
        this.dst = iNetElement2;
        this.linksList = new ArrayList();
        this.linksList.add(this);
        this.nodesList = new ArrayList();
        this.srcExtendable = true;
        this.dstExtendable = true;
        this.sdccLink = bl;
        this.topology = topology;
        this.topoId = n;
        this.sla = null;
        this.nodesList.add(iNetElement);
        this.nodesList.add(iNetElement2);
        this.deleted = false;
        this.timestamp = System.currentTimeMillis();
        this.initializeDebug();
        if (dbg.on()) {
            this.db.set(true);
        }
        this.acquireSrcSlotAndPort();
        this.acquireDstSlotAndPort();
    }

    protected AbstractNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        this(network, iLinkModel, iNetElement, iNetElement2, bl, network.getDefaultTopo(), 0);
    }

    protected AbstractNetLink(INetElement iNetElement, INetElement iNetElement2) {
        this(Network.instance(), null, iNetElement, iNetElement2, false, Network.instance().getDefaultTopo(), 0);
    }

    protected AbstractNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, boolean bl, LinkedList linkedList, LinkedList linkedList2) {
        Object object;
        this.net = network;
        this.linkModel = iLinkModel;
        this.src = iNetElement;
        this.dst = iNetElement2;
        this.sdccLink = bl;
        this.linksList = new ArrayList();
        this.nodesList = new ArrayList();
        this.topology = topology;
        this.topoId = n;
        linkedList.add(iNetElement);
        linkedList.add(iNetElement2);
        this.srcExtendable = true;
        this.dstExtendable = true;
        this.deleted = false;
        this.initializeDebug();
        if (dbg.on()) {
            this.db.set(true);
        }
        this.acquireSrcSlotAndPort();
        this.acquireDstSlotAndPort();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (INetElement)iterator.next();
            if (this.nodesList.contains(object)) continue;
            this.nodesList.add(object);
        }
        object = linkedList2.iterator();
        while (object.hasNext()) {
            INetLink iNetLink = (INetLink)object.next();
            if (this.linksList.contains(iNetLink)) continue;
            this.linksList.add(iNetLink);
        }
        this.timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public abstract void newState(int var1);

    protected abstract void setChecking(boolean var1);

    protected abstract boolean inChecking();

    protected String protectionTypeToString() {
        switch (this.getProtectionType()) {
            case 0: {
                return "2F-BLSR";
            }
            case 1: {
                return "1+1";
            }
            case 2: {
                return "LOT";
            }
            case 3: {
                return "Unprotected";
            }
            case 4: {
                return "4F-BLSR";
            }
            case 5: {
                return "2F-PCA";
            }
            case 6: {
                return "4F-PCA";
            }
            case 7: {
                return "Y-Cable";
            }
            case 8: {
                return "Splitter";
            }
            case 10: {
                return "Protected";
            }
            case 11: {
                return "BLSR";
            }
            case 12: {
                return "UPSR";
            }
            case 13: {
                return "PCA";
            }
            case 14: {
                return "Lost";
            }
            case 15: {
                return "Unknown";
            }
            case 16: {
                return "None";
            }
            case 17: {
                return "DRI";
            }
        }
        return "?????";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(!this.isPca() ? "[NL_" : "[NLp_");
        stringBuffer.append(this.src.getName() + "/");
        stringBuffer.append("s" + this.getSrcSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getSrcPortNumber()) + " -> ");
        stringBuffer.append(this.dst.getName() + "/");
        stringBuffer.append("s" + this.getDstSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getDstPortNumber()) + " (" + this.timestamp + ")]");
        return stringBuffer.toString();
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.src.getName() + "/");
        stringBuffer.append("s" + this.getSrcSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getSrcPortNumber()) + " -> ");
        stringBuffer.append(this.dst.getName() + "/");
        stringBuffer.append("s" + this.getDstSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getDstPortNumber()));
        return stringBuffer.toString();
    }

    public String prettyString() {
        return this.src.prettyString() + "(" + Integer.toHexString(this.linkModel.srcEntityIndex()) + (this.linkModel.srcHo() == null ? "" : ":" + this.linkModel.srcHo()) + ")" + "->" + this.dst.prettyString() + "(" + Integer.toHexString(this.linkModel.dstEntityIndex()) + (this.linkModel.dstHo() == null ? "" : ":" + this.linkModel.dstHo()) + "). " + "(" + EnumStrings.getString((Class)INetLinkType.class, (int)this.getLinkType()) + ", " + EnumStrings.getString((Class)ILinkType.class, (int)this.getPhysicalLinkType()) + (this.getSla() != null ? "SLA " + this.getSla().shortValue() + ", " : " ") + this.protectionTypeToString() + ", " + "State=" + (this.state() == 1 ? "Up)." : "Down).");
    }

    public String prettyStringDetail() {
        return this.prettyString();
    }

    public ILinkModel getLinkModel() {
        return this.linkModel;
    }

    public INodeModel topoHost() {
        return this.linkModel.topoHost();
    }

    public int getDstEntityIndex() {
        return this.linkModel.dstEntityIndex();
    }

    public int getSrcEntityIndex() {
        return this.linkModel.srcEntityIndex();
    }

    public int[] getDstPortNumber() {
        return this.dstPort;
    }

    public int getDstSlotNumber() {
        return this.dstSlot;
    }

    public int[] getSrcPortNumber() {
        return this.srcPort;
    }

    public int getSrcSlotNumber() {
        return this.srcSlot;
    }

    public IHoNum getSrcHo() {
        return this.linkModel.srcHo();
    }

    public IHoNum getDstHo() {
        return this.linkModel.dstHo();
    }

    public abstract int state();

    public int getCost() {
        return this.linkModel.cost();
    }

    public void addSrlg(ISrg iSrg) throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    public void removeSrlg(ISrg iSrg) throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    public void clearSrlg() throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    public LinkedList getSrlgList() throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    public int getProtectionRole() {
        return this.linkModel.protectionRole();
    }

    public int getPhysicalType() {
        return this.linkModel.physicalType();
    }

    public ILinkPhysicalType getPhysicalTypeObj() {
        return LinkPhysicalType.getLinkPhysicalType((int)this.linkModel.physicalType());
    }

    public int getPhysicalLinkType() {
        return this.linkModel.physicalLinkType();
    }

    public INetElement getDst() {
        return this.dst;
    }

    public int getPhysicalSize() {
        ILinkPhysicalType iLinkPhysicalType = LinkPhysicalType.getLinkPhysicalType((int)this.getPhysicalType(), (boolean)true);
        return iLinkPhysicalType == null ? 0 : iLinkPhysicalType.getStsCapacity();
    }

    public ILinkPhysicalType getPhysicalSizeObj() {
        ILinkPhysicalType iLinkPhysicalType = LinkPhysicalType.getLinkPhysicalType((int)this.getPhysicalType(), (boolean)true);
        return iLinkPhysicalType;
    }

    public boolean isSdccLink() {
        return this.sdccLink;
    }

    public int getProtectionGroup() {
        return this.linkModel.protectionGroup();
    }

    public INetElement getSrc() {
        return this.src;
    }

    public ArrayList getLinksList() {
        return this.linksList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getNodesList() {
        ArrayList arrayList = null;
        ArrayList arrayList2 = this.nodesList;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this.nodesList);
        }
        return arrayList;
    }

    public int getLinkType() {
        return this.linkModel.linkType();
    }

    public INetLinkType getLinkTypeObj() {
        return NetLinkType.getNetLinkType(this.getLinkType());
    }

    public int getProtectionType() {
        return this.linkModel.protectionType();
    }

    public int getSrcLinkId() {
        return -1;
    }

    public int getDstLinkId() {
        return -1;
    }

    public int getLinkDir() {
        return 0;
    }

    public INetProtectionType getProtectionTypeObj() {
        return NetProtectionType.getNetProtectionType(this.getProtectionType());
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setDeleted(boolean bl) {
        if (this.db.on()) {
            this.db.println("setDeleted: deleted state = " + bl);
        }
        this.deleted = bl;
    }

    public void setCost(int n) {
        if (this.linkModel.cost() != n) {
            if (this.db.on()) {
                this.db.println("setCost: " + this.linkModel.cost() + " --> " + n);
            }
            this.linkModel.setCost(n);
            this.setChanged();
        }
    }

    public void setPhysicalType(int n) {
        if (this.linkModel.physicalType() != n) {
            if (this.db.on()) {
                this.db.println("setPhysicalType: " + this.linkModel.physicalType() + " --> " + n);
            }
            this.linkModel.setPhysicalType(n);
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public void setProtectionGroup(int n) {
        if (this.linkModel.protectionGroup() != n) {
            if (this.db.on()) {
                this.db.println("setProtectionGroup: " + this.linkModel.protectionGroup() + " --> " + n);
            }
            this.linkModel.setProtectionGroup(n);
            this.setChanged();
        }
    }

    public void setLinkType(int n) {
        if (this.linkModel.linkType() != n) {
            if (this.db.on()) {
                this.db.println("setLinkType: " + this.linkModel.linkType() + " --> " + n);
            }
            this.linkModel.setLinkType(n);
            this.setChanged();
        }
    }

    public void setProtectionType(int n) {
        if (this.linkModel.protectionType() != n) {
            if (this.db.on()) {
                this.db.println("setProtectionType: " + this.linkModel.protectionType() + " --> " + n);
            }
            this.linkModel.setProtectionType(n);
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTopology(Topology topology, int n) {
        if (this.db.on()) {
            this.db.println("setTopology: topo = " + topology + ", topo id = " + n);
        }
        AbstractNetLink abstractNetLink = this;
        synchronized (abstractNetLink) {
            this.topology = topology;
            this.topoId = n;
        }
    }

    public Topology getTopology() {
        return this.topology;
    }

    public int getTopoId() {
        return this.topoId;
    }

    protected abstract void setOspfAreaId(long var1);

    public abstract long getOspfAreaId();

    protected void refresh(int n, String string, byte by, int n2, int n3, int n4, int n5) {
    }

    public void setSla(short s) {
        this.sla = new Integer(s);
    }

    public Integer getSla() {
        return this.sla;
    }

    public void containsSrg(Collection collection) throws xLinkNotUsable {
        if (SrgList.contains(collection, new NodeSrg(this.getSrc(), 2))) {
            throw new xLinkNotUsable(" Src node is excluded");
        }
        if (SrgList.contains(collection, new NodeSrg(this.getDst(), 1))) {
            throw new xLinkNotUsable(" Dst node is excluded");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ISrg iSrg = (ISrg)iterator.next();
            if (iSrg instanceof SlotSrg) {
                SlotSrg slotSrg = (SlotSrg)iSrg;
                if (this.getSrc().equals(slotSrg.getNe()) && this.getSrcSlotNumber() == slotSrg.getSlot() && slotSrg.getDirection() || this.getDst().equals(slotSrg.getNe()) && this.getDstSlotNumber() == slotSrg.getSlot() && !slotSrg.getDirection()) {
                    throw new xLinkNotUsable(" Link contains SRG: " + iSrg.prettyString());
                }
            }
            if (!(iSrg instanceof PortSrg) || (!this.getSrc().equals(((PortSrg)iSrg).getNe()) || this.getSrcSlotNumber() != ((PortSrg)iSrg).getSlot() || ComparisonUtil.compare((int[])this.getSrcPortNumber(), (int[])((PortSrg)iSrg).getPort()) != 0) && (!this.getDst().equals(((PortSrg)iSrg).getNe()) || this.getDstSlotNumber() != ((PortSrg)iSrg).getSlot() || ComparisonUtil.compare((int[])this.getDstPortNumber(), (int[])((PortSrg)iSrg).getPort()) != 0)) continue;
            throw new xLinkNotUsable(" Link contains SRG: " + iSrg.prettyString());
        }
    }

    public boolean isUsable(RoutePrefs routePrefs) throws xLinkNotUsable {
        return true;
    }

    public abstract boolean isRoutable();

    protected abstract void initializeDebug();

    public boolean equals(Object object) {
        if (object instanceof AbstractNetLink) {
            AbstractNetLink abstractNetLink = (AbstractNetLink)object;
            if (!this.physicalLinkEquals(abstractNetLink)) {
                return false;
            }
            if (!AbstractNetLink.areHosEqual(abstractNetLink.getSrcHo(), this.getSrcHo())) {
                return false;
            }
            if (!AbstractNetLink.areHosEqual(abstractNetLink.getDstHo(), this.getDstHo())) {
                return false;
            }
            return abstractNetLink.isSdccLink() == this.isSdccLink();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.src.hashCode();
        n = 37 * n + this.getSrcEntityIndex();
        n = 37 * n + (this.getSrcHo() == null ? 0 : this.getSrcHo().hashCode());
        n = 37 * n + this.dst.hashCode();
        n = 37 * n + this.getDstEntityIndex();
        n = 37 * n + (this.getDstHo() == null ? 0 : this.getDstHo().hashCode());
        n = 37 * n + (this.isSdccLink() ? 1 : 0);
        return n;
    }

    public boolean physicalLinkEquals(INetLink iNetLink) {
        if (!iNetLink.getSrc().equals(this.src)) {
            return false;
        }
        if (iNetLink.getSrcEntityIndex() != this.getSrcEntityIndex()) {
            return false;
        }
        if (!iNetLink.getDst().equals(this.dst)) {
            return false;
        }
        return iNetLink.getDstEntityIndex() == this.getDstEntityIndex();
    }

    public boolean isPhysical() {
        return this.getLinkType() == 1;
    }

    public boolean isPhantom() {
        return this.getLinkType() == 3;
    }

    public boolean isServerTrail() {
        return this.getLinkType() == 9;
    }

    public IServerTrailLinkId getServerTrailId() {
        return null;
    }

    public String getServerTrailIdString() {
        return "";
    }

    public String getServerTrailCktSizeString() {
        return "";
    }

    protected boolean isXcCapable() {
        return this.linkModel.isXcCapable();
    }

    protected boolean isNbrXcCapable() {
        return this.linkModel.isNbrXcCapable();
    }

    public boolean inWorkingBLSR() {
        return false;
    }

    public short blsrRingId() {
        return 0;
    }

    public boolean isPca() {
        return this.getProtectionTypeObj().isPca();
    }

    public boolean inBLSR() {
        return false;
    }

    public String blsrRingName() {
        return "";
    }

    public String blsrRingName(INetElement iNetElement) {
        return "";
    }

    public boolean isPca(INetElement iNetElement) {
        INetLink iNetLink = null;
        if (!this.isLOTunnel() && !this.isLAP()) {
            return this.isPca();
        }
        if (iNetElement == this.getSrc()) {
            iNetLink = this.net.findNetLinkFromSource(false, iNetElement, this.getSrcEntityIndex(), this.getSrcHo());
        } else if (iNetElement == this.getDst()) {
            iNetLink = this.net.findNetLinkFromDestination(false, iNetElement, this.getDstEntityIndex(), this.getDstHo());
        }
        return iNetLink != null && iNetLink.isPca();
    }

    public abstract boolean isBlsrCapable();

    public boolean isLOCapable() {
        if (this.getLinkType() == 7) {
            return true;
        }
        return this.getSrc().loXCon() && this.getDst().loXCon();
    }

    public boolean isProtected() {
        if (this.isServerTrail()) {
            return this.getProtectionType() == 10;
        }
        return this.getProtectionType() == 0 || this.getProtectionType() == 4 || this.getProtectionType() == 1 || this.getProtectionType() == 2;
    }

    public boolean isFullyUnprotected() {
        Iterator iterator = this.getLinksList().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isProtected() && !iNetLink.isPca()) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyProtected() {
        Iterator iterator = this.getLinksList().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink.isProtected()) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyLineProtected() {
        Iterator iterator = this.getLinksList().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink.isProtected()) continue;
            return false;
        }
        return true;
    }

    public boolean isLOTunnel() {
        return this.getLinkType() == 2;
    }

    public boolean isLAP() {
        return this.getLinkType() == 7;
    }

    public boolean isOchTrailTunnel() {
        return this.getLinkType() == 8;
    }

    public INetLinkSpan getAvailSpan(int n, int n2) {
        INetLinkSpan[] iNetLinkSpanArray = this.getNAvailSpans(n, n2, 1);
        if (iNetLinkSpanArray.length == 0) {
            return null;
        }
        return iNetLinkSpanArray[0];
    }

    public INetLinkSpan[] getAllAvailSpans(int n, int n2) {
        return this.getNAvailSpans(n, n2, 100000);
    }

    public INetLinkSpan[] getNAvailSpans(int n, int n2, int n3) {
        if (this.db.on()) {
            this.db.println("getNAvailSpans: N = " + n3);
        }
        int n4 = 0;
        INetLink iNetLink = this.getReverseLink();
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("getNAvailSpans: ReverseLink is Null. Error");
            }
            return new INetLinkSpan[0];
        }
        ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
        ILabelSet iLabelSet2 = this.getDstLabelSet(n, n2);
        if (this.getLinkType() == 7) {
            if (this.isDstExtendable()) {
                iLabelSet = iLabelSet2;
            }
        } else {
            iLabelSet.intersectSelf(iLabelSet2);
        }
        INetLinkSpan[] iNetLinkSpanArray = new INetLinkSpan[iLabelSet.size()];
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        while (iterator.hasNext() && n4 < n3) {
            ILabel iLabel = (ILabel)iterator.next();
            iNetLinkSpanArray[n4++] = new NetLinkSpan(this, iNetLink, iLabel, iLabel);
        }
        if (dbg.on()) {
            this.db.println("getNAvailSpans: Number of Spans: " + iNetLinkSpanArray.length);
        }
        return iNetLinkSpanArray;
    }

    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        if (this.isLOTunnel() || this.isLAP()) {
            return holoComp.isEqual(this.getSrcHo(), iHoNum);
        }
        return this.isValidHoNumber(iHoNum);
    }

    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        if (this.isLOTunnel() || this.isLAP()) {
            return holoComp.isEqual(this.getDstHo(), iHoNum);
        }
        return this.isValidHoNumber(iHoNum);
    }

    public boolean isValidHoNumber(IHoNum iHoNum) {
        return holoComp.compare(this.getFirstValidSrcHo(), iHoNum) <= 0 && holoComp.compare(iHoNum, this.getLastValidSrcHo()) <= 0;
    }

    public IHoNum get2fBlsrStartingPcaHo(boolean bl) {
        int n = bl ? this.src.getNodeModel().getFramingType() : this.dst.getNodeModel().getFramingType();
        int n2 = this.getPhysicalSize() / 2 + 1;
        return HoLoFactory.idlSts2HoNum(n, n2);
    }

    protected IPoolModel getPool(INetElement iNetElement, int n) {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (this.isPca(iNetElement) && !this.isServerTrail()) {
            return iNodeModel.getPoolModels().getProtectPoolModel(n);
        }
        return iNodeModel.getPoolModels().getPoolModel(n);
    }

    public IPoolModel getSrcPool() {
        return this.getPool(this.getSrc(), this.getSrcEntityIndex());
    }

    public IPoolModel getDstPool() {
        return this.getPool(this.getDst(), this.getDstEntityIndex());
    }

    public INetLink getReverseLink() {
        return this.net.findReverseLink(this);
    }

    public INetLink getCounterpartLink() {
        if (this.db.on()) {
            this.db.println("getCounterpartLink: link: " + this.prettyString());
        }
        Collection collection = this.getSrc().getAdjacencyList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (this.db.on()) {
                this.db.println("getCounterpartLink: adjLink: " + iNetLink.prettyString());
            }
            if (this.isLOTunnel()) {
                if (!iNetLink.isLOTunnel()) continue;
                if (!(iNetLink != this && iNetLink.getDst() == this.getDst() && iNetLink.originatingRingName().equals(this.originatingRingName()) && this.terminatingRingName().equals(this.originatingRingName()) && iNetLink.terminatingRingName().equals(this.terminatingRingName()) && iNetLink.getLinksList().size() == this.getLinksList().size())) {
                    if (!this.db.on()) continue;
                    this.db.println("getCounterpartLink: adjLink is not counterPart ");
                    continue;
                }
                boolean bl = true;
                Iterator iterator2 = this.getLinksList().iterator();
                while (iterator2.hasNext()) {
                    INetLink iNetLink2 = (INetLink)iterator2.next();
                    INetLink iNetLink3 = iNetLink2.getCounterpartLink();
                    if (iNetLink3 == null) {
                        if (this.db.on()) {
                            this.db.println("getCounterpartLink: adjLink is not counterPart. There is no counterPart  for " + iNetLink2.prettyString());
                        }
                        bl = false;
                        break;
                    }
                    if (iNetLink.getLinksList().contains(iNetLink3)) continue;
                    if (iNetLink3.getReverseLink() != null) {
                        if (this.db.on()) {
                            this.db.println("getCounterpartLink: revLink not found");
                        }
                        bl = false;
                        break;
                    }
                    if (!iNetLink.getLinksList().contains(iNetLink3.getReverseLink())) continue;
                }
                if (!bl) continue;
                if (this.db.on()) {
                    this.db.println("getCounterpartLink: link is Counterpart");
                }
                return iNetLink;
            }
            if (iNetLink == this || iNetLink.getSrcEntityIndex() != this.getSrcEntityIndex()) continue;
            return iNetLink;
        }
        return null;
    }

    public String originatingRingName() {
        return "";
    }

    public String terminatingRingName() {
        return "";
    }

    public boolean originatingInRing() {
        return false;
    }

    public boolean terminatingInRing() {
        return false;
    }

    public boolean shouldSrcDstLabelsMatch() {
        if (!this.inBLSR()) {
            return this.isPhysical();
        }
        if (this.isLAP()) {
            return false;
        }
        if (this.originatingRingName().equals("") || this.terminatingRingName().equals("")) {
            return false;
        }
        if (this.originatingRingName().equals(this.terminatingRingName())) {
            return !this.isLOTunnel() || this.isFullyProtected();
        }
        return false;
    }

    public boolean canSupportCircuitSize(int n) {
        return this.src.canSupportCircuitSize(n) && this.dst.canSupportCircuitSize(n);
    }

    public boolean canSupportCircuitDirection(int n) {
        return true;
    }

    public boolean availBW(RoutePrefs routePrefs) {
        return false;
    }

    public abstract List getAvailableHoNumbers(int var1, int var2);

    public ILabelSet getSrcLabelSet(int n, int n2) {
        boolean bl;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n2);
        boolean bl2 = bl = iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType();
        if (bl) {
            return new LoLabelSet();
        }
        return new HoLabelSet();
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        boolean bl;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n2);
        boolean bl2 = bl = iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType();
        if (bl) {
            return new LoLabelSet();
        }
        return new HoLabelSet();
    }

    public abstract List getAvailableLoNumbers(IHoNum var1, int var2);

    protected void acquireSrcSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block15: {
            iNodeModel = this.getSrc().getNodeModel();
            bl = false;
            if (iNodeModel.isInited()) {
                try {
                    IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                    if (iEntityTableModel != null) {
                        IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getSrcEntityIndex());
                        if (iEntityModel != null) {
                            this.srcSlot = iEntityModel.getSlot();
                            this.srcPort = AbstractNetLink.getPortNum(iEntityModel);
                            if (this.db.on()) {
                                this.db.println("acquireSrcSlotAndPort: slot => " + this.srcSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.srcPort));
                            }
                            if (this.srcSlot != 0 && this.srcPort.length > 0) {
                                if (iNodeModel.getConnectionNotifier() != null) {
                                    if (this.db.on()) {
                                        this.db.println("acquireSrcSlotAndPort: deleting SRC NM ConnNotifier observer.");
                                    }
                                    iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                                }
                                this.setChanged();
                            }
                        } else {
                            bl = true;
                        }
                        break block15;
                    }
                    bl = true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    bl = true;
                    if (this.db.on()) {
                        this.db.println("acquireSrcSlotAndPort: entity index invalid");
                    }
                    break block15;
                }
            }
            bl = true;
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireSrcSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireSrcSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    protected void acquireDstSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block16: {
            iNodeModel = this.getDst().getNodeModel();
            bl = false;
            if (iNodeModel.isInited()) {
                try {
                    IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                    if (iEntityTableModel != null) {
                        IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getDstEntityIndex());
                        if (iEntityModel != null) {
                            this.dstSlot = iEntityModel.getSlot();
                            this.dstPort = AbstractNetLink.getPortNum(iEntityModel);
                            if (this.db.on()) {
                                this.db.println("acquireDstSlotAndPort: slot => " + this.dstSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.dstPort));
                            }
                            if (this.dstSlot != 0 && this.dstPort.length > 0) {
                                if (iNodeModel.getConnectionNotifier() != null) {
                                    if (this.db.on()) {
                                        this.db.println("acquireDstSlotAndPort: deleting DST NM ConnNotifier observer.");
                                    }
                                    iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                                }
                                this.setChanged();
                            }
                        } else {
                            bl = true;
                        }
                        break block16;
                    }
                    bl = true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    bl = true;
                    if (this.db.on()) {
                        this.db.println("acquireDstSlotAndPort: entity index invalid");
                    }
                    break block16;
                }
            }
            if (this.db.on()) {
                this.db.println("acquireDstSlotAndPort: DST NE not inited");
            }
            bl = true;
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireDstSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireDstSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    public final void update(IObservable iObservable, Object object) {
        this._update(iObservable, object);
    }

    public final void update(Observable observable, Object object) {
        this._update(observable, object);
    }

    protected void _update(Object object, Object object2) {
        if (object instanceof INodeModel.AbstractConnectionNotifier) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED update event");
                }
                this.acquireSrcSlotAndPort();
                this.acquireDstSlotAndPort();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else if (object2 == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED update event");
                }
                ((INodeModel.AbstractConnectionNotifier)object).deleteObserver((IObserver)this);
                this.notifyObservers(ModelUpdateType.DELETED);
            }
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose: disposing link");
        }
        this.deleted = true;
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
        super.destroy();
        this.linksList.clear();
        this.nodesList.clear();
        if (this.linkModel != null) {
            this.linkModel.destroy();
        }
        INodeModel iNodeModel = this.getSrc().getNodeModel();
        INodeModel iNodeModel2 = this.getDst().getNodeModel();
        if (iNodeModel.getConnectionNotifier() != null) {
            if (this.db != null && this.db.on()) {
                this.db.println("dispose: deleting SRC NM ConnNotifier observer.");
            }
            iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
        }
        if (iNodeModel2.getConnectionNotifier() != null) {
            if (this.db != null && this.db.on()) {
                this.db.println("dispose: deleting DST NM ConnNotifier observer.");
            }
            iNodeModel2.getConnectionNotifier().deleteObserver((IObserver)this);
        }
        this.db.dispose();
    }

    public void disposed() {
        this.dispose();
    }

    public static String getDebugName(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                byte[] byArray = inetAddress.getAddress();
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    protected int getPhysicalMaxStsBandwidth() {
        if (this.isLOTunnel() || this.isLAP()) {
            return 0;
        }
        return this.getPhysicalTypeObj().getStsCapacity();
    }

    public IHoNum getFirstValidSrcHo() {
        return this.getValidHo(true, true);
    }

    public IHoNum getLastValidSrcHo() {
        return this.getValidHo(false, true);
    }

    public IHoNum getFirstValidDstHo() {
        return this.getValidHo(true, false);
    }

    public IHoNum getLastValidDstHo() {
        return this.getValidHo(false, false);
    }

    private IHoNum getValidHo(boolean bl, boolean bl2) {
        IHoNum iHoNum;
        if (this.isLOTunnel() || this.isLAP()) {
            return bl2 ? this.getSrcHo() : this.getDstHo();
        }
        int n = bl2 ? this.src.getNodeModel().getFramingType() : this.dst.getNodeModel().getFramingType();
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        IHoNum iHoNum2 = HoLoFactory.createFirstHoNum(n);
        if (bl) {
            iHoNum = iHoNum2;
        } else {
            int n2 = iFramingType.getFramingTypeHoPathWidth(this.getPhysicalMaxStsBandwidth());
            iHoNum = HoLoFactory.addOffset(iHoNum2, n2 - 1);
        }
        if (bl && this.getProtectionType() == 5) {
            iHoNum = this.get2fBlsrStartingPcaHo(bl2);
        }
        if (!bl && this.getProtectionType() == 0) {
            iHoNum = HoLoFactory.addOffset(this.get2fBlsrStartingPcaHo(bl2), -1);
        }
        return iHoNum;
    }

    protected static boolean areHosEqual(IHoNum iHoNum, IHoNum iHoNum2) {
        return holoComp.isEqual(iHoNum, iHoNum2);
    }

    protected static boolean areLosEqual(ILoNum iLoNum, ILoNum iLoNum2) {
        return holoComp.isEqual(iLoNum, iLoNum2);
    }

    protected static List _aditsWithCapacity(ILoAditModel[] iLoAditModelArray, ICircuitSize iCircuitSize) {
        short s = iCircuitSize.size2widthOfLoCircuit();
        int n = iLoAditModelArray == null ? 0 : iLoAditModelArray.length;
        ArrayList<ILoAditModel> arrayList = new ArrayList<ILoAditModel>();
        for (int i = 0; i < n; ++i) {
            ILoAditModel iLoAditModel = iLoAditModelArray[i];
            ILoPathInfo[] iLoPathInfoArray = iLoAditModel.getAvailableLos((int)s);
            if (iLoPathInfoArray == null || iLoPathInfoArray.length <= 0) continue;
            arrayList.add(iLoAditModel);
        }
        return arrayList;
    }

    protected static ILoAditModel[] aditsWithCapacity(ILoAditModel[] iLoAditModelArray, ICircuitSize iCircuitSize) {
        ILoAditModel[] iLoAditModelArray2;
        if (iCircuitSize == null) {
            iLoAditModelArray2 = iLoAditModelArray;
        } else {
            List list = AbstractNetLink._aditsWithCapacity(iLoAditModelArray, iCircuitSize);
            iLoAditModelArray2 = list.toArray(ILoAditModelArrayTemplate);
        }
        return iLoAditModelArray2;
    }

    protected static IHoNum getBaseHo(IPoolModel iPoolModel) {
        return iPoolModel.includedPath().getStartingHo();
    }

    protected static IHoNum physicalHo(ILoAditModel iLoAditModel) {
        IHoPathDefModel iHoPathDefModel = iLoAditModel.getHo();
        IHoNum iHoNum = iHoPathDefModel.getPool().includedPath().getStartingHo();
        IHoNum iHoNum2 = iHoPathDefModel.getStartingHo();
        return HoLoFactory.addOffset(iHoNum, iHoNum2);
    }

    protected static IHoNum physicalHo(IHoNum iHoNum, IPathInfo iPathInfo) {
        IHoNum iHoNum2 = iPathInfo.getStartingHo();
        return HoLoFactory.addOffset(iHoNum, iHoNum2);
    }

    protected static Set getCommonHoNums(IPathInfo[] iPathInfoArray, IPathInfo[] iPathInfoArray2, IHoNum iHoNum, IHoNum iHoNum2) {
        Set set = AbstractNetLink.getAllHoNums(iPathInfoArray, iHoNum);
        set.retainAll(AbstractNetLink.getAllHoNums(iPathInfoArray2, iHoNum2));
        return set;
    }

    protected static Set getCommonHoNums(IPathInfo[] iPathInfoArray, IPathInfo[] iPathInfoArray2, IPoolModel iPoolModel, IPoolModel iPoolModel2) {
        IHoNum iHoNum = AbstractNetLink.getBaseHo(iPoolModel);
        IHoNum iHoNum2 = AbstractNetLink.getBaseHo(iPoolModel2);
        return AbstractNetLink.getCommonHoNums(iPathInfoArray, iPathInfoArray2, iHoNum, iHoNum2);
    }

    protected static Set getCommonHoNums(ILoAditModel[] iLoAditModelArray, ILoAditModel[] iLoAditModelArray2) {
        Set set = AbstractNetLink.getAllHoNums(iLoAditModelArray);
        set.retainAll(AbstractNetLink.getAllHoNums(iLoAditModelArray2));
        return set;
    }

    protected static Set getCommonLoNums(ILoPathInfo[] iLoPathInfoArray, ILoPathInfo[] iLoPathInfoArray2) {
        Set set = AbstractNetLink.getAllLoNums(iLoPathInfoArray);
        set.retainAll(AbstractNetLink.getAllLoNums(iLoPathInfoArray2));
        return set;
    }

    protected static ILoNum getFirstCommonLoNum(ILoPathInfo[] iLoPathInfoArray, ILoPathInfo[] iLoPathInfoArray2) {
        Set set = AbstractNetLink.getCommonLoNums(iLoPathInfoArray, iLoPathInfoArray2);
        ILoNum iLoNum = null;
        if (set.size() > 0) {
            iLoNum = (ILoNum)set.iterator().next();
        }
        return iLoNum;
    }

    protected static Set getAllHoNums(IPathInfo[] iPathInfoArray, IHoNum iHoNum) {
        TreeSet<IHoNum> treeSet = new TreeSet<IHoNum>();
        for (int i = 0; i < iPathInfoArray.length; ++i) {
            treeSet.add(HoLoFactory.addOffset(iPathInfoArray[i].getStartingHo(), iHoNum));
        }
        return treeSet;
    }

    protected static Set getAllHoNums(ILoAditModel[] iLoAditModelArray) {
        TreeSet<IHoNum> treeSet = new TreeSet<IHoNum>();
        for (int i = 0; i < iLoAditModelArray.length; ++i) {
            treeSet.add(AbstractNetLink.physicalHo(iLoAditModelArray[i]));
        }
        return treeSet;
    }

    protected static Set getAllLoNums(ILoPathInfo[] iLoPathInfoArray) {
        TreeSet treeSet = AbstractNetLink.createLoSet();
        for (int i = 0; i < iLoPathInfoArray.length; ++i) {
            treeSet.add(iLoPathInfoArray[i].getLoNum());
        }
        return treeSet;
    }

    protected static Object linearSearch(Object object, Object object2, Comparator comparator) {
        int n = Array.getLength(object);
        Object object3 = null;
        for (int i = 0; i < n; ++i) {
            Object object4 = Array.get(object, i);
            if (comparator.compare(object4, object2) != 0) continue;
            object3 = object4;
            break;
        }
        return object3;
    }

    protected static TreeSet createLoSet() {
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        TreeSet treeSet = new TreeSet(hoLoComparator);
        return treeSet;
    }

    protected static int getLoTunnelSize(int n) {
        int n2 = FramingType.getFramingType((int)n).getLoTunnelSize();
        return n2;
    }

    public boolean isSonetCapable() {
        return this.getSrc().getFramingTypeObj().isSonet();
    }

    public int getEndProtectionSwitchState(boolean bl) {
        return -1;
    }

    protected static int[] getPortNum(IEntityModel iEntityModel) {
        if (iEntityModel instanceof IPortModel) {
            if (iEntityModel.getNodeModel().provides(Feature.EXP_PORT_NUM)) {
                return ((IPortModel)iEntityModel).getPortNum();
            }
            return new int[]{iEntityModel.getPort()};
        }
        return new int[0];
    }

    public boolean isSrcExtendable() {
        return this.srcExtendable;
    }

    public boolean isDstExtendable() {
        return this.dstExtendable;
    }

    public boolean isVirtual() {
        return false;
    }

    public class AbstractNetLinkDebug
    extends SDebug {
        public AbstractNetLinkDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            Object object;
            Iterator iterator;
            AbstractNetLink.this.db.println("NetLink state:");
            AbstractNetLink.this.db.println("Src = " + AbstractNetLink.this.src.getHostName());
            AbstractNetLink.this.db.println("Dst = " + AbstractNetLink.this.dst.getHostName());
            AbstractNetLink.this.db.println("Deleted = " + AbstractNetLink.this.deleted);
            AbstractNetLink.this.db.println("Topology ID = " + AbstractNetLink.this.topoId);
            AbstractNetLink.this.db.println("NetLink Type = " + AbstractNetLink.this.getLinkTypeObj());
            AbstractNetLink.this.db.println("Protection Type = " + AbstractNetLink.this.getProtectionTypeObj());
            AbstractNetLink.this.db.println("Physical Type = " + AbstractNetLink.this.getPhysicalTypeObj().getDisplayString(AbstractNetLink.this.isSonetCapable()));
            AbstractNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString((Class)(class$cerent$cms$model$ILinkType == null ? (class$cerent$cms$model$ILinkType = AbstractNetLink.class$("cerent.cms.model.ILinkType")) : class$cerent$cms$model$ILinkType), (int)AbstractNetLink.this.getPhysicalLinkType()));
            AbstractNetLink.this.db.println("Src XC Capable = " + AbstractNetLink.this.isXcCapable());
            AbstractNetLink.this.db.println("Dst XC Capable = " + AbstractNetLink.this.isNbrXcCapable());
            AbstractNetLink.this.db.println("Src Slot = " + AbstractNetLink.this.srcSlot);
            AbstractNetLink.this.db.println("Src Port = " + PortHelper.getConcatenatedString((int[])AbstractNetLink.this.srcPort));
            AbstractNetLink.this.db.println("Dst Slot = " + AbstractNetLink.this.dstSlot);
            AbstractNetLink.this.db.println("Dst Port = " + PortHelper.getConcatenatedString((int[])AbstractNetLink.this.dstPort));
            AbstractNetLink.this.db.println("  Nodes List: ");
            ArrayList arrayList = AbstractNetLink.this.nodesList;
            synchronized (arrayList) {
                iterator = AbstractNetLink.this.nodesList.iterator();
                while (iterator.hasNext()) {
                    object = (INetElement)iterator.next();
                    AbstractNetLink.this.db.println("    " + object.getHostName());
                }
            }
            AbstractNetLink.this.db.println("  Links List:");
            arrayList = AbstractNetLink.this.linksList;
            synchronized (arrayList) {
                iterator = AbstractNetLink.this.linksList.iterator();
                while (iterator.hasNext()) {
                    object = (INetLink)iterator.next();
                    AbstractNetLink.this.db.println("    " + object.prettyString());
                }
            }
        }

        public final void setLinkCost(int n) {
            AbstractNetLink.this.setCost(n);
        }

        public final void dumpObservers() {
            AbstractNetLink.this.db.println("NL observers:");
            AbstractNetLink.this.printObservers();
        }
    }
}

