/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.LambdaLabelSet;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.CircuitOptDir;
import cerent.cms.ui.Wavelength;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.IObserver;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observer;

public class DwdmNetLink
extends RoutableNetLink
implements Observer {
    private static final int LOS = 22;
    private static final int IMPROPRMVL = 81;
    private static final int EQPT_FAIL = 64;
    private static final int OCN_ENTITY_TYPE = 6;
    private long ospfAreaId = 0L;
    private IInterfaceModel srcIM;
    private IInterfaceModel dstIM;
    protected ICardAlarmStore dstCardAlarmStore;
    private int optLinkDir;
    private String optRingName;
    private OscNetLink oscParentLink;
    private boolean oscLinkObserved = false;
    private boolean dstAlrStoreObserved = false;
    private boolean srcdstPortModelObserved = false;
    private boolean isDstEntityAlarmed = false;
    private boolean isDstNEMS = false;
    static /* synthetic */ Class class$cerent$cms$model$ILinkType;

    protected DwdmNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n, boolean bl2) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        this.deleted = false;
        this.linkModel = iLinkModel;
        this.newState(1);
    }

    protected void initializeDebug() {
        this.db = new DwdmNetLinkDebug("NLd" + DwdmNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + DwdmNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
        if (this.db.on()) {
            this.db.println("DwdmNetLink: creating new DwdmNetLink");
        }
    }

    public String prettyString() {
        return super.prettyString() + "- Opt Dir: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(this.optLinkDir) + "- Observing: " + (this.oscLinkObserved ? "OSCLink - " : " - ") + (this.dstAlrStoreObserved ? "DstAlmStore - " : " - ") + (this.srcdstPortModelObserved ? "SrcDstPortModel - " : " -");
    }

    public boolean isBlsrCapable() {
        return false;
    }

    public INodeModel topoHost() {
        return this.linkModel.topoHost();
    }

    public void setTopoHost(INodeModel iNodeModel) {
        this.linkModel.setTopoHost(iNodeModel);
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    protected void oldState(int n) {
        ((LinkModel)this.linkModel).oldState(n);
    }

    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (n != this.oldState()) {
            if (this.db.on()) {
                this.db.println("newState: state changed from " + (this.oldState() == 1 ? "Up" : "Down") + " to " + (n == 1 ? "Up" : "Down"));
            }
            ((LinkModel)this.linkModel).newState(n);
            if (!this.deleted) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        } else if (this.db.on()) {
            this.db.println("newState: state unchanged = " + (n == 1 ? "Up" : "Down."));
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void setChecking(boolean bl) {
    }

    public boolean inChecking() {
        return false;
    }

    protected void setOptAttribs(String string, int n) {
        if (this.db.on()) {
            this.db.println("setOptAttirbs: optLinkDir = " + CircuitOptDir.getCktOptDirStringFromCktOptDir(this.optLinkDir));
        }
        if (this.db.on()) {
            this.db.println("setOptAttirbs: optRingName = " + string);
        }
        this.optLinkDir = n;
        this.optRingName = string;
    }

    public int getOptLinkDir() {
        return this.optLinkDir;
    }

    public String getOptRingName() {
        return this.optRingName;
    }

    public Topology getTopology() {
        return this.topology;
    }

    public int getTopoId() {
        return this.topoId;
    }

    protected void setOspfAreaId(long l) {
        if (this.ospfAreaId != l) {
            this.ospfAreaId = l;
            this.topology.ospfAreaChanged(this);
        }
    }

    protected void clearOspfAreaId() {
        this.ospfAreaId = 0L;
    }

    public long getOspfAreaId() {
        return this.ospfAreaId;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DwdmNetLink)) {
            return false;
        }
        DwdmNetLink dwdmNetLink = (DwdmNetLink)object;
        return this.physicalLinkEquals(dwdmNetLink);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.src.hashCode();
        n = 37 * n + this.getSrcEntityIndex();
        n = 37 * n + this.dst.hashCode();
        n = 37 * n + this.getDstEntityIndex();
        return n;
    }

    public ILabelSet getSrcLabelSet(int n, int n2) {
        return new LambdaLabelSet();
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        return new LambdaLabelSet();
    }

    private boolean isDstNeMultiShelf() {
        INodeModel iNodeModel;
        boolean bl = false;
        if (this.getDst().getConnectionState() && (iNodeModel = this.getDst().getNodeModel()).provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            bl = true;
        }
        return bl;
    }

    protected void startObserving(OscNetLink oscNetLink) {
        this.isDstNEMS = this.isDstNeMultiShelf();
        this.oscParentLink = oscNetLink;
        DwdmNetLink dwdmNetLink = this;
        this.oscParentLink.addObserver(dwdmNetLink);
        this.oscLinkObserved = true;
        if (this.db.on()) {
            this.db.println("Start observing OSC parent link " + this.oscParentLink.prettyString());
        }
        this.getSrc().addObserver(dwdmNetLink);
        this.getDst().addObserver(dwdmNetLink);
        if (this.db.on()) {
            this.db.println("Start observing src & dst NE " + this.getSrc().getHostName() + " & " + this.getDst().getHostName());
        }
        this.startObservingDstCardAlarmStore();
        this.startObservingSrcDstPortModel();
    }

    private void startObservingSrcDstPortModel() {
        block6: {
            try {
                IPortModel iPortModel = (IPortModel)this.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(this.linkModel.srcEntityIndex());
                this.srcIM = iPortModel.getInterfaceModel();
                IPortModel iPortModel2 = (IPortModel)this.getDst().getNodeModel().getEntityTable().getEntityModelByIndex(this.linkModel.dstEntityIndex());
                this.dstIM = iPortModel2.getInterfaceModel();
                DwdmNetLink dwdmNetLink = this;
                if (this.srcIM != null) {
                    this.srcIM.addObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Start observing src PortModel: " + this.srcIM.getPortModel().getEntityIndex());
                    }
                }
                if (this.dstIM != null) {
                    this.dstIM.addObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Start observing dst PortModel: " + this.dstIM.getPortModel().getEntityIndex());
                    }
                }
                this.srcdstPortModelObserved = true;
            }
            catch (Exception exception) {
                if (!this.db.on) break block6;
                this.db.println("Exception trying to observe portModel");
            }
        }
    }

    private void stopObservingSrcDstPortModel() {
        block6: {
            try {
                DwdmNetLink dwdmNetLink = this;
                if (this.srcIM != null) {
                    this.srcIM.deleteObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Stop observing src PortModel: " + this.srcIM.getPortModel().getEntityIndex());
                    }
                }
                if (this.dstIM != null) {
                    this.dstIM.deleteObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Stop observing dst PortModel: " + this.dstIM.getPortModel().getEntityIndex());
                    }
                }
                this.srcdstPortModelObserved = false;
            }
            catch (Exception exception) {
                if (!this.db.on) break block6;
                this.db.println("Exception trying to deregister from portModel: " + exception);
            }
        }
    }

    private void stopObserving() {
        this.stopObservingParentLink();
        DwdmNetLink dwdmNetLink = this;
        this.getSrc().deleteObserver(dwdmNetLink);
        this.getDst().deleteObserver(dwdmNetLink);
        if (this.db.on()) {
            this.db.println("Stop observing src & dst NE " + this.getSrc().getHostName() + " & " + this.getDst().getHostName());
        }
        this.stopObservingDstCardAlarmStore();
        this.stopObservingSrcDstPortModel();
    }

    private void stopObservingParentLink() {
        DwdmNetLink dwdmNetLink = this;
        if (this.oscLinkObserved) {
            this.oscParentLink.deleteObserver(dwdmNetLink);
            this.oscLinkObserved = false;
            if (this.db.on()) {
                this.db.println("Stop observing OSC parent link " + this.oscParentLink.prettyString());
            }
        }
    }

    private void startObservingDstCardAlarmStore() {
        block11: {
            INodeModel iNodeModel;
            if (this.db.on) {
                this.db.println("Try Observing CardAlarmStore: node " + this.getDst().getHostName());
            }
            if (this.getDst().getConnectionState() && (iNodeModel = this.getDst().getNodeModel()).provides(Feature.OCHNC_PROVISIONING)) {
                try {
                    IAlarmStore iAlarmStore = this.getDst().getNodeModel().getElementAlarmStore();
                    if (iAlarmStore != null) {
                        if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                            IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.linkModel.dstEntityIndex());
                            this.dstCardAlarmStore = iAlarmStore.getCardAlarmStore(iEntityModel.getShelfId(), this.linkModel.dstSlotNum());
                        } else {
                            this.dstCardAlarmStore = iAlarmStore.getCardAlarmStore(this.linkModel.dstSlotNum());
                        }
                        if (this.dstCardAlarmStore != null) {
                            this.dstCardAlarmStore.addAlarmStatusObserver((Observer)this);
                            this.dstAlrStoreObserved = true;
                            if (this.db.on) {
                                this.db.println("Start observing DstCardAlarmStore: node " + this.getDst().getHostName());
                            }
                            this.update(this.dstCardAlarmStore.getAlarmStatusObservable(), (Object)this.dstCardAlarmStore.getAlarmStatus());
                        }
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (this.db.on()) {
                        this.db.println("Caught exception in getElementAlarmStore()");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block11;
                    this.db.println("Caught exception in getElementAlarmStore()");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private void stopObservingDstCardAlarmStore() {
        if (this.db.on) {
            this.db.println("Stop observing DstCardAlarmStore: node " + this.getDst().getHostName());
        }
        if (this.dstCardAlarmStore != null) {
            this.dstCardAlarmStore.deleteAlarmStatusObserver((Observer)this);
        }
        this.dstAlrStoreObserved = false;
        this.dstCardAlarmStore = null;
    }

    protected void _update(Object object, Object object2) {
        if (object instanceof NetElement) {
            INetElement iNetElement = (INetElement)object;
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("UPDATE changed event from NE " + iNetElement.getHostName());
                }
                if (!this.isDstNEMS && this.isDstNeMultiShelf() || this.isDstNEMS && !this.isDstNeMultiShelf()) {
                    this.isDstNEMS = this.isDstNeMultiShelf();
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                        this.db.println("Dst NE changed from " + (this.isDstNEMS ? "SS" : "MS") + " to " + (this.isDstNEMS ? "MS" : "SS") + " restart observing dst alarm store");
                    }
                    this.stopObservingDstCardAlarmStore();
                    this.startObservingDstCardAlarmStore();
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                    }
                }
                if (!this.dstAlrStoreObserved) {
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                        this.db.println("Re-start observing destination alarm store");
                    }
                    this.startObservingDstCardAlarmStore();
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                    }
                }
            }
        } else if (object2 instanceof IAlarmStatus) {
            if (this.db.on) {
                this.db.println("UPDATE from alarm status");
            }
        } else if (object instanceof INetLink) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on) {
                    this.db.println("UPDATE OscNetLink updated");
                }
                OscNetLink oscNetLink = (OscNetLink)object;
                this.setOptAttribs(oscNetLink.getOptRingName(), oscNetLink.getOptLinkDir());
                this.setTopology(oscNetLink.getTopology(), oscNetLink.getTopoId());
            } else if (object2 == ModelUpdateType.DELETED) {
                if (this.db.on) {
                    this.db.println("UPDATE OscNetLink deleted");
                }
                this.stopObservingParentLink();
            }
        } else if (object instanceof IInterfaceModel && this.db.on) {
            this.db.println("UPDATE from PortModel");
        }
        this.driveLinkStatus();
    }

    private void driveLinkStatus() {
        boolean bl;
        this.isDstEntityAlarmed = this.isDstEntityAlarmed();
        boolean bl2 = this.getSrc().getConnectionState() && !this.isSrcPortOOS();
        boolean bl3 = bl = this.getDst().getConnectionState() && !this.isDstPortOOS() && !this.isDstEntityAlarmed;
        if (!bl && !bl2) {
            if (this.oscParentLink.isDeleted()) {
                this.dispose();
            } else {
                this.newState(2);
            }
        } else if (!bl || !bl2) {
            this.newState(2);
        } else if (bl && bl2) {
            this.newState(1);
        }
        if (this.db.on()) {
            this.db.println("Link Dir: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(this.optLinkDir) + " - Src node: " + (this.getSrc().getConnectionState() ? "UP" : "DOWN") + " - Dst node: " + (this.getDst().getConnectionState() ? "UP" : "DOWN") + " - Dst AlmStatus: " + (this.isDstEntityAlarmed ? "ALARMED" : "NOT ALARMED") + " - OSCLink Status: " + (this.oscParentLink.getLinkModel().state() == 1 ? "UP" : "DOWN"));
        }
    }

    private boolean isDstEntityAlarmed() {
        boolean bl = false;
        if (this.dstCardAlarmStore != null && this.getDst().getConnectionState()) {
            ArrayList arrayList = new ArrayList();
            arrayList = this.dstCardAlarmStore.getAlarmByCondition(22);
            arrayList.addAll(this.dstCardAlarmStore.getAlarmByCondition(64));
            arrayList.addAll(this.dstCardAlarmStore.getAlarmByCondition(81));
            if (arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    EventInfo eventInfo = (EventInfo)arrayList.get(i);
                    if (eventInfo.getEntityType() == 6) continue;
                    if (eventInfo.getState() != 'R') continue;
                    if (this.db.on) {
                        this.db.println("LOS, EQPT FAIL or IMPROPRMVL raised by destination link card");
                    }
                    bl = true;
                    break;
                }
            }
        }
        if (this.db.on && !bl) {
            this.db.println("Cleared alarms or no relevant alarm raised by dst link card");
        }
        return bl;
    }

    private boolean isSrcPortOOS() {
        boolean bl = false;
        try {
            IPortModel iPortModel = (IPortModel)this.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(this.linkModel.srcEntityIndex());
            if (iPortModel != null) {
                if (iPortModel.getAdminState() == 0 || iPortModel.getAdminState() == 2) {
                    if (this.db.on) {
                        this.db.println("Src Port is IS or OOS_MT: " + this.linkModel.srcEntityIndex());
                    }
                } else {
                    if (this.db.on) {
                        this.db.println("Src Port is OOS_DSBLD or IS_AINS: " + this.linkModel.srcEntityIndex());
                    }
                    bl = true;
                }
            } else if (this.db.on) {
                this.db.println("Src Port Model is NULL");
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (this.db.on) {
                this.db.println("Exception trying to get the SRC port Status");
            }
            bl = true;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                this.db.println("Exception trying to get the SRC port Model ");
            }
            bl = true;
        }
        catch (Exception exception) {
            if (this.db.on) {
                this.db.println("Exception trying to get the SRC Entity Table Model ");
            }
            bl = true;
        }
        return bl;
    }

    private boolean isDstPortOOS() {
        boolean bl = false;
        try {
            IPortModel iPortModel = (IPortModel)this.getDst().getNodeModel().getEntityTable().getEntityModelByIndex(this.linkModel.dstEntityIndex());
            if (iPortModel != null) {
                if (iPortModel.getAdminState() == 0 || iPortModel.getAdminState() == 2) {
                    if (this.db.on) {
                        this.db.println("Src Port is IS or OOS_MT: " + this.linkModel.srcEntityIndex());
                    }
                } else {
                    if (this.db.on) {
                        this.db.println("Src Port is OOS_DSBLD or IS_AINS: " + this.linkModel.srcEntityIndex());
                    }
                    bl = true;
                }
            } else if (this.db.on) {
                this.db.println("Dst Port Model is NULL");
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (this.db.on) {
                this.db.println("Exception trying to get the DST port Status");
            }
            bl = true;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                this.db.println("Exception trying to get the DST port Model ");
            }
            bl = true;
        }
        catch (Exception exception) {
            if (this.db.on) {
                this.db.println("Exception trying to get the DST Entity Table Model ");
            }
            bl = true;
        }
        return bl;
    }

    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on) {
            this.db.println("Disposing DWDMNetLink...");
        }
        DwdmNetLink dwdmNetLink = this;
        synchronized (dwdmNetLink) {
            if (this.deleted) {
                return;
            }
            this.deleted = true;
        }
        if (this.net != null) {
            this.net.delete(this);
        }
        this.stopObserving();
        super.dispose();
    }

    public static String getDebugName(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                byte[] byArray = inetAddress.getAddress();
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public INetLink getParentLink() {
        return this.oscParentLink;
    }

    public int state() {
        return this.newState();
    }

    public DwdmNetLink getOppositeLink() {
        DwdmNetLink dwdmNetLink = null;
        Collection collection = this.getDst().getAdjacencyList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!(iNetLink instanceof DwdmNetLink) || iNetLink.getSrc() != this.getDst() || iNetLink.getDst() != this.getSrc()) continue;
            dwdmNetLink = (DwdmNetLink)iNetLink;
            break;
        }
        return dwdmNetLink;
    }

    public boolean isUsable(RoutePrefs routePrefs) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("isUsable: Link : " + this.prettyString());
        }
        if (this.state() != 1) {
            throw new xLinkNotUsable("Link is Not UP");
        }
        if (!routePrefs.isOchncCircuit() && !routePrefs.isOchTrailTunnelCircuit()) {
            throw new xLinkNotUsable(ErrorMsg.getString((EID)NEMC.EID_ERROR_DWDM_LINK));
        }
        if (routePrefs.getOptDirRoute() && this.getOptLinkDir() != routePrefs.getcktOptDir()) {
            throw new xLinkNotUsable(ErrorMsg.getString((EID)NEMC.EID_ERROR_OCHNC_LINKEXCLUDED));
        }
        this.containsSrg(routePrefs.getExcludeSrgs());
        if (this.extendedAvailBW(routePrefs)) {
            return true;
        }
        throw new xLinkNotUsable(ErrorMsg.getString((EID)NEMC.EID_ERROR_DWDM_NOWAVEL));
    }

    public boolean availBW(RoutePrefs routePrefs) {
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Calling availBW on DwdmNetLink: " + this.prettyString());
            this.db.println("Is enhanced OCHNC: " + !routePrefs.getOptDirRoute());
        }
        if (routePrefs.getOptDirRoute()) {
            bl = this.isChannelAvailable(routePrefs.getSrc(), routePrefs.getDst(), routePrefs.getcktOptChannel(), routePrefs.getcktOptDir());
        }
        if (this.db.on()) {
            this.db.println("OCHNC channel is " + (bl ? "" : "NOT") + " available.");
        }
        return bl;
    }

    public boolean extendedAvailBW(RoutePrefs routePrefs) throws xLinkNotUsable {
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Calling extendedAvailBW on DwdmNetLink: " + this.prettyString());
        }
        if (!routePrefs.getOptDirRoute()) {
            LinkedList linkedList = routePrefs.getRequiredLinks();
            if (linkedList.contains(this)) {
                try {
                    INetLink iNetLink = this.isChannelAvailable(routePrefs.getSrc(), routePrefs.getDst(), routePrefs.getcktOptChannel(), routePrefs);
                    if (iNetLink != null) {
                        routePrefs.getRequiredLinks().add(iNetLink);
                        if (this.db.on()) {
                            this.db.println("Added next Required link " + iNetLink.prettyString());
                        }
                    }
                    bl = true;
                }
                catch (xLinkNotUsable xLinkNotUsable2) {
                    if (this.db.on()) {
                        this.db.println("Excluded Dwdm link because not usable: " + xLinkNotUsable2.getMessage());
                    }
                    throw xLinkNotUsable2;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("Excluded Dwdm link because channel is not available: " + exception.getMessage());
                    }
                    bl = false;
                }
            } else {
                if (this.db.on()) {
                    this.db.println("Excluded Dwdm link because not in required links list:\n" + this.prettyString());
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < linkedList.size(); ++i) {
                        stringBuffer.append("\n" + linkedList.get(i).toString());
                    }
                    this.db.println("Required links are:" + stringBuffer.toString());
                }
                bl = false;
            }
        } else {
            bl = this.availBW(routePrefs);
        }
        if (this.db.on()) {
            this.db.println("OCHNC channel is " + (bl ? "" : "NOT") + " available.");
        }
        return bl;
    }

    public boolean isChannelAvailable(INetElement iNetElement, INetElement iNetElement2, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.getSrc().getConnectionState()) {
            if (this.getSrc().equals(iNetElement)) {
                try {
                    bl = this.getSrc().getNodeModel().getOchncPathAvailability(n, n2, 0);
                }
                catch (AlreadyInUse alreadyInUse) {
                    if (this.db.on()) {
                        this.db.println("The Opt Channel is provisioned but already in use");
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("Exception retrieving the lambda availability" + exception);
                    }
                    bl = false;
                }
            } else {
                try {
                    bl = this.getSrc().getNodeModel().getOchncPathAvailability(n, n2, 2);
                }
                catch (AlreadyInUse alreadyInUse) {
                    if (this.db.on()) {
                        this.db.println("The Opt Channel is provisioned but already in use");
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("Exception retrieving the lambda availability" + exception);
                    }
                    bl = false;
                }
            }
        }
        if (this.getDst().getConnectionState()) {
            if (this.getDst().equals(iNetElement2)) {
                try {
                    bl2 = this.getDst().getNodeModel().getOchncPathAvailability(n, n2, 1);
                }
                catch (AlreadyInUse alreadyInUse) {
                    if (this.db.on()) {
                        this.db.println("The Opt Channel is provisioned but already in use");
                    }
                    bl2 = false;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("Exception retrieving the lambda availability" + exception);
                    }
                    bl2 = false;
                }
            } else {
                try {
                    bl2 = this.getDst().getNodeModel().getOchncPathAvailability(n, n2, 2);
                }
                catch (AlreadyInUse alreadyInUse) {
                    if (this.db.on()) {
                        this.db.println("The Opt Channel is provisioned but already in use");
                    }
                    bl2 = false;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("Exception retrieving the lambda availability" + exception);
                    }
                    bl2 = false;
                }
            }
        }
        return bl && bl2;
    }

    public INetLink isChannelAvailable(INetElement iNetElement, INetElement iNetElement2, int n, RoutePrefs routePrefs) throws xLinkNotUsable {
        if (!this.getSrc().getNodeModel().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            throw new xLinkNotUsable("Source node " + this.getSrc().getName() + " must be at least 7.0");
        }
        if (!this.getDst().getNodeModel().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            throw new xLinkNotUsable("Destination node " + this.getDst().getName() + " must be at least 7.0");
        }
        INetLink iNetLink = null;
        if (this.getDst().getConnectionState()) {
            IEntityModel iEntityModel;
            if (this.db.on()) {
                this.db.println("Trying to get available path for DST entity " + Integer.toHexString(this.getDstEntityIndex()));
            }
            INodeOpticsTopologyModel iNodeOpticsTopologyModel = this.getDst().getNodeModel().getINodeOpticsTopologyModel();
            int[] nArray = new int[]{};
            try {
                if (this.getDst().equals(iNetElement2) || this.getDst().equals(iNetElement)) {
                    if (this.db.on()) {
                        this.db.println("Dst/Src node reached.");
                    }
                    nArray = iNodeOpticsTopologyModel.getAvailOchncPathEntities(n, this.getDstEntityIndex());
                    boolean bl = false;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != routePrefs.getcktDstEntityIndex()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl && routePrefs.isOchncCircuit()) {
                        throw new xLinkNotUsable("drop port " + routePrefs.getcktDstEntityIndex() + " not reachable");
                    }
                    return iNetLink;
                }
                nArray = iNodeOpticsTopologyModel.getAvailOchncPathEntities(n, this.getDstEntityIndex());
            }
            catch (AlreadyInUse alreadyInUse) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)alreadyInUse);
                }
                throw new xLinkNotUsable("Channel " + Wavelength.getWavelengthStringFromWavelength(n) + " on " + this.getDst().prettyString() + " is already in use");
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchEquipment);
                }
                throw new xLinkNotUsable("Cannot check availability of channel " + Wavelength.getWavelengthStringFromWavelength(n) + " on " + this.getDst().prettyString() + ": " + noSuchEquipment.getMessage());
            }
            if (nArray.length == 0) {
                throw new xLinkNotUsable("Unavailable Channel " + Wavelength.getWavelengthStringFromWavelength(n) + " on " + this.getDst().prettyString());
            }
            if (this.db.on()) {
                this.db.println("Trying to get next dwdm link");
            }
            IEntityTableModel iEntityTableModel = this.getDst().getNodeModel().getEntityTable();
            Network network = Network.instance();
            ArrayList<INetLink> arrayList = new ArrayList<INetLink>();
            for (int i = 0; i < nArray.length; ++i) {
                INetLink iNetLink2;
                try {
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(nArray[i]);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("Cannot get entity " + nArray[i] + " on node " + this.getDst().prettyString() + " :" + abstractCmsNoSuchEntityException.getMessage());
                    continue;
                }
                if (this.db.on()) {
                    this.db.println("Trying with out port " + iEntityModel);
                }
                if ((iNetLink2 = network.findNetLinkFromSource(false, this.getDst(), nArray[i], null)) != null && routePrefs.isOchTrailTunnelCircuit() && iNetLink2.getDst().equals(routePrefs.getDst()) && iNetLink2 instanceof DwdmNetLink) {
                    IEntityModel iEntityModel2 = OchTrailHelper.getColocatedTrunkPort(iNetLink2.getDst(), iNetLink2.getDstEntityIndex(), n);
                    if (iEntityModel2 != null) {
                        if (iEntityModel2.getEntityIndex() != routePrefs.getcktDstEntityIndex()) {
                            if (this.db.on()) {
                                this.db.println("Next link " + iNetLink2 + " skipped since " + "it is internally connected to one trunk " + iEntityModel2 + "[" + Integer.toHexString(iEntityModel2.getEntityIndex()) + "], but the circuits ends at index " + Integer.toHexString(routePrefs.getcktDstEntityIndex()));
                            }
                            iNetLink2 = null;
                        } else if (this.db.on()) {
                            this.db.println("Next link " + iNetLink2 + " accepted since " + "it is internally connected to the destination " + "trunk " + iEntityModel2);
                        }
                    } else {
                        if (this.db.on()) {
                            this.db.println("Next link " + iNetLink2 + " skipped. No colocated trunk found.");
                        }
                        iNetLink2 = null;
                    }
                }
                if (iNetLink2 == null) continue;
                if (this.db.on()) {
                    this.db.println("Adding available next link " + iNetLink2);
                }
                arrayList.add(iNetLink2);
            }
            IEntityTableModel iEntityTableModel2 = routePrefs.getDst().getNodeModel().getEntityTable();
            try {
                iEntityModel = iEntityTableModel2.getEntityModelByIndex(routePrefs.getcktDstEntityIndex());
                boolean bl = OchTrailHelper.isClientPort(iEntityModel.getEqType());
                boolean bl2 = OchTrailHelper.isTrunkPort(iEntityModel.getEqType());
                if (this.db.on()) {
                    this.db.println("Starting check of " + arrayList.size() + "available next link(s) (isClient: " + bl + ", iTrunk: " + bl2 + ")");
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    INetLink iNetLink3 = (INetLink)iterator.next();
                    if (this.db.on()) {
                        this.db.println("Checking available next link " + iNetLink3);
                    }
                    if (iNetLink3 instanceof VirtualNetLink) {
                        if (iNetLink3.getDst().equals(routePrefs.getDst())) {
                            if (bl2) {
                                if (iNetLink3.getDstEntityIndex() == routePrefs.getcktDstEntityIndex()) {
                                    if (this.db.on()) {
                                        this.db.println("Available next link accepted: VL ending on ckt endpoint (trunk)");
                                    }
                                    iNetLink = iNetLink3;
                                }
                                if (!this.db.on()) continue;
                                this.db.println("Available next link discarded: VL trunk " + Integer.toHexString(iNetLink3.getDstEntityIndex()) + " differs from ckt trunk " + Integer.toHexString(routePrefs.getcktDstEntityIndex()));
                                continue;
                            }
                            if (!bl) continue;
                            VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink3;
                            if (OchTrailHelper.areTrunkAndClientCoLocated(this.dst, routePrefs.getcktDstEntityIndex(), iNetLink3.getDstEntityIndex())) {
                                if (this.db.on()) {
                                    this.db.println("Available next link accepted: VL ending on ckt endpoint (client)");
                                }
                                iNetLink = iNetLink3;
                            }
                            if (!this.db.on()) continue;
                            this.db.println("Available next link discarded: VL trunk " + Integer.toHexString(iNetLink3.getDstEntityIndex()) + " not connected to ckt client " + Integer.toHexString(routePrefs.getcktDstEntityIndex()));
                            continue;
                        }
                        if (!this.db.on()) continue;
                        this.db.println("Available next link discarded: VL ending on different node (" + iNetLink3.getDst() + ")");
                        continue;
                    }
                    if (this.db.on()) {
                        this.db.println("Available next link accepted: DWDM link");
                    }
                    iNetLink = iNetLink3;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    this.db.println("Cannot get ckt dst port: " + abstractCmsNoSuchEntityException.getMessage());
                }
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        } else if (this.db.on()) {
            this.db.println("Destination Node not connected");
        }
        if (this.db.on()) {
            if (iNetLink != null) {
                this.db.println("Next dwdm link is " + iNetLink.prettyString());
            } else {
                this.db.println("No next dwdm link found.");
            }
        }
        return iNetLink;
    }

    public String[] getSpanLoss() {
        if (Feature.provides((INodeModel)this.getDst().getNodeModel(), (Feature)Feature.REMOTE_ELE_V1)) {
            return this.getDst().getNodeModel().getSpanLoss(this.optLinkDir);
        }
        return this.getDst().getNodeModel().getSpanLoss(this.getDstEntityIndex());
    }

    public class DwdmNetLinkDebug
    extends SDebug {
        public DwdmNetLinkDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            Object object;
            Iterator iterator;
            AbstractNetLink.dbg.println("==============================================");
            DwdmNetLink.this.db.println("Src = " + DwdmNetLink.this.src.getHostName());
            DwdmNetLink.this.db.println("Dst = " + DwdmNetLink.this.dst.getHostName());
            DwdmNetLink.this.db.println("State = " + (DwdmNetLink.this.newState() == 1 ? "Up" : "Down"));
            DwdmNetLink.this.db.println("Deleted = " + DwdmNetLink.this.deleted);
            DwdmNetLink.this.db.println("Topology ID = " + DwdmNetLink.this.topoId);
            DwdmNetLink.this.db.println("NetLink Type = " + DwdmNetLink.this.getLinkTypeObj());
            DwdmNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString((Class)(class$cerent$cms$model$ILinkType == null ? (class$cerent$cms$model$ILinkType = DwdmNetLink.class$("cerent.cms.model.ILinkType")) : class$cerent$cms$model$ILinkType), (int)DwdmNetLink.this.getPhysicalLinkType()));
            DwdmNetLink.this.db.println("Src Slot = " + DwdmNetLink.this.srcSlot);
            DwdmNetLink.this.db.println("Src Port = " + DwdmNetLink.this.srcPort);
            DwdmNetLink.this.db.println("Dst Slot = " + DwdmNetLink.this.dstSlot);
            DwdmNetLink.this.db.println("Dst Port = " + DwdmNetLink.this.dstPort);
            DwdmNetLink.this.db.println("Optical RingName = " + DwdmNetLink.this.optRingName);
            DwdmNetLink.this.db.println("Optical Link Dir = " + CircuitOptDir.getCktOptDirStringFromCktOptDir(DwdmNetLink.this.optLinkDir));
            DwdmNetLink.this.db.println("  Nodes List: ");
            ArrayList arrayList = DwdmNetLink.this.nodesList;
            synchronized (arrayList) {
                iterator = DwdmNetLink.this.nodesList.iterator();
                while (iterator.hasNext()) {
                    object = (INetElement)iterator.next();
                    DwdmNetLink.this.db.println("    " + object.getHostName());
                }
            }
            DwdmNetLink.this.db.println("  Links List:");
            arrayList = DwdmNetLink.this.linksList;
            synchronized (arrayList) {
                iterator = DwdmNetLink.this.linksList.iterator();
                while (iterator.hasNext()) {
                    object = (INetLink)iterator.next();
                    DwdmNetLink.this.db.println("    " + object.prettyString());
                }
            }
        }

        public final void dumpObservers() {
            DwdmNetLink.this.db.println("NL observers:");
            DwdmNetLink.this.printObservers();
        }
    }
}

