/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.topo.UnknownNetLink;
import cerent.cms.ui.CircuitOptDir;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class NetLinkManager
implements Observer {
    private static NetLinkManager nlMgr;
    private Network net;
    private List splicedLinkList;
    private List sourceTerminatedLinkList;
    private List unprocessedLinkList;
    private List unknownLinkList;
    private List oscLinkList;
    private boolean updateRequired = false;
    private SDebug db = new NetLinkManagerDebug("NetLinkManager");

    private NetLinkManager() {
        this.net = Network.instance();
        this.splicedLinkList = Collections.synchronizedList(new LinkedList());
        this.sourceTerminatedLinkList = Collections.synchronizedList(new LinkedList());
        this.unprocessedLinkList = Collections.synchronizedList(new LinkedList());
        this.unknownLinkList = Collections.synchronizedList(new LinkedList());
        this.oscLinkList = Collections.synchronizedList(new LinkedList());
        if (this.net.db.on()) {
            this.db.set(true);
        }
        if (this.db.on()) {
            this.db.println("Creating new NetLinkManager");
        }
    }

    public static synchronized NetLinkManager instance() {
        if (nlMgr == null) {
            nlMgr = new NetLinkManager();
        }
        return nlMgr;
    }

    protected synchronized void newNetLink(INetLink iNetLink) {
        iNetLink.addObserver(this);
        if (iNetLink instanceof UnknownNetLink) {
            if (!((UnknownNetLink)iNetLink).isValid()) {
                if (this.db.on()) {
                    this.db.println("newNetLink: NL " + iNetLink.toString() + " not yet ready");
                }
                return;
            }
            if (!this.unknownLinkList.contains(iNetLink)) {
                if (this.db.on()) {
                    this.db.println("newNetLink: adding unknown NL " + iNetLink.toString());
                }
                this.unknownLinkList.add(iNetLink);
                if (iNetLink.isDeleted()) {
                    this.deleteNetLink(iNetLink);
                } else {
                    this.net.queueNetworkUpdateEvent();
                }
            }
        } else if (iNetLink instanceof OscNetLink) {
            if (!((OscNetLink)iNetLink).isValid()) {
                if (this.db.on()) {
                    this.db.println("newNetLink: NL " + iNetLink.toString() + " not valid");
                }
                return;
            }
            if (!this.oscLinkList.contains(iNetLink)) {
                if (this.db.on()) {
                    this.db.println("newNetLink: adding OSC NL " + iNetLink.toString());
                }
                this.oscLinkList.add(iNetLink);
                if (iNetLink.isDeleted()) {
                    this.deleteNetLink(iNetLink);
                } else {
                    this.net.queueNetworkUpdateEvent();
                }
            }
        } else if (iNetLink instanceof NonRoutableNetLink) {
            if (!((NonRoutableNetLink)iNetLink).isValid() || ((NonRoutableNetLink)iNetLink).isSpliced()) {
                if (this.db.on()) {
                    this.db.println("newNetLink: NL " + iNetLink.toString() + " not valid");
                }
                return;
            }
            switch (iNetLink.getLinkModel().physicalLinkType()) {
                case 1: 
                case 2: {
                    if (iNetLink.getLinkModel().isXcCapable() && !iNetLink.getLinkModel().isNbrXcCapable()) {
                        if (!this.sourceTerminatedLinkList.contains(iNetLink)) {
                            if (this.db.on()) {
                                this.db.println("newNetLink: adding non-routable NL " + iNetLink.toString());
                            }
                            this.sourceTerminatedLinkList.add(iNetLink);
                        }
                    } else if (!this.unprocessedLinkList.contains(iNetLink)) {
                        if (this.db.on()) {
                            this.db.println("newNetLink: adding non-routable NL " + iNetLink.toString());
                        }
                        this.unprocessedLinkList.add(iNetLink);
                    }
                    if (iNetLink.isDeleted()) {
                        this.deleteNetLink(iNetLink);
                        break;
                    }
                    this.net.queueNetworkUpdateEvent();
                    break;
                }
                case 3: 
                case 6: {
                    if (this.unprocessedLinkList.contains(iNetLink)) break;
                    if (this.db.on()) {
                        this.db.println("newNetLink: adding non-routable NL " + iNetLink.toString());
                    }
                    this.unprocessedLinkList.add(iNetLink);
                    if (iNetLink.isDeleted()) {
                        this.deleteNetLink(iNetLink);
                        break;
                    }
                    this.net.queueNetworkUpdateEvent();
                    break;
                }
            }
        }
    }

    private void deleteNetLink(INetLink iNetLink) {
        this.sourceTerminatedLinkList.remove(iNetLink);
        this.unprocessedLinkList.remove(iNetLink);
        this.unknownLinkList.remove(iNetLink);
        this.oscLinkList.remove(iNetLink);
        iNetLink.deleteObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getSourceTerminatedLinks() {
        LinkedList linkedList;
        List list = this.sourceTerminatedLinkList;
        synchronized (list) {
            linkedList = new LinkedList(this.sourceTerminatedLinkList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getUnprocessedLinks() {
        LinkedList linkedList;
        List list = this.unprocessedLinkList;
        synchronized (list) {
            linkedList = new LinkedList(this.unprocessedLinkList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getUnknownLinks() {
        LinkedList linkedList;
        List list = this.unknownLinkList;
        synchronized (list) {
            linkedList = new LinkedList(this.unknownLinkList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getOscLinks() {
        LinkedList linkedList;
        List list = this.oscLinkList;
        synchronized (list) {
            linkedList = new LinkedList(this.oscLinkList);
        }
        return linkedList;
    }

    private synchronized void spliceLinks() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = (LinkedList)this.getSourceTerminatedLinks();
        while (linkedList2.size() > 0) {
            Object object;
            NonRoutableNetLink nonRoutableNetLink = (NonRoutableNetLink)linkedList2.removeFirst();
            if (this.db.on()) {
                this.db.println("spliceLinks: processing SRC term. NL " + nonRoutableNetLink.toString());
            }
            LinkedList<Object> linkedList3 = new LinkedList<Object>();
            LinkedList linkedList4 = (LinkedList)this.getUnprocessedLinks();
            boolean bl = false;
            linkedList3.add(nonRoutableNetLink);
            linkedList4.remove(nonRoutableNetLink);
            Object object2 = nonRoutableNetLink;
            while (object2 != null) {
                object = this.findMatchingLink(((AbstractNetLink)object2).getDst(), ((NonRoutableNetLink)object2).getDstSlot(), ((NonRoutableNetLink)object2).getDstPort(), ((NonRoutableNetLink)object2).isDstDwdmPort(), linkedList4);
                if (object == null && ((AbstractNetLink)object2).getProtectionType() == 7) {
                    if (this.db.on()) {
                        this.db.println("spliceLinks: match not found using YCable working port, trying protect port");
                    }
                    int n = this.getProtectSlot((NonRoutableNetLink)object2, false);
                    int[] nArray = this.getProtectPort((NonRoutableNetLink)object2, false);
                    object = this.findMatchingLink(((AbstractNetLink)object2).getDst(), n, nArray, ((NonRoutableNetLink)object2).isDstDwdmPort(), linkedList4);
                }
                if (object != null) {
                    if (((AbstractNetLink)object).getLinkModel().isNbrXcCapable()) {
                        if (nonRoutableNetLink.getPhysicalSize() == ((AbstractNetLink)object).getPhysicalSize()) {
                            if (linkedList3.size() > 1) {
                                if (ComparisonUtil.compare((int[])nonRoutableNetLink.getDstPort(), (int[])((NonRoutableNetLink)object).getSrcPort()) == 0) {
                                    if (this.db.on()) {
                                        this.db.println("spliceLinks: Link successfully spliced");
                                    }
                                    linkedList3.add(object);
                                    bl = true;
                                    break;
                                }
                                if (this.db.on()) {
                                    this.db.println("spliceLinks: excluding matching Link");
                                }
                                linkedList4.remove(object);
                                continue;
                            }
                            if (this.db.on()) {
                                this.db.println("spliceLinks: Link successfully spliced");
                            }
                            linkedList3.add(object);
                            bl = true;
                            break;
                        }
                        if (this.db.on()) {
                            this.db.println("spliceLinks: Link successfully spliced");
                        }
                        linkedList3.add(object);
                        bl = true;
                        if (nonRoutableNetLink.getPhysicalSize() > ((AbstractNetLink)object).getPhysicalSize()) {
                            linkedList.add(nonRoutableNetLink);
                            break;
                        }
                        linkedList.add(object);
                        break;
                    }
                    linkedList3.add(object);
                    linkedList4.remove(object);
                    object2 = object;
                    if (!this.db.on()) continue;
                    this.db.println("spliceLinks: found match, setting new seed");
                    continue;
                }
                object2 = object;
            }
            if (bl) {
                this.createCompositeLink(linkedList3, linkedList);
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                NonRoutableNetLink nonRoutableNetLink2 = (NonRoutableNetLink)object.next();
                if (!nonRoutableNetLink2.isXcCapable()) continue;
                if (this.db.on()) {
                    this.db.println("spliceLinks: adding required link " + nonRoutableNetLink2.toString() + " to SRC term links");
                }
                linkedList2.add(nonRoutableNetLink2);
            }
            linkedList.clear();
        }
    }

    private int getProtectSlot(NonRoutableNetLink nonRoutableNetLink, boolean bl) {
        block4: {
            int n = nonRoutableNetLink.getLinkModel().getYCableProtectPortEntityIndex();
            INodeModel iNodeModel = bl ? nonRoutableNetLink.getSrc().getNodeModel() : nonRoutableNetLink.getDst().getNodeModel();
            try {
                IEntityModel iEntityModel;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(n)) != null) {
                    int n2 = iEntityModel.getSlot();
                    if (this.db.on()) {
                        this.db.println("getProtectSlot: NE " + iNodeModel.getHostName() + ", YCable prot slot " + n2);
                    }
                    return n2;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block4;
                this.db.println("getProtectSlot: entity index invalid");
            }
        }
        return 0;
    }

    private int[] getProtectPort(NonRoutableNetLink nonRoutableNetLink, boolean bl) {
        block4: {
            int n = nonRoutableNetLink.getLinkModel().getYCableProtectPortEntityIndex();
            INodeModel iNodeModel = bl ? nonRoutableNetLink.getSrc().getNodeModel() : nonRoutableNetLink.getDst().getNodeModel();
            try {
                IEntityModel iEntityModel;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(n)) != null) {
                    int[] nArray = AbstractNetLink.getPortNum(iEntityModel);
                    if (this.db.on()) {
                        this.db.println("getProtectPort: NE " + iNodeModel.getHostName() + ", YCable prot port " + PortHelper.getConcatenatedString((int[])nArray));
                    }
                    return nArray;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block4;
                this.db.println("getProtectPort: entity index invalid");
            }
        }
        return new int[0];
    }

    private NonRoutableNetLink findMatchingLink(INetElement iNetElement, int n, int[] nArray, boolean bl, Collection collection) {
        NonRoutableNetLink nonRoutableNetLink;
        Iterator iterator;
        NonRoutableNetLink nonRoutableNetLink2 = null;
        if (this.db.on()) {
            this.db.println("findMatchingLink: for NE " + iNetElement.getHostName() + ", slot => " + n + ", port => " + PortHelper.getConcatenatedString((int[])nArray) + ", trunk => " + bl);
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                nonRoutableNetLink = (NonRoutableNetLink)iterator.next();
                this.db.println("candidate NL => " + nonRoutableNetLink.toString());
            }
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            nonRoutableNetLink = (NonRoutableNetLink)iterator.next();
            if (this.db.on()) {
                this.db.println("findMatchingLink: trying NL " + nonRoutableNetLink.toString());
                this.db.println("findMatchingLink: src slot => " + nonRoutableNetLink.getSrcSlot() + ", src port => " + PortHelper.getConcatenatedString((int[])nonRoutableNetLink.getSrcPort()) + ", src DWDM => " + nonRoutableNetLink.isSrcDwdmPort());
            }
            if (!nonRoutableNetLink.isValid()) {
                if (!this.db.on()) continue;
                this.db.println("findMatchingLink: ignoring invalid NL");
                continue;
            }
            if (this.doEndpointsMatch(iNetElement, n, nArray, bl, nonRoutableNetLink.getSrc(), nonRoutableNetLink.getSrcSlot(), nonRoutableNetLink.getSrcPort(), nonRoutableNetLink.isSrcDwdmPort())) {
                if (this.db.on()) {
                    this.db.println("findMatchingLink: found matching NL " + nonRoutableNetLink.toString());
                }
                nonRoutableNetLink2 = nonRoutableNetLink;
                break;
            }
            if (nonRoutableNetLink.getProtectionType() != 7) continue;
            if (this.db.on()) {
                this.db.println("findMatchingLink: match not found using YCable working port, trying protect port");
            }
            int n2 = this.getProtectSlot(nonRoutableNetLink, true);
            int[] nArray2 = this.getProtectPort(nonRoutableNetLink, true);
            if (!this.doEndpointsMatch(iNetElement, n, nArray, bl, nonRoutableNetLink.getSrc(), n2, nArray2, nonRoutableNetLink.isSrcDwdmPort())) continue;
            if (this.db.on()) {
                this.db.println("findMatchingLink: found matching NL " + nonRoutableNetLink.toString());
            }
            nonRoutableNetLink2 = nonRoutableNetLink;
            break;
        }
        return nonRoutableNetLink2;
    }

    private boolean doEndpointsMatch(INetElement iNetElement, int n, int[] nArray, boolean bl, INetElement iNetElement2, int n2, int[] nArray2, boolean bl2) {
        return iNetElement == iNetElement2 && n == n2 && bl != bl2 && ComparisonUtil.compare((int[])nArray, (int[])nArray2) != 0;
    }

    private void createCompositeLink(Collection collection, Collection collection2) {
        CmsObservable cmsObservable;
        if (this.db.on()) {
            this.db.println("createCompositeLink: Composite Link components:");
        }
        AbstractNetLink abstractNetLink = null;
        AbstractNetLink abstractNetLink2 = null;
        LinkedList<NonRoutableNetLink> linkedList = new LinkedList<NonRoutableNetLink>();
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            cmsObservable = (NonRoutableNetLink)iterator.next();
            if (this.db.on()) {
                this.db.println("createCompositeLink:     " + cmsObservable.toString());
            }
            cmsObservable.setIsSpliced(true);
            n += cmsObservable.getCost();
            if (cmsObservable.getLinkModel().isXcCapable()) {
                abstractNetLink = cmsObservable;
                if (collection2.contains((Object)cmsObservable)) continue;
                this.sourceTerminatedLinkList.remove((Object)cmsObservable);
                cmsObservable.deleteObserver(this);
                continue;
            }
            if (cmsObservable.getLinkModel().isNbrXcCapable()) {
                abstractNetLink2 = cmsObservable;
                if (collection2.contains((Object)cmsObservable)) continue;
                this.unprocessedLinkList.remove((Object)cmsObservable);
                cmsObservable.deleteObserver(this);
                continue;
            }
            linkedList.add((NonRoutableNetLink)cmsObservable);
        }
        cmsObservable = new LinkModel(abstractNetLink.getSrc().getNodeModel(), abstractNetLink.getSrcEntityIndex(), null, abstractNetLink2.getDst().getNodeModel(), abstractNetLink2.getDstEntityIndex(), null, abstractNetLink.getLinkModel().linkType(), abstractNetLink.getLinkModel().physicalType(), abstractNetLink.getLinkModel().physicalLinkType(), true, true, -1, -1, 3, "", 0, abstractNetLink.getLinkModel().protectionGroup(), abstractNetLink.getLinkModel().protectionRole(), n, 0, 0);
        CompositeNetLink compositeNetLink = new CompositeNetLink(this.net, (ILinkModel)cmsObservable, (NonRoutableNetLink)abstractNetLink, (NonRoutableNetLink)abstractNetLink2, linkedList);
        this.net.addCompositeNetLink(compositeNetLink);
    }

    private void createDwdmLink(OscNetLink oscNetLink) throws NoSuchEquipment {
        int n = 0;
        int n2 = 0;
        try {
            if (this.db.on()) {
                this.db.println("createDwdmLink: getNodeOutputEntityIdx From:" + oscNetLink.getSrc().getHostName() + " To:" + oscNetLink.getDst().getHostName() + " Link dir.:" + CircuitOptDir.getCktOptDirStringFromCktOptDir(oscNetLink.getOptLinkDir()));
            }
            n = oscNetLink.getSrc().getNodeModel().getNodeOutputEntityIdx(oscNetLink.getOptLinkDir());
            if (this.db.on()) {
                this.db.println("createDwdmLink: srcEntityIdx " + Integer.toHexString(n));
            }
        }
        catch (NoSuchEquipment noSuchEquipment) {
            if (this.db.on()) {
                this.db.println("createDwdmLink exception on getNodeOutputEntityIdx: " + (Object)((Object)noSuchEquipment));
            }
            throw new NoSuchEquipment("createDwdmLink exception: ");
        }
        try {
            if (this.db.on()) {
                this.db.println("createDwdmLink: getNodeInputEntityIdx From:" + oscNetLink.getDst().getHostName() + " To:" + oscNetLink.getSrc().getHostName() + " Link dir.:" + CircuitOptDir.getCktOptDirStringFromCktOptDir(oscNetLink.getOptLinkDir()));
            }
            n2 = oscNetLink.getDst().getNodeModel().getNodeInputEntityIdx(oscNetLink.getOptLinkDir());
            if (this.db.on()) {
                this.db.println("createDwdmLink: dstEntityIdx " + Integer.toHexString(n2));
            }
        }
        catch (NoSuchEquipment noSuchEquipment) {
            if (this.db.on()) {
                this.db.println("createDwdmLink exception on getNodeInputEntityIdx: " + (Object)((Object)noSuchEquipment));
            }
            throw new NoSuchEquipment("createDwdmLink exception: ");
        }
        INetElement iNetElement = oscNetLink.getSrc();
        INetElement iNetElement2 = oscNetLink.getDst();
        Topology topology = oscNetLink.getTopology();
        LinkModel linkModel = new LinkModel(oscNetLink.getSrc().getNodeModel(), n, null, oscNetLink.getDst().getNodeModel(), n2, null, 1, 5, 5, true, true, -1, -1, 3, "", 0, 0, 0, 0, 0, 0);
        INetLink iNetLink = Network.instance().findNetLink(iNetElement, n, null, iNetElement2, n2, null, false);
        if (iNetLink == null) {
            iNetLink = NetLinkFactory.createNetLink(this.net, (ILinkModel)linkModel, iNetElement, iNetElement2, topology, false, false);
            this.net.addDwdmNetLink(iNetLink);
            if (this.db.on()) {
                this.db.println("createDwdmLink: link is new, add it to network");
            }
        } else if (this.db.on()) {
            this.db.println("createDwdmLink: link is already in the network");
        }
        ((DwdmNetLink)iNetLink).setOptAttribs(oscNetLink.getOptRingName(), oscNetLink.getOptLinkDir());
        ((DwdmNetLink)iNetLink).startObserving(oscNetLink);
    }

    private UnknownNetLink getNextUnknownLink() {
        UnknownNetLink unknownNetLink;
        block3: {
            unknownNetLink = null;
            try {
                if (!this.unknownLinkList.isEmpty()) {
                    unknownNetLink = (UnknownNetLink)this.unknownLinkList.remove(0);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!this.db.on()) break block3;
                this.db.println("getNextUnknownLink: no Unknown links to process");
            }
        }
        return unknownNetLink;
    }

    private void processUnknownLinks() {
        UnknownNetLink unknownNetLink = this.getNextUnknownLink();
        while (unknownNetLink != null) {
            if (this.db.on()) {
                this.db.println("processUnknownLinks: processing NL " + unknownNetLink.toString());
            }
            LinkModel linkModel = (LinkModel)unknownNetLink.getLinkModel();
            LinkModel linkModel2 = new LinkModel(unknownNetLink.getSrc().getNodeModel(), unknownNetLink.getSrcEntityIndex(), null, unknownNetLink.getDst().getNodeModel(), unknownNetLink.getDstEntityIndex(), null, 1, unknownNetLink.getPhysicalType(), unknownNetLink.getPhysicalLinkType(), unknownNetLink.isXcCapable(), unknownNetLink.isNbrXcCapable(), -1, -1, unknownNetLink.getProtectionType(), linkModel.blsrRingName(), linkModel.blsrNodeId(), linkModel.protectionGroup(), linkModel.protectionRole(), linkModel.cost(), linkModel.pcaRevertMode(), linkModel.getLinkDir());
            INetLink iNetLink = NetLinkFactory.createNetLink(this.net, (ILinkModel)linkModel2, unknownNetLink.getSrc(), unknownNetLink.getDst(), unknownNetLink.getTopology(), unknownNetLink.isSdccLink(), true);
            this.net.replaceUnknownLink(unknownNetLink, iNetLink);
            unknownNetLink = this.getNextUnknownLink();
        }
    }

    private void processOscLinks() {
        Iterator iterator = this.getOscLinks().iterator();
        while (iterator.hasNext()) {
            OscNetLink oscNetLink = (OscNetLink)iterator.next();
            if (this.db.on()) {
                this.db.println("processOscLinks: processing NL " + oscNetLink.toString());
            }
            try {
                this.createDwdmLink(oscNetLink);
                this.deleteNetLink(oscNetLink);
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!this.db.on()) continue;
                this.db.println("NoSuchEquipment: processing NL " + oscNetLink.toString());
            }
        }
    }

    protected void doAction() {
        this.processUnknownLinks();
        this.processOscLinks();
        this.spliceLinks();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof INetLink) {
            INetLink iNetLink = (INetLink)((Object)observable);
            if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from " + iNetLink.toString());
                }
                this.newNetLink(iNetLink);
            } else if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from " + iNetLink.toString());
                }
                this.deleteNetLink(iNetLink);
            }
        }
    }

    public class NetLinkManagerDebug
    extends SDebug {
        public NetLinkManagerDebug(String string) {
            super(string);
        }

        public final void dump() {
            this.dumpSrcTermLinks();
            this.dumpUnprocessedLinks();
            this.dumpUnknownLinks();
        }

        public final void dumpSrcTermLinks() {
            NetLinkManager.this.db.println("======================================");
            NetLinkManager.this.db.println("SRC term. Links:");
            Iterator iterator = NetLinkManager.this.sourceTerminatedLinkList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                NetLinkManager.this.db.println(iNetLink.toString());
            }
        }

        public final void dumpUnprocessedLinks() {
            NetLinkManager.this.db.println("======================================");
            NetLinkManager.this.db.println("Unprocessed Links:");
            Iterator iterator = NetLinkManager.this.unprocessedLinkList.iterator();
            while (iterator.hasNext()) {
                NonRoutableNetLink nonRoutableNetLink = (NonRoutableNetLink)iterator.next();
                NetLinkManager.this.db.println(nonRoutableNetLink.toString());
            }
        }

        public final void dumpUnknownLinks() {
            NetLinkManager.this.db.println("=======================================");
            NetLinkManager.this.db.println("Unknown Links:");
            Iterator iterator = NetLinkManager.this.unknownLinkList.iterator();
            while (iterator.hasNext()) {
                UnknownNetLink unknownNetLink = (UnknownNetLink)iterator.next();
                NetLinkManager.this.db.println(unknownNetLink.toString());
            }
        }

        public final void dumpObservers() {
        }
    }
}

