/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoServerTrailEnd;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoServerTrailEnd;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPoolModels;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LinkModel;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.PathInUse;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ServerTrailLinkId;
import cerent.cms.model.User;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.RollManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ocm.OhCircuitWatchDog;
import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.GenericSrg;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.INetwork;
import cerent.cms.topo.ITopology;
import cerent.cms.topo.InvalidTopoOperation;
import cerent.cms.topo.LinkComparator;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetElementDeletionException;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparatorKey;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.NetLinkManager;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.PhantomLinkException;
import cerent.cms.topo.ServerTrailException;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.topo.ServerTrailPrefs;
import cerent.cms.topo.Topology;
import cerent.cms.topo.UnknownNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.HoLoRange;
import cerent.util.IDebugDiag;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Network
extends CmsObservable
implements INetwork,
IObserver {
    private static final HoLoComparator holoComp = HoLoComparator.instance();
    private Map allNetLinks;
    private Map netElems;
    private Map netElemsByIp;
    private Map nodeNameMap;
    private Map waitQ;
    private Map svTrailLinks;
    private Map svTrailPrimCTPs;
    private Map svTrailPeerCTPs;
    private Object masterTrailLock;
    private List trailNodesToHandle;
    private int nextId;
    protected static Network network;
    private Map topologies;
    private List topoNEs;
    private List redundantLinks;
    private List limitedNodes = null;
    private int nextTopoId = 1;
    protected static String errString;
    private NetElementCreationNotifier netElementCreationNotifier;
    private NetLinkCreationNotifier netLinkCreationNotifier;
    private TopologyCreationNotifier topologyCreationNotifier;
    private boolean active = false;
    private List topologyUpdateQueue;
    private NetworkActionClient networkActionClient = null;
    private boolean enableCircuitDiscovery = false;
    private static boolean addNetEleCompleted;
    protected NetworkDebug db = new NetworkDebug();

    public static synchronized Network instance() {
        if (network == null) {
            network = new Network();
        }
        return network;
    }

    private Network() {
        this.allNetLinks = Collections.synchronizedMap(new TreeMap(new LinkComparator()));
        this.netElems = Collections.synchronizedMap(new TreeMap());
        this.netElemsByIp = Collections.synchronizedMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.topologies = Collections.synchronizedMap(new HashMap());
        this.topoNEs = Collections.synchronizedList(new LinkedList());
        this.waitQ = Collections.synchronizedMap(new HashMap());
        this.svTrailLinks = Collections.synchronizedMap(new TreeMap(new TrailIdComparator()));
        this.svTrailPrimCTPs = Collections.synchronizedMap(new TreeMap(new TrailIdComparator()));
        this.svTrailPeerCTPs = Collections.synchronizedMap(new TreeMap(new TrailIdComparator()));
        this.masterTrailLock = new Object();
        this.trailNodesToHandle = Collections.synchronizedList(new LinkedList());
        this.nodeNameMap = Collections.synchronizedMap(new HashMap());
        this.redundantLinks = Collections.synchronizedList(new LinkedList());
        this.topologyUpdateQueue = Collections.synchronizedList(new LinkedList());
        this.netElementCreationNotifier = new NetElementCreationNotifier();
        this.netLinkCreationNotifier = new NetLinkCreationNotifier();
        this.topologyCreationNotifier = new TopologyCreationNotifier();
        this.networkActionClient = new NetworkActionClient();
        Topology topology = new Topology(this, 0, false);
        this.topologies.put(new Integer(0), topology);
        this.getTopologyCreationNotifier().changed(topology);
        this.netElementCreationNotifier.addObserver(NetCircuitWatchDog.instance());
        this.netLinkCreationNotifier.addObserver(NetCircuitSplicer.instance());
        this.netLinkCreationNotifier.addObserver(VlanSetManager.instance());
        this.netElementCreationNotifier.addObserver(VlanSetManager.instance());
        this.netElementCreationNotifier.addObserver(OhCircuitWatchDog.instance());
        this.netLinkCreationNotifier.addObserver(OhCircuitWatchDog.instance());
        this.netElementCreationNotifier.addObserver(RollManager.instance());
        this.active = true;
    }

    protected void queueTopologyUpdateEvent(Topology topology) {
        if (this.db.on()) {
            this.db.println("queueTopologyUpdateEvent: for Topo " + topology.getTopoId());
        }
        this.topologyUpdateQueue.add(topology);
        ThreadPool.instance().enqueueClient((IActionClient)this.networkActionClient);
    }

    protected void queueNetworkUpdateEvent() {
        ThreadPool.instance().enqueueClient((IActionClient)this.networkActionClient);
    }

    private void cleanupOrphanedLinks() {
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink.getLinkModel().linkType() == 7 || iNetLink.getLinkModel().linkType() == 2 || iNetLink.getLinkModel().linkType() == 3 || iNetLink.getLinkModel().linkType() == 9 || iNetLink.getLinkModel().linkType() == 8 || this.topologies.containsKey(new Integer(iNetLink.getTopoId()))) continue;
            this.db.println("cleanupOrphanedLinks: removing orphaned NL " + iNetLink.prettyStringDetail());
            iNetLink.dispose();
        }
    }

    public void addNetElementCreationObserver(IObserver iObserver) {
        this.netElementCreationNotifier.addObserver(iObserver);
    }

    public void setExcludeDyn(boolean bl) {
        this.limitedNodes = bl ? Collections.synchronizedList(new LinkedList()) : null;
        if (this.db.on()) {
            this.db.println("Exclude dynamically discovered nodes=" + bl);
        }
    }

    public void setEnableCircuitDiscovery(boolean bl) {
        if (!this.enableCircuitDiscovery) {
            if (this.db.on()) {
                this.db.println("Enabling Circuit Discovery from " + this.enableCircuitDiscovery + " -> " + bl);
            }
            this.enableCircuitDiscovery = bl;
        }
    }

    public boolean getEnableCircuitDiscovery() {
        return this.enableCircuitDiscovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverServerTrails() {
        Object object;
        if (this.trailNodesToHandle.size() == 0) {
            return;
        }
        if (this.db.on()) {
            this.db.println("Discovering ServerTrails on " + this.trailNodesToHandle.size() + "node/s");
        }
        LinkedList linkedList = new LinkedList(this.trailNodesToHandle);
        Object object2 = this.trailNodesToHandle;
        synchronized (object2) {
            this.trailNodesToHandle.clear();
        }
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            object = (INetElement)object2.next();
            if (this.findNetElem((INetElement)object) == null) {
                if (this.db.on()) {
                    this.db.println("Removing node " + object.getName() + "from TrailToHandle list");
                }
                object2.remove();
                continue;
            }
            INodeModel iNodeModel = object.getNodeModel();
            if (!iNodeModel.isInited()) continue;
            if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
                if (this.db.on()) {
                    this.db.println("discoverServerTrails: STrail not supported at node " + iNodeModel.getName());
                }
                object2.remove();
                continue;
            }
            IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
            if (iServerTrailsManager == null || !iServerTrailsManager.isInited()) continue;
            ModelIndirectObservable.instance().addObserver((IObservable)iServerTrailsManager, this);
            this.deleteServerTrail(iServerTrailsManager);
            this.addNewServerTrail(iServerTrailsManager);
            object2.remove();
        }
        if (linkedList.size() != 0) {
            object = this.trailNodesToHandle;
            synchronized (object) {
                this.trailNodesToHandle.addAll(linkedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getServerTrails(INetElement iNetElement) {
        INodeModel iNodeModel;
        if (this.db.on()) {
            this.db.println("getServerTrails for " + iNetElement.getName());
        }
        if (!(iNodeModel = iNetElement.getNodeModel()).isInited()) {
            List list = this.trailNodesToHandle;
            synchronized (list) {
                if (!this.trailNodesToHandle.contains(iNetElement)) {
                    this.trailNodesToHandle.add(iNetElement);
                }
                return;
            }
        }
        if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
            if (this.db.on()) {
                this.db.println("getServerTrails: STrail not supported at node " + iNodeModel.getName());
            }
            return;
        }
        IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
        if (iServerTrailsManager != null) {
            ModelIndirectObservable.instance().addObserver((IObservable)iServerTrailsManager, this);
            this.addNewServerTrail(iServerTrailsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerTrails(INetElement iNetElement) {
        if (this.db.on()) {
            this.db.println("updateServerTrails for ne " + iNetElement.getName());
        }
        List list = this.trailNodesToHandle;
        synchronized (list) {
            if (!this.trailNodesToHandle.contains(iNetElement)) {
                this.trailNodesToHandle.add(iNetElement);
            }
        }
    }

    private void handleServerTrailCtp(IServerTrailsManager iServerTrailsManager, Object object) {
        if (object == ModelUpdateType.ADDED) {
            if (this.db.on()) {
                this.db.println("received ADDED event for ServerTrails");
            }
            this.addNewServerTrail(iServerTrailsManager);
        }
        if (object == ModelUpdateType.DELETED && this.db.on()) {
            this.db.println("received DELETED event for ServerTrails");
        }
        if (object == ModelUpdateType.CHANGED) {
            if (this.db.on()) {
                this.db.println("received CHANGED event for ServerTrails");
            }
            this.deleteServerTrail(iServerTrailsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewServerTrail(IServerTrailsManager iServerTrailsManager) {
        INetElement iNetElement;
        INodeModel iNodeModel = iServerTrailsManager.getNodeModel();
        try {
            iNetElement = this.findNetElem(iNodeModel);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (iNetElement == null) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (!iServerTrailsManager.isInited()) {
            this.db.println("addStrl:: SvMgr at is not initialized");
            return;
        }
        IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Received " + iServerTrailEndArray.length + " CTP objects on" + iNetElement.getName());
            this.db.println("=================================================");
        }
        for (int i = 0; i < iServerTrailEndArray.length; ++i) {
            List list;
            INetElement iNetElement2;
            IServerTrailLinkId iServerTrailLinkId;
            IServerTrailEnd iServerTrailEnd;
            block30: {
                iServerTrailEnd = iServerTrailEndArray[i];
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                String string = iServerTrailEnd.getPeerIpAddr();
                try {
                    InetUtil.parseDottedString(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.db.println("ERROR: Invalid PEER-IPAddress on SVTrail CTP");
                    return;
                }
                iNetElement2 = this.findNetElemByIp(string);
                if (iNetElement2 == null) {
                    try {
                        if (this.db.on()) {
                            this.db.println("SVDiscovery : Adding node " + string);
                        }
                        iNetElement2 = this.addNetElement(string, iNodeModel.getUserName(), iNodeModel.getUserPassword());
                        this.createTopology(iNetElement2);
                        list = this.trailNodesToHandle;
                        synchronized (list) {
                            if (!this.trailNodesToHandle.contains(iNetElement2)) {
                                this.trailNodesToHandle.add(iNetElement2);
                            }
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (this.db.on()) {
                            this.db.println("Unable to add node " + string + " Ex " + unknownHostException);
                        }
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (!this.db.on()) break block30;
                        this.db.println("Unable to add node " + string + " Ex " + (Object)((Object)abstractCmsIOException));
                    }
                }
            }
            INetLink iNetLink = this.findSvLink(iServerTrailLinkId);
            IServerTrailEnd iServerTrailEnd2 = this.findSvPrimCTP(iServerTrailLinkId);
            IServerTrailEnd iServerTrailEnd3 = this.findSvPeerCTP(iServerTrailLinkId);
            if (iServerTrailEnd2 != null && this.getCtpNe(iServerTrailEnd2, iNetElement) == null || iServerTrailEnd3 != null && this.getCtpNe(iServerTrailEnd3, iNetElement) == null) continue;
            if (iServerTrailEnd2 == null) {
                if (this.db.on()) {
                    this.db.println("DiscoverServerTrail: Found 1st CTP.");
                }
                this.putSvPrimCTP(iServerTrailEnd);
                if (iServerTrailEnd3 != null) {
                    this.createServerTrailLink(iServerTrailLinkId);
                }
                list = this.trailNodesToHandle;
                synchronized (list) {
                    if (!this.trailNodesToHandle.contains(iNetElement2)) {
                        this.trailNodesToHandle.add(iNetElement2);
                    }
                    continue;
                }
            }
            if (this.ctpMatch(iServerTrailEnd, iServerTrailEnd2)) {
                if (!this.db.on()) continue;
                this.db.println("DiscoverServerTrail: Found matching CTP in Primary list.");
                continue;
            }
            if (iServerTrailEnd3 == null) {
                if (this.db.on()) {
                    this.db.println("DiscoverServerTrail: Found 2nd CTP. Creating link");
                }
                this.putSvPeerCTP(iServerTrailEnd);
                this.createServerTrailLink(iServerTrailLinkId);
                continue;
            }
            if (this.ctpMatch(iServerTrailEnd3, iServerTrailEnd)) {
                if (this.db.on() && iNetLink == null) {
                    this.db.println("ERROR: ServerTrail missing even after both CTPs have been discovered");
                }
                this.createServerTrailLink(iServerTrailLinkId);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("ERROR: More than 2 CTPs with same svId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteServerTrail(IServerTrailsManager iServerTrailsManager) {
        INetElement iNetElement;
        IServerTrailEnd iServerTrailEnd;
        INetElement iNetElement2;
        INodeModel iNodeModel = iServerTrailsManager.getNodeModel();
        try {
            iNetElement2 = this.findNetElem(iNodeModel);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (iNetElement2 == null) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (!iServerTrailsManager.isInited()) {
            this.db.println("dStrl:: svMgr is not initialized");
            return;
        }
        IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Currently " + iServerTrailEndArray.length + " CTP objects on" + iNetElement2.getName());
            this.db.println("=================================================");
        }
        LinkedList linkedList = new LinkedList();
        TreeMap<ServerTrailLinkId, IServerTrailEnd> treeMap = new TreeMap<ServerTrailLinkId, IServerTrailEnd>(new TrailIdComparator());
        Iterator iterator = this.masterTrailLock;
        synchronized (iterator) {
            linkedList.addAll(this.svTrailPrimCTPs.values());
            linkedList.addAll(this.svTrailPeerCTPs.values());
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iServerTrailEnd = (IServerTrailEnd)iterator.next();
            iNetElement = this.getCtpNe(iServerTrailEnd, iNetElement2);
            if (iNetElement == null || !iNetElement.equals(iNetElement2)) continue;
            treeMap.put(new ServerTrailLinkId(iServerTrailEnd.getServerTrailLinkId().getNodeId(), iServerTrailEnd.getServerTrailLinkId().getUniqueId()), iServerTrailEnd);
        }
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Previously " + treeMap.size() + " CTP objects on" + iNetElement2.getName());
            this.db.println("=================================================");
        }
        for (int i = 0; i < iServerTrailEndArray.length; ++i) {
            iServerTrailEnd = iServerTrailEndArray[i];
            treeMap.remove(new ServerTrailLinkId(iServerTrailEnd.getServerTrailLinkId().getNodeId(), iServerTrailEnd.getServerTrailLinkId().getUniqueId()));
        }
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Update:: " + treeMap.size() + " CTP objects to be removed at" + iNetElement2.getName());
            this.db.println("=================================================");
        }
        if (treeMap.size() < 1) {
            if (this.db.on()) {
                this.db.println("No CTP removal needed at " + iNetElement2.getName());
            }
            return;
        }
        LinkedList linkedList2 = new LinkedList(treeMap.values());
        iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            Object object;
            IServerTrailLinkId iServerTrailLinkId;
            block28: {
                iServerTrailEnd = (IServerTrailEnd)iterator.next();
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                if (iServerTrailLinkId == null) {
                    if (!this.db.on()) continue;
                    this.db.println("Got a null svId for a CTP");
                    continue;
                }
                try {
                    if (this.db.on()) {
                        this.db.println("Removing ctp with svId::Uid " + iServerTrailLinkId.getUniqueId());
                    }
                    this.removeServerTrail(iServerTrailLinkId, false);
                }
                catch (ServerTrailException serverTrailException) {
                    if (!this.db.on()) break block28;
                    this.db.println("removeServerTrail: Update caught exception, e = \n" + serverTrailException.getMessage());
                }
            }
            ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
            iServerTrailEnd = this.findSvPeerCTP(serverTrailLinkId);
            if (iServerTrailEnd != null && (iNetElement = this.getCtpNe(iServerTrailEnd, iNetElement2)) != null && iNetElement.equals(iNetElement2)) {
                if (this.db.on()) {
                    this.db.println("PeerList: Removing CTP with Uid " + serverTrailLinkId.getUniqueId());
                }
                object = this.masterTrailLock;
                synchronized (object) {
                    this.svTrailPeerCTPs.remove(serverTrailLinkId);
                }
            }
            if ((iServerTrailEnd = this.findSvPrimCTP(serverTrailLinkId)) == null || (iNetElement = this.getCtpNe(iServerTrailEnd, iNetElement2)) == null || !iNetElement.equals(iNetElement2)) continue;
            if (this.db.on()) {
                this.db.println("PrimaryList: Removing CTP with Uid " + serverTrailLinkId.getUniqueId());
            }
            object = this.masterTrailLock;
            synchronized (object) {
                this.svTrailPrimCTPs.remove(serverTrailLinkId);
            }
        }
    }

    private INetElement getCtpNe(IServerTrailEnd iServerTrailEnd, INetElement iNetElement) {
        try {
            if (iServerTrailEnd instanceof IHoServerTrailEnd) {
                INodeModel iNodeModel = ((IHoServerTrailEnd)iServerTrailEnd).getTrailStart().getNodeModel();
                return this.findNetElem(iNodeModel);
            }
            if (iServerTrailEnd instanceof ILoServerTrailEnd) {
                ILoAditModel iLoAditModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart().getLoAdit();
                if (iLoAditModel != null) {
                    INodeModel iNodeModel = iLoAditModel.getHo().getNodeModel();
                    return this.findNetElem(iNodeModel);
                }
            } else if (this.db.on()) {
                this.db.println(" Unknown CTP instance ");
            }
        }
        catch (Exception exception) {
            this.db.println("getCtpNe: caught Exception => " + exception.getMessage() + "Returning null");
            this.invalidCTP(iServerTrailEnd, iNetElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidCTP(IServerTrailEnd iServerTrailEnd, INetElement iNetElement) {
        LinkedList<INetElement> linkedList;
        block11: {
            INetElement iNetElement2;
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            linkedList = new LinkedList<INetElement>();
            if (iNetElement != null && !this.trailNodesToHandle.contains(iNetElement)) {
                linkedList.add(iNetElement);
            }
            if ((iNetElement2 = this.findNetElem(iServerTrailLinkId.getNodeId())) != null && !this.trailNodesToHandle.contains(iNetElement2)) {
                linkedList.add(iNetElement2);
            }
            INetElement iNetElement3 = null;
            INetElement iNetElement4 = null;
            ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
            IServerTrailEnd iServerTrailEnd2 = this.findSvPrimCTP(serverTrailLinkId);
            if (iServerTrailEnd2 != null) {
                iNetElement3 = this.findNetElemByIp(iServerTrailEnd2.getPeerIpAddr());
                if (iNetElement3 != null && !this.trailNodesToHandle.contains(iNetElement3)) {
                    linkedList.add(iNetElement3);
                }
                this.svTrailPrimCTPs.remove(serverTrailLinkId);
            }
            if ((iServerTrailEnd2 = this.findSvPeerCTP(serverTrailLinkId)) != null) {
                iNetElement4 = this.findNetElemByIp(iServerTrailEnd2.getPeerIpAddr());
                if (iNetElement4 != null && !this.trailNodesToHandle.contains(iNetElement4)) {
                    linkedList.add(iNetElement4);
                }
                this.svTrailPeerCTPs.remove(serverTrailLinkId);
            }
            try {
                this.removeServerTrail(serverTrailLinkId, false);
            }
            catch (ServerTrailException serverTrailException) {
                if (!this.db.on()) break block11;
                this.db.println("removeServerTrail: Caught exception at invalidCtp");
            }
        }
        List list = this.trailNodesToHandle;
        synchronized (list) {
            this.trailNodesToHandle.addAll(linkedList);
        }
    }

    private void handleCTPChange(IServerTrailsManager iServerTrailsManager) {
    }

    private boolean ctpMatch(IServerTrailEnd iServerTrailEnd, IServerTrailEnd iServerTrailEnd2) {
        IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
        IServerTrailLinkId iServerTrailLinkId2 = iServerTrailEnd2.getServerTrailLinkId();
        if (iServerTrailEnd instanceof IHoServerTrailEnd && iServerTrailEnd2 instanceof IHoServerTrailEnd) {
            IHoPathDefModel iHoPathDefModel = ((IHoServerTrailEnd)iServerTrailEnd).getTrailStart();
            IHoPathDefModel iHoPathDefModel2 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            INodeModel iNodeModel = iHoPathDefModel.getNodeModel();
            INodeModel iNodeModel2 = iHoPathDefModel2.getNodeModel();
            if (iServerTrailLinkId.getNodeId() == iServerTrailLinkId2.getNodeId() && iServerTrailLinkId.getUniqueId() == iServerTrailLinkId2.getUniqueId() && this.findNetElem(iNodeModel).getNodeId() == this.findNetElem(iNodeModel2).getNodeId()) {
                return true;
            }
        } else if (iServerTrailEnd instanceof ILoServerTrailEnd && iServerTrailEnd2 instanceof ILoServerTrailEnd) {
            ILoDefModel iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
            ILoDefModel iLoDefModel2 = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            INodeModel iNodeModel = iLoDefModel.getLoAdit().getHo().getNodeModel();
            INodeModel iNodeModel3 = iLoDefModel2.getLoAdit().getHo().getNodeModel();
            if (iServerTrailLinkId.getNodeId() == iServerTrailLinkId2.getNodeId() && iServerTrailLinkId.getUniqueId() == iServerTrailLinkId2.getUniqueId() && this.findNetElem(iNodeModel).getNodeId() == this.findNetElem(iNodeModel3).getNodeId()) {
                return true;
            }
        }
        return false;
    }

    public INetLink findSvLink(IServerTrailLinkId iServerTrailLinkId) {
        return (INetLink)this.svTrailLinks.get(new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServerTrailEnd findSvPrimCTP(IServerTrailLinkId iServerTrailLinkId) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            return (IServerTrailEnd)this.svTrailPrimCTPs.get(new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServerTrailEnd findSvPeerCTP(IServerTrailLinkId iServerTrailLinkId) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            return (IServerTrailEnd)this.svTrailPeerCTPs.get(new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSvPrimCTP(IServerTrailEnd iServerTrailEnd) {
        IServerTrailEnd iServerTrailEnd2 = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            iServerTrailEnd2 = this.findSvPrimCTP(iServerTrailLinkId);
            if (iServerTrailEnd2 == null) {
                ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
                this.svTrailPrimCTPs.put(serverTrailLinkId, iServerTrailEnd);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSvPeerCTP(IServerTrailEnd iServerTrailEnd) {
        IServerTrailEnd iServerTrailEnd2 = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            iServerTrailEnd2 = this.findSvPeerCTP(iServerTrailLinkId);
            if (iServerTrailEnd2 == null) {
                ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
                this.svTrailPeerCTPs.put(serverTrailLinkId, iServerTrailEnd);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSvLink(INetLink iNetLink) {
        INetLink iNetLink2 = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            IServerTrailLinkId iServerTrailLinkId = ((ServerTrailLink)iNetLink).getPrefs().getTrailId();
            iNetLink2 = this.findSvLink(iServerTrailLinkId);
            if (iNetLink2 == null) {
                ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
                this.svTrailLinks.put(serverTrailLinkId, iNetLink);
                return true;
            }
        }
        return false;
    }

    public INetElement findNetElemByIp(String string) {
        if (this.db.on()) {
            this.db.println("findNetElemByIp: looking for NE with ip " + string);
        }
        return (INetElement)this.netElemsByIp.get(string);
    }

    protected void updateIPAddress(NetElement netElement, String string) {
        if (!this.netElemsByIp.containsKey(netElement.getHostName())) {
            if (this.db.on()) {
                this.db.println("updateIPAddress: IP address of NE has changed from " + string + " to " + netElement.getHostName());
            }
            this.netElemsByIp.remove(string);
            this.addNetElementToIPMap(netElement.getHostName(), netElement);
        }
    }

    protected void updateSecureIPAddress(NetElement netElement, String string) {
        if (!this.netElemsByIp.containsKey(netElement.getSecureIPAddress())) {
            if (this.db.on()) {
                this.db.println("updateSecureIPAddress: IP address of NE has changed from " + string + " to " + netElement.getSecureIPAddress());
            }
            this.addNetElementToIPMap(netElement.getSecureIPAddress(), netElement);
            this.netElemsByIp.remove(string);
        }
    }

    protected void updateNodeId(NetElement netElement) {
        if (this.db.on()) {
            this.db.println("updateNodeId: Node ID of NE has changed from " + netElement.getOldNodeId() + " to " + netElement.getNodeId());
        }
        if (netElement == null) {
            if (this.db.on()) {
                this.db.println("NE is null in updateNodeId .. returning");
            }
            return;
        }
        if (this.netElems.remove(new Integer(netElement.getOldNodeId())) != null) {
            this.netElems.put(new Integer(netElement.getNodeId()), netElement);
        } else if (this.db.on) {
            this.db.println("ERROR !! In updateNodeId , netElement " + netElement + " is not in the network !!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized INetElement addNetElement(String string, String string2, String string3) throws UnknownHostException, AbstractCmsIOException {
        if (this.db.on()) {
            this.db.println("addNetElement: adding NE " + string + " to " + "network");
        }
        addNetEleCompleted = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            String string4 = inetAddress.getHostAddress();
            if (this.limitedNodes != null) {
                this.limitedNodes.add(string4);
                if (this.db.on()) {
                    this.db.println("addNetElement: added NE " + string4 + " to limitedNodes list");
                }
            }
            INetElement iNetElement = null;
            iNetElement = this.findNetElemByIp(string4);
            if (iNetElement != null) {
                if (this.db.on()) {
                    this.db.println("addNetElement: found existing NE using IP");
                }
                INodeModel iNodeModel = iNetElement.getNodeModel();
                ((NodeModel)iNodeModel).setUserName(string2);
                ((NodeModel)iNodeModel).setUserPassword(string3);
                INetElement iNetElement2 = iNetElement;
                return iNetElement2;
            }
            if (this.db.on()) {
                this.db.println("addNetElement: NE is unique based on IP");
            }
            NodeModel nodeModel = new NodeModel(string4, 0, string2, string3, this.getDefaultName());
            iNetElement = new NetElement(nodeModel, this.getDefaultTopo(), 0);
            iNetElement = this.addNetElement(iNetElement);
            this.getNetElementCreationNotifier().changed((NetElement)iNetElement);
            INetElement iNetElement3 = iNetElement;
            return iNetElement3;
        }
        finally {
            addNetEleCompleted = true;
        }
    }

    public boolean isAddingNetEleCompleted() {
        return addNetEleCompleted;
    }

    public void deleteNetElement(INetElement iNetElement) throws NetElementDeletionException {
        if (!this.canDeleteNetElement(iNetElement)) {
            throw new NetElementDeletionException("Network Element " + iNetElement.getName() + " cannot " + "be deleted");
        }
        if (this.db.on) {
            this.db.println("Calling ne.destroy from deleteNetElement");
        }
        iNetElement.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDeleteNetElement(INetElement iNetElement) {
        if (this.db.on) {
            this.db.println("Entering canDeleteNetElement");
        }
        Network network = this;
        synchronized (network) {
            if (iNetElement == null) {
                if (this.db.on()) {
                    this.db.println("deleteNetElement: ne = null");
                }
                return false;
            }
            if (this.getNetElem(iNetElement) == null) {
                if (this.db.on()) {
                    this.db.println("deleteNetElement: NE " + iNetElement.getName() + " is unknown");
                }
                return false;
            }
            if (this.findAllNetLinksWithNetElem(iNetElement).size() != 0) {
                if (this.db.on) {
                    this.db.println("Cannot delete NetElement because there are links " + this.findAllNetLinksWithNetElem(iNetElement).size());
                }
                return false;
            }
        }
        if (this.db.on) {
            this.db.println("Returning true from canDeleteNetElement");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNetElementAndBlock(INetElement iNetElement) throws NetElementDeletionException, AbstractCmsIOException {
        NetElemObserver netElemObserver;
        block17: {
            if (iNetElement == null) {
                if (this.db.on()) {
                    this.db.println("blockedDeleteNetElement: ne = null");
                }
                return;
            }
            if (this.getNetElem(iNetElement) == null) {
                if (this.db.on()) {
                    this.db.println("blockedDeleteNetElement: NE " + iNetElement.getName() + " is unknown");
                }
                return;
            }
            if (this.db.on()) {
                this.db.println("blockedDeleteNetElement: deleting NE " + iNetElement.getName());
            }
            if (this.findAllNetLinksWithNetElem(iNetElement).size() == 0) {
                netElemObserver = new NetElemObserver();
                ((NetElement)iNetElement).addObserver(netElemObserver);
                try {
                    iNetElement.destroy();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    ((NetElement)iNetElement).deleteObserver(netElemObserver);
                    netElemObserver = null;
                    this.db.println("deleteNetElementAndBlock: unable to delete NE due to exception => " + (Object)((Object)abstractCmsIOException));
                    throw abstractCmsIOException;
                }
                while (true) {
                    try {
                        NetElemObserver netElemObserver2 = netElemObserver;
                        synchronized (netElemObserver2) {
                            if (!netElemObserver.isDeleted()) {
                                if (this.db.on()) {
                                    this.db.println("deleteNetElementAndBlock: waiting for deleted event");
                                }
                                netElemObserver.wait();
                                if (this.db.on()) {
                                    this.db.println("deleteNetElementAndBlock: finished waiting");
                                }
                            }
                            break block17;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.db.on()) continue;
                        this.db.println("deleteNetElementAndBlock: caught " + interruptedException);
                        continue;
                    }
                    break;
                }
            }
            throw new NetElementDeletionException("Network Element " + iNetElement.getName() + " cannot " + "be deleted because it is " + "connected to other " + "Network Element(s)");
        }
        ((NetElement)iNetElement).deleteObserver(netElemObserver);
        netElemObserver = null;
    }

    public void deleteNetElementAndConnectedNetLinks(INetElement iNetElement) {
        Iterator iterator = this.findAllNetLinksWithNetElem(iNetElement).iterator();
        if (this.db.on()) {
            this.db.println("deleteNetElementAndConnectedNetLinks: deleting NE " + iNetElement.getHostName());
        }
        iNetElement.destroy();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (this.db.on()) {
                this.db.println("deleteNetElementAndConnectedNetLinks: deleting NL " + iNetLink.prettyString());
            }
            iNetLink.dispose();
            INetLink iNetLink2 = this.findReverseLink(iNetLink);
            if (iNetLink2 == null) continue;
            iNetLink2.dispose();
            if (!this.db.on()) continue;
            this.db.println("deleteNetElementAndConnectedNetLinks: deleting NL " + iNetLink2.prettyString());
        }
    }

    public synchronized ITopology createTopology(INetElement iNetElement) {
        NetElement netElement = null;
        Topology topology = null;
        if (iNetElement == null) {
            if (this.db.on()) {
                this.db.println("createTopology: ne is null");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("createTopology: called for NE " + iNetElement.getHostName());
        }
        if ((netElement = (NetElement)this.findNetElem(iNetElement)) != null) {
            if (this.db.on()) {
                this.db.println("createTopology: found NE " + netElement.getHostName() + " in inited list");
            }
            if (netElement.getTopoId() != 0) {
                if (this.db.on()) {
                    this.db.println("createTopology: NE already assigned to topo " + netElement.getTopoId() + ", returning existing" + " topo");
                }
                return netElement.getTopology();
            }
            topology = this.createNewTopology(netElement, false);
            if (topology != null) {
                this.getTopologyCreationNotifier().changed(topology);
            }
            return topology;
        }
        netElement = (NetElement)this.getNetElem(iNetElement.getHostName());
        if (netElement != null) {
            if (this.db.on()) {
                this.db.println("createTopology: found NE " + netElement.getHostName() + " in waitQ");
            }
            if (netElement.getTopoId() != 0) {
                if (this.db.on()) {
                    this.db.println("createTopology: NE already assigned to topo " + netElement.getTopoId() + ", returning existing topo");
                }
                return netElement.getTopology();
            }
            topology = this.createNewTopology(null, false);
            this.getTopologyCreationNotifier().changed(topology);
            netElement.setTopology(topology, topology.getTopoId());
            this.topoNEs.add(netElement);
            return topology;
        }
        if (this.db.on()) {
            this.db.println("createTopology: NE " + iNetElement.getHostName() + " is unknown, returning null Topology");
        }
        return null;
    }

    public void createTopology(LinkedList linkedList) {
        while (!linkedList.isEmpty()) {
            ITopology iTopology;
            block6: {
                INetElement iNetElement = (INetElement)linkedList.removeFirst();
                iTopology = null;
                if (iNetElement instanceof NetElement) {
                    if (this.db.on()) {
                        this.db.println("createTopology: trying NE " + iNetElement.getHostName());
                    }
                    iTopology = this.createTopology(iNetElement);
                    if (this.db.on()) {
                        this.db.println("createTopology: sleeping for 30 sec");
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.db.on()) break block6;
                        this.db.println("createTopology: caught interruptedException");
                    }
                }
            }
            if (iTopology == null) continue;
            linkedList.removeAll(iTopology.getTopoElems());
        }
    }

    protected Topology createNewTopology(NetElement netElement, boolean bl) {
        Topology topology = null;
        if (netElement != null) {
            try {
                topology = new Topology(this, netElement, this.nextTopoId);
            }
            catch (InvalidTopoOperation invalidTopoOperation) {
                this.db.println("createNewTopology: caught unexpected exception => " + invalidTopoOperation.getMessage());
                NetworkDebug.printStackTrace((Throwable)((Object)invalidTopoOperation));
                return topology;
            }
        } else {
            topology = new Topology(this, this.nextTopoId, bl);
        }
        if (this.db.on()) {
            this.db.println("createNewTopology: created new Topology " + this.nextTopoId);
        }
        this.topologies.put(new Integer(this.nextTopoId), topology);
        ++this.nextTopoId;
        return topology;
    }

    public void deleteTopology(INetElement iNetElement) {
        Topology topology = iNetElement.getTopology();
        topology.destroy(true);
    }

    public void deleteTopology(ITopology iTopology) {
        ((Topology)iTopology).destroy(true);
    }

    private INetElement addNetElement(INetElement iNetElement) {
        int n = iNetElement.getNodeId();
        String string = iNetElement.getHostName();
        if (n == -1 || n == 0) {
            NetElement netElement = null;
            netElement = (NetElement)this.waitQ.get(string);
            if (netElement == null) {
                this.waitQ.put(string, iNetElement);
                if (!this.netElemsByIp.containsKey(string)) {
                    this.addNetElementToIPMap(string, iNetElement);
                    if (this.db.on()) {
                        this.db.println("addNetElement: added NE with IP " + iNetElement.getHostName() + " to netElemsByIp map");
                    }
                }
                if (iNetElement.hasSecureIPAddress() && !this.netElemsByIp.containsKey(iNetElement.getSecureIPAddress())) {
                    this.addNetElementToIPMap(iNetElement.getSecureIPAddress(), iNetElement);
                    if (this.db.on()) {
                        this.db.println("addNetElement: added NE with secure IP" + iNetElement.getSecureIPAddress() + " to " + "netElemsByIp map");
                    }
                }
                ((NetElement)iNetElement).addObserver(this);
                if (iNetElement.getNodeId() != -1 && iNetElement.getNodeId() != 0) {
                    if (this.db.on()) {
                        this.db.println("addNetElement: NE " + string + " now has" + " valid Node ID, adding to inited map");
                    }
                    this.waitQ.remove(string);
                    ((NetElement)iNetElement).deleteObserver(this);
                    return this.putNetElement(iNetElement);
                }
                if (this.db.on()) {
                    this.db.println("addNetElement: " + string + " added to waitQ");
                }
                return iNetElement;
            }
            if (this.db.on()) {
                this.db.println("addNetElement: " + string + " found in waitQ");
            }
            return netElement;
        }
        if (this.db.on()) {
            this.db.println("addNetElement: for " + Integer.toHexString(iNetElement.getNodeId()) + "/" + string);
        }
        return this.putNetElement(iNetElement);
    }

    protected synchronized INetElement addNetElement(String string, int n, Topology topology, boolean bl, int n2) throws AbstractCmsIOException {
        if (this.db.on()) {
            this.db.println("addNetElement: Topo " + topology.getTopoId() + " is " + "attempting to add NE " + string);
        }
        if (!bl && this.filterNode(string)) {
            if (this.db.on()) {
                this.db.println("addNetElement: dynamically discovered NE ignored");
            }
            return null;
        }
        INetElement iNetElement = (NetElement)this.findNetElem(n);
        if (iNetElement != null) {
            if (!iNetElement.getHostName().equals(string)) {
                String string2;
                block20: {
                    string2 = iNetElement.getHostName();
                    try {
                        ((NetElement)iNetElement).setHostName(string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!this.db.on()) break block20;
                        this.db.println("addNetElement: caught unexpected exception, e = " + unknownHostException);
                    }
                }
                if (this.db.on()) {
                    this.db.println("addNetElement: oldIP = " + string2 + ", ne.getHostName() = " + iNetElement.getHostName() + ", ne.hasSecureIPAddress() = " + iNetElement.hasSecureIPAddress() + ", ne.getSecureIPAddress() = " + iNetElement.getSecureIPAddress());
                }
                if (iNetElement.hasSecureIPAddress() && iNetElement.getSecureIPAddress().equals(string2)) {
                    if (this.db.on()) {
                        this.db.println("addNetElement: changing IP address from secure to public");
                    }
                    this.addNetElementToIPMap(iNetElement.getHostName(), iNetElement);
                } else {
                    if (this.db.on()) {
                        this.db.println("addNetElement: IP address has changed");
                    }
                    this.updateIPAddress((NetElement)iNetElement, string2);
                }
            }
            if (this.db.on()) {
                this.db.println("addNetElement: returning NE in inited list");
            }
            return iNetElement;
        }
        iNetElement = (INetElement)this.waitQ.remove(string);
        if (iNetElement != null) {
            iNetElement.setNodeId(n);
            iNetElement.deleteObserver(this);
            if (this.topoNEs.remove(iNetElement)) {
                if (this.db.on()) {
                    this.db.println("addNetElement: NE " + iNetElement.getHostName() + " is a topo host, initing topo " + iNetElement.getTopoId());
                }
                Topology topology2 = iNetElement.getTopology();
                topology2.initialize((NetElement)iNetElement);
            }
            this.addNetElement(iNetElement);
            if (this.db.on()) {
                this.db.println("addNetElement: returning NE found in waitQ");
            }
            return iNetElement;
        }
        iNetElement = this.findNetElemByIp(string);
        if (iNetElement != null) {
            if (this.db.on()) {
                this.db.println("addNetElement: WARNING returning NE found in netElemsByIP map");
            }
            return iNetElement;
        }
        if (this.db.on()) {
            this.db.println("addNetElement: NE " + string + " is unique");
        }
        User user = NetworkModel.instance().getUser();
        NodeModel nodeModel = new NodeModel(string, n, user.getName(), user.getPassword(), this.getDefaultName());
        iNetElement = new NetElement(nodeModel, topology, topology.getTopoId());
        iNetElement = this.addNetElement(iNetElement);
        this.getNetElementCreationNotifier().changed(iNetElement);
        return iNetElement;
    }

    public boolean filterNode(String string) {
        return this.limitedNodes != null && !this.limitedNodes.contains(string);
    }

    public synchronized void update(IObservable iObservable, Object object) {
        if (iObservable instanceof NetElement) {
            NetElement netElement;
            block19: {
                netElement = (NetElement)iObservable;
                if (object == ModelUpdateType.DELETED) {
                    if (this.db.on()) {
                        this.db.println("update: received DELETED event for NE " + netElement.getHostName());
                    }
                    this.delete(netElement);
                    netElement.deleteObserver(this);
                    return;
                }
                if (this.db.on()) {
                    this.db.println("update: event for NE " + netElement.getHostName());
                }
                if (this.db.on()) {
                    this.db.dumpWaitQ();
                }
                if (netElement.getNodeId() == 0 || netElement.getNodeId() == -1) {
                    if (this.db.on()) {
                        this.db.println("update: NE still has invalid Node ID, ignoring update event");
                    }
                    return;
                }
                if (this.waitQ.remove(netElement.getHostName()) != null) {
                    if (this.db.on()) {
                        this.db.println("update: NE found in waitQ");
                    }
                    int n = netElement.getNodeId();
                    if (this.db.on()) {
                        this.db.println("update: NE nodeId = " + n);
                    }
                    netElement.deleteObserver(this);
                    if (this.db.on()) {
                        this.db.println("update: removed Network from NE " + netElement.getHostName() + " observer list");
                    }
                    this.addNetElement(netElement);
                    if (netElement.getTopoId() == 0) {
                        try {
                            Topology topology = (Topology)this.topologies.get(new Integer(0));
                            if (topology != null) {
                                topology.addNetElement(netElement);
                            }
                            break block19;
                        }
                        catch (InvalidTopoOperation invalidTopoOperation) {
                            if (this.db.on()) {
                                this.db.println("update: " + (Object)((Object)invalidTopoOperation));
                            }
                            break block19;
                        }
                    }
                    if (this.topoNEs.remove(netElement)) {
                        if (this.db.on()) {
                            this.db.println("update: NE " + netElement.getName() + " is a topo host, init topo");
                        }
                        Topology topology = netElement.getTopology();
                        topology.initialize(netElement);
                    }
                }
            }
            netElement.deleteObserver(this);
        }
        if (iObservable instanceof IServerTrailsManager) {
            this.handleServerTrailCtp((IServerTrailsManager)iObservable, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prettyPrint(SDebug sDebug) {
        INetLink iNetLink;
        Iterator<Object> iterator;
        INetElement iNetElement;
        Iterator<Object> iterator2;
        int n = 0;
        sDebug.println("Active => " + this.active);
        Object object = this.netElems;
        synchronized (object) {
            iterator2 = this.netElems.values().iterator();
            sDebug.println("Network Element(s) :");
            while (iterator2.hasNext()) {
                iNetElement = (INetElement)iterator2.next();
                sDebug.println("  NE #" + ++n + " : " + iNetElement.prettyString() + " => " + iNetElement.getHostName());
            }
        }
        sDebug.println("Network Link(s) :");
        n = 0;
        object = this.allNetLinks;
        synchronized (object) {
            iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                iNetLink = (INetLink)iterator.next();
                sDebug.print("  Link #" + ++n + " : ");
                sDebug.println(iNetLink.prettyStringDetail());
            }
        }
        sDebug.println("");
        sDebug.println("Next Topo ID = " + this.nextTopoId);
        sDebug.println("");
        sDebug.println("Printing Topology Aggregation:");
        Iterator iterator3 = this.getTopologies().iterator();
        while (iterator3.hasNext()) {
            object = (Topology)iterator3.next();
            if (((Topology)object).getTopoId() == 0) {
                sDebug.println("  Topology Id = " + ((Topology)object).getTopoId() + "    TopoAgent(s) : None ");
            } else {
                sDebug.println("  Topology Id = " + ((Topology)object).getTopoId());
                sDebug.println("    TopoAgent(s): ");
                Iterator iterator4 = ((Topology)object).getCurrentTopoHosts().iterator();
                while (iterator4.hasNext()) {
                    NetElement netElement = (NetElement)iterator4.next();
                    sDebug.println("      " + netElement.prettyString());
                }
            }
            sDebug.println("    Network Element(s) :");
            n = 0;
            iterator2 = ((Topology)object).getTopoElems().iterator();
            while (iterator2.hasNext()) {
                iNetElement = (INetElement)iterator2.next();
                sDebug.println("      NE #" + ++n + " : " + iNetElement.prettyString());
            }
            sDebug.println("    Network Link(s) :");
            n = 0;
            iterator = ((Topology)object).getTopoLinks().iterator();
            while (iterator.hasNext()) {
                iNetLink = (INetLink)iterator.next();
                sDebug.print("      Link #" + ++n + " : ");
                sDebug.println(iNetLink.prettyString());
            }
            sDebug.println("");
        }
        sDebug.println("");
    }

    public static void prettyPrint(SDebug sDebug, List list) {
        if (!sDebug.on) {
            return;
        }
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PathSegment pathSegment = (PathSegment)iterator.next();
            Iterator iterator2 = pathSegment.getPrimary().iterator();
            sDebug.println("Path Segment #" + ++n + (pathSegment.isProtected() ? "(" : "(un") + "protected)");
            INetLink iNetLink = null;
            sDebug.println("Printing the Primary Path:");
            while (iterator2.hasNext()) {
                iNetLink = (INetLink)iterator2.next();
                sDebug.println(iNetLink.prettyString());
            }
            if (pathSegment.getAlternate().size() == 0) continue;
            iterator2 = pathSegment.getAlternate().iterator();
            iNetLink = null;
            sDebug.println("Printing the Alternate Path:");
            while (iterator2.hasNext()) {
                iNetLink = (INetLink)iterator2.next();
                sDebug.println(iNetLink.prettyString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INetElement putNetElement(INetElement iNetElement) {
        INetElement iNetElement2 = null;
        Map map = this.netElems;
        synchronized (map) {
            iNetElement2 = this.findNetElem(iNetElement);
            if (iNetElement2 == null) {
                this.netElems.put(new Integer(iNetElement.getNodeId()), iNetElement);
                if (!this.netElemsByIp.containsKey(iNetElement.getHostName())) {
                    this.addNetElementToIPMap(iNetElement.getHostName(), iNetElement);
                    if (this.db.on()) {
                        this.db.println("putNetElement: added NE with IP " + iNetElement.getHostName() + " to netElemsByIp map");
                    }
                }
                if (iNetElement.hasSecureIPAddress() && !this.netElemsByIp.containsKey(iNetElement.getSecureIPAddress())) {
                    this.addNetElementToIPMap(iNetElement.getSecureIPAddress(), iNetElement);
                    if (this.db.on()) {
                        this.db.println("putNetElement: added NE with secure IP " + iNetElement.getSecureIPAddress() + " to netElemsByIp map");
                    }
                }
                if (this.db.on()) {
                    this.db.println("putNetElement: NE " + iNetElement.getHostName() + " added to NE list, list size = " + this.netElemsByIp.size());
                }
                this.getServerTrails(iNetElement);
            }
        }
        if (iNetElement2 == null) {
            return iNetElement;
        }
        if (iNetElement2 != iNetElement) {
            if (this.db.on()) {
                this.db.println("putNetElement: Duplicate NEs detected => ");
                this.db.println("putNetElement:    Existing NE => ");
                this.db.println("putNetElement:        Public IP => " + iNetElement2.getHostName());
                this.db.println("putNetElement:        Secure IP => " + iNetElement2.getSecureIPAddress());
                this.db.println("putNetElement:    New NE => ");
                this.db.println("putNetElement:        Public IP => " + iNetElement.getHostName());
                this.db.println("putNetElement:        Secure IP => " + iNetElement.getSecureIPAddress());
            }
            iNetElement.destroy();
            return iNetElement2;
        }
        if (this.db.on()) {
            this.db.println("putNetElement: NE " + iNetElement.getHostName() + " already " + "in list, returning existing NE, list size = " + this.netElems.size());
        }
        return iNetElement2;
    }

    private void addNetElementToIPMap(String string, INetElement iNetElement) {
        if (!string.equals("unknown")) {
            this.netElemsByIp.put(string, iNetElement);
            if (this.db.on()) {
                this.db.println("addNetElementToIPMap: added NE with IP " + string + " to netElemsByIp map, size => " + this.netElemsByIp.size());
            }
        }
    }

    public INetElement getNetElem(int n) {
        return this.findNetElem(n);
    }

    public INetElement getNetElem(INetElement iNetElement) {
        return this.getNetElem(iNetElement, iNetElement.getHostName());
    }

    private INetElement getNetElem(String string) {
        if (string != null) {
            INetElement iNetElement;
            if (this.db.on()) {
                this.db.println("getNetElem: looking for NE with IP " + string);
            }
            if ((iNetElement = (INetElement)this.waitQ.get(string)) != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE found in waitQ");
                }
                return iNetElement;
            }
        }
        if (this.db.on()) {
            this.db.println("getNetElem: NE not found in waitQ");
        }
        return null;
    }

    public INetElement getNetElem(INetElement iNetElement, String string) {
        INetElement iNetElement2 = null;
        if (iNetElement != null && iNetElement.getNodeModel() != null) {
            if (this.db.on()) {
                this.db.println("getNetElem: looking for NE " + iNetElement.getHostName());
            }
            if ((iNetElement2 = this.findNetElem(iNetElement.getNodeId())) != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE found in initialized list");
                }
                return iNetElement2;
            }
            iNetElement2 = this.getNetElem(iNetElement.getHostName());
            if (iNetElement2 != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE found in waitQ");
                }
                return iNetElement2;
            }
            iNetElement2 = this.getNetElem(string);
            if (iNetElement2 != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE with IP " + string + " found in waitQ");
                }
                return iNetElement2;
            }
        } else {
            return this.getNetElem(string);
        }
        if (this.db.on()) {
            this.db.println("getNetElem: returning NULL NE");
        }
        return null;
    }

    public List getNetElemsWithFramingType(int n) {
        ArrayList<INetElement> arrayList = new ArrayList<INetElement>();
        Iterator iterator = this.netElems.values().iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            INodeModel iNodeModel = iNetElement.getNodeModel();
            try {
                if (!iNodeModel.isInited() || iNodeModel.getFramingType() != n) continue;
                arrayList.add(iNetElement);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) continue;
                this.db.println("failed to get framing type for node: " + iNodeModel.getNodeId() + " " + abstractCmsIOException.getMessage());
            }
        }
        return arrayList;
    }

    public FramingType[] getSupportedFramingTypes() {
        FramingType[] framingTypeArray;
        ArrayList<FramingType> arrayList = new ArrayList<FramingType>();
        Iterator iterator = this.netElems.values().iterator();
        while (iterator.hasNext()) {
            int n;
            framingTypeArray = (FramingType[])iterator.next();
            INodeModel iNodeModel = framingTypeArray.getNodeModel();
            try {
                n = iNodeModel.getFramingType();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) continue;
                this.db.println("failed to get framing type for node: " + iNodeModel.getNodeId() + " " + abstractCmsIOException.getMessage());
                continue;
            }
            FramingType framingType = (FramingType)FramingType.getFramingType((int)n);
            if (arrayList.contains(framingType)) continue;
            arrayList.add(framingType);
        }
        framingTypeArray = arrayList.toArray(new FramingType[0]);
        return framingTypeArray;
    }

    protected void delete(INetElement iNetElement) {
        if (iNetElement == null) {
            if (this.db.on()) {
                this.db.println("delete: NE is null");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: disposing of NE " + iNetElement.getHostName());
        }
        if (this.findNetElemByIp(iNetElement.getHostName()) == iNetElement || this.findNetElem(iNetElement.getNodeId()) == iNetElement) {
            this.netElems.remove(new Integer(iNetElement.getNodeId()));
            this.netElemsByIp.remove(iNetElement.getHostName());
            this.netElemsByIp.remove(iNetElement.getSecureIPAddress());
            this.waitQ.remove(iNetElement.getHostName());
        } else if (this.db.on()) {
            this.db.println("delete: duplicate NE destroyed, NE not removed from list");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void createPhantomLink(INetElement iNetElement, INetElement iNetElement2, int n, int n2, int n3, int n4, int n5) throws PhantomLinkException {
        int n6;
        NodeModel nodeModel;
        block27: {
            IEntityModel iEntityModel;
            IEntityModel iEntityModel2;
            block23: {
                ITdmPortModel iTdmPortModel;
                ITdmPortModel iTdmPortModel2;
                block24: {
                    if (this.findNetLinkFromEnt(iNetElement, n) != null || this.findNetLinkFromEnt(iNetElement2, n2) != null) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: Phantom link cannot be created as link already exists");
                        }
                        throw new PhantomLinkException("The following phantom link cannot be created as another link with the same source or destination exists: \nsource => " + iNetElement.getHostName() + ", entity index => " + n + "\ndestination => " + iNetElement2.getHostName() + ", entity index => " + n2);
                    }
                    if (!iNetElement.getConnectionState() || !iNetElement2.getConnectionState()) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: Src or Dst is not connected");
                        }
                        throw new PhantomLinkException("Cannot create Phantom link because source and/or destination NetElement is/are not connected");
                    }
                    nodeModel = (NodeModel)iNetElement.getNodeModel();
                    NodeModel nodeModel2 = (NodeModel)iNetElement2.getNodeModel();
                    iEntityModel2 = null;
                    iEntityModel = null;
                    try {
                        iEntityModel2 = nodeModel.getEntityTable().getEntityModelByIndex(n);
                        iEntityModel = nodeModel2.getEntityTable().getEntityModelByIndex(n2);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: Src or Dst entity index invalid");
                        }
                        throw new PhantomLinkException("Cannot create Phantom link as Src and/or Dst entity index is invalid");
                    }
                    if (!(iEntityModel2 instanceof IPortModel) || !(iEntityModel instanceof IPortModel)) break block23;
                    iTdmPortModel2 = (ITdmPortModel)iEntityModel2;
                    iTdmPortModel = (ITdmPortModel)iEntityModel;
                    if (!iTdmPortModel2.isOptical() || !iTdmPortModel.isOptical()) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: src/dst not optical");
                        }
                        throw new PhantomLinkException("Cannot create Phantom link as Src and/or Dst card is not an optical interface");
                    }
                    if (iTdmPortModel2.getEqType() != iTdmPortModel.getEqType()) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: SRC and DST eq. type diff");
                        }
                        throw new PhantomLinkException("Cannot create Phantom link as Src and Dst interfaces are not the same type");
                    }
                    n6 = iTdmPortModel2.getEqType();
                    if (!iTdmPortModel2.hasOpticalProtection() || !iTdmPortModel.hasOpticalProtection()) break block24;
                    try {
                        block26: {
                            block25: {
                                if (iTdmPortModel2.getElementModel().getType() != 1 || iTdmPortModel.getElementModel().getType() != 1) break block25;
                                IOnePlusOneModel iOnePlusOneModel = (IOnePlusOneModel)iTdmPortModel2.getElementModel();
                                IOnePlusOneModel iOnePlusOneModel2 = (IOnePlusOneModel)iTdmPortModel.getElementModel();
                                if (iOnePlusOneModel.getWorkingEntityIndex() == n && iOnePlusOneModel2.getWorkingEntityIndex() == n2) {
                                    if (this.db.on()) {
                                        this.db.println("createPhantomLink: 1+1 Working port");
                                    }
                                    break block26;
                                } else {
                                    if (this.db.on()) {
                                        this.db.println("createPhantomLink: 1+1 Protect port");
                                    }
                                    throw new PhantomLinkException("Cannot create Phantom link as Src and/or Dst port is a 1+1 protect port");
                                }
                            }
                            if (this.db.on()) {
                                this.db.println("createPhantomLink: Port(s) has unknown protection type");
                            }
                            throw new PhantomLinkException("Cannot create Phantom link as Src and/or Dst port must either be unprotected or the working port of a 1+1 protection group");
                        }
                        n4 = 1;
                    }
                    catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                        this.db.println("createPhantomLink: caught Exception => ");
                        NetworkDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                        throw new PhantomLinkException("Cannot create Phantom link due to unexpected exception");
                    }
                }
                if (iTdmPortModel2.hasOpticalProtection() && !iTdmPortModel.hasOpticalProtection() || !iTdmPortModel2.hasOpticalProtection() && iTdmPortModel.hasOpticalProtection()) {
                    if (this.db.on()) {
                        this.db.println("createPhantomLink: Inconsistent SRC/DST 1+1 configuration");
                    }
                    throw new PhantomLinkException("Inconsistent 1+1 Port provisioning - both or neither SRC/DST port must be part of a protection group");
                }
                break block27;
            }
            if (this.db.on()) {
                this.db.println("createPhantomLink: Invalid src/dst entity index, src model = " + iEntityModel2.getClass().getName() + ", dst model = " + iEntityModel.getClass().getName());
            }
            throw new PhantomLinkException("Cannot create Phantom Link as Src and/or Dst Entity index specifies a slot rather than a port");
        }
        if (this.db.on()) {
            this.db.println("createPhantomLink: creating fwd and rev link models");
        }
        int n7 = nodeModel.getFramingTypeObj().isSonet() ? 1 : 2;
        LinkModel linkModel = new LinkModel(iNetElement.getNodeModel(), n, null, iNetElement2.getNodeModel(), n2, null, 3, NetLink.getLinkPhysicalType(n6), n7, true, true, -1, -1, n4, "", 0, 0, 1, n5, 0, 0);
        LinkModel linkModel2 = new LinkModel(iNetElement2.getNodeModel(), n2, null, iNetElement.getNodeModel(), n, null, 3, NetLink.getLinkPhysicalType(n6), n7, true, true, -1, -1, n4, "", 0, 0, 1, n5, 0, 0);
        if (this.db.on()) {
            this.db.println("createPhantomLink: creating fwd and rev NL's");
        }
        INetLink iNetLink = this.addNetLink(linkModel, (NetElement)iNetElement, (NetElement)iNetElement2, false, false, ((NetElement)iNetElement).getTopology(), this.redundantLinks);
        INetLink iNetLink2 = this.addNetLink(linkModel2, (NetElement)iNetElement2, (NetElement)iNetElement, false, false, ((NetElement)iNetElement2).getTopology(), this.redundantLinks);
        this.getNetLinkCreationNotifier().changed(iNetLink);
        this.getNetLinkCreationNotifier().changed(iNetLink2);
    }

    public synchronized void deletePhantomLink(INetLink iNetLink) throws PhantomLinkException {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("deletePhantomLink: cannot delete null link");
            }
            return;
        }
        if (iNetLink.getLinkType() != 3) {
            if (this.db.on()) {
                this.db.println("deletePhantomLink: cannot delete non-phantom link " + iNetLink.prettyString());
            }
            throw new PhantomLinkException("Cannot delete NetLink " + iNetLink.prettyString() + " as it " + "is not a phantom link");
        }
        if (iNetLink.isDeleted()) {
            if (this.db.on()) {
                this.db.println("deletePhantomLink: link is already deleted");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("deletePhantomLink: attempting to delete phantom link " + iNetLink.prettyString());
        }
        INetLink iNetLink2 = this.findReverseLink(iNetLink);
        int n = iNetLink.getTopoId();
        INetElement iNetElement = iNetLink.getSrc();
        INetElement iNetElement2 = iNetLink.getDst();
        iNetLink.dispose();
        if (iNetLink2 != null) {
            iNetLink2.dispose();
        }
    }

    public void validateServerTrailPrefs(ServerTrailPrefs serverTrailPrefs) throws ServerTrailException {
        IEntityModel iEntityModel;
        if (!serverTrailPrefs.validateTrailCktEnds()) {
            if (this.db.on()) {
                this.db.println("validateServerTrailPrefs: Invalid boundary condition");
            }
            throw new ServerTrailException("Cannot create ServerTrail link as Trail boundaries are invalid");
        }
        if (!serverTrailPrefs.validateLoNums()) {
            if (this.db.on()) {
                this.db.println("validateServerTrailPrefs: LoNum mismatch");
            }
            throw new ServerTrailException("ServerTrail link creation fail : Mismatched LoNums on Source and Dest side ");
        }
        try {
            InetUtil.parseDottedString(serverTrailPrefs.getSrc().getHostName());
            InetUtil.parseDottedString(serverTrailPrefs.getDest().getHostName());
        }
        catch (NumberFormatException numberFormatException) {
            this.db.println("ERROR: Invalid IPAddress in SVTrailPrefs :");
            this.db.println("SRC hostname is " + serverTrailPrefs.getSrc().getHostName());
            this.db.println("Dest hostname is " + serverTrailPrefs.getDest().getHostName());
            throw new ServerTrailException("Invalid SRC/DST IP Address \n");
        }
        INetLink iNetLink = this.findNetLinkFromEnt(serverTrailPrefs.getSrc(), serverTrailPrefs.getSrcEntity());
        if (iNetLink != null && iNetLink.getLinkType() != 9 && !iNetLink.isLOTunnel() && !iNetLink.isLAP()) {
            if (this.db.on()) {
                this.db.println("A NON-ServerTrail link exists on Src Entity");
            }
            throw new ServerTrailException("Port already used \n");
        }
        iNetLink = this.findNetLinkFromEnt(serverTrailPrefs.getDest(), serverTrailPrefs.getDestEntity());
        if (iNetLink != null && iNetLink.getLinkType() != 9 && !iNetLink.isLOTunnel() && !iNetLink.isLAP()) {
            if (this.db.on()) {
                this.db.println("A NON-ServerTrail link exists on Dest Entity");
            }
            throw new ServerTrailException("Port already used \n");
        }
        INodeModel iNodeModel = serverTrailPrefs.getSrc().getNodeModel();
        try {
            iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(serverTrailPrefs.getSrcEntity());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("validateServerTrailPrefs: Src entity index invalid");
            }
            throw new ServerTrailException("Cannot create ServerTrail link as Src entity index is invalid");
        }
        List list = serverTrailPrefs.getCktEnds(serverTrailPrefs.getSrc());
        if (this.db.on()) {
            this.db.println("validateServerTrailPrefs: Got " + list.size() + " SourceCktEnds for " + serverTrailPrefs.prettyString());
        }
        int n = list.size();
        this.removeExistingServerTrails(iNodeModel, iEntityModel, serverTrailPrefs, list);
        if (this.db.on()) {
            this.db.println("addServerTrailLink: After removing there remain " + list.size() + " cktEnds ");
        }
        if (n != list.size()) {
            throw new ServerTrailException("ServerTrail link cannot be created as it overlaps another ServerTrail-Link on Source port \n");
        }
    }

    private void createServerTrailLink(IServerTrailLinkId iServerTrailLinkId) {
        block4: {
            IServerTrailEnd iServerTrailEnd = this.findSvPrimCTP(iServerTrailLinkId);
            IServerTrailEnd iServerTrailEnd2 = this.findSvPeerCTP(iServerTrailLinkId);
            if (iServerTrailEnd == null || iServerTrailEnd2 == null) {
                if (this.db.on()) {
                    this.db.println("ERROR: ServerTrail discovery");
                    this.db.println("CTP objects don't exist");
                }
                return;
            }
            ServerTrailPrefs serverTrailPrefs = this.makeSvPrefs(iServerTrailEnd, iServerTrailEnd2);
            try {
                this.createServerTrailLink(serverTrailPrefs);
            }
            catch (ServerTrailException serverTrailException) {
                if (!this.db.on()) break block4;
                this.db.println("discoverServerTrail: caught exception, e = " + serverTrailException.getMessage());
            }
        }
    }

    private ServerTrailPrefs makeSvPrefs(IServerTrailEnd iServerTrailEnd, IServerTrailEnd iServerTrailEnd2) {
        ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
        serverTrailPrefs.setDiscovered();
        serverTrailPrefs.setTrailId(iServerTrailEnd.getServerTrailLinkId());
        serverTrailPrefs.setSrlg(iServerTrailEnd.getSharedRiskLinkGroup());
        serverTrailPrefs.setProtectionType(iServerTrailEnd.getProtectionType());
        serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)iServerTrailEnd.getTrailSize()));
        serverTrailPrefs.discoverCircuitType();
        if (iServerTrailEnd instanceof IHoServerTrailEnd && iServerTrailEnd2 instanceof IHoServerTrailEnd) {
            IHoPathDefModel iHoPathDefModel = ((IHoServerTrailEnd)iServerTrailEnd).getTrailStart();
            IHoPathDefModel iHoPathDefModel2 = ((IHoServerTrailEnd)iServerTrailEnd).getTrailEnd();
            IHoPathDefModel iHoPathDefModel3 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            IHoPathDefModel iHoPathDefModel4 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailEnd();
            serverTrailPrefs.setSrc(this.findNetElem(iHoPathDefModel.getNodeModel()));
            serverTrailPrefs.setDest(this.findNetElem(iHoPathDefModel3.getNodeModel()));
            serverTrailPrefs.setSrcEntity(iHoPathDefModel.getPool().getEntityIndex());
            serverTrailPrefs.setDestEntity(iHoPathDefModel3.getPool().getEntityIndex());
            IHoNum iHoNum = iHoPathDefModel.getStartingHo();
            IHoNum iHoNum2 = iHoPathDefModel2.getStartingHo();
            serverTrailPrefs.setSrcPoolStart((ILabel)iHoNum);
            serverTrailPrefs.setSrcPoolEnd((ILabel)iHoNum2);
            IHoNum iHoNum3 = iHoPathDefModel3.getStartingHo();
            IHoNum iHoNum4 = iHoPathDefModel4.getStartingHo();
            serverTrailPrefs.setDestPoolStart((ILabel)iHoNum3);
            serverTrailPrefs.setDestPoolEnd((ILabel)iHoNum4);
            serverTrailPrefs.calculateNx((ILabel)iHoNum, (ILabel)iHoNum2);
        } else if (iServerTrailEnd instanceof ILoServerTrailEnd && iServerTrailEnd2 instanceof ILoServerTrailEnd) {
            ILoDefModel iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
            ILoDefModel iLoDefModel2 = ((ILoServerTrailEnd)iServerTrailEnd).getTrailEnd();
            ILoDefModel iLoDefModel3 = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            ILoDefModel iLoDefModel4 = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailEnd();
            IHoPathDefModel iHoPathDefModel = iLoDefModel.getLoAdit().getHo();
            IHoPathDefModel iHoPathDefModel5 = iLoDefModel2.getLoAdit().getHo();
            IHoPathDefModel iHoPathDefModel6 = iLoDefModel3.getLoAdit().getHo();
            IHoPathDefModel iHoPathDefModel7 = iLoDefModel4.getLoAdit().getHo();
            serverTrailPrefs.setSrc(this.findNetElem(iHoPathDefModel.getNodeModel()));
            serverTrailPrefs.setDest(this.findNetElem(iHoPathDefModel6.getNodeModel()));
            serverTrailPrefs.setSrcEntity(iHoPathDefModel.getPool().getEntityIndex());
            serverTrailPrefs.setDestEntity(iHoPathDefModel6.getPool().getEntityIndex());
            IHoNum iHoNum = iHoPathDefModel.getStartingHo();
            ILoNum iLoNum = iLoDefModel.getLoNum();
            IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
            IHoNum iHoNum5 = iHoPathDefModel5.getStartingHo();
            ILoNum iLoNum2 = iLoDefModel2.getLoNum();
            IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum5, iLoNum2);
            serverTrailPrefs.setSrcPoolStart((ILabel)iHoLoNum);
            serverTrailPrefs.setSrcPoolEnd((ILabel)iHoLoNum2);
            IHoNum iHoNum6 = iHoPathDefModel6.getStartingHo();
            ILoNum iLoNum3 = iLoDefModel3.getLoNum();
            IHoLoNum iHoLoNum3 = HoLoFactory.createHoLoNum(iHoNum6, iLoNum3);
            IHoNum iHoNum7 = iHoPathDefModel7.getStartingHo();
            ILoNum iLoNum4 = iLoDefModel4.getLoNum();
            IHoLoNum iHoLoNum4 = HoLoFactory.createHoLoNum(iHoNum7, iLoNum4);
            serverTrailPrefs.setDestPoolStart((ILabel)iHoLoNum3);
            serverTrailPrefs.setDestPoolEnd((ILabel)iHoLoNum4);
            serverTrailPrefs.calculateNx((ILabel)iHoLoNum, (ILabel)iHoLoNum2);
        } else {
            if (this.db.on) {
                this.db.println("ERROR in discoverServerTrailPrefs");
                this.db.println(" CTP objects not of same type");
            }
            return null;
        }
        serverTrailPrefs.setLoTrail();
        return serverTrailPrefs;
    }

    public void createServerTrailLink(ServerTrailPrefs serverTrailPrefs) throws ServerTrailException {
        int n;
        int n2;
        Object object;
        if (serverTrailPrefs == null) {
            return;
        }
        if (this.db.on()) {
            this.db.println("createServerTrailLink: Prefs = " + serverTrailPrefs.prettyString());
        }
        INetElement iNetElement = serverTrailPrefs.getSrc();
        INetElement iNetElement2 = serverTrailPrefs.getDest();
        int n3 = serverTrailPrefs.getSrcEntity();
        ILabel iLabel = serverTrailPrefs.getSrcPoolStart();
        ILabel iLabel2 = serverTrailPrefs.getSrcPoolEnd();
        int n4 = serverTrailPrefs.getDestEntity();
        ILabel iLabel3 = serverTrailPrefs.getDestPoolStart();
        ILabel iLabel4 = serverTrailPrefs.getDestPoolEnd();
        int n5 = serverTrailPrefs.getPhyLinkType();
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        int n6 = serverTrailPrefs.getProtectionType();
        String string = serverTrailPrefs.getSrlg();
        int n7 = serverTrailPrefs.getCost();
        int n8 = serverTrailPrefs.getNx();
        if (iNetElement == null || iNetElement2 == null || !iNetElement.getConnectionState() || !iNetElement2.getConnectionState()) {
            throw new ServerTrailException("Cannot create ServerTrail link Src/Dst Null error");
        }
        if (this.findNetLinkFromEnt(iNetElement, n3, true) != null || this.findNetLinkFromEnt(iNetElement2, n4, true) != null) {
            throw new ServerTrailException("The following ServerTrail link cannot be created as another SDCC-link with the same source or destination exists: \nsource => " + iNetElement.getHostName() + ", entity index => " + n3 + "\ndestination => " + iNetElement2.getHostName() + ", entity index => " + n4);
        }
        NodeModel nodeModel = (NodeModel)iNetElement.getNodeModel();
        NodeModel nodeModel2 = (NodeModel)iNetElement2.getNodeModel();
        if (!nodeModel.provides(Feature.SERVER_TRAIL) || !nodeModel2.provides(Feature.SERVER_TRAIL)) {
            throw new ServerTrailException(" SERVER_TRAIL feature not supported at nodes : " + nodeModel.getName() + " OR " + nodeModel2.getName());
        }
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        try {
            iEntityModel = nodeModel.getEntityTable().getEntityModelByIndex(n3);
            iEntityModel2 = nodeModel2.getEntityTable().getEntityModelByIndex(n4);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("createServerTrailLink: Src or Dst entity index invalid");
            }
            throw new ServerTrailException("Cannot create ServerTrail link as Src and/or Dst entity index is invalid");
        }
        if (iEntityModel instanceof IPortModel && iEntityModel2 instanceof IPortModel) {
            IPortModel iPortModel = (IPortModel)iEntityModel;
            object = (IPortModel)iEntityModel2;
            n2 = iPortModel.getEqType();
            n = object.getEqType();
        } else {
            n2 = 251;
            n = 251;
            if (this.db.on()) {
                this.db.println("createServerTrailLink: Src or Dst entity index not instanceof IPortModel");
            }
        }
        boolean bl = false;
        if (!serverTrailPrefs.isDiscovered()) {
            serverTrailPrefs.setPoolEnds();
            try {
                this.validateServerTrailPrefs(serverTrailPrefs);
            }
            catch (ServerTrailException serverTrailException) {
                if (this.db.on()) {
                    this.db.println("createServerTrailLink: Invalid ServerTrailPrefs");
                }
                throw new ServerTrailException("Invalid Preferences");
            }
            if (this.db.on()) {
                this.db.println("ServerTrailPrefs are valid");
            }
            object = null;
            try {
                this.createServerTrailCTPs(serverTrailPrefs);
            }
            catch (PathInUse pathInUse) {
                bl = true;
                object = pathInUse.getMessage();
            }
            catch (InvalidPath invalidPath) {
                bl = true;
                object = invalidPath.getMessage();
            }
            catch (ProvisionError provisionError) {
                bl = true;
                object = provisionError.getMessage();
            }
            catch (ServerTrailException serverTrailException) {
                bl = true;
                object = serverTrailException.getMessage();
            }
            if (bl) {
                if (object == null) {
                    throw new ServerTrailException("Server trail link CTP objects could not be created.");
                }
                throw new ServerTrailException((String)object);
            }
            if (this.db.on()) {
                this.db.println("createServerTrailLink: CTP objects created successfully");
            }
        }
        int n9 = 12;
        LinkModel linkModel = new LinkModel(iNetElement.getNodeModel(), n3, null, iNetElement2.getNodeModel(), n4, null, 9, NetLink.getLinkPhysicalType(n2), n9, true, true, -1, -1, n6, "", 0, 0, 1, n7, 0, 0);
        LinkModel linkModel2 = new LinkModel(iNetElement2.getNodeModel(), n4, null, iNetElement.getNodeModel(), n3, null, 9, NetLink.getLinkPhysicalType(n), n9, true, true, -1, -1, n6, "", 0, 0, 1, n7, 0, 0);
        if (this.db.on()) {
            this.db.println("createServerTrailLink: creating fwd and rev NL's");
        }
        ServerTrailPrefs serverTrailPrefs2 = new ServerTrailPrefs(serverTrailPrefs, true);
        INetLink iNetLink = this.addServerTrailLink(linkModel, (NetElement)iNetElement, (NetElement)iNetElement2, false, ((NetElement)iNetElement).getTopology(), serverTrailPrefs, true);
        INetLink iNetLink2 = this.addServerTrailLink(linkModel2, (NetElement)iNetElement2, (NetElement)iNetElement, false, ((NetElement)iNetElement2).getTopology(), serverTrailPrefs2, false);
        this.getNetLinkCreationNotifier().changed(iNetLink);
        this.getNetLinkCreationNotifier().changed(iNetLink2);
        this.putSvLink(iNetLink);
    }

    public void createServerTrailCTPs(ServerTrailPrefs serverTrailPrefs) throws ProvisionError, PathInUse, InvalidPath, ServerTrailException {
        ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(0, 0);
        IServerTrailLinkId iServerTrailLinkId = null;
        INodeModel iNodeModel = serverTrailPrefs.getSrc().getNodeModel();
        INodeModel iNodeModel2 = serverTrailPrefs.getDest().getNodeModel();
        if (!iNodeModel.provides(Feature.SERVER_TRAIL) || !iNodeModel2.provides(Feature.SERVER_TRAIL)) {
            throw new ServerTrailException(" SERVER_TRAIL feature not supported at nodes : " + iNodeModel.getName() + " OR " + iNodeModel2.getName());
        }
        IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
        IServerTrailsManager iServerTrailsManager2 = iNodeModel2.getServerTrailsManager();
        IPoolModels iPoolModels = iNodeModel.getPoolModels();
        IPoolModel iPoolModel = iPoolModels.getPoolModel(serverTrailPrefs.getSrcEntity());
        IPoolModels iPoolModels2 = iNodeModel2.getPoolModels();
        IPoolModel iPoolModel2 = iPoolModels2.getPoolModel(serverTrailPrefs.getDestEntity());
        String string = serverTrailPrefs.getSrc().getHostName();
        String string2 = serverTrailPrefs.getDest().getHostName();
        IIpAddr iIpAddr = iNodeModel.getSecureIpConfig().getIpAddress();
        IIpAddr iIpAddr2 = iNodeModel2.getSecureIpConfig().getIpAddress();
        if (this.db.on()) {
            this.db.println("SrcIpAddr = " + Topology.IpAddrString(iIpAddr));
            this.db.println("Src Hostname = " + string);
            this.db.println("DstIpAddr = " + Topology.IpAddrString(iIpAddr2));
            this.db.println("Dst Hostname = " + string2);
        }
        boolean bl = false;
        if (serverTrailPrefs.isLoTrail()) {
            serverTrailPrefs.checkLoAdits();
            short s = CircuitSize.getCircuitSize((int)serverTrailPrefs.getCircuitSize().getEnum()).size2widthOfLoCircuit();
            IHoNum iHoNum = ((IHoLoNum)serverTrailPrefs.getSrcPoolStart()).getHoNum();
            IHoNum iHoNum2 = ((IHoLoNum)serverTrailPrefs.getSrcPoolEnd()).getHoNum();
            ILoAditModel iLoAditModel = ServerTrailPrefs.getLoAdit(iHoNum, serverTrailPrefs.getSrc().getNodeModel(), serverTrailPrefs.getSrcEntity());
            ILoAditModel iLoAditModel2 = ServerTrailPrefs.getLoAdit(iHoNum2, serverTrailPrefs.getSrc().getNodeModel(), serverTrailPrefs.getSrcEntity());
            LoDefModel loDefModel = null;
            LoDefModel loDefModel2 = null;
            loDefModel = new LoDefModel(iNodeModel, iLoAditModel, ((IHoLoNum)serverTrailPrefs.getSrcPoolStart()).getLoNum(), s, 0, serverTrailPrefs.getSrcEntity());
            loDefModel2 = new LoDefModel(iNodeModel, iLoAditModel2, ((IHoLoNum)serverTrailPrefs.getSrcPoolEnd()).getLoNum(), s, 0, serverTrailPrefs.getSrcEntity());
            try {
                serverTrailLinkId = iServerTrailsManager.createLoServerTrail((ILoDefModel)loDefModel, (ILoDefModel)loDefModel2, string2, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            }
            catch (Exception exception) {
                serverTrailPrefs.cleanupLoAdits();
                throw new ServerTrailException(exception.getMessage());
            }
            if (this.db.on()) {
                this.db.println("Created source side loCTP object: sCTP Nodeid = " + serverTrailLinkId.getNodeId() + "sCTP uId = " + serverTrailLinkId.getUniqueId());
                this.db.println("StartHo :" + loDefModel.getLoAdit().getHo().getStartingHo().prettyString() + "Lo :" + loDefModel.getLoNum().prettyString() + "EndHo :" + loDefModel2.getLoAdit().getHo().getStartingHo().prettyString() + "Lo :" + loDefModel2.getLoNum().prettyString());
            }
            IHoNum iHoNum3 = ((IHoLoNum)serverTrailPrefs.getDestPoolStart()).getHoNum();
            IHoNum iHoNum4 = ((IHoLoNum)serverTrailPrefs.getDestPoolEnd()).getHoNum();
            ILoAditModel iLoAditModel3 = ServerTrailPrefs.getLoAdit(iHoNum3, serverTrailPrefs.getDest().getNodeModel(), serverTrailPrefs.getDestEntity());
            ILoAditModel iLoAditModel4 = ServerTrailPrefs.getLoAdit(iHoNum4, serverTrailPrefs.getDest().getNodeModel(), serverTrailPrefs.getDestEntity());
            LoDefModel loDefModel3 = null;
            LoDefModel loDefModel4 = null;
            loDefModel3 = new LoDefModel(iNodeModel2, iLoAditModel3, ((IHoLoNum)serverTrailPrefs.getDestPoolStart()).getLoNum(), s, 0, serverTrailPrefs.getDestEntity());
            loDefModel4 = new LoDefModel(iNodeModel2, iLoAditModel4, ((IHoLoNum)serverTrailPrefs.getDestPoolEnd()).getLoNum(), s, 0, serverTrailPrefs.getDestEntity());
            try {
                iServerTrailLinkId = iServerTrailsManager2.createLoServerTrail((ILoDefModel)loDefModel3, (ILoDefModel)loDefModel4, string, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            }
            catch (PathInUse pathInUse) {
                if (this.db.on()) {
                    this.db.println("Failed to create CTP on destination node ");
                }
                bl = true;
            }
            catch (InvalidPath invalidPath) {
                if (this.db.on()) {
                    this.db.println("Failed to create CTP on destination node ");
                }
                bl = true;
            }
            catch (ProvisionError provisionError) {
                if (this.db.on()) {
                    this.db.println("Failed to create CTP on destination node ");
                }
                bl = true;
            }
            if (bl) {
                if (this.db.on()) {
                    this.db.println("createServerTrailCTPs: Unable to create CTP objects. Attempting to rollback source server trail and cleanup adit if unused.");
                }
                try {
                    block33: {
                        int n = 0;
                        while (true) {
                            boolean bl2 = false;
                            IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
                            for (int i = 0; i < iServerTrailEndArray.length; ++i) {
                                IServerTrailEnd iServerTrailEnd = iServerTrailEndArray[i];
                                if (!iServerTrailEnd.getServerTrailLinkId().equals(serverTrailLinkId)) continue;
                                bl2 = true;
                                iServerTrailsManager.deleteServerTrail((IServerTrailLinkId)serverTrailLinkId);
                                break;
                            }
                            if (bl2) break block33;
                            if (n >= 30000) break;
                            Thread.sleep(2000L);
                            n += 2000;
                        }
                        throw new Exception("Timed out trying to rollback source server trail");
                    }
                    serverTrailPrefs.cleanupLoAdits();
                }
                catch (Exception exception) {
                    this.db.println("createServerTrailCTPs: Failed to rollback source CTP. " + exception);
                    NetworkDebug.printStackTrace((Throwable)exception);
                    throw new ProvisionError("The source CTP could not be rolled back. " + exception);
                }
                throw new ProvisionError("Server trail creation on the destination node failed.\nRollback of the source server trail was successful.");
            }
            if (this.db.on()) {
                this.db.println("Created destination side loCTP object: dCTP Nodeid = " + iServerTrailLinkId.getNodeId() + "dCTP uId = " + iServerTrailLinkId.getUniqueId());
            }
        } else {
            short s = CircuitSize.getCircuitSize((int)serverTrailPrefs.getCircuitSize().getEnum()).size2widthOfHoCircuit();
            IHoNum iHoNum = iPoolModel.includedPath().getStartingHo();
            IHoNum iHoNum5 = (IHoNum)serverTrailPrefs.getSrcPoolStart();
            IHoNum iHoNum6 = HoLoFactory.removeOffset(iHoNum5, iHoNum);
            IHoNum iHoNum7 = (IHoNum)serverTrailPrefs.getSrcPoolEnd();
            IHoNum iHoNum8 = HoLoFactory.removeOffset(iHoNum7, iHoNum);
            HoPathDefModel hoPathDefModel = new HoPathDefModel(iPoolModel, s, iHoNum6, 0);
            HoPathDefModel hoPathDefModel2 = new HoPathDefModel(iPoolModel, s, iHoNum8, 0);
            serverTrailLinkId = iServerTrailsManager.createHoServerTrail((IHoPathDefModel)hoPathDefModel, (IHoPathDefModel)hoPathDefModel2, string2, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            if (this.db.on()) {
                this.db.println("Created source side CTP object: sCTP Nodeid = " + serverTrailLinkId.getNodeId() + "sCTP uId = " + serverTrailLinkId.getUniqueId());
            }
            iHoNum = iPoolModel2.includedPath().getStartingHo();
            iHoNum5 = (IHoNum)serverTrailPrefs.getDestPoolStart();
            iHoNum6 = HoLoFactory.removeOffset(iHoNum5, iHoNum);
            iHoNum7 = (IHoNum)serverTrailPrefs.getDestPoolEnd();
            iHoNum8 = HoLoFactory.removeOffset(iHoNum7, iHoNum);
            HoPathDefModel hoPathDefModel3 = new HoPathDefModel(iPoolModel2, s, iHoNum6, 0);
            HoPathDefModel hoPathDefModel4 = new HoPathDefModel(iPoolModel2, s, iHoNum8, 0);
            try {
                iServerTrailLinkId = iServerTrailsManager2.createHoServerTrail((IHoPathDefModel)hoPathDefModel3, (IHoPathDefModel)hoPathDefModel4, string, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            }
            catch (ProvisionError provisionError) {
                if (this.db.on()) {
                    this.db.println("Failed to create Ho CTP on destination node ");
                }
                bl = true;
            }
            catch (PathInUse pathInUse) {
                if (this.db.on()) {
                    this.db.println("Failed to create Ho CTP on destination node ");
                }
                bl = true;
            }
            catch (InvalidPath invalidPath) {
                if (this.db.on()) {
                    this.db.println("Failed to create Ho CTP on destination node ");
                }
                bl = true;
            }
            if (bl) {
                try {
                    iServerTrailsManager.deleteServerTrail((IServerTrailLinkId)serverTrailLinkId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProvisionError("Failed to rollback srcCTP");
            }
            if (this.db.on()) {
                this.db.println("Created dest side hoCTP object: dCTP Nodeid = " + iServerTrailLinkId.getNodeId() + "dCTP uId = " + iServerTrailLinkId.getUniqueId());
            }
        }
        serverTrailPrefs.setTrailId(serverTrailLinkId);
    }

    public boolean isServerTrailInUse(IServerTrailLinkId iServerTrailLinkId) {
        ServerTrailLinkId serverTrailLinkId;
        IServerTrailEnd iServerTrailEnd;
        if (iServerTrailLinkId == null) {
            if (this.db.on()) {
                this.db.println("isServerTrailInUse :: ServerTrailId is NULL");
            }
            return false;
        }
        if (this.db.on()) {
            this.db.println("InUse check for SVTrail with NodeId " + iServerTrailLinkId.getNodeId() + "Uid " + iServerTrailLinkId.getUniqueId());
        }
        if ((iServerTrailEnd = this.findSvPrimCTP(serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()))) != null && iServerTrailEnd.inUse()) {
            if (this.db.on()) {
                this.db.println("Primary CTP is inUse");
            }
            return true;
        }
        iServerTrailEnd = this.findSvPeerCTP(serverTrailLinkId);
        if (iServerTrailEnd != null && iServerTrailEnd.inUse()) {
            if (this.db.on()) {
                this.db.println("Peer CTP is inUse");
            }
            return true;
        }
        return false;
    }

    public void deleteServerTrail(IServerTrailLinkId iServerTrailLinkId) throws ServerTrailException {
        this.removeServerTrail(iServerTrailLinkId, true);
    }

    private void removeServerTrail(IServerTrailLinkId iServerTrailLinkId, boolean bl) throws ServerTrailException {
        block11: {
            ServerTrailLinkId serverTrailLinkId;
            INetLink iNetLink;
            if (iServerTrailLinkId == null) {
                if (this.db.on()) {
                    this.db.println("RemoveServerTrail :: ServerTrailId is NULL");
                }
                return;
            }
            if (this.db.on()) {
                this.db.println("Removing SVTrail with NodeId " + iServerTrailLinkId.getNodeId() + "Uid " + iServerTrailLinkId.getUniqueId() + "deleteCTP " + bl);
            }
            if ((iNetLink = this.findSvLink(serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()))) == null) {
                this.db.println("removeServerTrail: ServerTrailLink already removed for svId::NodeId " + iServerTrailLinkId.getNodeId() + "Uid:: " + iServerTrailLinkId.getUniqueId());
            } else {
                try {
                    this.deleteServerTrailLink(iNetLink);
                    this.svTrailLinks.remove(serverTrailLinkId);
                }
                catch (ServerTrailException serverTrailException) {
                    if (!this.db.on()) break block11;
                    this.db.println("deleteServerTrail: caught exception, e = \n" + serverTrailException.getMessage());
                    throw new ServerTrailException();
                }
            }
        }
        if (bl) {
            if (this.db.on()) {
                this.db.println("deleteServerTrail: Going to delete CTP objects");
            }
            if (this.deleteCtp(this.findSvPrimCTP(iServerTrailLinkId)) && this.db.on()) {
                this.db.println("Successfully deleted Primary CTP");
            }
            if (this.deleteCtp(this.findSvPeerCTP(iServerTrailLinkId)) && this.db.on()) {
                this.db.println("Successfully deleted Peer CTP");
            }
        }
    }

    private boolean deleteCtp(IServerTrailEnd iServerTrailEnd) {
        if (iServerTrailEnd != null) {
            INetElement iNetElement = this.getCtpNe(iServerTrailEnd, null);
            if (iNetElement == null) {
                if (this.db.on()) {
                    this.db.println("Failed to deleteCtp");
                }
                return false;
            }
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
                if (this.db.on()) {
                    this.db.println("deleteCTP: STrail not supported at node " + iNodeModel.getName());
                }
                return false;
            }
            IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
            try {
                if (this.db.on()) {
                    this.db.println("Going to delete CTP at" + iNodeModel.getName());
                }
                iServerTrailsManager.deleteServerTrail(iServerTrailLinkId);
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("deleteServerTrail: Failed to delete SrcCTP");
                }
                return false;
            }
            if (this.db.on()) {
                this.db.println("CTP deletion successful at" + iNodeModel.getName());
            }
            ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
            serverTrailPrefs.cleanupLoAdits(iServerTrailEnd);
            return true;
        }
        return false;
    }

    private void deleteServerTrailLink(INetLink iNetLink) throws ServerTrailException {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("deleteServerTrailLink: cannot delete null link");
            }
            return;
        }
        if (iNetLink.getLinkType() != 9) {
            if (this.db.on()) {
                this.db.println("deleteServerTrailLink: cannot delete non-servertrail link " + iNetLink.prettyString());
            }
            throw new ServerTrailException("Cannot delete NetLink " + iNetLink.prettyString() + " as it " + "is not a server trail link");
        }
        if (iNetLink.isDeleted()) {
            if (this.db.on()) {
                this.db.println("deleteServerTrailLink: link is already deleted");
            }
            return;
        }
        INetLink iNetLink2 = this.findReverseLink(iNetLink);
        iNetLink.dispose();
        if (iNetLink2 != null) {
            iNetLink2.dispose();
        }
    }

    public List getAvailServerTrailPorts(INodeModel iNodeModel, ServerTrailPrefs serverTrailPrefs) {
        IEntityTableModel iEntityTableModel;
        List list = new LinkedList();
        if (serverTrailPrefs == null) {
            return list;
        }
        if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
            if (this.db.on()) {
                this.db.println("getAvailSTPorts: STrail not supported at node " + iNodeModel.getName());
            }
            return list;
        }
        if (this.db.on()) {
            this.db.println("getAvailServerTrailPorts called at " + iNodeModel + serverTrailPrefs.getCircuitSize().getCircuitSizeString());
        }
        if ((iEntityTableModel = iNodeModel.getEntityTable()) == null) {
            if (this.db.on()) {
                this.db.println("Unable to find entity table model");
            }
            return list;
        }
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        if (serverTrailPrefs.isLoTrail()) {
            short s = iCircuitSize.size2widthOfLoCircuit();
            list = iEntityTableModel.getAvailEntitiesForLo((int)s, false);
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            list = iEntityTableModel.getAvailEntitiesForHo(s, 1, false);
        }
        list.addAll(this.getConnectedEntitiesForServerTrail(iNodeModel, serverTrailPrefs));
        this.removeNonServerTrailPorts(iNodeModel, list);
        if (this.db.on()) {
            this.db.println("getAvailServerTrailPorts at " + iNodeModel + " returning " + list.size() + " entities");
        }
        return list;
    }

    protected List getConnectedEntitiesForServerTrail(INodeModel iNodeModel, ServerTrailPrefs serverTrailPrefs) {
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        if (serverTrailPrefs.isLoTrail()) {
            ILoConnectionModel iLoConnectionModel;
            short s = iCircuitSize.size2widthOfLoCircuit();
            List<ILoConnectionModel> list = Arrays.asList(iConnectionModels.getLoConnectionModels());
            List<ILoAditModel> list2 = Arrays.asList(iConnectionModels.getLoAditModels());
            Iterator<ILoConnectionModel> iterator = list.iterator();
            while (iterator.hasNext()) {
                iLoConnectionModel = iterator.next();
                if (!(iLoConnectionModel instanceof ILoConnectionModel)) continue;
                IEntityModel[] iEntityModelArray = iLoConnectionModel.getPathEntities();
                Iterator<IEntityModel> iterator2 = Arrays.asList(iEntityModelArray).iterator();
                while (iterator2.hasNext()) {
                    IEntityModel iEntityModel = iterator2.next();
                    if (linkedList.contains(iEntityModel)) continue;
                    linkedList.add(iEntityModel);
                }
            }
            IEntityModel iEntityModel = null;
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                iLoConnectionModel = iterator.next();
                if (!(iLoConnectionModel instanceof ILoAditModel)) continue;
                ILoAditModel iLoAditModel = (ILoAditModel)iLoConnectionModel;
                int n = iLoAditModel.getHo().getPool().getEntityIndex();
                try {
                    iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
                    if (iEntityModel == null || linkedList.contains(iEntityModel)) continue;
                    linkedList.add(iEntityModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("getConnectedEntitiesForServerTrail: Invalid AditentityIndex " + n);
                }
            }
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            List<IHoConnectionModel> list = Arrays.asList(iConnectionModels.getHoConnectionModels());
            Iterator<IHoConnectionModel> iterator = list.iterator();
            while (iterator.hasNext()) {
                IHoConnectionModel iHoConnectionModel;
                short s2;
                IHoConnectionModel iHoConnectionModel2 = iterator.next();
                if (!(iHoConnectionModel2 instanceof IHoConnectionModel) || (s2 = (iHoConnectionModel = iHoConnectionModel2).getPaths()[0].getPathWidth()) != s) continue;
                IEntityModel[] iEntityModelArray = iHoConnectionModel2.getPathEntities();
                Iterator<IEntityModel> iterator3 = Arrays.asList(iEntityModelArray).iterator();
                while (iterator3.hasNext()) {
                    IEntityModel iEntityModel = iterator3.next();
                    if (linkedList.contains(iEntityModel)) continue;
                    linkedList.add(iEntityModel);
                }
            }
        }
        return linkedList;
    }

    public List getAvailServerTrailPoints(INodeModel iNodeModel, IEntityModel iEntityModel, ServerTrailPrefs serverTrailPrefs) {
        ArrayList arrayList = new ArrayList();
        if (this.db.on()) {
            this.db.println("getAvailServerTrailPoints @ " + iNodeModel + "::" + Integer.toHexString(iEntityModel.getEntityIndex()));
        }
        if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
            if (this.db.on()) {
                this.db.println("getAvailSTPoints: STrail not supported at node " + iNodeModel.getName());
            }
            return arrayList;
        }
        int n = serverTrailPrefs.getCircuitType().getEnum();
        int n2 = serverTrailPrefs.getCircuitSize().getEnum();
        LinkedList linkedList = new LinkedList();
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(n, n2, 1);
        arrayList.addAll(NetCircuitManager.instance().getAvailSourcePoints(iNodeModel, iEntityModel, circuitCreatInfo));
        arrayList.addAll(this.getConnectedPathsForServerTrail(iNodeModel, iEntityModel, serverTrailPrefs));
        this.removeExistingServerTrails(iNodeModel, iEntityModel, serverTrailPrefs, arrayList);
        return arrayList;
    }

    protected List getConnectedPathsForServerTrail(INodeModel iNodeModel, IEntityModel iEntityModel, ServerTrailPrefs serverTrailPrefs) {
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        if (serverTrailPrefs.isLoTrail()) {
            short s = iCircuitSize.size2widthOfLoCircuit();
            List<ILoConnectionModel> list = Arrays.asList(iConnectionModels.getLoConnectionModels());
            Iterator<ILoConnectionModel> iterator = list.iterator();
            while (iterator.hasNext()) {
                ILoConnectionModel iLoConnectionModel = iterator.next();
                if (!(iLoConnectionModel instanceof ILoConnectionModel)) continue;
                ILoConnectionModel iLoConnectionModel2 = iLoConnectionModel;
                ILoDefModel[] iLoDefModelArray = iLoConnectionModel2.getPaths();
                Iterator<ILoDefModel> iterator2 = Arrays.asList(iLoDefModelArray).iterator();
                while (iterator2.hasNext()) {
                    ILoDefModel iLoDefModel = iterator2.next();
                    ILoAditModel iLoAditModel = iLoDefModel.getLoAdit();
                    int n = iLoAditModel.getHo().getPool().getEntityIndex();
                    if (n != iEntityModel.getEntityIndex()) continue;
                    LoCircuitEnd loCircuitEnd = NetCircuitManager.instance().getAutoAssignedLoCktEnd(iNodeModel, iEntityModel);
                    if (loCircuitEnd != null) {
                        linkedList.add(loCircuitEnd);
                        continue;
                    }
                    ILoNum iLoNum = iLoDefModel.getLoNum();
                    IHoNum iHoNum = iLoAditModel.getHo().getStartingHo();
                    loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoNum, false);
                    linkedList.add(loCircuitEnd);
                }
            }
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            List<IHoConnectionModel> list = Arrays.asList(iConnectionModels.getHoConnectionModels());
            Iterator<IHoConnectionModel> iterator = list.iterator();
            while (iterator.hasNext()) {
                IHoConnectionModel iHoConnectionModel;
                short s2;
                IHoConnectionModel iHoConnectionModel2 = iterator.next();
                if (!(iHoConnectionModel2 instanceof IHoConnectionModel) || (s2 = (iHoConnectionModel = iHoConnectionModel2).getPaths()[0].getPathWidth()) != s) continue;
                IHoPathDefModel[] iHoPathDefModelArray = iHoConnectionModel.getPaths();
                Iterator<IHoPathDefModel> iterator3 = Arrays.asList(iHoPathDefModelArray).iterator();
                while (iterator3.hasNext()) {
                    IHoPathDefModel iHoPathDefModel = iterator3.next();
                    if (iHoPathDefModel.getPool().getEntityIndex() != iEntityModel.getEntityIndex()) continue;
                    HoCircuitEnd hoCircuitEnd = NetCircuitManager.instance().getAutoAssignedHoCktEnd(iNodeModel, iEntityModel);
                    if (hoCircuitEnd != null) {
                        linkedList.add(hoCircuitEnd);
                        continue;
                    }
                    IHoNum iHoNum = iHoPathDefModel.getStartingHo();
                    hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum, null, false);
                    linkedList.add(hoCircuitEnd);
                }
            }
        }
        return linkedList;
    }

    protected void removeExistingServerTrails(INodeModel iNodeModel, IEntityModel iEntityModel, ServerTrailPrefs serverTrailPrefs, List list) {
        HoLoRange hoLoRange;
        IHoLoNum iHoLoNum;
        Object object;
        IServerTrailEnd iServerTrailEnd;
        List list2 = this.findCTPs(iEntityModel);
        LinkedList<HoLoRange> linkedList = new LinkedList<HoLoRange>();
        LinkedList linkedList2 = new LinkedList();
        List list3 = new LinkedList();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        if (this.db.on()) {
            this.db.println("removeExistingServerTrails: From allCktEnds size = " + list.size());
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            iServerTrailEnd = (IServerTrailEnd)iterator.next();
            if (serverTrailPrefs.isLoTrail()) {
                object = this.getNetElem(iNodeModel.getNodeId());
                list3 = ServerTrailPrefs.getAllLoLabels(serverTrailPrefs.getCircuitSize(), iServerTrailEnd);
                linkedList2.addAll(list3);
                if (!this.db.on()) continue;
                this.db.println("Adding " + list3.size() + " more ctp loLabels");
                this.db.println("Updated LoSet size = " + linkedList2.size());
                continue;
            }
            object = null;
            iHoLoNum = null;
            if (iServerTrailEnd instanceof IHoServerTrailEnd) {
                object = ((IHoServerTrailEnd)iServerTrailEnd).getTrailStart().getStartingHo();
                iHoLoNum = ((IHoServerTrailEnd)iServerTrailEnd).getTrailEnd().getStartingHo();
            } else if (iServerTrailEnd instanceof ILoServerTrailEnd) {
                object = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart().getLoAdit().getHo().getStartingHo();
                iHoLoNum = ((ILoServerTrailEnd)iServerTrailEnd).getTrailEnd().getLoAdit().getHo().getStartingHo();
            }
            if (this.db.on()) {
                this.db.println("Creating Ho range from " + object.getHoNum() + " to " + iHoLoNum.getHoNum() + " for pre-existing CTP");
            }
            hoLoRange = new HoLoRange((IHoNum)object, (IHoNum)iHoLoNum);
            linkedList.add(hoLoRange);
        }
        iServerTrailEnd = list.iterator();
        if (serverTrailPrefs.isLoTrail()) {
            while (iServerTrailEnd.hasNext()) {
                LoCircuitEnd loCircuitEnd;
                object = (INetCircuitEnd)iServerTrailEnd.next();
                if (!(object instanceof LoCircuitEnd) && this.db.on()) {
                    this.db.println("ERROR: CktEnd not LoType");
                }
                if (!linkedList2.contains(iHoLoNum = (loCircuitEnd = (LoCircuitEnd)object).getHoLoNum())) continue;
                linkedList3.add(object);
            }
        } else {
            int n = serverTrailPrefs.getCircuitSize().getEnum();
            ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n);
            short s = iCircuitSize.size2widthOfHoCircuit();
            int n2 = iNodeModel.getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n2);
            int n3 = iFramingType.getFramingTypeHoPathWidth((int)s);
            while (iServerTrailEnd.hasNext()) {
                object = (INetCircuitEnd)iServerTrailEnd.next();
                if (!(object instanceof HoCircuitEnd) && this.db.on()) {
                    this.db.println("ERROR: CktEnd not HoType");
                }
                HoCircuitEnd hoCircuitEnd = (HoCircuitEnd)object;
                IHoNum iHoNum = hoCircuitEnd.getHoNum();
                IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, n3 - 1);
                HoLoRange hoLoRange2 = new HoLoRange(iHoNum, iHoNum2);
                iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    hoLoRange = (HoLoRange)iterator.next();
                    if (!hoLoRange2.doesIntersect(hoLoRange)) continue;
                    linkedList3.add(object);
                    if (!this.db.on()) continue;
                    this.db.println("ServerTrails: Filtering out cktEnd " + hoCircuitEnd.prettyString());
                }
            }
        }
        if (this.db.on()) {
            this.db.println("allCktEnds size = " + list.size() + "usedCktEnds size = " + linkedList3.size());
        }
        list.removeAll(linkedList3);
        if (this.db.on()) {
            this.db.println("After removing allCktEnds size = " + list.size());
        }
    }

    protected synchronized void delete(INetLink iNetLink) {
        NetLinkComparatorKey netLinkComparatorKey;
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("delete: cannot delete NULL link");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: attempting to delete NL " + iNetLink.prettyString());
        }
        if (this.allNetLinks.remove(netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkModel().linkType(), iNetLink.getSrc(), iNetLink.getDst(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.getSrcHo(), iNetLink.getDstHo(), iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null)) == null) {
            if (this.db.on()) {
                this.db.println("delete: NL not found in network, returning");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: removed NL from links list, list size = " + this.allNetLinks.size());
        }
        iNetLink.getSrc().removeAdjacentLink(iNetLink);
    }

    private void delete(Topology topology) {
        if (topology == null) {
            if (this.db.on()) {
                this.db.println("delete: cannot delete null Topo");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: deleting Topo " + topology.getTopoId());
        }
        this.topologies.remove(new Integer(topology.getTopoId()));
        topology.destroy(true);
    }

    private void initErrorString(INetElement iNetElement, INetElement iNetElement2, int n, INetLink[] iNetLinkArray) {
        errString = "Unable to find a " + (n == 0 ? "protected " : " ") + "path from " + iNetElement.getName() + " to " + iNetElement2.getName() + "\n";
        if (iNetLinkArray.length != 0) {
            errString = errString + "Following Links are blocked:\n";
        }
        for (int i = 0; i < iNetLinkArray.length; ++i) {
            INetLink iNetLink = iNetLinkArray[i];
            errString = errString + iNetLink.prettyString() + "\n";
        }
    }

    protected void removeTopology(Topology topology) {
        if (this.active) {
            if (this.db.on()) {
                this.db.println("removeTopology: removing Topo " + topology.getTopoId());
            }
            this.topologies.remove(new Integer(topology.getTopoId()));
        } else if (this.db.on()) {
            this.db.println("removeTopology: ignored, as Network is being destroyed");
        }
    }

    public INetElement[] getAvailDropNodes(RoutePrefs routePrefs) {
        if (this.db.on()) {
            this.db.println("getAvailDropNodes: Source: " + routePrefs.getSrc().prettyString() + " Circuit Size: " + routePrefs.getCircuitSize());
        }
        if (this.findNetElem(routePrefs.getSrc()) == null) {
            if (this.db.on()) {
                this.db.println("getAvailDropNodes: Source Not Found");
            }
            return new INetElement[0];
        }
        AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(routePrefs);
        return autoRouteRequestor.computeReachableNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getElements() {
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        Map map = this.netElems;
        synchronized (map) {
            Iterator iterator = this.netElems.values().iterator();
            while (iterator.hasNext()) {
                INetElement iNetElement = (INetElement)iterator.next();
                linkedList.add(iNetElement);
            }
        }
        map = this.waitQ;
        synchronized (map) {
            linkedList.addAll(this.waitQ.values());
        }
        return linkedList;
    }

    public Collection getAllElements() {
        LinkedList linkedList = new LinkedList(this.netElems.values());
        linkedList.addAll(this.waitQ.values());
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTopologies() {
        LinkedList linkedList = null;
        Map map = this.topologies;
        synchronized (map) {
            linkedList = new LinkedList(this.topologies.values());
        }
        return linkedList;
    }

    public synchronized Map getTopologyMap() {
        return this.topologies;
    }

    public void refresh() {
        Object object;
        Object object2;
        Iterator iterator = this.getTopologies().iterator();
        while (iterator.hasNext()) {
            object2 = (Topology)iterator.next();
            int n = ((Topology)object2).getTopoId();
            if (((Topology)object2).getTopoId() == 0) continue;
            ((Topology)object2).destroy(false);
            if (!this.db.on()) continue;
            this.db.println("refresh: topo " + n + " destroyed");
        }
        object2 = (LinkedList)this.getElements();
        LinkedList linkedList = (LinkedList)this.getNetLinks();
        Iterator iterator2 = ((AbstractSequentialList)object2).iterator();
        while (iterator2.hasNext()) {
            object = (INetElement)iterator2.next();
            if (!(object instanceof NetElement)) continue;
            object.setTopology(this.getDefaultTopo(), 0);
        }
        this.createTopology((LinkedList)object2);
        object = linkedList.iterator();
        while (object.hasNext()) {
            AbstractNetLink abstractNetLink = (AbstractNetLink)object.next();
            if (abstractNetLink.getLinkType() != 4) {
                abstractNetLink.setTopology(abstractNetLink.getSrc().getTopology(), abstractNetLink.getSrc().getTopoId());
            }
            this.addNewNetLink(abstractNetLink);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void destroy() {
        if (this.db.on()) {
            this.db.println("destroy: destroying network");
        }
        this.active = false;
        Iterator iterator = this.getTopologies().iterator();
        while (iterator.hasNext()) {
            Topology topology = (Topology)iterator.next();
            int n = topology.getTopoId();
            topology.destroy(true);
            if (!this.db.on()) continue;
            this.db.println("destroy: topo " + n + " destroyed");
        }
        super.destroy();
        network = null;
        this.db.dispose();
    }

    public INetElement findNetElem(int n) {
        return (INetElement)this.netElems.get(new Integer(n));
    }

    public INetElement findNetElem(INodeModel iNodeModel) {
        INetElement iNetElement = null;
        iNetElement = (INetElement)this.netElems.get(new Integer(iNodeModel.getNodeId()));
        if (iNetElement == null) {
            if (iNodeModel instanceof NodeModel) {
                if (this.db.on()) {
                    this.db.println("Could not find node with Id: " + Integer.toHexString(iNodeModel.getNodeId()) + ", will search using oldNodeId: " + Integer.toHexString(((NodeModel)iNodeModel).getOldNodeId()));
                }
                iNetElement = this.netElems.get(new Integer(((NodeModel)iNodeModel).getOldNodeId()));
            } else if (this.db.on()) {
                this.db.println("Could not find node with Id: " + Integer.toHexString(iNodeModel.getNodeId()) + ", cannot search for oldNodeId since object not a instance of NodeModel");
                this.db.println("findNetElem(INodeModel nodeM) : nodeM.getClass() = " + iNodeModel.getClass());
            }
        }
        return iNetElement;
    }

    public INetElement findNetElem(INetElement iNetElement) {
        return this.findNetElem(iNetElement.getNodeId());
    }

    private String formatLink(INetLink iNetLink) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(iNetLink.getSrc().getNodeId()));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toHexString(iNetLink.getSrcEntityIndex()));
        stringBuffer.append("/");
        stringBuffer.append(iNetLink.getSrcHo());
        stringBuffer.append("->");
        stringBuffer.append(Integer.toHexString(iNetLink.getDst().getNodeId()));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toHexString(iNetLink.getDstEntityIndex()));
        stringBuffer.append("/");
        stringBuffer.append(iNetLink.getDstHo());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLinks(INetLink iNetLink) {
        StringBuffer stringBuffer = new StringBuffer();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            stringBuffer.append("links+");
            stringBuffer.append(this.formatLink(iNetLink));
            stringBuffer.append("={");
            while (iterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator.next();
                stringBuffer.append(" ");
                stringBuffer.append(this.formatLink(iNetLink2));
            }
            stringBuffer.append(" }");
        }
        this.db.println(stringBuffer.toString());
    }

    private void addNewNetLink(INetLink iNetLink) {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("addNewNetLink: cannot add NULL link");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addNewNetLink: attempting to add NL " + iNetLink.prettyString());
        }
        iNetLink.getSrc().addAdjacentLink(iNetLink);
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkModel().linkType(), iNetLink.getSrc(), iNetLink.getDst(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.getSrcHo(), iNetLink.getDstHo(), iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null);
        if (!this.allNetLinks.containsKey(netLinkComparatorKey)) {
            this.allNetLinks.put(netLinkComparatorKey, iNetLink);
            if (this.db.on()) {
                this.db.println("addNewNetLink: link is new, added to NL list, list size = " + this.allNetLinks.size());
            }
            this.getNetLinkCreationNotifier().changed(iNetLink);
        }
    }

    public void addNetLink(INetLink iNetLink) throws ObjDuplicate {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("addNetLink- link is null");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addNetLink: adding link between " + iNetLink.getSrc() + " and " + iNetLink.getDst());
        }
        if (this.db.on()) {
            this.db.println("Adding a link to the network");
        }
        if (this.db.on()) {
            this.db.println(iNetLink.prettyString());
        }
        if (iNetLink instanceof NetLink && this.db.on()) {
            this.db.println(" Old state = " + (((NetLink)iNetLink).oldState() == 1 ? "Up" : "Down"));
        }
        iNetLink.getSrc().addAdjacentLink(iNetLink);
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkModel().linkType(), iNetLink.getSrc(), iNetLink.getDst(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.isOchTrailTunnel() ? null : iNetLink.getSrcHo(), iNetLink.isOchTrailTunnel() ? null : iNetLink.getDstHo(), iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null);
        if (this.allNetLinks.containsKey(netLinkComparatorKey)) {
            if (this.db.on()) {
                this.db.println("Duplicate link");
            }
            throw new ObjDuplicate("Duplicate Obj");
        }
        if (this.getNetElem(iNetLink.getSrc()) == null) {
            if (this.db.on()) {
                this.db.println("Source NE of link doesn't exist, adding it");
            }
            this.addNetElement(iNetLink.getSrc());
        }
        if (this.getNetElem(iNetLink.getDst()) == null) {
            if (this.db.on()) {
                this.db.println("Destination NE of link doesn't exist, adding it");
            }
            this.addNetElement(iNetLink.getDst());
        }
        this.allNetLinks.put(netLinkComparatorKey, iNetLink);
        if (this.db.on()) {
            this.showLinks(iNetLink);
        }
        if (this.db.on()) {
            this.db.println("addNetLink: notify observer of a new netlink");
        }
        this.getNetLinkCreationNotifier().changed(iNetLink);
    }

    protected INetLink addNetLink(ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, boolean bl2, Topology topology, List list) {
        INetLink iNetLink;
        if (iLinkModel == null) {
            if (this.db.on()) {
                this.db.println("addNetLink: link model is null, returning null");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("addNetLink: attempting to add NL between NE's " + iNetElement.getHostName() + " and " + iNetElement2.getHostName());
        }
        INetLink iNetLink2 = null;
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iLinkModel.linkType(), iNetElement, iNetElement2, iLinkModel.isVirtual() ? 0 : iLinkModel.srcEntityIndex(), iLinkModel.isVirtual() ? 0 : iLinkModel.dstEntityIndex(), iLinkModel.srcHo(), iLinkModel.dstHo(), iLinkModel.linkType() == 6 ? iLinkModel.getSrcLinkId() : -1, iLinkModel.linkType() == 6 ? iLinkModel.getDstLinkId() : -1, bl2, null);
        if (this.allNetLinks.containsKey(netLinkComparatorKey)) {
            if (this.db.on()) {
                this.db.println("addNetLink: link already exists, returning existing NL, list size= " + this.allNetLinks.size());
            }
            if ((iNetLink2 = (INetLink)this.allNetLinks.get(netLinkComparatorKey)).getLinkType() == 9) {
                if (this.db.on()) {
                    this.db.println("addNetLink: DENY A ServerTrail already exists between given entities.");
                }
                return null;
            }
            if (iNetLink2.getLinkType() == 3) {
                if (this.db.on()) {
                    this.db.println("addNetLink: existing link is a phantom link, must be removed");
                }
                INetLink iNetLink3 = this.findReverseLink(iNetLink2);
                ((NetLink)iNetLink2).dispose();
                if (iNetLink3 != null) {
                    ((NetLink)iNetLink3).dispose();
                }
                iNetLink2 = NetLinkFactory.createNetLink(this, iLinkModel, iNetElement, iNetElement2, topology, bl2, bl);
            }
            this.addNewNetLink(iNetLink2);
            return iNetLink2;
        }
        INetLink iNetLink4 = null;
        INetLink iNetLink5 = null;
        if (iNetElement instanceof NetElement) {
            iNetLink4 = this.findRedundantNetLinkFromSource(iLinkModel.linkType(), iNetElement, iLinkModel.srcEntityIndex(), iLinkModel.srcHo(), iLinkModel.isPca(), iLinkModel.getSrcLinkId());
        }
        if (iNetElement2 instanceof NetElement) {
            iNetLink5 = this.findRedundantNetLinkFromDestination(iLinkModel.linkType(), iNetElement2, iLinkModel.dstEntityIndex(), iLinkModel.dstHo(), iLinkModel.isPca(), iLinkModel.getDstLinkId());
        }
        iNetLink2 = NetLinkFactory.createNetLink(this, iLinkModel, iNetElement, iNetElement2, topology, bl2, bl);
        this.addNewNetLink(iNetLink2);
        if (iNetLink4 != null && !list.contains(iNetLink4)) {
            if (this.db.on()) {
                this.db.println("addNetLink: adding SRC redundant NL " + iNetLink4.prettyString() + " to list");
            }
            list.add(iNetLink4);
            iNetLink = this.findReverseLink(iNetLink4);
            if (iNetLink != null) {
                if (this.db.on()) {
                    this.db.println("addNetLink: adding SRC redundant NL " + iNetLink.prettyString() + " to list");
                }
                list.add(iNetLink);
            }
        }
        if (iNetLink5 != null && !list.contains(iNetLink5)) {
            if (this.db.on()) {
                this.db.println("addNetLink: adding DST redundant NL " + iNetLink5.prettyString() + " to list");
            }
            list.add(iNetLink5);
            iNetLink = this.findReverseLink(iNetLink5);
            if (iNetLink != null) {
                if (this.db.on()) {
                    this.db.println("addNetLink: adding DST redundant NL " + iNetLink.prettyString() + " to list");
                }
                list.add(iNetLink);
            }
        }
        return iNetLink2;
    }

    protected INetLink addServerTrailLink(ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, ServerTrailPrefs serverTrailPrefs, boolean bl2) throws ServerTrailException {
        if (iLinkModel == null) {
            if (this.db.on()) {
                this.db.println("addServerTrailLink: link model is null, returning null");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("addServerTrailLink: Adding SvrTrl-NL between NE's " + iNetElement.getHostName() + " and " + iNetElement2.getHostName());
        }
        INetLink iNetLink = null;
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iLinkModel.linkType(), iNetElement, iNetElement2, iLinkModel.isVirtual() ? 0 : iLinkModel.srcEntityIndex(), iLinkModel.isVirtual() ? 0 : iLinkModel.dstEntityIndex(), iLinkModel.srcHo(), iLinkModel.dstHo(), iLinkModel.linkType() == 6 ? iLinkModel.getSrcLinkId() : -1, iLinkModel.linkType() == 6 ? iLinkModel.getDstLinkId() : -1, false, serverTrailPrefs.getTrailId());
        if (this.allNetLinks.containsKey(netLinkComparatorKey)) {
            if (this.db.on()) {
                this.db.println("addServerTrailLink: Found matching ServerTrail existing NL, list size= " + this.allNetLinks.size());
            }
            iNetLink = (INetLink)this.allNetLinks.get(netLinkComparatorKey);
            this.addNewNetLink(iNetLink);
            return iNetLink;
        }
        iNetLink = NetLinkFactory.createNetLink(this, iLinkModel, iNetElement, iNetElement2, topology, bl, serverTrailPrefs);
        this.addNewNetLink(iNetLink);
        return iNetLink;
    }

    protected void addDwdmNetLink(INetLink iNetLink) {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("addDwdmNetLink: link is null, returning");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addDwdmNetLink: attempting to add NL between NE's " + iNetLink.getSrc().getHostName() + " and " + iNetLink.getDst().getHostName());
        }
        this.addNewNetLink(iNetLink);
    }

    protected void addCompositeNetLink(CompositeNetLink compositeNetLink) {
        if (compositeNetLink == null) {
            if (this.db.on()) {
                this.db.println("addCompositeNetLink: link is null, returning");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addCompositeNetLink: attempting to add NL between NE's " + compositeNetLink.getSrc().getHostName() + " and " + compositeNetLink.getDst().getHostName());
        }
        this.addNewNetLink(compositeNetLink);
    }

    protected synchronized void replaceUnknownLink(UnknownNetLink unknownNetLink, INetLink iNetLink) {
        Topology topology = unknownNetLink.getTopology();
        if (this.db.on()) {
            this.db.println("replaceUnknownLink: replacing NL " + unknownNetLink.prettyString() + " with " + iNetLink.prettyString());
        }
        if (topology != null && !topology.isDestroyed()) {
            topology.replaceUnknownLink(unknownNetLink, iNetLink);
        }
        unknownNetLink.dispose();
        this.addNewNetLink(iNetLink);
    }

    public void deleteNetLink(INetLink iNetLink) {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("deleteNetLink- link is null");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("deleteNetLink: deleting NL " + iNetLink.prettyString());
        }
        iNetLink.dispose();
    }

    public INetLink findNetLink(INetElement iNetElement, int n, IHoNum iHoNum, INetElement iNetElement2, int n2, IHoNum iHoNum2, boolean bl) {
        if (iNetElement == null || iNetElement2 == null) {
            if (this.db.on()) {
                this.db.println("findNetLink- null NE reference");
            }
            return null;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        INodeModel iNodeModel2 = iNetElement2.getNodeModel();
        if (iNodeModel == null || iNodeModel2 == null) {
            return null;
        }
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(0, iNetElement, iNetElement2, n, n2, iHoNum, iHoNum2, -1, -1, bl, null);
        if (this.allNetLinks.containsKey(netLinkComparatorKey)) {
            INetLink iNetLink = (INetLink)this.allNetLinks.get(netLinkComparatorKey);
            return iNetLink;
        }
        if (this.db.on()) {
            this.db.println("Unable to find netlink in the network");
        }
        return null;
    }

    public INetLink findServerTrailLink(INetElement iNetElement, int n, ILabel iLabel, INetElement iNetElement2, int n2) {
        if (iNetElement == null || iNetElement2 == null) {
            if (this.db.on()) {
                this.db.println("findServerTrail- null NE reference");
            }
            return null;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        INodeModel iNodeModel2 = iNetElement2.getNodeModel();
        if (iNodeModel == null || iNodeModel2 == null) {
            return null;
        }
        if (this.db.on()) {
            this.db.println("Unable to find netlink in the network");
        }
        return null;
    }

    public INetLink findReverseLink(INetLink iNetLink) {
        NetLinkComparatorKey netLinkComparatorKey;
        INetLink iNetLink2 = null;
        if (iNetLink == null) {
            return null;
        }
        if (this.db.on()) {
            this.db.println("findReverseLink: link = " + iNetLink.prettyString());
        }
        if ((iNetLink2 = (INetLink)this.allNetLinks.get(netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkType(), iNetLink.getDst(), iNetLink.getSrc(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.getDstHo(), iNetLink.getSrcHo(), iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null))) == null) {
            if (this.db.on()) {
                this.db.println("findReverseLink: Unable to find reverse link in the network");
            }
        } else if (this.db.on()) {
            this.db.println("findReverseLink: returning reverse link from network");
        }
        return iNetLink2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findVirtualLinks(INetElement iNetElement, INetElement iNetElement2) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!(iNetLink instanceof VirtualNetLink) || (!iNetLink.getSrc().equals(iNetElement) || !iNetLink.getDst().equals(iNetElement2)) && (!iNetLink.getSrc().equals(iNetElement2) || !iNetLink.getDst().equals(iNetElement))) continue;
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findNetLinkFromLinkModel(ILinkModel iLinkModel) {
        INetLink iNetLink = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iNetLink == null && iterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator.next();
                if (iNetLink2.getLinkModel() != iLinkModel) continue;
                iNetLink = iNetLink2;
            }
        }
        return iNetLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findNetLinkFromEnt(INetElement iNetElement, int n, boolean bl) {
        INetLink iNetLink = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator.next();
                if (iNetLink2.getSrc() != iNetElement || iNetLink2.getSrcEntityIndex() != n || iNetLink2.isSdccLink() != bl) continue;
                if (iNetLink == null) {
                    iNetLink = iNetLink2;
                    continue;
                }
                if (iNetLink.getTimestamp() >= iNetLink2.getTimestamp()) continue;
                iNetLink = iNetLink2;
            }
        }
        return iNetLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INetLink findNetLinkFromEnt(INetElement iNetElement, int n) {
        INetLink iNetLink = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator.next();
                if (iNetLink2.getSrc() != iNetElement || iNetLink2.getSrcEntityIndex() != n) continue;
                if (iNetLink == null) {
                    iNetLink = iNetLink2;
                    continue;
                }
                if (iNetLink.getTimestamp() >= iNetLink2.getTimestamp()) continue;
                iNetLink = iNetLink2;
            }
        }
        return iNetLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findPcaNetLinkFromEnt(INetElement iNetElement, int n) {
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.isLOTunnel() || iNetLink.isLAP() || !iNetLink.isPca() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n) continue;
                return iNetLink;
            }
        }
        return null;
    }

    private INetLink findRedundantNetLinkFromSource(int n, INetElement iNetElement, int n2, IHoNum iHoNum, boolean bl, int n3) {
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink instanceof CompositeNetLink || iNetLink.getLinkType() != n || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n2 || !holoComp.isEqual(iNetLink.getSrcHo(), iHoNum) || iNetLink.isPca() != bl || iNetLink.getSrcLinkId() != n3) continue;
            return iNetLink;
        }
        return null;
    }

    private INetLink findRedundantNetLinkFromDestination(int n, INetElement iNetElement, int n2, IHoNum iHoNum, boolean bl, int n3) {
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink instanceof CompositeNetLink || iNetLink.getLinkType() != n || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n2 || !holoComp.isEqual(iNetLink.getDstHo(), iHoNum) || iNetLink.isPca() != bl || iNetLink.getDstLinkId() != n3) continue;
            return iNetLink;
        }
        return null;
    }

    public INetLink findNetLinkFromSourceCktEnd(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum) {
        INetLink iNetLink;
        Iterator iterator = this.getNetLinks().iterator();
        if (this.db.on()) {
            this.db.println("findNetLinkFromSourceCktEnd: on ne " + iNetElement.getName());
        }
        if (bl) {
            while (iterator.hasNext()) {
                iNetLink = (INetLink)iterator.next();
                if (!iNetLink.isLOTunnel() && !iNetLink.isLAP() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n || !holoComp.isEqual(iNetLink.getSrcHo(), iHoNum)) continue;
                return iNetLink;
            }
        }
        iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isRoutable() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n || !iNetLink.isValidSrcHoNumber(iHoNum)) continue;
            return iNetLink;
        }
        return null;
    }

    public INetLink findNetLinkFromDestinationCktEnd(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum) {
        INetLink iNetLink;
        Iterator iterator = this.getNetLinks().iterator();
        if (this.db.on()) {
            this.db.println("findNetLinkFromDestinationCktEnd: on ne " + iNetElement.getName());
        }
        if (bl) {
            while (iterator.hasNext()) {
                iNetLink = (INetLink)iterator.next();
                if (!iNetLink.isLOTunnel() && !iNetLink.isLAP() || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n || !holoComp.isEqual(iNetLink.getDstHo(), iHoNum)) continue;
                return iNetLink;
            }
        }
        iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isRoutable() || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n || !iNetLink.isValidDstHoNumber(iHoNum)) continue;
            return iNetLink;
        }
        return null;
    }

    public INetLink findNetLinkFromSource(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum) {
        return this.findNetLinkFromSource(bl, iNetElement, n, iHoNum, null);
    }

    public INetLink findNetLinkFromDestination(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum) {
        return this.findNetLinkFromDestination(bl, iNetElement, n, iHoNum, null);
    }

    public INetLink findNetLinkFromSource(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!bl && (iNetLink.isLOTunnel() || iNetLink.isLAP()) || bl && !iNetLink.isLOTunnel() && !iNetLink.isLAP() || !iNetLink.isRoutable() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n || !iNetLink.isValidSrcHoNumber(iHoNum) || iNetLink.isVirtual() && !((VirtualNetLink)iNetLink).isDstPortRX() || iNetLink.isServerTrail() && iLoNum != null && !((ServerTrailLink)iNetLink).isValidHoLoNum(iHoNum, iLoNum, true)) continue;
            return iNetLink;
        }
        return null;
    }

    public INetLink findNetLinkFromDestination(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!bl && (iNetLink.isLOTunnel() || iNetLink.isLAP()) || bl && !iNetLink.isLOTunnel() && !iNetLink.isLAP() || !iNetLink.isRoutable() || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n || !iNetLink.isValidDstHoNumber(iHoNum) || iNetLink.isServerTrail() && iLoNum != null && !((ServerTrailLink)iNetLink).isValidHoLoNum(iHoNum, iLoNum, false)) continue;
            return iNetLink;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllNetLinksWithSource(INetElement iNetElement) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.getSrc() != iNetElement) continue;
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllNetLinksWithNetElem(INetElement iNetElement) {
        if (this.db.on()) {
            this.db.println("findAllNetLinksWithNetElem: looking for NE " + iNetElement.getHostName());
        }
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.getDst() != iNetElement && iNetLink.getSrc() != iNetElement) continue;
                if (this.db.on()) {
                    this.db.println("findAllNetLinksWithNetElem: link = " + iNetLink.prettyString());
                }
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllNetLinksWithBlsrRingName(String string) {
        if (this.db.on()) {
            this.db.println("findAllNetLinksWithBlsrRingName: looking for ring " + string);
        }
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!iNetLink.inBLSR() || !iNetLink.blsrRingName().equals(string)) continue;
                if (this.db.on()) {
                    this.db.println("findAllNetLinksWithBlsrRingName: link = " + iNetLink.prettyString());
                }
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllLoTunnelNetLinks(INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (bl && iNetLink.isLOTunnel() && iNetLink.getSrc() == iNetElement && iNetLink.getDst() == iNetElement2) {
                    linkedList.add(iNetLink);
                    continue;
                }
                if (bl || !iNetLink.isLAP() || iNetLink.getSrc() != iNetElement || iNetLink.getDst() != iNetElement2) continue;
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    protected INetLink findLoTunnelNetLink(INetElement iNetElement, INetElement iNetElement2, int n, IHoNum iHoNum) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        linkedList.addAll(this.findAllLoTunnelNetLinks(iNetElement, iNetElement2, true));
        linkedList2.addAll(this.findAllLoTunnelNetLinks(iNetElement, iNetElement2, false));
        Iterator iterator = linkedList.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetLink netLink = (NetLink)iterator.next();
                if (netLink.getSrcEntityIndex() != n || !holoComp.isEqual(netLink.getSrcHo(), iHoNum)) continue;
                return netLink;
            }
            iterator = linkedList2.iterator();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getNetLinks() {
        LinkedList linkedList = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            linkedList = new LinkedList(this.allNetLinks.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List findServerTrailsAtSrc(IEntityModel iEntityModel) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        INetElement iNetElement = this.getNetElem(iEntityModel.getNodeModel().getNodeId());
        int n = iEntityModel.getEntityIndex();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n) continue;
                if (iNetLink.getLinkType() == 9) {
                    linkedList.add(iNetLink);
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("ERROR: Found a Non-ServerTrail on port " + iEntityModel.toString());
            }
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findCTPs(IEntityModel iEntityModel) {
        LinkedList linkedList = new LinkedList();
        LinkedList<IServerTrailEnd> linkedList2 = this.masterTrailLock;
        synchronized (linkedList2) {
            linkedList.addAll(this.svTrailPrimCTPs.values());
            linkedList.addAll(this.svTrailPeerCTPs.values());
        }
        linkedList2 = new LinkedList<IServerTrailEnd>();
        INetElement iNetElement = this.getNetElem(iEntityModel.getNodeModel().getNodeId());
        int n = iEntityModel.getEntityIndex();
        Iterator iterator = linkedList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            IServerTrailEnd iServerTrailEnd = (IServerTrailEnd)iterator.next();
            INetElement iNetElement2 = this.getCtpNe(iServerTrailEnd, null);
            if (iNetElement2 == null) continue;
            if (iServerTrailEnd instanceof IHoServerTrailEnd) {
                IHoServerTrailEnd iHoServerTrailEnd = (IHoServerTrailEnd)iServerTrailEnd;
                n2 = iHoServerTrailEnd.getTrailStart().getPool().getEntityIndex();
            } else if (iServerTrailEnd instanceof ILoServerTrailEnd) {
                ILoServerTrailEnd iLoServerTrailEnd = (ILoServerTrailEnd)iServerTrailEnd;
                n2 = iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getPool().getEntityIndex();
            }
            if (iNetElement2 == null || !iNetElement2.equals(iNetElement) || n != n2) continue;
            linkedList2.add(iServerTrailEnd);
        }
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Found " + linkedList2.size() + " CTP objects on" + iNetElement.getName() + "::" + Integer.toHexString(n));
            this.db.println("=================================================");
        }
        return linkedList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findOchTrailTunnelNetLink(INetElement iNetElement, int n) {
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!(iNetLink instanceof OchTrailTunnelNetLink) || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n) continue;
                return iNetLink;
            }
        }
        return null;
    }

    private void removeNonServerTrailPorts(INodeModel iNodeModel, List list) {
        INetElement iNetElement = this.getNetElem(iNodeModel.getNodeId());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            if (!ServerTrailPrefs.isServerTrailPort(iEntityModel)) {
                iterator.remove();
                continue;
            }
            int n = iEntityModel.getEntityIndex();
            INetLink iNetLink = this.findNetLinkFromEnt(iNetElement, n);
            if (iNetLink == null || iNetLink.getLinkType() == 9 || iNetLink.isLOTunnel() || iNetLink.isLAP()) continue;
            iterator.remove();
        }
    }

    public INodeModel getNodeModel(int n) {
        INetElement iNetElement = this.findNetElem(n);
        return iNetElement == null ? null : iNetElement.getNodeModel();
    }

    public Topology getNonDefaultTopoOfSmallestId() {
        Topology topology = null;
        int n = 0;
        Iterator iterator = this.topologies.values().iterator();
        while (iterator.hasNext()) {
            Topology topology2 = (Topology)iterator.next();
            if (topology2.getTopoId() == 0) continue;
            if (topology == null) {
                topology = topology2;
                n = topology2.getTopoId();
                continue;
            }
            if (topology2.getTopoId() >= n) continue;
            topology = topology2;
            n = topology2.getTopoId();
        }
        return topology;
    }

    protected Topology getDefaultTopo() {
        return (Topology)this.topologies.get(new Integer(0));
    }

    public INetElement getTopoHost(int n) {
        INetElement iNetElement = null;
        Topology topology = (Topology)this.getTopologyMap().get(new Integer(n));
        Iterator iterator = topology.getTopoElems().iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement2 = (INetElement)iterator.next();
            if (!iNetElement2.isTopoHost() || iNetElement2.getTopoId() != n) continue;
            iNetElement = iNetElement2;
            break;
        }
        return iNetElement;
    }

    public NetElementCreationNotifier getNetElementCreationNotifier() {
        return this.netElementCreationNotifier;
    }

    public NetLinkCreationNotifier getNetLinkCreationNotifier() {
        return this.netLinkCreationNotifier;
    }

    public TopologyCreationNotifier getTopologyCreationNotifier() {
        return this.topologyCreationNotifier;
    }

    private String getDefaultName() {
        return "Unknown" + ++this.nextId;
    }

    static {
        addNetEleCompleted = true;
    }

    public class NetworkDebug
    extends SDebug
    implements IDebugDiag,
    IActionClient {
        private User user;
        private static final String defaultUserName = "CISCO15";
        private static final String defaultPassword = "otbu+1";
        public static final String Hdump = "Dump all of the NetLinks in the network";
        public static final String HlistTopoNEs = "List the Topology Hosts";

        public NetworkDebug() {
            super("Network");
            this.user = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            if (network != null) {
                Network network = Network.network;
                synchronized (network) {
                    Network.network.prettyPrint(this);
                }
            }
        }

        public final void setUser(String string, String string2) {
            this.user = new User(string, string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void listTopoNEs() {
            this.println("Topology Hosts:");
            List list = Network.this.topoNEs;
            synchronized (list) {
                Iterator iterator = network.topoNEs.iterator();
                while (iterator.hasNext()) {
                    INetElement iNetElement = (INetElement)iterator.next();
                    this.println("\t" + iNetElement.getName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpNEs() {
            this.println("Network Elements:");
            Map map = Network.this.netElems;
            synchronized (map) {
                Iterator iterator = Network.this.netElems.values().iterator();
                while (iterator.hasNext()) {
                    INetElement iNetElement = (INetElement)iterator.next();
                    this.println("\t" + iNetElement.getHostName() + ", inited => " + iNetElement.getNodeModel().isInited());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpNLs() {
            this.println("Network Links:");
            Map map = Network.this.allNetLinks;
            synchronized (map) {
                Iterator iterator = Network.this.allNetLinks.values().iterator();
                while (iterator.hasNext()) {
                    INetLink iNetLink = (INetLink)iterator.next();
                    this.println("\t" + iNetLink.prettyString());
                    this.println("\t\t" + iNetLink);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpWaitQ() {
            Map map = Network.this.waitQ;
            synchronized (map) {
                Iterator iterator = Network.this.waitQ.values().iterator();
                if (Network.this.db.on()) {
                    Network.this.db.println("waitQ:");
                }
                while (iterator.hasNext()) {
                    NetElement netElement = (NetElement)iterator.next();
                    Network.this.db.println("    " + netElement.getName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpLimitedNodes() {
            this.println("Network Elements:");
            List list = Network.this.limitedNodes;
            synchronized (list) {
                Iterator iterator = Network.this.limitedNodes.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Network.this.db.println("    " + string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpNEbyIP() {
            this.println("Network Elements list by IP address:");
            Map map = Network.this.netElemsByIp;
            synchronized (map) {
                Iterator iterator = Network.this.netElemsByIp.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    INetElement iNetElement = (INetElement)Network.this.netElemsByIp.get(string);
                    this.println("\t" + string + " => " + iNetElement.prettyString());
                }
            }
        }

        public final void dumpTopologies() {
            this.println("Dumping Topologies:");
            Iterator iterator = Network.this.getTopologies().iterator();
            while (iterator.hasNext()) {
                Topology topology = (Topology)iterator.next();
                this.println("    Topology " + topology.getTopoId());
            }
        }

        public final void addNE(String string, String string2, String string3) {
            Network.this.db.println("addNE: manually adding NE " + string + ", user= " + string2 + ", password= " + string3);
            try {
                NetworkModel.instance().addNetElementBlocking(string, string2, string3, false);
                NetworkModel.instance().setUser(string2, string3);
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("addNE: caught UnknownHostException, e = " + unknownHostException);
            }
            Network.this.db.println("addNE: manually added topo host");
        }

        public final void addNE(String string) {
            Network.this.db.println("addNE: manually adding NE " + string);
            this.addNE(string, defaultUserName, defaultPassword);
            Network.this.db.println("addNE: manually added topo host");
        }

        public final void createTopo(String string) {
            Network.this.db.println("createTopo: creating Topo with topo host " + string);
            INetElement iNetElement = null;
            try {
                iNetElement = Network.this.addNetElement(string, defaultUserName, defaultPassword);
                NetworkModel.instance().setUser(defaultUserName, defaultPassword);
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("createTopo: caught UnknownHostException, e = " + unknownHostException);
            }
            Network.this.createTopology(iNetElement);
        }

        public final void delTopo(String string) {
            Network.this.db.println("delTopo: deleting topo containing NE " + string);
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("delTopo: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                Network.this.deleteTopology(iNetElement);
            }
        }

        public final void dumpObservers() {
            Network.this.db.println("Network observers:");
            Network.this.printObservers();
            Network.this.db.println("NetElementCreationNotifier observers:");
            Network.this.netElementCreationNotifier.printObservers();
            Network.this.db.println("NetLinkCreationNotifier observers:");
            Network.this.netLinkCreationNotifier.printObservers();
        }

        public final void deleteNE(String string) {
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("deleteNE: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                Network.this.db.println("deleteNE: NE = " + iNetElement.getHostName());
                try {
                    Network.this.deleteNetElement(iNetElement);
                }
                catch (NetElementDeletionException netElementDeletionException) {
                    Network.this.db.println("deleteNE: caught exception, e = " + (Object)((Object)netElementDeletionException));
                }
            } else {
                Network.this.db.println("deleteNE: NE = null");
            }
        }

        public final void blockedDeleteNE(String string) {
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("deleteNE: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                Network.this.db.println("deleteNE: NE = " + iNetElement.getHostName());
                try {
                    Network.this.deleteNetElementAndBlock(iNetElement);
                }
                catch (NetElementDeletionException netElementDeletionException) {
                    Network.this.db.println("deleteNE: caught exception, e = " + (Object)((Object)netElementDeletionException));
                }
            } else {
                Network.this.db.println("deleteNE: NE = null");
            }
        }

        public final void deleteNEAndConnectedNLs(String string) {
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("deleteNEAndConnectedNLs: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                Network.this.deleteNetElementAndConnectedNetLinks(iNetElement);
            } else {
                Network.this.db.println("deleteNEAndConnectedNLs: NE = NULL");
            }
        }

        public final void createSrlg(String string, int n, String string2) {
            Object object;
            INetElement iNetElement = null;
            try {
                object = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(((InetAddress)object).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("createSrlg: caught exception, e = " + unknownHostException.getMessage());
            }
            object = Network.this.findNetLinkFromEnt(iNetElement, n);
            if (object == null) {
                Network.this.db.println("createSrlg: No matching link found");
                return;
            }
            if (!(object instanceof NetLink)) {
                Network.this.db.println("createSrlg: Link not an instance of NetLink class");
                return;
            }
            NetLink netLink = (NetLink)object;
            if (string2.equals("X")) {
                try {
                    netLink.clearSrlg();
                    Network.this.db.println("createSrlg: Cleared SRLGs for:" + netLink.prettyStringDetail());
                    return;
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    Network.this.db.println("createSrlg: Exception in addSrlg , e = " + sanityCheckFailed.getMessage());
                }
            }
            try {
                GenericSrg genericSrg = new GenericSrg(string2);
                netLink.addSrlg(genericSrg);
                Network.this.db.println("createSrlg: Added SRLG " + string2 + " for: " + netLink.prettyStringDetail());
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                Network.this.db.println("createSrlg: Exception in addSrlg , e = " + sanityCheckFailed.getMessage());
            }
        }

        public final void createPhantom(String string, int n, String string2, int n2) {
            block4: {
                INetElement iNetElement = null;
                INetElement iNetElement2 = null;
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
                    iNetElement2 = Network.this.findNetElemByIp(inetAddress2.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    Network.this.db.println("createPhantom: caught exception, e = " + unknownHostException.getMessage());
                }
                int n3 = 3;
                int n4 = 1;
                int n5 = 1000;
                try {
                    Network.this.createPhantomLink(iNetElement, iNetElement2, n, n2, n4, n3, n5);
                }
                catch (PhantomLinkException phantomLinkException) {
                    if (!Network.this.db.on()) break block4;
                    Network.this.db.println("createPhantom: caught exception, e = " + phantomLinkException.getMessage());
                }
            }
        }

        public final void deletePhantom(String string, int n, String string2, int n2) {
            block7: {
                Object object;
                Object object2;
                INetElement iNetElement = null;
                INetElement iNetElement2 = null;
                try {
                    object2 = InetAddress.getByName(string);
                    object = InetAddress.getByName(string2);
                    iNetElement = Network.this.findNetElemByIp(((InetAddress)object2).getHostAddress());
                    iNetElement2 = Network.this.findNetElemByIp(((InetAddress)object).getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    Network.this.db.println("deletePhantom: caught exception, e = " + unknownHostException);
                    return;
                }
                object2 = Network.this.findNetLink(iNetElement, n, null, iNetElement2, n2, null, false);
                if (object2 == null) {
                    Network.this.db.println("deletePhantom: cannot find phantom link to destroy");
                } else {
                    try {
                        object = Network.this.findReverseLink((INetLink)object2);
                        Network.this.deletePhantomLink((INetLink)object2);
                        if (object != null) {
                            Network.this.deletePhantomLink((INetLink)object);
                        }
                    }
                    catch (PhantomLinkException phantomLinkException) {
                        if (!Network.this.db.on()) break block7;
                        Network.this.db.println("deletePhantom: caught exception, e = \n" + phantomLinkException.getMessage());
                    }
                }
            }
        }

        public final void dumpAvailTrailPoints(String string, int n, int n2) {
            InetAddress inetAddress;
            ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
            serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)n2));
            INetElement iNetElement = null;
            try {
                inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("createServerTrail: caught exception, e = " + unknownHostException.getMessage());
            }
            inetAddress = iNetElement.getNodeModel();
            IEntityModel iEntityModel = null;
            if (inetAddress != null) {
                try {
                    iEntityModel = inetAddress.getEntityTable().getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    return;
                }
            } else {
                return;
            }
            LinkedList linkedList = (LinkedList)Network.this.getAvailServerTrailPoints((INodeModel)inetAddress, iEntityModel, serverTrailPrefs);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                Network.this.db.println(" NetCircuitEnd: " + netCircuitEnd.prettyString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpServerTrails() {
            int n;
            ServerTrailLink serverTrailLink;
            Iterator iterator;
            this.println("ServerTrail Links:");
            Object object = Network.this.masterTrailLock;
            synchronized (object) {
                iterator = Network.this.svTrailLinks.values().iterator();
                while (iterator.hasNext()) {
                    serverTrailLink = (ServerTrailLink)iterator.next();
                    Network.this.db.println("    " + serverTrailLink.prettyStringDetail());
                }
            }
            this.println("Primary CTPs:");
            Object object2 = Network.this.masterTrailLock;
            synchronized (object2) {
                iterator = Network.this.svTrailPrimCTPs.values().iterator();
                n = 0;
                while (iterator.hasNext()) {
                    object = (IServerTrailEnd)iterator.next();
                    serverTrailLink = object.getServerTrailLinkId();
                    Network.this.db.println(" P-ctp " + ++n + " has SvId-NodeId = " + serverTrailLink.getNodeId() + " Unique = " + serverTrailLink.getUniqueId());
                }
            }
            this.println("Peer CTPs:");
            object2 = Network.this.masterTrailLock;
            synchronized (object2) {
                iterator = Network.this.svTrailPeerCTPs.values().iterator();
                n = 0;
                while (iterator.hasNext()) {
                    object = (IServerTrailEnd)iterator.next();
                    serverTrailLink = object.getServerTrailLinkId();
                    Network.this.db.println(" S-Ctp " + ++n + " has SvId-NodeId = " + serverTrailLink.getNodeId() + " Unique = " + serverTrailLink.getUniqueId());
                }
            }
        }

        public final void dumpAvailTrailPorts(String string, int n) {
            InetAddress inetAddress;
            ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
            serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)n));
            INetElement iNetElement = null;
            try {
                inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("dumpServerTrailPorts: caught exception, e = " + unknownHostException.getMessage());
            }
            inetAddress = iNetElement.getNodeModel();
            LinkedList linkedList = (LinkedList)Network.this.getAvailServerTrailPorts((INodeModel)inetAddress, serverTrailPrefs);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IEntityModel iEntityModel = (IEntityModel)iterator.next();
                Network.this.db.println(" Entity: " + iEntityModel.toString());
            }
        }

        public final void getCTPs(String string) {
            ILoDefModel iLoDefModel;
            boolean bl;
            IServerTrailLinkId iServerTrailLinkId;
            IServerTrailEnd iServerTrailEnd;
            InetAddress inetAddress;
            INetElement iNetElement = null;
            try {
                inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("getServerTrail: caught exception, e = " + unknownHostException.getMessage());
            }
            inetAddress = iNetElement.getNodeModel();
            if (!inetAddress.provides(Feature.SERVER_TRAIL)) {
                if (Network.this.db.on()) {
                    Network.this.db.println("getCTPs: STrail not supported at node " + inetAddress.getName());
                }
                return;
            }
            IServerTrailsManager iServerTrailsManager = inetAddress.getServerTrailsManager();
            Network.this.db.println("Going to fetch CTPs");
            if (!iServerTrailsManager.isInited()) {
                Network.this.db.println("getCTPs:: svMgr is not initialized");
                return;
            }
            IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
            Network.this.db.println("Received " + iServerTrailEndArray.length + " CTP objects on" + iNetElement.getName());
            for (int i = 0; i < iServerTrailEndArray.length; ++i) {
                iServerTrailEnd = iServerTrailEndArray[i];
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                if (!(iServerTrailEnd instanceof ILoServerTrailEnd)) continue;
                bl = true;
                Network.this.db.println("Validating LoCTP FROM NODE:: NodeId " + iServerTrailLinkId.getNodeId() + " Uid: " + iServerTrailLinkId.getUniqueId());
                try {
                    iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
                    inetAddress = iLoDefModel.getLoAdit().getHo().getNodeModel();
                }
                catch (Exception exception) {
                    Network.this.db.println("Failed Adit call: Caught Exception => " + exception.getMessage());
                    bl = false;
                }
                if (!bl) continue;
                Network.this.db.println("LoCTP (FROM NODE) looks good");
            }
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(Network.this.svTrailPrimCTPs.values());
            linkedList.addAll(Network.this.svTrailPeerCTPs.values());
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                iServerTrailEnd = (IServerTrailEnd)iterator.next();
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                if (!(iServerTrailEnd instanceof ILoServerTrailEnd)) continue;
                bl = true;
                Network.this.db.println("Validating LoCTP FROM local list:: NodeId " + iServerTrailLinkId.getNodeId() + " Uid: " + iServerTrailLinkId.getUniqueId());
                try {
                    iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
                    inetAddress = iLoDefModel.getLoAdit().getHo().getNodeModel();
                }
                catch (Exception exception) {
                    Network.this.db.println("Failed Adit call (LOCAL CTP): Caught Exception => " + exception.getMessage());
                    bl = false;
                }
                if (!bl) continue;
                Network.this.db.println("LoCTP (LOCAL LIST) looks good at node " + Network.this.findNetElem((INodeModel)inetAddress).getName());
            }
        }

        public final void createServerTrail(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, int n7, int n8, String string3, int n9, int n10) {
            block8: {
                IHoNum iHoNum;
                int n11;
                InetAddress inetAddress;
                INetElement iNetElement = null;
                INetElement iNetElement2 = null;
                try {
                    InetAddress inetAddress2 = InetAddress.getByName(string);
                    inetAddress = InetAddress.getByName(string2);
                    iNetElement = Network.this.findNetElemByIp(inetAddress2.getHostAddress());
                    iNetElement2 = Network.this.findNetElemByIp(inetAddress.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    Network.this.db.println("createServerTrail: caught exception, e = " + unknownHostException.getMessage());
                }
                inetAddress = iNetElement.getNodeModel();
                try {
                    n11 = inetAddress.getFramingType();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    Network.this.db.println("failed to get framing type for node: " + inetAddress.getNodeId() + " " + abstractCmsIOException.getMessage());
                    return;
                }
                ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
                serverTrailPrefs.setSrc(iNetElement);
                serverTrailPrefs.setSrcEntity(n);
                serverTrailPrefs.setDest(iNetElement2);
                serverTrailPrefs.setDestEntity(n4);
                if (n3 != 0) {
                    iHoNum = HoLoFactory.ho2HoNum(n11, n2);
                    ILoNum iLoNum = HoLoFactory.idlVt2LoNum(n11, n7, n3);
                    IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                    serverTrailPrefs.setSrcPoolStart((ILabel)iHoLoNum);
                    iHoNum = HoLoFactory.ho2HoNum(n11, n5);
                    iLoNum = HoLoFactory.idlVt2LoNum(n11, n7, n6);
                    iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                    serverTrailPrefs.setDestPoolStart((ILabel)iHoLoNum);
                } else {
                    iHoNum = HoLoFactory.ho2HoNum(n11, n2);
                    serverTrailPrefs.setSrcPoolStart((ILabel)iHoNum);
                    iHoNum = HoLoFactory.ho2HoNum(n11, n5);
                    serverTrailPrefs.setDestPoolStart((ILabel)iHoNum);
                }
                serverTrailPrefs.setProtectionType(n8);
                serverTrailPrefs.setSrlg(string3);
                serverTrailPrefs.setCost(n9);
                serverTrailPrefs.setNx(n10);
                serverTrailPrefs.setPhyLinkType(5);
                serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)n7));
                try {
                    Network.this.createServerTrailLink(serverTrailPrefs);
                }
                catch (ServerTrailException serverTrailException) {
                    if (!Network.this.db.on()) break block8;
                    Network.this.db.println("createServerTrail: caught exception, e = " + serverTrailException.getMessage());
                }
            }
        }

        public final void deleteSvTrail(String string, int n, int n2, int n3, int n4) {
            block13: {
                ServerTrailLink serverTrailLink;
                Object object;
                IHoNum iHoNum;
                int n5;
                InetAddress inetAddress;
                INetElement iNetElement = null;
                INetLink iNetLink = null;
                try {
                    inetAddress = InetAddress.getByName(string);
                    iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    Network.this.db.println("deleteServerTrail: caught exception, e = " + unknownHostException);
                    return;
                }
                inetAddress = iNetElement.getNodeModel();
                try {
                    n5 = inetAddress.getFramingType();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    Network.this.db.println("failed to get framing type for node: " + inetAddress.getNodeId() + " " + abstractCmsIOException.getMessage());
                    return;
                }
                IHoLoNum iHoLoNum = null;
                IHoNum iHoNum2 = null;
                if (n3 > 0) {
                    iHoNum = HoLoFactory.ho2HoNum(n5, n2);
                    object = HoLoFactory.idlVt2LoNum(n5, n4, n3);
                    iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, (ILoNum)object);
                } else {
                    iHoNum2 = HoLoFactory.ho2HoNum(n5, n2);
                }
                iHoNum = null;
                try {
                    iHoNum = inetAddress.getEntityTable().getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    return;
                }
                object = (LinkedList)Network.this.findServerTrailsAtSrc((IEntityModel)iHoNum);
                Iterator iterator = ((AbstractSequentialList)object).iterator();
                while (iterator.hasNext()) {
                    serverTrailLink = (ServerTrailLink)iterator.next();
                    ILabel iLabel = serverTrailLink.getSrcPoolStartLabel();
                    if ((!(iLabel instanceof IHoLoNum) || !iLabel.equals(iHoLoNum)) && (!(iLabel instanceof IHoNum) || !iLabel.equals(iHoNum2))) continue;
                    iNetLink = serverTrailLink;
                    break;
                }
                if (iNetLink == null) {
                    Network.this.db.println("deleteServerTrail: cannot find servertrail link to destroy");
                } else {
                    try {
                        serverTrailLink = iNetLink.getServerTrailId();
                        Network.this.deleteServerTrail((IServerTrailLinkId)serverTrailLink);
                    }
                    catch (ServerTrailException serverTrailException) {
                        if (!Network.this.db.on()) break block13;
                        Network.this.db.println("deleteServerTrail: caught exception, e = \n" + serverTrailException.getMessage());
                    }
                }
            }
        }

        public final void refreshTopo() {
            ThreadPool.instance().enqueueClient((IActionClient)this);
        }

        public void dumpDiag() {
            this.dump();
        }

        public final void ciruitDiscovery(boolean bl) {
            Network.this.setEnableCircuitDiscovery(bl);
        }

        public void doAction() {
            Network.this.refresh();
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }
    }

    public class TopologyCreationNotifier
    extends UObservable {
        protected void changed(Topology topology) {
            if (Network.this.db.on()) {
                Network.this.db.println("changed: notifying observers about new topo " + topology.getTopoId());
            }
            this.setChanged();
            this.notifyObservers(topology);
        }
    }

    public class NetLinkCreationNotifier
    extends UObservable {
        protected void changed(INetLink iNetLink) {
            if (Network.this.db.on()) {
                Network.this.db.println("changed: notifying observers about new link " + iNetLink.prettyString() + "\nchanged: NL = " + iNetLink);
            }
            this.setChanged();
            this.notifyObservers(iNetLink);
        }
    }

    public class NetElementCreationNotifier
    extends UObservable {
        protected void changed(INetElement iNetElement) {
            if (Network.this.db.on()) {
                Network.this.db.println("changed: notifying observers about new NE " + iNetElement.getHostName());
            }
            this.setChanged();
            this.notifyObservers(iNetElement);
        }
    }

    private class NetElemObserver
    implements IObserver {
        boolean deleted = false;

        private NetElemObserver() {
        }

        public synchronized void update(IObservable iObservable, Object object) {
            if (object == ModelUpdateType.DELETED) {
                if (Network.this.db.on()) {
                    Network.this.db.println("NetElemObserver.update: received DELETED event");
                }
                this.deleted = true;
                this.notifyAll();
                if (Network.this.db.on()) {
                    Network.this.db.println("NetElemObserver.update: called notifyAll");
                }
            }
        }

        protected boolean isDeleted() {
            return this.deleted;
        }
    }

    private class NetworkActionClient
    implements IActionClient {
        private boolean disposed = false;

        public void doAction() {
            try {
                if (Network.this.db.on()) {
                    Network.this.db.println("doAction: processing update events");
                }
                while (!Network.this.topologyUpdateQueue.isEmpty()) {
                    Topology topology = (Topology)Network.this.topologyUpdateQueue.remove(0);
                    if (Network.this.db.on()) {
                        Network.this.db.println("doAction: processing event for Topo " + topology.getTopoId());
                    }
                    topology.processUpdateEvents();
                    if (!Network.this.db.on()) continue;
                    Network.this.db.println("doAction: processed event for Topo " + topology.getTopoId());
                }
                NetLinkManager.instance().doAction();
                Network.this.cleanupOrphanedLinks();
                if (Network.this.db.on()) {
                    Network.this.db.println("doAction: processed update event");
                }
            }
            catch (Exception exception) {
                Network.this.db.println("doAction: caught Exception => " + exception.getMessage());
                NetworkDebug cfr_ignored_0 = Network.this.db;
                NetworkDebug.printStackTrace((Throwable)exception);
            }
        }

        public void dispose() {
            if (Network.this.db.on()) {
                Network.this.db.println("dispose: networkActionClient disposed");
            }
            this.disposed = true;
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }
    }

    public class TrailIdComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IServerTrailLinkId iServerTrailLinkId = (IServerTrailLinkId)object;
            IServerTrailLinkId iServerTrailLinkId2 = (IServerTrailLinkId)object2;
            return ((ServerTrailLinkId)iServerTrailLinkId).compareTo(iServerTrailLinkId2);
        }
    }
}

