/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.route.SptLink;
import cerent.cms.route.SptNode;
import cerent.cms.route.xCausesRouteLoop;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class TopologySPTMap
extends TreeMap {
    private TopologyMapDebug db;
    private static SDebug sdb = new SDebug("TopologySPTMap");
    private boolean isTopologyDisjoint;
    private LinkedList disjointLinksList;
    private LinkedList disjointElementsList;
    private LinkedList emptyAdjacencyList;

    public TopologySPTMap(String string) {
        this.db = new TopologyMapDebug(string);
        if (sdb.on()) {
            this.db.set(true);
        }
        this.isTopologyDisjoint = false;
        this.disjointLinksList = new LinkedList();
        this.disjointElementsList = new LinkedList();
        this.emptyAdjacencyList = new LinkedList();
    }

    public Collection getDisjointElements() {
        return (LinkedList)this.disjointElementsList.clone();
    }

    public Collection getDisjointLinks() {
        return (LinkedList)this.disjointLinksList.clone();
    }

    public boolean isTopologyDisjoint() {
        Object object;
        Iterator iterator;
        this.isTopologyDisjoint = false;
        this.disjointLinksList.clear();
        this.disjointElementsList.clear();
        if (this.isEmpty()) {
            if (this.db.on()) {
                this.db.println("isTopologyDisjoint: Topo Map is empty, returning false");
            }
            return false;
        }
        LinkedList<SptNode> linkedList = new LinkedList<SptNode>();
        AdjacencyList adjacencyList = (AdjacencyList)this.get((Integer)this.firstKey());
        if (adjacencyList == null) {
            if (this.db.on()) {
                this.db.println("isTopologyDisjoint: cannot find adjacency list for given NE");
                this.db.println("isTopologyDisjoint: Topo Map size = " + this.size());
                this.db.println("isTopologyDisjoint: disjointElementList count = " + this.disjointElementsList.size());
            }
            this.isTopologyDisjoint = this.disjointElementsList.size() != this.size();
            this.cleanupAdjacencyLists();
            return this.isTopologyDisjoint;
        }
        if (this.db.on()) {
            this.db.println("isTopologyDisjoint: starting with NE " + adjacencyList.getRoot().getNetElement().getHostName());
        }
        linkedList.add(adjacencyList.getRoot());
        while (!linkedList.isEmpty()) {
            iterator = adjacencyList.getSptLinks().iterator();
            if (this.db.on()) {
                this.db.println("isTopologyDisjoint: considering NE " + adjacencyList.getRoot().getNetElement().getHostName());
            }
            while (iterator.hasNext()) {
                object = (SptLink)iterator.next();
                INetLink iNetLink = ((SptLink)object).getLink();
                this.disjointLinksList.add(iNetLink);
                if (iNetLink.isPca()) {
                    if (!this.db.on()) continue;
                    this.db.println("isTopologyDisjoint: ignoring PCA link " + iNetLink.prettyString());
                    continue;
                }
                if (linkedList.contains(((SptLink)object).getDstNode()) || this.disjointElementsList.contains(((SptLink)object).getDstNode().getNetElement())) continue;
                linkedList.add(((SptLink)object).getDstNode());
                if (!this.db.on()) continue;
                this.db.println("isTopologyDisjoint: added NE " + ((SptLink)object).getDstNode().getNetElement().getHostName() + " to candidate list");
                this.db.println("isTopologyDisjoint: candList size = " + linkedList.size());
            }
            linkedList.remove(adjacencyList.getRoot());
            this.disjointElementsList.add(adjacencyList.getRoot().getNetElement());
            if (this.db.on()) {
                this.db.println("isTopologyDisjoint: removed NE " + adjacencyList.getRoot().getNetElement().getHostName() + " from candidate list");
                this.db.println("isTopologyDisjoint: added NE " + adjacencyList.getRoot().getNetElement().getHostName() + " to disjoint Elements list");
            }
            if (!linkedList.isEmpty()) {
                if (this.db.on()) {
                    this.db.println("isTopologyDisjoint: getting next NE from candidate list");
                }
                object = (SptNode)linkedList.getFirst();
                adjacencyList = this.findAdjacencyList(((SptNode)object).getNetElement());
                if (this.db.on()) {
                    this.db.println("isTopologyDisjoint: got NE from candidate list, adjList = " + adjacencyList);
                }
            }
            if (adjacencyList != null) continue;
            break;
        }
        if (this.db.on()) {
            this.db.println("isTopologyDisjoint: Topo Map size = " + this.size());
            this.db.println("isTopologyDisjoint: disjointElementList count = " + this.disjointElementsList.size());
            iterator = this.disjointElementsList.iterator();
            while (iterator.hasNext()) {
                object = (INetElement)iterator.next();
                if (!this.db.on()) continue;
                this.db.println("isTopologyDisjoint: " + object.getHostName());
            }
        }
        this.isTopologyDisjoint = this.disjointElementsList.size() != this.size();
        this.cleanupAdjacencyLists();
        return this.isTopologyDisjoint;
    }

    protected void cleanupAdjacencyLists() {
        Iterator iterator = this.emptyAdjacencyList.iterator();
        while (iterator.hasNext()) {
            AdjacencyList adjacencyList = (AdjacencyList)iterator.next();
            if (this.db.on()) {
                this.db.println("cleanupAdjacencyLists: removing adjList " + adjacencyList.getRoot().getNetElement().getHostName());
            }
            this.removeAdjacencyList(adjacencyList);
            adjacencyList.dispose();
        }
        this.emptyAdjacencyList.clear();
    }

    protected void addNetLink(INetLink iNetLink) {
        if (this.db.on()) {
            this.db.println("addNetLink: attempting to add NL " + iNetLink.prettyString());
        }
        AdjacencyList adjacencyList = this.findAdjacencyList(iNetLink.getSrc());
        AdjacencyList adjacencyList2 = this.findAdjacencyList(iNetLink.getDst());
        if (adjacencyList == null) {
            adjacencyList = new AdjacencyList(iNetLink.getSrc());
            this.addAdjacencyList(adjacencyList);
        }
        if (adjacencyList2 == null) {
            adjacencyList2 = new AdjacencyList(iNetLink.getDst());
            this.addAdjacencyList(adjacencyList2);
        }
        adjacencyList.addNetLink(iNetLink, adjacencyList2.getRoot());
    }

    protected void deleteNetLink(INetLink iNetLink) {
        AdjacencyList adjacencyList = this.getAdjacencyList(iNetLink);
        if (adjacencyList == null) {
            if (this.db.on()) {
                this.db.println("deleteNetLink: Attempt to delete non-existant NL " + iNetLink.prettyString());
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("deleteNetLink: deleting NL " + iNetLink.prettyString());
        }
        adjacencyList.deleteNetLink(iNetLink);
        if (adjacencyList.getSptLinks().isEmpty()) {
            if (this.db.on()) {
                this.db.println("deleteNetLink: removing empty adjacency list for NL " + iNetLink.prettyString());
            }
            this.removeAdjacencyList(adjacencyList);
            adjacencyList.dispose();
        }
    }

    protected void removeNetLink(INetLink iNetLink) {
        AdjacencyList adjacencyList = this.getAdjacencyList(iNetLink);
        if (adjacencyList == null) {
            if (this.db.on()) {
                this.db.println("remove: Attempt to delete non-existant NL " + iNetLink.prettyString());
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("remove: removing NL " + iNetLink.prettyString());
        }
        adjacencyList.deleteNetLink(iNetLink);
        if (adjacencyList.getSptLinks().isEmpty()) {
            if (this.db.on()) {
                this.db.println("remove: adding Adj list for NE " + adjacencyList.getRoot().getNetElement().getHostName() + " to empty Adj list");
            }
            if (!this.emptyAdjacencyList.contains(adjacencyList)) {
                this.emptyAdjacencyList.add(adjacencyList);
            }
        }
    }

    protected void refresh() {
        this.clear();
    }

    protected void dispose() {
        this.clear();
        if (this.db != null) {
            this.db.dispose();
        }
    }

    private synchronized void addAdjacencyList(AdjacencyList adjacencyList) {
        this.put(new Integer(adjacencyList.getRoot().getNetElement().getNodeId()), adjacencyList);
    }

    private synchronized void removeAdjacencyList(AdjacencyList adjacencyList) {
        this.remove(new Integer(adjacencyList.getRoot().getNetElement().getNodeId()));
    }

    private synchronized AdjacencyList getAdjacencyList(INetLink iNetLink) {
        return (AdjacencyList)this.get(new Integer(iNetLink.getSrc().getNodeId()));
    }

    private synchronized AdjacencyList findAdjacencyList(INetElement iNetElement) {
        return (AdjacencyList)this.get(new Integer(iNetElement.getNodeId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getAdjacencyLists() {
        LinkedList linkedList;
        TopologySPTMap topologySPTMap = this;
        synchronized (topologySPTMap) {
            linkedList = new LinkedList(this.values());
        }
        return linkedList;
    }

    protected Collection getElements() {
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        Iterator iterator = this.getAdjacencyLists().iterator();
        while (iterator.hasNext()) {
            AdjacencyList adjacencyList = (AdjacencyList)iterator.next();
            linkedList.add(adjacencyList.getRoot().getNetElement());
        }
        return linkedList;
    }

    protected boolean containsNE(INetElement iNetElement) {
        return this.findAdjacencyList(iNetElement) != null;
    }

    public class TopologyMapDebug
    extends SDebug {
        public TopologyMapDebug(String string) {
            super(string);
        }

        public final void dump() {
            TopologySPTMap.this.db.println("Dumping the Topology Map, NE count = " + TopologySPTMap.this.size());
            Iterator iterator = TopologySPTMap.this.values().iterator();
            while (iterator.hasNext()) {
                AdjacencyList adjacencyList = (AdjacencyList)iterator.next();
                TopologySPTMap.this.db.println(adjacencyList.getRoot().prettyString());
                Iterator iterator2 = adjacencyList.getSptLinks().iterator();
                while (iterator2.hasNext()) {
                    SptLink sptLink = (SptLink)iterator2.next();
                    TopologySPTMap.this.db.println("SPTLink:: " + sptLink.prettyString());
                }
            }
        }
    }

    private class AdjacencyList {
        TreeMap links;
        SptNode root;
        AdjacencyListDebug alDb;

        public AdjacencyList(INetElement iNetElement) {
            block2: {
                this.alDb = new AdjacencyListDebug("AdjacencyList_" + iNetElement.getHostName());
                try {
                    this.root = new SptNode(iNetElement, null);
                }
                catch (xCausesRouteLoop xCausesRouteLoop2) {
                    if (!this.alDb.on()) break block2;
                    this.alDb.println("AdjacencyList: Creating SPT node shouldnever through this error");
                }
            }
            this.links = new TreeMap(new NetLinkComparator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addNetLink(INetLink iNetLink, SptNode sptNode) {
            if (this.alDb.on()) {
                this.alDb.println("addNetLink: adding link ");
            }
            SptLink sptLink = new SptLink(iNetLink, this.root);
            sptLink.setDstNode(sptNode);
            TreeMap treeMap = this.links;
            synchronized (treeMap) {
                this.links.put(iNetLink, sptLink);
            }
        }

        protected synchronized void deleteNetLink(INetLink iNetLink) {
            this.links.remove(iNetLink);
        }

        protected synchronized SptNode getRoot() {
            return this.root;
        }

        protected synchronized Collection getSptLinks() {
            return ((TreeMap)this.links.clone()).values();
        }

        protected void dispose() {
            if (this.alDb.on()) {
                this.alDb.println("dispose: disposing AdjacencyList");
            }
            this.links.clear();
            this.root = null;
            this.alDb.dispose();
        }

        public class AdjacencyListDebug
        extends SDebug {
            public AdjacencyListDebug(String string) {
                super(string);
            }
        }
    }
}

