/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.LambdaLabelSet;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LinkStateMachine;
import cerent.cms.topo.Network;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.topo.VirtualNetLinkStateMachine;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.IObserver;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;

public class VirtualNetLink
extends RoutableNetLink {
    private boolean checking;
    private Network network;
    private long ospfAreaId;
    private LinkStateMachine linkStateMc;
    static /* synthetic */ Class class$cerent$cms$model$ILinkType;

    public VirtualNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n) {
        super(network, iLinkModel, iNetElement, iNetElement2, false, topology, n);
        if (this.db.on()) {
            this.db.println("Creating new VirtualNetLink");
        }
        this.linkStateMc = new VirtualNetLinkStateMachine(network, this, this.db);
        this.network = network;
        this.ospfAreaId = 0L;
        this.startObservingNetLinkCreation();
    }

    public String prettyString() {
        return super.prettyString() + " srcLinkId = " + this.getSrcLinkId() + " dstLinkId = " + this.getDstLinkId();
    }

    public boolean equals(Object object) {
        if (object instanceof VirtualNetLink) {
            VirtualNetLink virtualNetLink = (VirtualNetLink)object;
            return virtualNetLink.getSrc().equals(this.getSrc()) && virtualNetLink.getDst().equals(this.getDst()) && virtualNetLink.getSrcLinkId() == this.getSrcLinkId() && virtualNetLink.getDstEntityIndex() == this.getDstEntityIndex();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.src.hashCode();
        n = 37 * n + this.getSrcLinkId();
        n = 37 * n + this.dst.hashCode();
        n = 37 * n + this.getDstLinkId();
        return n;
    }

    public int getSrcLinkId() {
        return this.linkModel.getSrcLinkId();
    }

    public int getDstLinkId() {
        return this.linkModel.getDstLinkId();
    }

    public int getLinkDir() {
        return this.linkModel.getLinkDir();
    }

    protected void startObservingNetLinkCreation() {
        if (this.db.on()) {
            this.db.println("Start observing NetLinkCreationNotifier");
        }
        this.network.getNetLinkCreationNotifier().addObserver(this);
    }

    protected void stopObservingNetLinkCreation() {
        if (this.db.on()) {
            this.db.println("Stop observing NetLinkCreationNotifier");
        }
        this.network.getNetLinkCreationNotifier().deleteObserver(this);
    }

    protected void notifyAllObservers() {
        if (this.db.on()) {
            this.db.println("link is valid, notify NLM");
        }
        this.stopObservingNetLinkCreation();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected void _update(Object object, Object object2) {
        if (this.db.on()) {
            this.db.println("update: received an update from:" + object + " arg=" + object2);
        }
        INetLink iNetLink = this.network.findReverseLink(this);
        if (object instanceof INodeModel.AbstractConnectionNotifier) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED update event");
                }
                if (this.getSrcSlotNumber() == 0) {
                    this.acquireSrcSlotAndPort();
                }
                if (iNetLink != null) {
                    this.setDstSlotAndPort(iNetLink);
                    this.notifyAllObservers();
                }
            }
        } else {
            this.acquireSrcSlotAndPort();
            if (iNetLink != null) {
                this.setDstSlotAndPort(iNetLink);
                this.notifyAllObservers();
            }
        }
    }

    protected void acquireDstSlotAndPort() {
        INodeModel iNodeModel = this.getDst().getNodeModel();
        if (iNodeModel.isInited()) {
            if (iNodeModel.getConnectionNotifier() != null) {
                if (this.db.on()) {
                    this.db.println("VL acquireDstSlotAndPort: deleting DST NM ConnNotifier observer.");
                }
                iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
            }
            this.setChanged();
        } else {
            if (this.db.on()) {
                this.db.println("VL acquireDstSlotAndPort: DST NE not inited");
            }
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("VL acquireDstSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("VL acquireDstSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    protected void setDstSlotAndPort(INetLink iNetLink) {
        boolean bl;
        INodeModel iNodeModel;
        block14: {
            iNodeModel = iNetLink.getSrc().getNodeModel();
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(iNetLink.getSrcEntityIndex());
                    if (iEntityModel != null) {
                        this.dstSlot = iEntityModel.getSlot();
                        this.dstPort = VirtualNetLink.getPortNum(iEntityModel);
                        if (this.db.on()) {
                            this.db.println("setDstSlotAndPort: slot => " + this.dstSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.dstPort));
                        }
                        if (this.dstSlot != 0 && this.dstPort.length > 0) {
                            if (iNodeModel.getConnectionNotifier() != null) {
                                if (this.db.on()) {
                                    this.db.println("setDstSlotAndPort: deleting DST NM ConnNotifier observer.");
                                }
                                iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                            }
                            this.setChanged();
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = true;
                if (!this.db.on()) break block14;
                this.db.println("setDstSlotAndPort: entity index invalid");
            }
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("setDstSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("setDstSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    public boolean isVirtual() {
        return true;
    }

    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    protected void initializeDebug() {
        this.db = new VirtualNetLinkDebug("NLV" + VirtualNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + VirtualNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose: NL disposed");
        }
        this.src.deleteObserver(this);
        this.dst.deleteObserver(this);
        this.deleted = true;
        this.setChanged();
        if (this.net != null) {
            this.net.delete(this);
        }
        super.dispose();
    }

    public boolean isUsable(RoutePrefs routePrefs) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("isUsable: Link : " + this.prettyString());
        }
        if (this.state() != 1) {
            throw new xLinkNotUsable("Link is Not UP");
        }
        if (!routePrefs.isOchTrailTunnelCircuit() && !routePrefs.isOchTrailCircuit()) {
            throw new xLinkNotUsable(ErrorMsg.getString((EID)NEMC.EID_ERROR_OCH_TRAIL_LINK));
        }
        if (this.availBW(routePrefs)) {
            return true;
        }
        throw new xLinkNotUsable(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_NOWAVEL));
    }

    public boolean availBW(RoutePrefs routePrefs) {
        boolean bl;
        LinkedList linkedList = routePrefs.getRequiredLinks();
        boolean bl2 = bl = this.getSrc().equals(routePrefs.getSrc()) && this.getDst().equals(routePrefs.getDst());
        if (bl || linkedList.contains(this)) {
            return this.isChannelAvailable(routePrefs, routePrefs.getSrc(), routePrefs.getcktSrcEntityIndex(), routePrefs.getDst(), routePrefs.getcktDstEntityIndex(), routePrefs.getcktOptChannel());
        }
        if (this.db.on()) {
            this.db.println("Not in the required list, discarded.");
            this.db.println("List size " + linkedList.size());
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                this.db.println("Required link " + iNetLink.prettyString());
            }
        }
        return false;
    }

    public boolean isChannelAvailable(RoutePrefs routePrefs, INetElement iNetElement, int n, INetElement iNetElement2, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.getSrc().getConnectionState() && this.getDst().getConnectionState()) {
            if (this.getSrc().equals(iNetElement) && this.getDst().equals(iNetElement2)) {
                bl = OchTrailHelper.areTrunkAndClientCoLocated(iNetElement, n, this.getSrcEntityIndex());
                bl = bl && OchTrailHelper.areTrunkAndClientCoLocated(iNetElement2, n2, this.getDstEntityIndex());
                bl2 = true;
            } else if (this.getSrc().equals(iNetElement)) {
                bl = OchTrailHelper.areTrunkAndClientCoLocated(iNetElement, n, this.getSrcEntityIndex());
                if (bl) {
                    bl2 = this.isChannelAvailable(routePrefs, this.getDst(), this.getDstEntityIndex(), n3);
                }
            } else if (this.getSrc().equals(iNetElement2)) {
                bl = OchTrailHelper.areTrunkAndClientCoLocated(iNetElement2, n2, this.getSrcEntityIndex());
                if (bl) {
                    bl2 = this.isChannelAvailable(routePrefs, this.getDst(), this.getDstEntityIndex(), n3);
                }
            } else if (this.getDst().equals(iNetElement2)) {
                bl2 = bl = OchTrailHelper.areTrunkAndClientCoLocated(iNetElement2, n2, this.getDstEntityIndex());
            } else if (this.getSrc().equals(iNetElement2)) {
                bl2 = bl = OchTrailHelper.areTrunkAndClientCoLocated(iNetElement, n, this.getDstEntityIndex());
            } else if (this.db.on()) {
                this.db.println("Virtual link endpoints do not match any of the circuit endpoints.");
            }
        }
        return bl && bl2;
    }

    private boolean isChannelAvailable(RoutePrefs routePrefs, INetElement iNetElement, int n, int n2) {
        boolean bl;
        block5: {
            bl = false;
            try {
                int[] nArray = iNetElement.getNodeModel().getINodeOpticsTopologyModel().getAvailOchncPathEntities(n2, n);
                for (int i = 0; i < nArray.length; ++i) {
                    this.addRequiredLink(routePrefs, iNetElement, nArray[i]);
                }
                bl = true;
            }
            catch (AlreadyInUse alreadyInUse) {
                if (this.db.on()) {
                    this.db.println("The Opt Channel is provisioned but already in use. Mark the Virtual link as in use.");
                }
                bl = false;
            }
            catch (Exception exception) {
                if (!this.db.on()) break block5;
                this.db.println("Exception retrieving the lambda availability" + exception);
            }
        }
        return bl;
    }

    public void addRequiredLink(RoutePrefs routePrefs, INetElement iNetElement, int n) {
        INetLink iNetLink = this.network.findNetLinkFromSource(false, iNetElement, n, null);
        if (iNetLink != null && iNetLink instanceof DwdmNetLink) {
            routePrefs.getRequiredLinks().add(iNetLink);
            if (this.db.on()) {
                this.db.println("Added Link " + iNetLink.prettyString());
            }
        }
    }

    public int getDstEntityIndex() {
        IEntityModel iEntityModel = this.getDestinationEntityModel();
        if (iEntityModel != null) {
            return iEntityModel.getEntityIndex();
        }
        return 0;
    }

    private IEntityModel getDestinationEntityModel() {
        IEntityModel iEntityModel;
        block4: {
            iEntityModel = null;
            int n = 0;
            INetLink iNetLink = this.getReverseLink();
            if (iNetLink != null) {
                n = iNetLink.getSrcEntityIndex();
                try {
                    IEntityModel iEntityModel2;
                    IEntityTableModel iEntityTableModel;
                    INodeModel iNodeModel;
                    INetElement iNetElement = this.getDst();
                    if (iNetElement != null && (iNodeModel = this.getDst().getNodeModel()) != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null && (iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n)) != null) {
                        iEntityModel = iEntityModel2;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (this.db == null || !this.db.on()) break block4;
                    this.db.println("Exception getting entitymodel " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        return iEntityModel;
    }

    public boolean isDstPortRX() {
        IEntityModel iEntityModel = this.getDestinationEntityModel();
        if (iEntityModel != null) {
            if (iEntityModel instanceof IDwdmPortModel || iEntityModel instanceof ITdmPortModel) {
                return true;
            }
            if (iEntityModel.getEntityIndex() % 2 == 0) {
                return true;
            }
        }
        return false;
    }

    public ILabelSet getSrcLabelSet(int n, int n2) {
        return new LambdaLabelSet();
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        return new LambdaLabelSet();
    }

    public boolean isBlsrCapable() {
        return false;
    }

    public int state() {
        return this.newState();
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    protected void oldState(int n) {
        ((LinkModel)this.linkModel).oldState(n);
    }

    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (n != this.oldState()) {
            if (this.db.on()) {
                this.db.println("newState: state changed from " + (this.oldState() == 1 ? "Up" : "Down") + " to " + (n == 1 ? "Up" : "Down"));
            }
            ((LinkModel)this.linkModel).newState(n);
            if (n == 2) {
                this.linkStateMc.driveSm(8);
            } else if (n == 1) {
                this.linkStateMc.driveSm(9);
            }
            if (!this.deleted) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected void setTopology(Topology topology, int n) {
        super.setTopology(topology, n);
        if (topology != null && this.isDeleted()) {
            if (this.db.on()) {
                this.db.println("setTopology: setDeleted(false)");
            }
            this.setDeleted(false);
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public void setChecking(boolean bl) {
        if (this.db.on()) {
            this.db.println("setChecking: checking = " + bl);
        }
        this.checking = bl;
    }

    public boolean inChecking() {
        return this.checking;
    }

    public long getOspfAreaId() {
        return this.ospfAreaId;
    }

    protected void setOspfAreaId(long l) {
        if (this.ospfAreaId != l) {
            this.ospfAreaId = l;
            this.topology.ospfAreaChanged(this);
        }
    }

    public class VirtualNetLinkDebug
    extends SDebug {
        public VirtualNetLinkDebug(String string) {
            super(string);
        }

        public final void dump() {
            VirtualNetLink.this.db.println("======================================");
            VirtualNetLink.this.db.println("Src = " + VirtualNetLink.this.src.getHostName());
            VirtualNetLink.this.db.println("Dst = " + VirtualNetLink.this.dst.getHostName());
            VirtualNetLink.this.db.println("State = " + (VirtualNetLink.this.newState() == 1 ? "Up" : "Down"));
            VirtualNetLink.this.db.println("Topology ID = " + VirtualNetLink.this.topoId);
            VirtualNetLink.this.db.println("src state = " + VirtualNetLink.this.linkStateMc.getCurrentSrcStateAsString());
            VirtualNetLink.this.db.println("dst state = " + VirtualNetLink.this.linkStateMc.getCurrentDstStateAsString());
            VirtualNetLink.this.db.println("NetLink Type = " + VirtualNetLink.this.getLinkTypeObj());
            VirtualNetLink.this.db.println("Protection Type = " + VirtualNetLink.this.getProtectionTypeObj());
            VirtualNetLink.this.db.println("Physical Type = " + VirtualNetLink.this.getPhysicalTypeObj().getDisplayString(VirtualNetLink.this.isSonetCapable()));
            VirtualNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString((Class)(class$cerent$cms$model$ILinkType == null ? (class$cerent$cms$model$ILinkType = VirtualNetLink.class$("cerent.cms.model.ILinkType")) : class$cerent$cms$model$ILinkType), (int)VirtualNetLink.this.getPhysicalLinkType()));
            VirtualNetLink.this.db.println("Src XC Capable = " + VirtualNetLink.this.linkModel.isXcCapable());
            VirtualNetLink.this.db.println("Dst XC Capable = " + VirtualNetLink.this.linkModel.isNbrXcCapable());
            VirtualNetLink.this.db.println("Src Slot = " + VirtualNetLink.this.srcSlot);
            VirtualNetLink.this.db.println("Src Port = " + PortHelper.getConcatenatedString((int[])VirtualNetLink.this.srcPort));
            VirtualNetLink.this.db.println("Src linkId = " + VirtualNetLink.this.linkModel.getSrcLinkId());
            VirtualNetLink.this.db.println("Dst Slot = " + VirtualNetLink.this.dstSlot);
            VirtualNetLink.this.db.println("Dst Port = " + PortHelper.getConcatenatedString((int[])VirtualNetLink.this.dstPort));
            VirtualNetLink.this.db.println("Dst linkId = " + VirtualNetLink.this.linkModel.getDstLinkId());
            VirtualNetLink.this.db.println("Cost = " + VirtualNetLink.this.linkModel.cost());
            VirtualNetLink.this.db.println("Link Dir = " + VirtualNetLink.this.linkModel.getLinkDir());
        }

        public final void dumpLSMState() {
            VirtualNetLink.this.db.println("=============================");
            VirtualNetLink.this.db.println("src state = " + VirtualNetLink.this.linkStateMc.getCurrentSrcStateAsString());
            VirtualNetLink.this.db.println("dst state = " + VirtualNetLink.this.linkStateMc.getCurrentDstStateAsString());
        }

        public final void dumpObservers() {
            VirtualNetLink.this.db.println("======================================");
            VirtualNetLink.this.db.println("VirtualNetLink Observers:");
            VirtualNetLink.this.printObservers();
        }
    }
}

