/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.topo.Network;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.StEndpointPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractStEndpointPanel
extends JPanel
implements ActionListener {
    protected static final SDebug db = new SDebug("StEndpointPanel");
    protected String title;
    protected StEndpointPane parent;
    protected INetCircuitEnd endpoint;
    protected JLabel slotLB;
    protected JLabel portLB;
    protected JComboBox slotCB;
    protected JComboBox portCB;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();
    protected List hoParts = new ArrayList();
    protected List loParts = new ArrayList();
    protected IHoNum hoNum;
    protected ILoNum loNum;
    protected String slot;
    protected SortablePortString port;
    protected INodeModel node;
    protected SortedMap entityMap;
    protected SortedMap portMap;
    protected SortedMap endpointMap;

    public AbstractStEndpointPanel(String string, StEndpointPane stEndpointPane) {
        this.title = string;
        this.parent = stEndpointPane;
        this.setName(string);
        if (db.on()) {
            db.println(string + "<init>");
        }
        if (string != null) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        }
        this.gbl.setConstraints(this, this.gbc);
        this.setLayout(this.gbl);
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(1, 1, 1, 1);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 1;
        this.slotLB = new JLabel("Slot:", 4);
        this.slotCB = this.addCB(this.slotLB, "slotCB", this.gbc);
        this.portLB = new JLabel("Port:", 4);
        this.portCB = this.addCB(this.portLB, "portCB", this.gbc);
        this.addComponents(this.gbc);
        this.reset();
    }

    protected abstract void addComponents(GridBagConstraints var1);

    protected List getHoParts() {
        if (this.hoParts.size() == 0) {
            this.hoParts.add(this.getHoCB());
        }
        return this.hoParts;
    }

    protected static void setComponentsVisible(List list, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((JComponent)iterator.next()).setVisible(bl);
        }
    }

    protected abstract JComboBox getHoCB();

    protected abstract List getLoParts();

    protected abstract void setLoComponents(ILoNum var1);

    protected abstract SortedMap createNewLoMap();

    protected abstract void putInLoMap(SortedMap var1, INetCircuitEnd var2);

    protected abstract boolean inLoMap(SortedMap var1, ILoNum var2);

    protected abstract ILoNum getFirstLoFromLoMap(SortedMap var1, int var2);

    protected void reset() {
        if (db.on()) {
            db.println(this.title + " reset");
        }
        this.endpoint = new NetCircuitEnd();
        this.slot = null;
        this.port = null;
        this.hoNum = null;
        this.resetLoNum();
        this.resetComponents();
    }

    protected void resetLoNum() {
        this.loNum = null;
    }

    protected void resetComponents() {
        this.setCBList(this.slotCB, null);
        this.setCBList(this.portCB, null);
        this.setCBList(this.getHoParts(), null);
        this.setCBList(this.getLoParts(), null);
    }

    protected JComboBox addCB(JLabel jLabel, String string, GridBagConstraints gridBagConstraints) {
        JComboBox jComboBox = new JComboBox();
        jLabel.setPreferredSize(new Dimension(50, 20));
        jComboBox.setName(string);
        jComboBox.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setPreferredSize(new Dimension(300, 22));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel, "West");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        jPanel.add(jComboBox, "Center");
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jComboBox;
    }

    void setNode(INodeModel iNodeModel) {
        this.node = iNodeModel;
        if (this.endpoint.getNodeModel() != iNodeModel) {
            this.endpoint.setNodeModel(iNodeModel);
            this.refresh();
        }
    }

    private String getSlotString(IEntityModel iEntityModel) {
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(this.node).createEntityCellRenderer(iModuleModel);
        return iEntityCellRenderer.getString((Object)iModuleModel, null);
    }

    protected String getStatusText() {
        return CircuitEndCellRenderer.asSlashSeparatedString(this.endpoint);
    }

    public void refresh() {
        if (db.on()) {
            db.println(this.title + " refresh");
        }
        this.debugEndpoint(this.title + " refresh: ");
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.parent.getCircuitInfo().type());
        this.localRefresh(iCircuitType, this.parent.getCircuitInfo().size());
        if (this.endpoint.getNodeModel() != null) {
            this.getDropPorts();
            TreeSet treeSet = new TreeSet(this.entityMap.keySet());
            this.setCBList(this.slotCB, treeSet);
            if (this.slot == null && this.entityMap.keySet().size() == 1) {
                this.slot = (String)this.entityMap.keySet().iterator().next();
            }
            if (this.slot != null) {
                this.slotCB.setSelectedItem(this.slot);
                if (this.port != null) {
                    this.portCB.setSelectedItem(this.port);
                }
            } else {
                this.setCBList(this.portCB, null);
                this.setCBList(this.getHoParts(), null);
                this.setCBList(this.getLoParts(), null);
            }
        } else {
            this.setCBList(this.slotCB, null);
            this.setCBList(this.portCB, null);
            this.setCBList(this.getHoParts(), null);
            this.setCBList(this.getLoParts(), null);
        }
    }

    public void validatePage() throws Exception {
        this.debugEndpoint(this.title + " validatePage: ");
        if (!this.fullySelected()) {
            throw new Exception(this.getName() + " is not fully specified");
        }
        this.endpoint.setLoNum(this.loNum);
        if (db.on()) {
            db.println(this.title + " validatePage: endpoint OK");
        }
    }

    protected boolean fullySelected() {
        if (this.slot == null) {
            return false;
        }
        if (this.slotCB.isEnabled() && this.slotCB.getSelectedIndex() < 0) {
            return false;
        }
        if (this.portCB.isEnabled() && this.portCB.getSelectedIndex() < 0) {
            return false;
        }
        return !this.getHoCB().isEnabled() || this.getHoCB().getSelectedIndex() >= 0;
    }

    protected void setCBList(List list, Collection collection) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JComboBox)) continue;
            this.setCBList((JComboBox)e, collection);
        }
    }

    protected void setCBList(JComboBox jComboBox, Collection collection) {
        jComboBox.removeActionListener(this);
        if (collection != null) {
            Object[] objectArray = collection.toArray();
            if (db.on()) {
                db.println(this.title + " setCBList: " + jComboBox.getName() + " choices: " + ((AbstractCollection)collection).toString());
            }
            jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }
        if (collection == null || collection.isEmpty()) {
            if (db.on()) {
                db.println(this.title + " setCBList: disabling " + jComboBox.getName());
            }
            jComboBox.setEnabled(false);
        } else {
            jComboBox.setEnabled(true);
            jComboBox.addActionListener(this);
        }
        jComboBox.setSelectedItem(null);
    }

    protected IEntityModel getEntityModel() {
        IEntityModel iEntityModel;
        block2: {
            iEntityModel = null;
            try {
                iEntityModel = this.endpoint.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                if (!db.on()) break block2;
                db.println("Can't find the entity model");
            }
        }
        return iEntityModel;
    }

    protected abstract void localRefresh(ICircuitType var1, int var2);

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void getDropPorts() {
        boolean bl = this.slot == "Ethergroup";
        this.slot = null;
        this.port = null;
        IEntityModel iEntityModel = this.getEntityModel();
        int n = iEntityModel != null ? iEntityModel.getEqType() : -1;
        IEntityModel iEntityModel2 = null;
        List list = null;
        list = this.parent.availPorts;
        this.entityMap = new TreeMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TreeMap<SortablePortString, IEntityModel> treeMap;
            SortablePortString sortablePortString;
            IModuleModel iModuleModel;
            IEntityModel iEntityModel3 = (IEntityModel)iterator.next();
            if (iEntityModel3 == null) {
                if (!db.on()) continue;
                db.println(this.title + " getDropPorts: null entity returned from getAvailDropPorts");
                continue;
            }
            if (iEntityModel3.getGenericClass() == 7) {
                iModuleModel = iEntityModel3.getModuleModel();
                sortablePortString = new SortablePortString(iEntityModel3);
            } else if (iEntityModel3.getGenericClass() == 6) {
                iModuleModel = (IModuleModel)iEntityModel3;
                sortablePortString = new SortablePortString();
            } else {
                if (!db.on()) continue;
                db.println(this.title + " getDropPorts: unexpected entity: " + iEntityModel3);
                continue;
            }
            String string = this.getSlotString(iEntityModel3);
            if (iEntityModel3.equals(iEntityModel)) {
                this.slot = string;
                if (iEntityModel3.getGenericClass() == 7) {
                    this.port = new SortablePortString(iEntityModel3);
                }
            } else if (iEntityModel2 == null && iEntityModel3 != null && iEntityModel3.getEqType() == n && iEntityModel3.getIndex() == iEntityModel.getIndex() + 1) {
                iEntityModel2 = iEntityModel3;
            }
            if ((treeMap = (TreeMap<SortablePortString, IEntityModel>)this.entityMap.get(string)) == null) {
                treeMap = new TreeMap<SortablePortString, IEntityModel>();
                this.entityMap.put(string, treeMap);
            }
            if (treeMap.put(sortablePortString, iEntityModel3) == null || !db.on()) continue;
            db.println(this.title + " getDropPorts: multiple entities with " + "slot = " + string + ", port = " + sortablePortString);
        }
        if (this.slot == null && iEntityModel2 != null) {
            this.slot = this.getSlotString(iEntityModel2);
            if (iEntityModel2.getGenericClass() == 7) {
                this.port = new SortablePortString(iEntityModel2);
            }
        }
    }

    protected void setEntity(IEntityModel iEntityModel) throws AnnotatedException {
        db.info(this.title + " setEntity: slot = " + this.slot + ", port = " + this.port);
        if (!iEntityModel.equals(this.getEntityModel())) {
            this.endpoint.setEntityIndex(iEntityModel.getEntityIndex());
            this.endpoint.setHoNum(null);
            this.endpoint.setLoNum(null);
        }
        this.hoNum = null;
        this.resetLoNum();
        this.getDropPoints();
        if (this.endpointMap.size() == 0) {
            this.setCBList(this.getHoCB(), null);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_ENDPOINTS_AVAILABLE);
            return;
        }
        this.setCBList(this.getHoCB(), this.endpointMap.keySet());
        if (this.endpointMap.size() == 1) {
            this.getHoCB().setSelectedItem(this.endpointMap.firstKey());
            this.getHoCB().setEnabled(false);
        } else if (this.hoNum != null) {
            this.getHoCB().setSelectedItem(this.hoNum);
        } else if (this.endpoint.getHoNum() != null) {
            if (db.on()) {
                db.println(this.title + " setEntity: auto-incrementing hoNum");
            }
            if (this.parent != null && this.getCircuitInfo() != null) {
                this.setNextAvailableHo(iEntityModel);
            }
        }
        if (this.hoNum == null) {
            this.setCBList(this.loParts, null);
        } else if (this.loNum != null) {
            this.setLoComponents(this.loNum);
        } else if (this.endpoint.getLoNum() != null && this.endpoint.getLoNum().getCircuitSize() == this.getCircuitInfoSize()) {
            ILoNum iLoNum = this.getNextAvailableLo(this.endpoint.getHoLoNum(), iEntityModel);
            if (db.on()) {
                db.println(this.title + " setEntity: auto-incrementing loNum " + "from " + this.endpoint.getHoLoNum().prettyString("-") + " to " + iLoNum.prettyString());
            }
            this.setLoComponents(iLoNum);
        }
    }

    protected void clearEntity(final AnnotatedException annotatedException, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AbstractStEndpointPanel.this.port != null || bl && AbstractStEndpointPanel.this.slot != null) {
                    if (bl) {
                        AbstractStEndpointPanel.this.slot = null;
                        if (db.on()) {
                            db.println(AbstractStEndpointPanel.this.title + " Runnable: clearing slotCB");
                        }
                        AbstractStEndpointPanel.this.slotCB.setSelectedItem(null);
                        if (db.on()) {
                            db.println(AbstractStEndpointPanel.this.title + " Runnable: emptying portCB");
                        }
                        AbstractStEndpointPanel.this.setCBList(AbstractStEndpointPanel.this.portCB, null);
                    }
                    AbstractStEndpointPanel.this.port = null;
                    if (db.on()) {
                        db.println(AbstractStEndpointPanel.this.title + " Runnable: clearing portCB");
                    }
                    AbstractStEndpointPanel.this.portCB.setSelectedItem(null);
                    SDebug.printStackTrace((Throwable)annotatedException);
                    ErrorMsg.displayError((Component)AbstractStEndpointPanel.this, (EID)NEMC.EID_ENDPOINT_SELECTION_ERROR);
                    AbstractStEndpointPanel.this.repaint();
                }
            }
        });
    }

    protected void getDropPoints() throws AnnotatedException {
        List list;
        try {
            list = Network.instance().getAvailServerTrailPoints(this.endpoint.getNodeModel(), this.endpoint.getEntityModel(), this.parent.getServerTrailPrefs());
        }
        catch (Exception exception) {
            throw new AnnotatedException("Failure getting list of available drop points from " + this.endpoint.getNodeModel().getName(), exception);
        }
        this.endpointMap = new TreeMap();
        if (this.isNull(list, "availDropPoints")) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            IEntityModel iEntityModel;
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)iterator.next();
            if (iNetCircuitEnd == null) {
                if (!db.on()) continue;
                db.println(this.title + " getDropPoints: null entity returned from getAvailDropPorts");
                continue;
            }
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                iEntityModel = null;
            }
            IHoNum iHoNum = CircuitEndCellRenderer.convertToExternalHoNumber(iEntityModel, iNetCircuitEnd.getHoNum());
            if (HoLoComparator.instance().isEqual(iNetCircuitEnd.getHoNum(), this.endpoint.getHoNum())) {
                if (this.hoNum == null) {
                    this.hoNum = iHoNum;
                }
                if (HoLoComparator.instance().isEqual(iNetCircuitEnd.getLoNum(), this.endpoint.getLoNum()) && iNetCircuitEnd.getLoNum() != null) {
                    this.loNum = iNetCircuitEnd.getLoNum();
                }
            }
            if (iNetCircuitEnd.getLoNum() == null) {
                INetCircuitEnd iNetCircuitEnd2 = this.endpointMap.put(iHoNum, iNetCircuitEnd);
                continue;
            }
            SortedMap sortedMap = (SortedMap)this.endpointMap.get(iHoNum);
            boolean bl2 = bl = sortedMap == null;
            if (bl) {
                sortedMap = this.createNewLoMap();
                this.endpointMap.put(iHoNum, sortedMap);
            }
            try {
                this.putInLoMap(sortedMap, iNetCircuitEnd);
            }
            catch (Exception exception) {
                db.println(exception.getMessage());
            }
        }
    }

    protected Object getValidSelectedItem(JComboBox jComboBox, Object object) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
        if (defaultComboBoxModel.getIndexOf(object) < 0) {
            jComboBox.setSelectedIndex(0);
            return defaultComboBoxModel.getElementAt(0);
        }
        return object;
    }

    private void setNextAvailableHo(IEntityModel iEntityModel) {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfoType());
        int n = this.endpoint.getNodeModel().getFramingType();
        int n2 = iCircuitType.isLoCircuitType() ? CircuitSize.getLoTunnelSize((int)n).getEnum() : this.getCircuitInfoSize();
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        IHoNum iHoNum = CircuitEndCellRenderer.convertFromExternalHoNumber(iEntityModel, this.endpoint.getHoNum());
        int n3 = iCircuitSize.getFramingTypeHoPathWidth(n);
        IHoNum iHoNum2 = this.getNextAvailableHo(iHoNum, n3);
        this.getHoCB().setSelectedItem(iHoNum2);
    }

    private IHoNum getNextAvailableHo(IHoNum iHoNum, int n) {
        IHoNum iHoNum2 = iHoNum;
        while (true) {
            IHoNum iHoNum3;
            try {
                iHoNum3 = HoLoFactory.addOffset(iHoNum2, n);
            }
            catch (ArithmeticException arithmeticException) {
                break;
            }
            if (this.endpointMap.keySet().contains(iHoNum3)) {
                return iHoNum3;
            }
            iHoNum2 = iHoNum3;
        }
        return (IHoNum)this.endpointMap.firstKey();
    }

    private ILoNum getNextAvailableLo(IHoLoNum iHoLoNum, IEntityModel iEntityModel) {
        IHoNum iHoNum = iHoLoNum.getHoNum();
        ILoNum iLoNum = iHoLoNum.getLoNum();
        SortedMap sortedMap = (SortedMap)this.endpointMap.get(iHoNum);
        for (int i = 1; i < 10; ++i) {
            IHoLoNum iHoLoNum2;
            try {
                iHoLoNum2 = this.getNextHoLoNum(iHoLoNum, iEntityModel);
            }
            catch (ArithmeticException arithmeticException) {
                break;
            }
            if (!iHoLoNum2.getHoNum().equals(iHoNum)) break;
            if (this.inLoMap(sortedMap, iHoLoNum2.getLoNum())) {
                return iHoLoNum2.getLoNum();
            }
            iHoLoNum = iHoLoNum2;
        }
        return this.getFirstLoFromLoMap(sortedMap, iLoNum.getCircuitSize());
    }

    protected IHoLoNum getNextHoLoNum(IHoLoNum iHoLoNum, IEntityModel iEntityModel) {
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
        return HoLoFactory.addOffset(iHoLoNum2, 1);
    }

    protected CircuitCreatInfo getCircuitInfo() {
        return this.parent.getCircuitInfo();
    }

    protected int getCircuitInfoSize() {
        return this.getCircuitInfo().size();
    }

    protected int getCircuitInfoType() {
        return this.getCircuitInfo().type();
    }

    protected boolean isNull(Object object, String string) {
        if (object == null) {
            if (db.on()) {
                db.println(this.title + " " + string + " is null");
            }
            return true;
        }
        return false;
    }

    protected void debugEndpoint(String string) {
        if (db.on()) {
            db.println(string + "endpoint.node = " + this.endpoint.getNodeModel());
            db.println(string + "endpoint.entity = " + this.getEntityModel());
            db.println(string + "slot = " + this.slot);
            db.println(string + "port = " + this.port);
            db.println(string + "endpoint.hoNum = " + this.endpoint.getHoNum());
        }
    }
}

