/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.NetworkModel;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.PrefsNodesPropertyPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import com.cisco.ctc.CtcApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddNodeDialog
extends UDialog
implements ActionListener {
    private static final SDebug db = new SDebug("AddNodeDialog");
    private JTextField nodeTF;
    private JCheckBox addToLoginCB;
    private JLabel label;
    private JButton okButton;
    private JButton cancelButton;
    private Preferences prefs = Preferences.instance();
    private static final String DIALOG_TITLE = "Add Node";
    private static final String PATH = "ctc.nodes";
    private static final String ADD_NODE_PATH = "ctc.addNode";
    private static final String ADD_TO_LOGIN = "addToLogin";

    public static AddNodeDialog instance(Frame frame) {
        return new AddNodeDialog(frame, DIALOG_TITLE);
    }

    private AddNodeDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.label = new JLabel("Enter node name: ");
        this.nodeTF = new JTextField(20);
        jPanel2.add(this.label);
        jPanel2.add(this.nodeTF);
        jPanel.add((Component)jPanel2, "North");
        this.addToLoginCB = new JCheckBox("Add to current login node group");
        String string = CtcApplication.instance().getAdditionalNodeGroup();
        this.addToLoginCB.setEnabled(!"(None)".equals(string) && PrefsNodesPropertyPane.getGroupNames().contains(string));
        if (this.addToLoginCB.isEnabled()) {
            this.addToLoginCB.setSelected(Preferences.instance().getBoolean(ADD_NODE_PATH, ADD_TO_LOGIN, false));
        }
        jPanel.add((Component)this.addToLoginCB, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.okButton = new JButton("OK");
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(this);
        jPanel3.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        jPanel3.add(this.cancelButton);
        jPanel.add((Component)jPanel3, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            Object object = actionEvent.getSource();
            if (object == this.okButton) {
                if (this.getNodeName().equals("")) {
                    ErrorMsg.displayError(null, (EID)NEMC.EID_NODE_NAME_CANNOT_BE_EMPTY);
                    return;
                }
                String string = null;
                try {
                    string = InetAddress.getByName(this.getNodeName()).getHostAddress().trim();
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorMsg.displayError(null, (EID)NEMC.EID_ERROR_ADDING_UNKNOWN_HOST_PARAM_1, (Object)this.getNodeName());
                    return;
                }
                if (db.on()) {
                    db.println("Looking for node to match " + string);
                }
                Collection collection = Network.instance().getElements();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    NetElement netElement = (NetElement)iterator.next();
                    if (db.on()) {
                        db.println("   found " + netElement.getHostName());
                    }
                    boolean bl = false;
                    if (netElement.getHostName().equals(string)) {
                        bl = true;
                    } else if (this.checkIfMatchesSecureIP(netElement, string)) {
                        bl = true;
                    }
                    if (!bl) continue;
                    ErrorMsg.displayError(null, (EID)NEMC.EID_NODE_ALREADY_IN_THE_NETWORK_PARAM_1, (Object)this.getNodeName());
                    return;
                }
                try {
                    NetworkModel.instance().addNetElement(string, null, null);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                if (this.addToLoginCB.isSelected() && !this.storeNodeToGroup()) {
                    return;
                }
                if (this.addToLoginCB.isEnabled()) {
                    this.prefs.setBoolean(ADD_NODE_PATH, ADD_TO_LOGIN, this.addToLoginCB.isSelected());
                }
                this.dispose();
            } else if (object == this.cancelButton) {
                this.dispose();
            }
        }
    }

    private boolean checkIfMatchesSecureIP(NetElement netElement, String string) {
        ISecureIpConfig iSecureIpConfig;
        INodeModel iNodeModel = netElement.getNodeModel();
        if (iNodeModel != null && iNodeModel.isInited() && iNodeModel.provides(Feature.TCC2P_SECURITY_MODE) && (iSecureIpConfig = iNodeModel.getSecureIpConfig()).isSecureMode()) {
            IIpAddr iIpAddr = iSecureIpConfig.getIpAddress();
            String string2 = InetUtil.makeDottedString(iIpAddr);
            if (db.on()) {
                db.println("Secure: " + string2 + "Name: " + string);
            }
            if (string2.equals(string)) {
                return true;
            }
        }
        return false;
    }

    public String getNodeName() {
        return this.nodeTF.getText().trim();
    }

    private boolean storeNodeToGroup() {
        String string;
        String string2 = null;
        int n = 0;
        while ((string = this.prefs.getProperty(PATH, string2 = Integer.toString(n), null)) != null) {
            if (string.equals(CtcApplication.instance().getAdditionalNodeGroup())) {
                String[] stringArray = PrefsNodesPropertyPane.getGroupMembers(string);
                String[] stringArray2 = new String[stringArray.length + 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(this.getNodeName())) {
                        ErrorMsg.displayError(null, (EID)NEMC.EID_NODE_ALREADY_IN_LOGIN_GRP);
                        return false;
                    }
                    stringArray2[i] = stringArray[i];
                }
                stringArray2[stringArray2.length - 1] = this.getNodeName();
                this.prefs.setPropertyArray(PATH, string2 + ".members", stringArray2);
                break;
            }
            ++n;
        }
        return true;
    }
}

