/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AddNode2OnePlusOneModel;
import cerent.cms.model.ElementModels;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AddNode2OnePlusOneDialog;
import cerent.cms.ui.WizardPane;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AndPortPane
extends WizardPane
implements ActionListener {
    private AddNode2OnePlusOneDialog parent;
    private JComboBox work1PortCB;
    private JComboBox protect1PortCB;
    private JComboBox work2PortCB;
    private JComboBox protect2PortCB;
    List portsList = new ArrayList();
    private IEntityModel lastSelectedWorkModel1 = null;
    private IEntityModel lastSelectedWorkModel2 = null;

    public AndPortPane(String string, AddNode2OnePlusOneDialog addNode2OnePlusOneDialog) {
        super(string, addNode2OnePlusOneDialog);
        this.parent = addNode2OnePlusOneDialog;
        this.work1PortCB = new JComboBox();
        this.protect1PortCB = new JComboBox();
        this.work2PortCB = new JComboBox();
        this.protect2PortCB = new JComboBox();
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createPanel(addNode2OnePlusOneDialog.getSrcNodeName()), 0, 1);
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createPanel(addNode2OnePlusOneDialog.getDstNodeName()), 1, 1);
        this.setLayout(new BorderLayout());
        this.add(gridBagPanel, "Center");
    }

    private JPanel createPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getSubPanel(string), "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("To Node " + string));
        return jPanel;
    }

    private JPanel getSubPanel(String string) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        JLabel jLabel = new JLabel("Working Port: ", 4);
        this.addCB(jPanel, jLabel, gridBagConstraints, true, string);
        JLabel jLabel2 = new JLabel("Protect Port: ", 4);
        this.addCB(jPanel, jLabel2, gridBagConstraints, false, string);
        return jPanel;
    }

    private void addCB(JPanel jPanel, JLabel jLabel, GridBagConstraints gridBagConstraints, boolean bl, String string) {
        JComboBox jComboBox = null;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        jComboBox = bl ? (string.compareTo(this.parent.getSrcNodeName()) == 0 ? this.work1PortCB : this.work2PortCB) : (string.compareTo(this.parent.getSrcNodeName()) == 0 ? this.protect1PortCB : this.protect2PortCB);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        JComboBox jComboBox = null;
        JComboBox jComboBox2 = null;
        IEntityModel iEntityModel = null;
        if (object == this.work1PortCB) {
            jComboBox = this.work1PortCB;
            jComboBox2 = this.protect1PortCB;
            iEntityModel = this.lastSelectedWorkModel1;
        } else if (object == this.work2PortCB) {
            jComboBox = this.work2PortCB;
            jComboBox2 = this.protect2PortCB;
            iEntityModel = this.lastSelectedWorkModel2;
        }
        if (jComboBox != null && jComboBox.getSelectedItem() != null && jComboBox.getSelectedItem() != iEntityModel) {
            jComboBox2.setSelectedItem(null);
            try {
                IElementModel iElementModel = this.parent.newNetElement.getNodeModel().getIElementModels().getIElementModel((IEntityModel)jComboBox.getSelectedItem());
                Set set = this.parent.newNetElement.getNodeModel().getIElementModels().getOnePlusOneCompatibleEntities(iElementModel);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ITdmPortModel iTdmPortModel = (ITdmPortModel)iterator.next();
                    if (!iTdmPortModel.isSonetDccTermination()) continue;
                    iterator.remove();
                }
                ITdmPortModel[] iTdmPortModelArray = set.toArray(new ITdmPortModel[0]);
                Arrays.sort(iTdmPortModelArray, new PortComparator());
                this.setCBList(jComboBox2, iTdmPortModelArray);
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            if (object == this.work1PortCB) {
                this.lastSelectedWorkModel1 = (IEntityModel)jComboBox.getSelectedItem();
            } else {
                this.lastSelectedWorkModel2 = (IEntityModel)jComboBox.getSelectedItem();
            }
        }
    }

    public void refresh() {
        this.parent.setNextEnabled(true);
        this.parent.setBackEnabled(true);
        this.parent.setCancelEnabled(true);
    }

    protected void setCBList(JComboBox jComboBox, ITdmPortModel[] iTdmPortModelArray) {
        DefaultComboBoxModel<ITdmPortModel> defaultComboBoxModel = new DefaultComboBoxModel<ITdmPortModel>(iTdmPortModelArray);
        jComboBox.removeActionListener(this);
        if (iTdmPortModelArray != null) {
            jComboBox.setModel(defaultComboBoxModel);
        }
        if (iTdmPortModelArray == null) {
            jComboBox.setEnabled(false);
        } else {
            jComboBox.setEnabled(true);
            jComboBox.addActionListener(this);
        }
        jComboBox.setSelectedItem(null);
    }

    public void validatePage() throws Exception {
        if (AndPortPane.db.on) {
            db.println("validatePage() called");
        }
        if (this.parent.isNodeUnreachable()) {
            return;
        }
        if (this.work1PortCB.getSelectedItem() == null || this.protect1PortCB.getSelectedItem() == null || this.work2PortCB.getSelectedItem() == null || this.protect2PortCB.getSelectedItem() == null) {
            throw new Exception("All the working/protect ports must be selected on the node");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = this.work1PortCB.getSelectedItem();
        Object object2 = this.protect1PortCB.getSelectedItem();
        Object object3 = this.work2PortCB.getSelectedItem();
        Object object4 = this.protect2PortCB.getSelectedItem();
        arrayList.add(object);
        arrayList.add(object2);
        arrayList.add(object3);
        arrayList.add(object4);
        if (arrayList.indexOf(object) != arrayList.lastIndexOf(object) || arrayList.indexOf(object2) != arrayList.lastIndexOf(object2) || arrayList.indexOf(object3) != arrayList.lastIndexOf(object3) || arrayList.indexOf(object4) != arrayList.lastIndexOf(object4)) {
            throw new Exception("No port can be selected twice");
        }
        IOnePlusOneModel iOnePlusOneModel = (IOnePlusOneModel)this.parent.linkModel.getEndElementModel(true);
        IRevertiveBehavior iRevertiveBehavior = iOnePlusOneModel.getReversion();
        AddNode2OnePlusOneModel addNode2OnePlusOneModel = AddNode2OnePlusOneModel.instance();
        addNode2OnePlusOneModel.createDccAndOnePlusOne(this.parent.newNetElement.getNodeModel(), this.parent.isLdccLink, (IEntityModel)object, (IEntityModel)object2, ElementModels.truncateString(this.parent.entityCellRenderer.getString(object2, "slot ")), (IEntityModel)object3, (IEntityModel)object4, ElementModels.truncateString(this.parent.entityCellRenderer.getString(object4, "slot ")), iRevertiveBehavior);
        Set set = this.parent.newNetElement.getNodeModel().getIElementModels().getOnePlusOneElements();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            iOnePlusOneModel = (IOnePlusOneModel)iterator.next();
            if (iOnePlusOneModel.getWorkingEntityIndex() == ((IEntityModel)object).getEntityIndex()) {
                this.parent.addOpo1 = iOnePlusOneModel;
            }
            if (iOnePlusOneModel.getWorkingEntityIndex() != ((IEntityModel)object3).getEntityIndex()) continue;
            this.parent.addOpo2 = iOnePlusOneModel;
        }
        ((IPortModel)object).maybeSetAdminState(0, 1, 0);
        ((IPortModel)object2).maybeSetAdminState(0, 1, 0);
        ((IPortModel)object3).maybeSetAdminState(0, 1, 0);
        ((IPortModel)object4).maybeSetAdminState(0, 1, 0);
        this.parent.workModel1 = (IEntityModel)object;
        this.parent.protectModel1 = (IEntityModel)object2;
        this.parent.workModel2 = (IEntityModel)object3;
        this.parent.protectModel2 = (IEntityModel)object4;
        this.parent.addRefiberProtectPane();
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (AndPortPane.db.on) {
            db.println("getStatusText() called");
        }
        if (this.parent.isNodeUnreachable()) {
            return "";
        }
        stringBuffer.append("-Working port to " + this.parent.getSrcNodeName() + ": s" + this.parent.workModel1.getSlot() + "/p" + this.parent.workModel1.getPort() + "\n");
        stringBuffer.append("-Protect port to " + this.parent.getSrcNodeName() + ": s" + this.parent.protectModel1.getSlot() + "/p" + this.parent.protectModel1.getPort() + "\n");
        stringBuffer.append("-Working port to " + this.parent.getDstNodeName() + ": s" + this.parent.workModel2.getSlot() + "/p" + this.parent.workModel2.getPort() + "\n");
        stringBuffer.append("-Protect port to " + this.parent.getDstNodeName() + ": s" + this.parent.protectModel2.getSlot() + "/p" + this.parent.protectModel2.getPort() + "\n");
        return stringBuffer.toString();
    }

    public void enteringPage() {
        if (AndPortPane.db.on) {
            db.println("enteringPage() called");
        }
        this.portsList.clear();
        this.work1PortCB.setRenderer(this.parent.entityCellRenderer);
        this.protect1PortCB.setRenderer(this.parent.entityCellRenderer);
        this.work2PortCB.setRenderer(this.parent.entityCellRenderer);
        this.protect2PortCB.setRenderer(this.parent.entityCellRenderer);
        AddNode2OnePlusOneModel addNode2OnePlusOneModel = AddNode2OnePlusOneModel.instance();
        this.portsList = addNode2OnePlusOneModel.getAvailablePortsForUpgrade(this.parent.newNetElement.getNodeModel(), this.parent.netLink.getLinkModel());
        if (this.work1PortCB.getItemCount() == 0) {
            this.setCBList(this.work1PortCB, this.portsList.toArray(new ITdmPortModel[0]));
            this.setCBList(this.protect1PortCB, this.portsList.toArray(new ITdmPortModel[0]));
            this.setCBList(this.work2PortCB, this.portsList.toArray(new ITdmPortModel[0]));
            this.setCBList(this.protect2PortCB, this.portsList.toArray(new ITdmPortModel[0]));
        }
        Dimension dimension = this.parent.getSize();
        this.parent.setSize(new Dimension(dimension.width, 340));
        this.revalidate();
        this.parent.invalidate();
        this.parent.validate();
        this.parent.repaint();
    }

    public void dispose() {
        if (AndPortPane.db.on) {
            db.println("dispose() called");
        }
        super.dispose();
    }

    private class PortComparator
    implements Comparator {
        private PortComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof IPortModel && object2 instanceof IPortModel) {
                IPortModel iPortModel = (IPortModel)object;
                IPortModel iPortModel2 = (IPortModel)object2;
                if (iPortModel.getSlot() == iPortModel2.getSlot()) {
                    try {
                        int n;
                        int[] nArray = iPortModel.getPortNum();
                        Integer[] integerArray = new Integer[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            integerArray[i] = new Integer(nArray[i]);
                        }
                        int[] nArray2 = iPortModel2.getPortNum();
                        Integer[] integerArray2 = new Integer[nArray2.length];
                        for (n = 0; n < nArray2.length; ++n) {
                            integerArray2[n] = new Integer(nArray2[n]);
                        }
                        n = integerArray.length < integerArray2.length ? integerArray.length : integerArray2.length;
                        for (int i = 0; i < n; ++i) {
                            if (integerArray[i].compareTo(integerArray2[i]) == 0) continue;
                            return integerArray[i].compareTo(integerArray2[i]);
                        }
                        return integerArray.length < integerArray2.length ? -1 : (integerArray.length == integerArray2.length ? 0 : 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (AbstractPane.db.on) {
                            SDebug.printStackTrace((Throwable)numberFormatException);
                        }
                        return -1;
                    }
                }
                if (iPortModel.getSlot() > iPortModel2.getSlot()) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            return object instanceof IPortModel;
        }
    }
}

