/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.HandlerUtils;
import cerent.cms.ui.UiToolkit;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.ExportTableDialog;
import java.awt.Component;
import javax.swing.JTable;

public class ExportHandler {
    private AbstractViewController avc = null;
    private static final UiToolkit uiToolkit = UiToolkit.instance();
    private static final SDebug db = new SDebug("ExportHandler");

    public ExportHandler(AbstractViewController abstractViewController) {
        if (db.on()) {
            db.println("<init>");
        }
        this.avc = abstractViewController;
    }

    public void export() {
        String string = null;
        JTable jTable = HandlerUtils.getDisplayedTable(this.avc);
        if (jTable == null) {
            db.fine("No table available... trying report");
            string = HandlerUtils.getDisplayedHtmlReport(this.avc);
            if (string == null) {
                ErrorMsg.displayWarning(null, (EID)NEMC.WID_NOTHING_EXPORTABLE_ON_THIS_VIEW);
                return;
            }
        }
        db.fine("Table or report available for export...");
        ExportTableDialog exportTableDialog = jTable == null ? new ExportTableDialog(null, "Export", true, true, false, false) : new ExportTableDialog(null, "Export", true);
        exportTableDialog.pack();
        exportTableDialog.setLocationRelativeTo((Component)uiToolkit.getApplicationFrame());
        int n = exportTableDialog.showDialog();
        if (n == 0) {
            int n2 = exportTableDialog.getExportTypeSelection();
            try {
                this.avc.exportView(n2);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error exporting: " + exception.getMessage());
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

