/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractPrefsPropertyPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.network.MapPersist;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.BooleanPropertyEditor;
import cerent.util.gui.CoordinatePropertyEditor;
import cerent.util.gui.FilePropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class PrefsMapPropertyPane
extends AbstractPrefsPropertyPane {
    private static final String PREFS_MAP_LEFT_LONG = "map.longitude.left";
    private static final String PREFS_MAP_RIGHT_LONG = "map.longitude.right";
    private static final String PREFS_MAP_TOP_LAT = "map.latitude.top";
    private static final String PREFS_MAP_BOTTOM_LAT = "map.latitude.bottom";
    private static final String PREFS_MAP_FILE = "map.file";
    private static final String PREFS_MAP_USE_DEFAULT = "map.usedefault";
    private BooleanPropertyEditor useDfltMapEdit;
    private BooleanPropertyEditor domainGlobalModeEdit;
    private FilePropertyEditor userMapEdit;
    private CoordinatePropertyEditor bottomLatEdit;
    private CoordinatePropertyEditor leftLongEdit;
    private CoordinatePropertyEditor rightLongEdit;
    private CoordinatePropertyEditor topLatEdit;
    private String cLLong;
    private String cRLong;
    private String cTLat;
    private String cBLat;
    private AbstractPropertySheet parentSheet;

    public PrefsMapPropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet, preferences);
        this.parentSheet = abstractPropertySheet;
        try {
            this.initialize();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void store() {
        this.store("ctc", PREFS_MAP_FILE, this.userMapEdit);
        this.store("ctc", PREFS_MAP_USE_DEFAULT, this.useDfltMapEdit);
        this.store("ctc", PREFS_MAP_LEFT_LONG, this.leftLongEdit);
        this.store("ctc", PREFS_MAP_RIGHT_LONG, this.rightLongEdit);
        this.store("ctc", PREFS_MAP_TOP_LAT, this.topLatEdit);
        this.store("ctc", PREFS_MAP_BOTTOM_LAT, this.bottomLatEdit);
        boolean bl = this.domainGlobalModeEdit.getBooleanValue();
        this.domainGlobalModeEdit.setValue(!bl);
        this.store(MapPersist.dpmPrefix, MapPersist.dpmSuffix, this.domainGlobalModeEdit);
        this.domainGlobalModeEdit.setValue(bl);
        this.cLLong = (String)this.leftLongEdit.getValue();
        this.cRLong = (String)this.rightLongEdit.getValue();
        this.cTLat = (String)this.topLatEdit.getValue();
        this.cBLat = (String)this.bottomLatEdit.getValue();
    }

    public void load() {
        this.load("ctc", PREFS_MAP_FILE, this.userMapEdit);
        this.load("ctc", PREFS_MAP_USE_DEFAULT, this.useDfltMapEdit);
        this.load("ctc", PREFS_MAP_LEFT_LONG, this.leftLongEdit);
        this.load("ctc", PREFS_MAP_RIGHT_LONG, this.rightLongEdit);
        this.load("ctc", PREFS_MAP_TOP_LAT, this.topLatEdit);
        this.load("ctc", PREFS_MAP_BOTTOM_LAT, this.bottomLatEdit);
        this.load(MapPersist.dpmPrefix, MapPersist.dpmSuffix, this.domainGlobalModeEdit);
        this.domainGlobalModeEdit.setValue(!this.domainGlobalModeEdit.getBooleanValue());
        String string = null;
        string = (String)this.leftLongEdit.getValue();
        this.cLLong = string == null || string.length() == 0 ? "-126.0" : string;
        string = (String)this.rightLongEdit.getValue();
        this.cRLong = string == null || string.length() == 0 ? "-65.0" : string;
        string = (String)this.topLatEdit.getValue();
        this.cTLat = string == null || string.length() == 0 ? "52.0" : string;
        string = (String)this.bottomLatEdit.getValue();
        this.cBLat = string == null || string.length() == 0 ? "22.0" : string;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        Object object = propertyChangeEvent.getSource();
        if (object == this.useDfltMapEdit) {
            if (this.useDfltMapEdit.getValue().equals("0")) {
                this.toggleMapButtons(true);
            } else {
                this.toggleMapButtons(false);
            }
        }
    }

    private void toggleMapButtons(boolean bl) {
        this.userMapEdit.setEnabled(bl);
    }

    private JPanel makeWestAlignPane(AbstractPropertyEditor abstractPropertyEditor) {
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.add(abstractPropertyEditor);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel makeMapPane() {
        JPanel jPanel = AbstractPane.createVerticalPanel("Network Map Settings");
        jPanel.add(this.makeWestAlignPane(this.useDfltMapEdit));
        jPanel.add(this.makeWestAlignPane(this.userMapEdit));
        jPanel.add(this.makeCoordinatesPane());
        return jPanel;
    }

    private JPanel makeDomainPane() {
        JPanel jPanel = AbstractPane.createVerticalPanel("Domain Settings");
        jPanel.add(this.makeWestAlignPane(this.domainGlobalModeEdit));
        return jPanel;
    }

    private JPanel makeCoordinatesPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)new JLabel("Left Longitude:"), gridBagConstraints);
        jPanel.add((Component)this.leftLongEdit, gridBagConstraints);
        jPanel.add((Component)new JLabel("Top Latitude:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.topLatEdit, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Right Longitude:"), gridBagConstraints);
        jPanel.add((Component)this.rightLongEdit, gridBagConstraints);
        jPanel.add((Component)new JLabel("  Bottom Latitude:"), gridBagConstraints);
        jPanel.add((Component)this.bottomLatEdit, gridBagConstraints);
        return jPanel;
    }

    private void initialize() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
        this.useDfltMapEdit = new BooleanPropertyEditor("Use Default Map");
        this.domainGlobalModeEdit = new BooleanPropertyEditor("Persist Domain Membership Globally (effective when CTC is restarted)");
        this.userMapEdit = new FilePropertyEditor("Image Name:");
        this.leftLongEdit = new CoordinatePropertyEditor("", CoordinatePropertyEditor.LONGITUDE);
        this.rightLongEdit = new CoordinatePropertyEditor("", CoordinatePropertyEditor.LONGITUDE);
        this.topLatEdit = new CoordinatePropertyEditor("", CoordinatePropertyEditor.LATITUDE);
        this.bottomLatEdit = new CoordinatePropertyEditor("", CoordinatePropertyEditor.LATITUDE);
        this.userMapEdit.setEditorSize(25);
        FileFilter fileFilter = this.userMapEdit.getAcceptAllFileFilter();
        this.userMapEdit.removeChoosableFileFilter(fileFilter);
        this.userMapEdit.setFilter("JPEG files (*.jpg)", "jpg");
        this.userMapEdit.setFilter("Gif files (*.gif)", "gif");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel.add((Component)this.makeMapPane(), gridBagConstraints);
        jPanel.add((Component)this.makeDomainPane(), gridBagConstraints);
        this.load();
        this.notifyAllPropertyEditors(this);
        if (this.useDfltMapEdit.getValue().equals("0")) {
            this.toggleMapButtons(true);
        } else {
            this.toggleMapButtons(false);
        }
        this.parentSheet.resetApply();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsMapPropertyPane;
    }
}

