/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.PrefsStringArrayPropertyPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.AbstractPropertyPane;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.proxy.CtcProxyFactory;
import java.awt.BorderLayout;
import java.awt.Container;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class PrefsSocksPropertyPane
extends AbstractPropertyPane {
    private PrefsStringArrayPropertyPane pp;

    public PrefsSocksPropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet);
        this.setLayout(new BorderLayout());
        this.pp = new PrefsStringArrayPropertyPane(string, abstractPropertySheet, preferences, "Designated SOCKS Servers:", 8, "Check All Servers...", 1080, CtcProxyFactory.connectTimeout());
        this.add(this.pp);
        this.notifyAllPropertyEditors(this);
        this.load();
    }

    public void store() {
        String[] stringArray = this.pp.getValues();
        try {
            CtcProxyFactory.setDesignatedGnes((String[])stringArray, (boolean)true);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            ErrorMsg.displayError(null, (EID)NEMC.EID_CANT_SAVE_PREFS);
        }
    }

    public void load() {
        String[] stringArray = CtcProxyFactory.getDesignatedGnesFromPrefs();
        this.pp.setValues(stringArray);
    }

    protected boolean onValidate(Container container) {
        if (this.pp.isDirty()) {
            String[] stringArray = this.pp.getValues();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(stringArray[i]);
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorMsg.displayError(null, (EID)NEMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)("Invalid name or IP address: " + stringArray[i]));
                    return false;
                }
            }
        }
        return true;
    }

    public CSHelpID getHelpID() {
        return null;
    }
}

