/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.AbstractSdhStEndpointPanel;
import cerent.cms.ui.StEndpointPane;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SdhAu4LoNum;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SdhAu4StEndpointPanel
extends AbstractSdhStEndpointPanel {
    protected JLabel vc4LB;
    protected JComboBox vc4CB;
    protected List vc3LoParts;

    public SdhAu4StEndpointPanel(String string, StEndpointPane stEndpointPane) {
        super(string, stEndpointPane);
    }

    protected void addComponents(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridheight = 1;
        this.vc4LB = new JLabel("VC4:", 4);
        this.vc4CB = this.addCB(this.vc4LB, "vc4CB", gridBagConstraints);
        this.vc3LB = new JLabel("VC3:", 4);
        this.vc3CB = this.addCB(this.vc3LB, "vc3CB", gridBagConstraints);
        this.tug2LB = new JLabel("TUG2:", 4);
        this.tug2CB = this.addCB(this.tug2LB, "tug2CB", gridBagConstraints);
        this.vc11_12LB = new JLabel("", 4);
        this.vc11_12CB = this.addCB(this.vc11_12LB, "vc11_12CB", gridBagConstraints);
        this.hoParts.add(this.vc4CB);
        this.vc3LoParts = new ArrayList();
        this.vc11_12LoParts = new ArrayList();
        this.vc3LoParts.add(this.vc3LB);
        this.vc3LoParts.add(this.vc3CB);
        this.vc11_12LoParts.add(this.tug2LB);
        this.vc11_12LoParts.add(this.tug2CB);
        this.vc11_12LoParts.add(this.vc11_12LB);
        this.vc11_12LoParts.add(this.vc11_12CB);
        this.loParts.addAll(this.vc3LoParts);
        this.loParts.addAll(this.vc11_12LoParts);
    }

    protected void reset() {
        super.reset();
        this.resetLoNum();
    }

    protected void resetLoNum() {
        this.loNum = null;
        this.vc11_12 = null;
        this.tug2 = null;
        this.vc3 = null;
    }

    protected List getLoParts() {
        if (this.loParts.size() == 0) {
            if (this.vc3LoParts.size() == 0) {
                this.vc3LoParts.add(this.vc3LB);
                this.vc3LoParts.add(this.vc3CB);
            }
            if (this.vc11_12LoParts.size() == 0) {
                this.vc11_12LoParts.add(this.tug2LB);
                this.vc11_12LoParts.add(this.tug2CB);
                this.vc11_12LoParts.add(this.vc11_12LB);
                this.vc11_12LoParts.add(this.vc11_12CB);
            }
            this.loParts.addAll(this.vc3LoParts);
            this.loParts.addAll(this.vc11_12LoParts);
        }
        return this.loParts;
    }

    protected JComboBox getHoCB() {
        return this.vc4CB;
    }

    protected void localRefresh(ICircuitType iCircuitType, int n) {
        if (!iCircuitType.isLoCircuitType()) {
            this.endpoint.setLoNum(null);
            this.vc11_12 = null;
            this.tug2 = null;
            this.vc3 = null;
            SdhAu4StEndpointPanel.setComponentsVisible(this.loParts, false);
        } else {
            SdhAu4StEndpointPanel.setComponentsVisible(this.vc3LoParts, true);
            if (n == 11) {
                this.vc11_12 = null;
                this.tug2 = null;
                this.vc3LB.setText("VC3:");
                SdhAu4StEndpointPanel.setComponentsVisible(this.vc11_12LoParts, false);
            } else {
                this.vc3LB.setText("TUG3:");
                SdhAu4StEndpointPanel.setComponentsVisible(this.vc11_12LoParts, true);
                if (n == 9) {
                    this.vc11_12LB.setText("VC11:");
                } else {
                    this.vc11_12LB.setText("VC12:");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.slotCB) {
            super.actionPerformed(actionEvent);
            return;
        }
        if (object == this.portCB) {
            SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
            if (this.isNull(sortablePortString, "newPort")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: port " + this.port + " -> " + sortablePortString);
            }
            this.port = sortablePortString;
            try {
                this.setEntity((IEntityModel)this.portMap.get(this.port));
                return;
            }
            catch (AnnotatedException annotatedException) {
                if (db.on()) {
                    db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                }
                this.clearEntity(annotatedException, false);
                return;
            }
        }
        if (object == this.vc4CB) {
            IHoNum iHoNum = (IHoNum)this.vc4CB.getSelectedItem();
            if (this.isNull(iHoNum, "newVc4")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: vc4 " + this.hoNum + " -> " + iHoNum);
            }
            this.hoNum = iHoNum;
            this.endpoint.setHoNum(this.hoNum);
            Object v = this.endpointMap.get(this.hoNum);
            if (this.isNull(v, "endpointMap value for VC4 " + this.hoNum.toString())) {
                return;
            }
            if (v instanceof INetCircuitEnd) {
                return;
            }
            if (v instanceof SortedMap) {
                this.setCBList(this.tug2CB, null);
                this.setCBList(this.vc11_12CB, null);
                this.vc3Map = (SortedMap)v;
                this.setCBList(this.vc3CB, this.vc3Map.keySet());
                if (this.vc3Map.size() != 1) return;
                this.vc3CB.setSelectedItem(this.vc3Map.firstKey());
                this.vc3CB.setEnabled(false);
                return;
            }
            if (!db.on()) return;
            db.fine(this.title + " actionPerformed: endpointMap value " + "has wrong class: " + v.getClass().toString());
            return;
        }
        if (object == this.vc3CB) {
            Integer n = (Integer)this.vc3CB.getSelectedItem();
            if (this.isNull(n, "newVc3")) {
                return;
            }
            n = (Integer)this.getValidSelectedItem(this.vc3CB, n);
            if (db.on()) {
                db.println(this.title + " actionPerformed: vc3 " + this.vc3 + " -> " + n);
            }
            this.vc3 = n;
            if (this.getCircuitInfoSize() == 11) {
                this.loNum = HoLoFactory.createVc3LoNum(this.vc3);
                this.endpoint.setLoNum(this.loNum);
                return;
            }
            this.setCBList(this.vc11_12CB, null);
            this.tug2Map = (SortedMap)this.vc3Map.get(this.vc3);
            this.setCBList(this.tug2CB, this.tug2Map.keySet());
            if (this.tug2Map.size() != 1) return;
            this.tug2CB.setSelectedItem(this.tug2Map.firstKey());
            this.tug2CB.setEnabled(false);
            return;
        }
        if (object == this.tug2CB) {
            Integer n = (Integer)this.tug2CB.getSelectedItem();
            if (this.isNull(n, "newTug2")) {
                return;
            }
            n = (Integer)this.getValidSelectedItem(this.tug2CB, n);
            if (db.on()) {
                db.println(this.title + " actionPerformed: tug2 " + this.tug2 + " -> " + n);
            }
            this.tug2 = n;
            this.vc11_12Map = (SortedMap)this.tug2Map.get(this.tug2);
            this.setCBList(this.vc11_12CB, this.vc11_12Map.keySet());
            if (this.vc11_12Map.size() != 1) return;
            this.vc11_12CB.setSelectedItem(this.vc11_12Map.firstKey());
            this.vc11_12CB.setEnabled(false);
            return;
        }
        if (object != this.vc11_12CB) return;
        Integer n = (Integer)this.vc11_12CB.getSelectedItem();
        if (this.isNull(n, "newVc11_12")) {
            return;
        }
        n = (Integer)this.getValidSelectedItem(this.vc11_12CB, n);
        if (db.on()) {
            db.println(this.title + " actionPerformed: vc11_12 " + this.vc11_12 + " -> " + n);
        }
        this.vc11_12 = n;
        this.loNum = HoLoFactory.createSdhAu4LoNum(this.getCircuitInfoSize(), this.vc3, this.tug2, this.vc11_12);
        this.endpoint.setLoNum(this.loNum);
    }

    protected void putInLoMap(SortedMap sortedMap, INetCircuitEnd iNetCircuitEnd) {
        if (this.getCircuitInfoType() != 5 && this.getCircuitInfoType() != 13) {
            throw new IllegalArgumentException("The circuit type should be VC_LO_CIRCUIT");
        }
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iNetCircuitEnd.getLoNum();
        if (sdhAu4LoNum != null) {
            Integer n = new Integer(sdhAu4LoNum.getVc3());
            if (sdhAu4LoNum.getCorrespondingCircuitSize() != this.getCircuitInfoSize()) {
                throw new IllegalArgumentException("The circuit size doesn't match. The circuit size should be " + this.getCircuitInfoSize() + ", but getting circuit size  " + sdhAu4LoNum.getCorrespondingCircuitSize());
            }
            if (sdhAu4LoNum.isVc3Num()) {
                sortedMap.put(n, iNetCircuitEnd);
            } else {
                TreeMap<Integer, INetCircuitEnd> treeMap;
                Integer n2 = new Integer(sdhAu4LoNum.getTug2());
                Integer n3 = new Integer(sdhAu4LoNum.getVc11_12());
                TreeMap<Integer, TreeMap<Integer, INetCircuitEnd>> treeMap2 = (TreeMap<Integer, TreeMap<Integer, INetCircuitEnd>>)sortedMap.get(n);
                if (treeMap2 == null) {
                    treeMap2 = new TreeMap<Integer, TreeMap<Integer, INetCircuitEnd>>();
                    sortedMap.put(n, treeMap2);
                }
                if ((treeMap = (TreeMap<Integer, INetCircuitEnd>)treeMap2.get(n2)) == null) {
                    treeMap = new TreeMap<Integer, INetCircuitEnd>();
                    treeMap2.put(n2, treeMap);
                }
                treeMap.put(n3, iNetCircuitEnd);
            }
        }
    }

    protected boolean inLoMap(SortedMap sortedMap, ILoNum iLoNum) {
        if (sortedMap == null) {
            return false;
        }
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iLoNum;
        Integer n = new Integer(sdhAu4LoNum.getVc3());
        if (sdhAu4LoNum.isVc3Num()) {
            return sortedMap.get(n) != null;
        }
        SortedMap sortedMap2 = (SortedMap)sortedMap.get(n);
        Integer n2 = new Integer(sdhAu4LoNum.getTug2());
        Integer n3 = new Integer(sdhAu4LoNum.getVc11_12());
        SortedMap sortedMap3 = (SortedMap)sortedMap2.get(n2);
        if (sortedMap3 == null) {
            return false;
        }
        return sortedMap3.containsKey(n3);
    }

    protected ILoNum getFirstLoFromLoMap(SortedMap sortedMap, int n) {
        Integer n2 = (Integer)sortedMap.firstKey();
        if (sortedMap.get(n2) instanceof SortedMap) {
            SortedMap sortedMap2 = (SortedMap)sortedMap.get(n2);
            Integer n3 = (Integer)sortedMap2.firstKey();
            SortedMap sortedMap3 = (SortedMap)sortedMap2.get(n3);
            Integer n4 = (Integer)sortedMap3.firstKey();
            return HoLoFactory.createSdhAu4LoNum(n, n2, n3, n4);
        }
        return HoLoFactory.createVc3LoNum(n2);
    }

    protected void setLoComponents(ILoNum iLoNum) {
        if (iLoNum == null) {
            db.fine("LoNum is null for 'setLoComponents'");
            return;
        }
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iLoNum;
        this.vc3CB.setSelectedItem(new Integer(sdhAu4LoNum.getVc3()));
        if (!sdhAu4LoNum.isVc3Num()) {
            this.tug2CB.setSelectedItem(new Integer(sdhAu4LoNum.getTug2()));
            this.vc11_12CB.setSelectedItem(new Integer(sdhAu4LoNum.getVc11_12()));
        }
    }

    protected void setLoComponentsFromEndpoint() {
        this.setCBList(this.vc3CB, this.vc3 != null ? Collections.singleton(this.vc3) : null);
        this.vc3CB.setSelectedItem(this.vc3);
        this.setCBList(this.tug2CB, this.tug2 != null ? Collections.singleton(this.tug2) : null);
        this.tug2CB.setSelectedItem(this.tug2);
        this.setCBList(this.vc11_12CB, this.vc11_12 != null ? Collections.singleton(this.vc11_12) : null);
        this.vc11_12CB.setSelectedItem(this.vc11_12);
    }
}

