/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.SecurityIntrusionAlarmClearDialog;
import cerent.cms.ui.SecurityUsersDataSource;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.UserChangeDialog;
import cerent.cms.ui.UserCreationDialog;
import cerent.cms.ui.UserDeletionDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.NEMC;
import cerent.util.ObservableManager;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SecurityUsersPane
extends ObserverPane
implements Observer {
    private static final String CREATE = "Create...";
    private static final String EDIT = "Edit...";
    private static final String DELETE = "Delete...";
    private static final String CLEAR = "Clear Security Intrusion Alarm";
    private JButton createButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton clearButton;
    private Frame parentFrame;
    private String dlgTitle;
    private String dlgErrMsg;
    private JPanel buttonRow;
    private UScrollPane userSP;
    private NodeModel nodeOfRelevance;
    private UserInfo _dsc;

    public SecurityUsersPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, tabbedView);
        this.nodeOfRelevance = iModel instanceof NodeModel ? (NodeModel)iModel : (NodeModel)iModel.getNodeModel();
        this._dsc = new UserInfo(iModel);
        this.setDataSourceControl(this._dsc);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(observable, null);
        this.manageButtons();
    }

    private void displayStatusMessage(String string, String string2) {
        this.parentFrame = JOptionPane.getFrameForComponent((Component)((Object)this));
        this.dlgTitle = string;
        this.dlgErrMsg = string2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new TextAreaDialog(SecurityUsersPane.this.parentFrame, SecurityUsersPane.this.dlgTitle, SecurityUsersPane.this.dlgErrMsg);
            }
        });
    }

    private SecurityLevel securityLevel(SecurityUsersDataSource.UserInfo userInfo) {
        return SecurityLevel.from_int((int)userInfo.getSecurityLevelValue());
    }

    private void createUser() {
        NetSecurityModel netSecurityModel;
        Map map;
        UserCreationDialog userCreationDialog = UserCreationDialog.instance(this, this._dsc.getNodes());
        userCreationDialog.show();
        if (userCreationDialog.ok() && NetSecurityModel.hasFailures(map = (netSecurityModel = NetSecurityModel.instance()).createUser(userCreationDialog.getUserName(), userCreationDialog.getPassword(), userCreationDialog.getSecurityLevel().value(), userCreationDialog.getSelectedList()))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("User creation:\n");
            NetSecurityModel.formatFailedMap(stringBuffer, map);
            this.displayStatusMessage("User Creation Results", stringBuffer.toString());
        }
    }

    private void changeUser() {
        SecurityUsersDataSource.UserInfo userInfo = this._dsc.getSelected();
        if (userInfo == null) {
            if (db.on()) {
                db.println("Tried to change empty user");
            }
            return;
        }
        String string = userInfo.getUsername();
        SecurityLevel securityLevel = this.securityLevel(userInfo);
        Boolean bl = userInfo.getLockedOutValue();
        Boolean bl2 = userInfo.getUserDisabledValue();
        Boolean bl3 = userInfo.getUserForcePasswordChangeValue();
        if (this.nodeOfRelevance.getSecurityLevel().value() != SecurityLevel.SUPERUSER.value() && !this.nodeOfRelevance.getUserName().equals(string)) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ONLY_CHANGE_YOUR_ACCOUNT);
            return;
        }
        UserChangeDialog userChangeDialog = UserChangeDialog.instance(this, this._dsc.getNodes(string), string, securityLevel, bl, bl2, bl3);
        userChangeDialog.show();
        if (!userChangeDialog.ok()) {
            return;
        }
        Map map = null;
        StringBuffer stringBuffer = new StringBuffer();
        NetSecurityModel netSecurityModel = NetSecurityModel.instance();
        List list = userChangeDialog.getSelectedList();
        if (userChangeDialog.getNewPassword() != null && userChangeDialog.getNewPassword().length() != 0 && NetSecurityModel.hasFailures(map = !this.nodeOfRelevance.getUserName().equals(string) ? netSecurityModel.setUserPassword(userChangeDialog.getUserName(), userChangeDialog.getNewPassword(), list) : netSecurityModel.changePassword(userChangeDialog.getUserName(), userChangeDialog.getOldPassword(), userChangeDialog.getNewPassword(), list))) {
            stringBuffer.append("Password Changes:\n");
            NetSecurityModel.formatFailedMap(stringBuffer, map);
        }
        if (this.nodeOfRelevance.getSecurityLevel().value() == SecurityLevel.SUPERUSER.value()) {
            List list2 = this._dsc.filterSecurityLevel(list, userChangeDialog.getUserName(), userChangeDialog.getSecurityLevel().value());
            if (list2.size() > 0 && NetSecurityModel.hasFailures(map = netSecurityModel.setUserSecurityLevel(userChangeDialog.getUserName(), userChangeDialog.getSecurityLevel().value(), list2))) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("Security Level Changes:\n");
                NetSecurityModel.formatFailedMap(stringBuffer, map);
            }
            if ((list2 = this._dsc.filterLockedOut(list, userChangeDialog.getUserName(), userChangeDialog.getLockedOut())).size() > 0 && NetSecurityModel.hasFailures(map = userChangeDialog.getLockedOut() ? netSecurityModel.adminLockUsername(userChangeDialog.getUserName(), list2) : netSecurityModel.adminUnlockUsername(userChangeDialog.getUserName(), list2))) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("Locked Out Changes:\n");
                NetSecurityModel.formatFailedMap(stringBuffer, map);
            }
            boolean bl4 = userChangeDialog.getUserDisabled();
            list2 = this._dsc.filterUserDisabled(list, userChangeDialog.getUserName(), bl4);
            if (list2.size() > 0 && NetSecurityModel.hasFailures(map = netSecurityModel.setUserDisabled(userChangeDialog.getUserName(), bl4, list2))) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("Disabled User Changes:\n");
                NetSecurityModel.formatFailedMap(stringBuffer, map);
            }
            boolean bl5 = userChangeDialog.getUserForcePasswordChange();
            list2 = this._dsc.filterUserForcePasswordChange(list, userChangeDialog.getUserName(), bl5);
            if (list2.size() > 0 && NetSecurityModel.hasFailures(map = netSecurityModel.setUserForcePasswordChange(userChangeDialog.getUserName(), bl5, list2))) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("Password Change On Next Login:\n");
                NetSecurityModel.formatFailedMap(stringBuffer, map);
            }
        }
        if (stringBuffer.length() != 0) {
            this.displayStatusMessage("User Change Results", stringBuffer.toString());
        }
    }

    private void deleteUser() {
        NetSecurityModel netSecurityModel;
        Map map;
        SecurityUsersDataSource.UserInfo userInfo = this._dsc.getSelected();
        if (userInfo == null) {
            if (db.on()) {
                db.println("Tried to delete empty user");
            }
            return;
        }
        String string = userInfo.getUsername();
        UserDeletionDialog userDeletionDialog = UserDeletionDialog.instance(this, string, this._dsc.getNodes(string));
        userDeletionDialog.show();
        if (userDeletionDialog.ok() && NetSecurityModel.hasFailures(map = (netSecurityModel = NetSecurityModel.instance()).deleteUser(userDeletionDialog.getUserName(), userDeletionDialog.getLogoutBeforeDelete(), userDeletionDialog.getSelectedList()))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("User deletes:\n");
            NetSecurityModel.formatFailedMap(stringBuffer, map);
            this.displayStatusMessage("User Deletion Results", stringBuffer.toString());
        }
    }

    private void clearSecurityIntrusionAlarm() {
        List list = this._dsc.getNodes();
        if (list.size() == 1) {
            this.sendClear(list);
        } else {
            SecurityIntrusionAlarmClearDialog securityIntrusionAlarmClearDialog = SecurityIntrusionAlarmClearDialog.instance(this, this._dsc.getNodes());
            securityIntrusionAlarmClearDialog.show();
            if (securityIntrusionAlarmClearDialog.ok()) {
                this.sendClear(securityIntrusionAlarmClearDialog.getSelectedList());
            }
        }
    }

    private void sendClear(List list) {
        NetSecurityModel netSecurityModel = NetSecurityModel.instance();
        Map map = netSecurityModel.clearSecurityIntrusionAlarm(list);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Clear Security Intrusion Alarm:\n");
        NetSecurityModel.formatFailedMap(stringBuffer, map);
        this.displayStatusMessage("Clear Security Intrusion Results", stringBuffer.toString());
    }

    private void manageButtons() {
        this.createButton.setEnabled(this.isUserAuthorized());
        if (this._dsc.nodeSupportClearSecurityIntrusionAlarm()) {
            this.clearButton.setEnabled(this.isUserAuthorized());
        } else {
            this.clearButton.setEnabled(false);
        }
        boolean bl = this.nodeOfRelevance.getSecurityLevel().value() == SecurityLevel.SUPERUSER.value();
        SecurityUsersDataSource.UserInfo userInfo = this._dsc.getSelected();
        String string = userInfo != null ? userInfo.getUsername() : null;
        boolean bl2 = this.nodeOfRelevance.getUserName().equals(string);
        this.deleteButton.setEnabled(this.isUserAuthorized() && userInfo != null);
        this.editButton.setEnabled(bl && userInfo != null || bl2);
    }

    private class UserInfo
    extends AbstractDataSourceControl {
        private IModel _model;
        private NetSecurityModel _secuModel;
        private ObservableManager _om;
        private SecurityUsersDataSource _ds;
        private SortableRowTableModel _tm;
        private Thread _updater;
        private boolean _needsUpdate;

        UserInfo(IModel iModel) {
            this._model = iModel;
            this._secuModel = null;
            this._om = new ObservableManager(SecurityUsersPane.this, true);
            this._ds = null;
            this._tm = null;
            this._updater = null;
            this._needsUpdate = false;
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                if (AbstractPane.db.on()) {
                    AbstractPane.db.println("updater starting update");
                }
                this._needsUpdate = false;
                return true;
            }
            return false;
        }

        private void doUpdate() {
            try {
                this._ds.refreshFromModel(this._tm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            if (AbstractPane.db.on()) {
                AbstractPane.db.println("refreshFromModel()");
            }
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        ((UserInfo)UserInfo.this).SecurityUsersPane.this.uiToolkit.setSBText("Loading users...");
                        while (UserInfo.this.needsUpdate()) {
                            UserInfo.this.doUpdate();
                        }
                        UserInfo.this._updater = null;
                        ((UserInfo)UserInfo.this).SecurityUsersPane.this.uiToolkit.setSBText("");
                        if (AbstractPane.db.on()) {
                            AbstractPane.db.println("updater done");
                        }
                    }
                });
                if (AbstractPane.db.on()) {
                    AbstractPane.db.println("updater created");
                }
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) throws Exception {
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        public void applyToModel() {
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            this._om.removeObservable((Observable)((Object)this._secuModel));
        }

        SecurityUsersDataSource.UserInfo getSelected() {
            JTable jTable = SecurityUsersPane.this.getTable();
            int n = jTable.getSelectedRow();
            if (n >= 0 && n < jTable.getRowCount()) {
                return (SecurityUsersDataSource.UserInfo)this._tm.getValueAt(n, 0);
            }
            return null;
        }

        boolean nodeDoesNotSupportGetUsers() {
            return this._ds.nodeDoesNotSupportGetUsers();
        }

        boolean nodeSupportClearSecurityIntrusionAlarm() {
            return this._ds.nodeSupportClearSecurityIntrusionAlarm();
        }

        List getNodes() {
            return this._ds.getNodes();
        }

        List getNodes(String string) {
            return this._ds.getNodes(string);
        }

        List filterSecurityLevel(List list, String string, int n) {
            return this._ds.filterSecurityLevel(list, string, n);
        }

        List filterLockedOut(List list, String string, boolean bl) {
            return this._ds.filterLockedOut(list, string, bl);
        }

        List filterUserDisabled(List list, String string, boolean bl) {
            return this._ds.filterUserDisabled(list, string, bl);
        }

        List filterUserForcePasswordChange(List list, String string, boolean bl) {
            return this._ds.filterUserForcePasswordChange(list, string, bl);
        }

        UScrollPane initTable() {
            this._secuModel = NetSecurityModel.instance();
            this._om.addObservable((Observable)((Object)this._secuModel));
            this._ds = new SecurityUsersDataSource(this._model);
            this._tm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            SecurityUsersPane.this.setTable((JTable)new UTable((TableModel)((Object)this._tm)));
            this._tm.initTable(SecurityUsersPane.this.getTable());
            ListSelectionModel listSelectionModel = SecurityUsersPane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        SecurityUsersPane.this.manageButtons();
                    }
                }
            });
            return new UScrollPane((Component)SecurityUsersPane.this.getTable());
        }

        void initUi() {
            SecurityUsersPane.this.setLayout(new BorderLayout());
            SecurityUsersPane.this.buttonRow = AbstractPane.createHorizontalPanel(null);
            SecurityUsersPane.this.buttonRow.setLayout(new BorderLayout());
            SecurityUsersPane.this.userSP = this.initTable();
            SecurityUsersPane.this.createButton = new JButton(SecurityUsersPane.CREATE);
            SecurityUsersPane.this.createButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SecurityUsersPane.this.createUser();
                }
            });
            SecurityUsersPane.this.editButton = new JButton(SecurityUsersPane.EDIT);
            SecurityUsersPane.this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SecurityUsersPane.this.changeUser();
                }
            });
            SecurityUsersPane.this.deleteButton = new JButton(SecurityUsersPane.DELETE);
            SecurityUsersPane.this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SecurityUsersPane.this.deleteUser();
                }
            });
            SecurityUsersPane.this.clearButton = new JButton(SecurityUsersPane.CLEAR);
            SecurityUsersPane.this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SecurityUsersPane.this.clearSecurityIntrusionAlarm();
                }
            });
            SecurityUsersPane.this.manageButtons();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel.add(SecurityUsersPane.this.createButton);
            jPanel.add(SecurityUsersPane.this.editButton);
            jPanel.add(SecurityUsersPane.this.deleteButton);
            jPanel.add(SecurityUsersPane.this.clearButton);
            jPanel2.add(new CSHelpButton(NetCSHelpConst.SecurityUsersPane));
            SecurityUsersPane.this.buttonRow.add((Component)jPanel, "Center");
            SecurityUsersPane.this.buttonRow.add((Component)jPanel2, "East");
            SecurityUsersPane.this.add((Component)SecurityUsersPane.this.userSP, "Center");
            SecurityUsersPane.this.add(SecurityUsersPane.this.buttonRow, "South");
        }
    }
}

