/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.HoServerTrailModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.LoServerTrailModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServerTrailModel;
import cerent.cms.model.ServerTrailProtection;
import cerent.cms.model.ServerTrailsDirector;
import cerent.cms.topo.Network;
import cerent.cms.topo.ServerTrailException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ServerTrailDialog;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.ServerTrailUtil;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.LabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ServerTrailPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
TableModelListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    protected ServerTrailsDirector std = ServerTrailsDirector.instance();
    protected ServerTrailTableModel dataModel;
    protected ArrayList tableDataList;
    UScrollPane scrollPane;
    private JPanel buttons;
    private JButton createPB;
    private JButton deletePB;
    private boolean inited = false;
    Attribute[] trailProtectionTypes = new Attribute[]{new Attribute("PREEMPTIBLE", new Integer(0)), new Attribute("UNPROTECTED", new Integer(1)), new Attribute("FULLY PROTECTED", new Integer(2))};

    public ServerTrailPane(String string, TabbedView tabbedView) {
        super(string, tabbedView.getUiModel(), tabbedView);
        this.std.addObserver((Observer)((Object)this));
    }

    public boolean isInited() {
        return this.inited;
    }

    protected void init() {
        this.tableDataList = new ArrayList();
        this.dataModel = this.createTableModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.prepareColumns();
        this.setLayout(new BorderLayout());
        this.scrollPane = new UScrollPane((Component)this.table);
        this.add((Component)this.scrollPane, "Center");
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.buttons = this.getButtonBar();
        this.add(this.buttons, "South");
        this.inited = true;
    }

    protected ServerTrailTableModel createTableModel() {
        return new ServerTrailTableModel();
    }

    protected void prepareColumns() {
        ServerTrailRenderer serverTrailRenderer = new ServerTrailRenderer();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            this.table.getColumn(this.dataModel.getColumnName(i)).setCellRenderer(serverTrailRenderer);
        }
    }

    public void enteringPage() {
        if (db.on()) {
            db.println(">>>  enteringPage");
        }
        try {
            if (!this.inited) {
                this.init();
            }
            this.refresh();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        if (db.on()) {
            db.println("<<< enteringPage()");
        }
    }

    public void leavingPage() throws Exception {
        if (ServerTrailPane.db.on) {
            db.println(">>> leavingPage()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void update(Observable observable, Object object) {
        db.fine("update(" + observable + ", " + object + ")");
        if (observable instanceof ServerTrailsDirector && this.inited) {
            this.refresh();
        }
    }

    public void refresh() {
        Set set = this.std.getServerTrails();
        this.tableDataList = new ArrayList(set);
        this.refreshTable();
    }

    protected void refreshTable() {
        this.dataModel.fireTableDataChanged();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.dataModel.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
    }

    protected void setEditDeleteEnabled(boolean bl) {
        if (!this.isUserAuthorized()) {
            bl = false;
        }
        if (!bl) {
            this.clearTableSelection();
        }
        this.deletePB.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    protected void clearTableSelection() {
        if (this.table != null && !this.tableDataList.isEmpty()) {
            this.table.removeRowSelectionInterval(0, this.tableDataList.size() - 1);
        }
    }

    protected void removeActionListeners() {
        this.createPB.removeActionListener(this);
        this.deletePB.removeActionListener(this);
    }

    public void destroy() {
        if (db.on()) {
            db.println(">>>  destroy()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.removeActionListeners();
        }
        super.destroy();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            new ServerTrailDialog(JOptionPane.getFrameForComponent((Component)this.parentTV));
        } else if (object == this.deletePB) {
            int[] nArray = this.table.getSelectedRows();
            Object[] objectArray = new ServerTrailModel[nArray.length];
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n >= this.tableDataList.size()) continue;
                objectArray[i] = (ServerTrailModel)this.tableDataList.get(n);
                if (!Network.instance().isServerTrailInUse(((ServerTrailModel)objectArray[i]).getServerTrailLinkId())) continue;
                bl = true;
            }
            String string = null;
            if (bl) {
                string = nArray.length == 1 ? "The server trail is in use.  Deleting the server trail will cause\ncircuits provisioned over the server trail to go into PARTIAL state." : "Some server trails are in use.  Deleting the server trails will cause\ncircuits provisioned over the server trails to go into PARTIAL state.";
            }
            ServerTrailDeletionConfirmDialog serverTrailDeletionConfirmDialog = new ServerTrailDeletionConfirmDialog(objectArray, string);
            serverTrailDeletionConfirmDialog.show();
            if (serverTrailDeletionConfirmDialog.isOk()) {
                this.deleteServerTrail((ServerTrailModel[])objectArray);
            }
        }
    }

    private void deleteServerTrail(ServerTrailModel[] serverTrailModelArray) {
        for (int i = 0; i < serverTrailModelArray.length; ++i) {
            ServerTrailModel serverTrailModel = serverTrailModelArray[i];
            try {
                Network.instance().deleteServerTrail(serverTrailModel.getServerTrailLinkId());
                continue;
            }
            catch (ServerTrailException serverTrailException) {
                db.println("ServerTrailPane: unable to delete server trail on node " + serverTrailModel.getSrcNode().getName() + " with id " + serverTrailModel.getServerTrailLinkId().getUniqueId());
            }
        }
    }

    protected JPanel getButtonBar() {
        this.createPB = this.makeActionButton(CREATE);
        this.deletePB = this.makeActionButton(DELETE);
        JPanel jPanel = ServerTrailPane.createHorizontalPanel(null);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this.createPB);
        cSHelpButtonPane.addLeft(this.deletePB);
        jPanel.add(cSHelpButtonPane);
        return jPanel;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            try {
                int n = this.dataModel.getRowCount();
                boolean bl = n == 0;
                int n2 = this.table.getSelectedRow();
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                }
                this.setEditDeleteEnabled(bl);
            }
            catch (Exception exception) {
                this.setEditDeleteEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.setEditDeleteEnabled(!listSelectionModel.isSelectionEmpty());
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.ServerTrailPane;
    }

    protected class ServerTrailDeletionConfirmDialog {
        protected boolean ok = false;
        protected Object[] strailsToDelete;
        protected String extraWarnings = null;

        public ServerTrailDeletionConfirmDialog(Object[] objectArray, String string) {
            this.strailsToDelete = objectArray;
            this.extraWarnings = string;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void show() {
            String string = "Really delete the selected server " + PluralisationUtil.s("trail", this.strailsToDelete.length) + "?";
            if (this.extraWarnings != null) {
                string = this.extraWarnings + "\n \n" + string;
            }
            JLabel jLabel = new JLabel(string);
            jLabel.setUI((LabelUI)new MultiLineLabelUI());
            Object[] objectArray = new Object[]{jLabel};
            JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 0, CerentDialog.QUESTION_ICON);
            JDialog jDialog = jOptionPane.createDialog((Component)((Object)ServerTrailPane.this), "Delete Server " + PluralisationUtil.s("Trail", this.strailsToDelete.length));
            jDialog.show();
            if (jOptionPane.getValue() != null && (Integer)jOptionPane.getValue() == 0) {
                this.ok = true;
            }
        }
    }

    protected class ServerTrailRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = jTable.convertColumnIndexToModel(n2);
            switch (n3) {
                case 0: {
                    if (object != null) break;
                    object = "Could not retrieve";
                    break;
                }
                case 1: 
                case 2: {
                    if (object == null) {
                        object = "Could not retrieve";
                        break;
                    }
                    object = ServerTrailUtil.getEndpointString((IPathDefModel)object);
                    break;
                }
                case 3: {
                    if (object == null) break;
                    int n4 = (Integer)object;
                    object = CircuitSize.getCircuitSize((int)n4).getCircuitSizeString();
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (object == null) break;
                    int n5 = (Integer)object;
                    object = ServerTrailProtection.getServerTrailProtection((int)n5);
                    break;
                }
                case 6: {
                    break;
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    protected class ServerTrailTableModel
    extends AbstractTableModel {
        public static final int ID_INDEX = 0;
        public static final int SRC_INDEX = 1;
        public static final int DST_INDEX = 2;
        public static final int SIZE_INDEX = 3;
        public static final int NUM_TRAILS_INDEX = 4;
        public static final int PROT_INDEX = 5;
        public static final int SRLG_INDEX = 6;
        public final String[] columnNames = new String[]{"ID", "Source", "Destination", "Size", "# of Trails", "Protection", "SRLG"};

        protected ServerTrailTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return ServerTrailPane.this.tableDataList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (ServerTrailPane.this.tableDataList != null && n < ServerTrailPane.this.tableDataList.size()) {
                ServerTrailModel serverTrailModel = (ServerTrailModel)ServerTrailPane.this.tableDataList.get(n);
                switch (n2) {
                    case 0: {
                        if (serverTrailModel.getSrcNode() != null) {
                            return "Node: " + serverTrailModel.getSrcNode().getName() + " ID: " + serverTrailModel.getServerTrailLinkId().getUniqueId();
                        }
                        return null;
                    }
                    case 1: {
                        if (serverTrailModel instanceof HoServerTrailModel) {
                            return ((HoServerTrailModel)serverTrailModel).getSrcTrailStart();
                        }
                        return ((LoServerTrailModel)serverTrailModel).getSrcTrailStart();
                    }
                    case 2: {
                        if (serverTrailModel instanceof HoServerTrailModel) {
                            return ((HoServerTrailModel)serverTrailModel).getDstTrailStart();
                        }
                        return ((LoServerTrailModel)serverTrailModel).getDstTrailStart();
                    }
                    case 3: {
                        return new Integer(serverTrailModel.getTrailSize());
                    }
                    case 4: {
                        return new Integer(serverTrailModel.getNumberOfTrails());
                    }
                    case 5: {
                        return new Integer(serverTrailModel.getProtectionType());
                    }
                    case 6: {
                        return serverTrailModel.getSharedRiskLinkGroup();
                    }
                }
                return "";
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

