/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.topo.Network;
import cerent.cms.topo.ServerTrailPrefs;
import cerent.cms.ui.AbstractStEndpointPanel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeSelector;
import cerent.cms.ui.SdhAu3StEndpointPanel;
import cerent.cms.ui.SdhAu4StEndpointPanel;
import cerent.cms.ui.ServerTrailDialog;
import cerent.cms.ui.SonetStEndpointPanel;
import cerent.cms.ui.WizardPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StEndpointPane
extends WizardPane
implements ActionListener {
    private ServerTrailDialog parent;
    private boolean inited = false;
    protected JPanel leftPanel;
    protected NodeSelector nodeCB;
    protected AbstractStEndpointPanel mainPanel;
    protected INodeModel excludedNode = null;
    private String endpointName;
    protected INodeModel nodeModel;
    List availPorts;

    public StEndpointPane(String string, ServerTrailDialog serverTrailDialog, String string2) {
        super(string, serverTrailDialog);
        this.parent = serverTrailDialog;
        this.endpointName = string2;
    }

    public void enteringPage() throws Exception {
        if (!this.inited) {
            this.initPane();
            this.inited = true;
        }
        if (!this.isSourcePane()) {
            this.parent.setFinishEnabled(true);
        }
    }

    protected void initPane() {
        this.leftPanel = StEndpointPane.createVerticalPanel(null);
        this.add(this.leftPanel);
        JPanel jPanel = StEndpointPane.createHorizontalPanel(null);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel("Node: ", 4));
        this.nodeCB = new NodeSelector();
        jPanel.add((Component)((Object)this.nodeCB));
        this.nodeCB.addActionListener(this);
        this.leftPanel.add(jPanel);
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSourcePane()) {
            stringBuffer.append("\nSource: ");
        } else {
            stringBuffer.append("\nDest: ");
        }
        stringBuffer.append(this.mainPanel.getStatusText());
        return stringBuffer.toString();
    }

    public void refresh() {
        this.updateNodeList();
        if (this.nodeModel != null) {
            if (db.on()) {
                db.println(this.endpointName + " revalidateData: nodeModel = " + this.nodeModel);
            }
            this.nodeCB.setSelectedItem(this.nodeModel);
        } else {
            this.nodeCB.setSelectedItem(null);
        }
        this.updateEndpointPanel();
        if (this.mainPanel != null) {
            this.mainPanel.refresh();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nodeCB) {
            this.setNode((INodeModel)this.nodeCB.getSelectedItem());
        }
    }

    protected void updateNodeList() {
        db.println("updateNodeList");
        this.nodeCB.removeActionListener(this);
        this.nodeCB.updateNodeList(this.parent.circuitInfo, null);
        if (!this.isSourcePane()) {
            this.excludeNode(this.parent.srcNode);
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.nodeCB.getModel();
        for (int i = defaultComboBoxModel.getSize() - 1; i >= 0; --i) {
            INodeModel iNodeModel = (INodeModel)defaultComboBoxModel.getElementAt(i);
            db.println("loop of comboBoxModel " + iNodeModel.getName());
            if (iNodeModel.provides(Feature.SERVER_TRAIL)) continue;
            db.println("removeItem " + iNodeModel.getName());
            this.nodeCB.removeItem(iNodeModel);
        }
        this.nodeCB.addActionListener(this);
        this.nodeCB.setSelectedItem(null);
    }

    void excludeNode(INodeModel iNodeModel) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.nodeCB.getModel();
        if (defaultComboBoxModel.getIndexOf(iNodeModel) >= 0) {
            this.nodeCB.removeItem(iNodeModel);
        }
    }

    void setNode(INodeModel iNodeModel) {
        if (iNodeModel == this.nodeModel) {
            return;
        }
        this.nodeModel = iNodeModel;
        if (iNodeModel != null && !iNodeModel.getConnectionState()) {
            this.clearNode(iNodeModel.getName() + " is disconnected: no endpoints are available");
        } else {
            this.updateAvailPorts(iNodeModel);
            if (this.mainPanel == null && iNodeModel != null) {
                this.setEndpointPanel(iNodeModel);
            }
            if (this.mainPanel != null) {
                this.mainPanel.setNode(iNodeModel);
            }
        }
    }

    protected void setEndpointPanel(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        if (iNodeModel.getFramingType() == 0) {
            this.mainPanel = new SonetStEndpointPanel(this.endpointName, this);
            this.leftPanel.add(this.mainPanel);
        } else if (iNodeModel.getFramingType() == 1) {
            this.mainPanel = new SdhAu4StEndpointPanel(this.endpointName, this);
            this.leftPanel.add(this.mainPanel);
        } else if (iNodeModel.getFramingType() == 2) {
            this.mainPanel = new SdhAu3StEndpointPanel(this.endpointName, this);
            this.leftPanel.add(this.mainPanel);
        }
        this.updateEndpointPanel();
    }

    private void updateEndpointPanel() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        if (this.mainPanel != null) {
            this.mainPanel.setVisible(true);
        }
    }

    private void clearNode(Object object) {
        if (db.on()) {
            db.println(this.endpointName + " clearNode: " + object.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (StEndpointPane.this.nodeModel != null) {
                    String string = "Node Selection Error";
                    StEndpointPane.this.nodeCB.setSelectedItem(null);
                    ErrorMsg.displayError((Component)((Object)StEndpointPane.this), (EID)NEMC.EID_NODE_SELECTION_ERROR);
                }
            }
        });
    }

    protected void updateAvailPorts(INodeModel iNodeModel) {
        this.availPorts = new ArrayList();
        ICircuitType iCircuitType = this.parent.circuitType;
        if (iNodeModel == null) {
            if (db.on()) {
                db.println(this.endpointName + " updateAvailPorts: got 0 ports from null nodeModel");
            }
            return;
        }
        ServerTrailPrefs serverTrailPrefs = this.parent.stPrefs;
        this.availPorts = Network.instance().getAvailServerTrailPorts(iNodeModel, serverTrailPrefs);
    }

    public void validatePage() throws Exception {
        this.mainPanel.validatePage();
        if (this.isSourcePane()) {
            this.parent.srcNode = this.nodeModel;
            this.parent.srcEndpoint = this.mainPanel.endpoint;
        } else {
            this.parent.dstNode = this.nodeModel;
            this.parent.dstEndpoint = this.mainPanel.endpoint;
        }
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.parent == null ? null : this.parent.circuitInfo;
    }

    public ServerTrailPrefs getServerTrailPrefs() {
        return this.parent == null ? null : this.parent.stPrefs;
    }

    private boolean isSourcePane() {
        return this.getName().equals(ServerTrailDialog.ST_SOURCE);
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.StEndpointPane;
    }
}

