/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeSelectPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.UserChangePane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class UserChangeDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Edit User";
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    private String userName;
    private SecurityLevel securityLevel;
    private boolean lockedOut;
    private boolean disabled;
    private boolean forcePasswordChange;
    UserChangePane changePane;
    private static List nodeModelList;
    private static NodeSelectPane nodeSelPane;
    private boolean ok = false;
    private static final SDebug db;

    public static UserChangeDialog instance(Pane pane, List list, String string, SecurityLevel securityLevel, Boolean bl, Boolean bl2, Boolean bl3) {
        Object[] objectArray = new Object[]{pane, string, securityLevel, bl, list, bl2, bl3};
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new UserChangeDialog(frame, TITLE, objectArray);
    }

    private UserChangeDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        this.userName = (String)objectArray[1];
        this.securityLevel = (SecurityLevel)objectArray[2];
        this.lockedOut = (Boolean)objectArray[3];
        nodeModelList = (List)objectArray[4];
        this.disabled = (Boolean)objectArray[5];
        this.forcePasswordChange = (Boolean)objectArray[6];
        this.setSize(new Dimension(400, 250));
        NodeModel nodeModel = (NodeModel)NetworkModel.instance().getCmsHostModel();
        if (nodeModelList != null && nodeModelList.size() > 1) {
            jPanel.add((Component)this.getChangePanel(nodeModel), "North");
            nodeSelPane = new NodeSelectPane(nodeModelList);
            jPanel.add((Component)nodeSelPane, "Center");
        } else {
            if (nodeModelList != null) {
                nodeModel = (NodeModel)nodeModelList.get(0);
                jPanel.add((Component)new JLabel("Change on " + nodeModel.getName()), "North");
            }
            nodeSelPane = null;
            jPanel.add((Component)this.getChangePanel(nodeModel), "Center");
        }
        jPanel.add((Component)this.getButtonPanel(), "South");
        jPanel.revalidate();
    }

    public List getSelectedList() {
        if (nodeSelPane != null) {
            return nodeSelPane.getSelectedList();
        }
        return nodeModelList;
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok = true;
                    this.dispose();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_GENERAL_EXCEPTION);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected boolean apply() throws Exception {
        boolean bl = true;
        String string = this.getOldPassword();
        String string2 = this.getNewPassword();
        String string3 = this.getConfirmPassword();
        if (string.length() > 0 || string2.length() > 0 || string3.length() > 0) {
            bl = this.validatePassword();
        }
        if (bl) {
            bl = this.validateSecurityLevel();
        }
        return bl;
    }

    public boolean ok() {
        return this.ok;
    }

    private JPanel getChangePanel(NodeModel nodeModel) {
        this.changePane = nodeModel != null ? new UserChangePane(this.userName, nodeModel, this.securityLevel, this.lockedOut, this.disabled, this.forcePasswordChange) : null;
        return this.changePane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(NetCSHelpConst.UserChangeDialog));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public String getUserName() {
        return this.changePane.getUserName();
    }

    public String getOldPassword() {
        return this.changePane.getOldPassword();
    }

    public String getNewPassword() {
        return this.changePane.getNewPassword();
    }

    public String getConfirmPassword() {
        return this.changePane.getConfirmPassword();
    }

    public SecurityLevel getSecurityLevel() {
        return this.changePane.getSecurityLevel();
    }

    public boolean getLockedOut() {
        return this.changePane.getLockedOut();
    }

    public boolean getUserDisabled() {
        return this.changePane.getUserDisabled();
    }

    public boolean getUserForcePasswordChange() {
        return this.changePane.getUserForcePasswordChange();
    }

    private boolean validateSecurityLevel() {
        boolean bl = true;
        if (this.securityLevel.value() == SecurityLevel.SUPERUSER.value() && this.getSecurityLevel().value() != SecurityLevel.SUPERUSER.value()) {
            bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"Really want to change a superuser's security level?", (String)"Validation Message");
        }
        return bl;
    }

    protected boolean validatePassword() {
        String string;
        boolean bl = true;
        if (this.getUserName().length() < 6) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_MIN_CHAR_LEN_ERROR_PARAM_1, (Object)"Name length must be at least 6 characters long.");
            bl = false;
        }
        if (bl) {
            string = this.getOldPassword();
            String string2 = this.getNewPassword();
            String string3 = this.getConfirmPassword();
            if ((string.length() > 0 || string2.length() > 0 || string3.length() > 0) && string2.compareTo(string3) != 0) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PASSWORD_MISMATCH);
                bl = false;
            }
        }
        if (bl && this.changePane.isPasswordSimple(this.getUserName())) {
            string = this.changePane.getExceptionMessage();
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ILLEGAL_PASSWORD_PARAM_1, (Object)string);
            bl = false;
        }
        if (bl && null == this.getSecurityLevel()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_SECURITY_LEVEL);
            bl = false;
        }
        if (bl && this.getNewPassword().length() > 10 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"The new password exceeds 10 characters \nand certain management functions will be disabled.\nOK to continue?", (String)"Password Illegal For TL1")) {
            bl = false;
        }
        return bl;
    }

    static {
        db = new SDebug("UserChangeDialog");
    }
}

