/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.TL1PasswordField;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UserChangePane
extends JPanel {
    static final int MIN_CHARS = 6;
    static final int MARGIN = 5;
    protected LetterOrDigitTextField nameTF;
    protected TL1PasswordField oldPasswordTF;
    protected TL1PasswordField newPasswordTF;
    protected TL1PasswordField confirmedNewPasswordTF;
    protected JComboBox securityLevelCB;
    protected JCheckBox lockedOutCB;
    protected JCheckBox disabledCB;
    protected JCheckBox forcePasswordChangeCB;
    private String userName;
    private SecurityLevel securityLevel;
    private boolean lockedOut;
    private boolean disabled;
    private boolean forcePasswordChange;
    private String exceptionMessage = null;
    private static final SDebug db = new SDebug("UserChangePane");

    public UserChangePane(String string, NodeModel nodeModel, SecurityLevel securityLevel, boolean bl, boolean bl2, boolean bl3) {
        this.userName = string;
        this.securityLevel = securityLevel;
        this.lockedOut = bl;
        this.disabled = bl2;
        this.forcePasswordChange = bl3;
        this.add((Component)this.createAttrsPanel(nodeModel), "Center");
    }

    private JPanel createAttrsPanel(NodeModel nodeModel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.add(new JLabel("Name:"));
        this.nameTF = new LetterOrDigitTextField(20);
        jPanel.add(this.nameTF);
        if (this.userName != null) {
            this.nameTF.setText(this.userName);
            this.nameTF.setEnabled(false);
        }
        if (nodeModel.getUserName().equals(this.userName)) {
            jPanel.add(new JLabel("Old Password:"));
            this.oldPasswordTF = new TL1PasswordField(20);
            jPanel.add(this.oldPasswordTF);
        }
        jPanel.add(new JLabel("New Password:"));
        this.newPasswordTF = new TL1PasswordField(20);
        jPanel.add(this.newPasswordTF);
        jPanel.add(new JLabel("Confirm New Password:"));
        this.confirmedNewPasswordTF = new TL1PasswordField(20);
        jPanel.add(this.confirmedNewPasswordTF);
        jPanel.add(new JLabel("Security Level:"));
        this.securityLevelCB = new JComboBox<String>(EnumStrings.getStrings((Class)SecurityLevel.class));
        jPanel.add(this.securityLevelCB);
        this.securityLevelCB.setSelectedIndex(this.securityLevel.value());
        jPanel.add(new JLabel("Lock out:"));
        this.lockedOutCB = new JCheckBox();
        jPanel.add(this.lockedOutCB);
        this.lockedOutCB.setSelected(this.lockedOut);
        jPanel.add(new JLabel("Disable:"));
        this.disabledCB = new JCheckBox();
        jPanel.add(this.disabledCB);
        this.disabledCB.setSelected(this.disabled);
        jPanel.add(new JLabel("Change Password On Next Login:"));
        this.forcePasswordChangeCB = new JCheckBox();
        jPanel.add(this.forcePasswordChangeCB);
        this.forcePasswordChangeCB.setSelected(this.forcePasswordChange);
        if (nodeModel.getSecurityLevel().value() != SecurityLevel.SUPERUSER.value() || nodeModel.getUserName().equals(this.userName)) {
            this.securityLevelCB.setEnabled(false);
            this.lockedOutCB.setEnabled(false);
            this.disabledCB.setEnabled(false);
            this.forcePasswordChangeCB.setEnabled(false);
        }
        return jPanel;
    }

    public String getUserName() {
        return this.nameTF.getText();
    }

    public String getOldPassword() {
        String string = null != this.oldPasswordTF ? new String(this.oldPasswordTF.getPassword()) : new String();
        return string;
    }

    public String getNewPassword() {
        return new String(this.newPasswordTF.getPassword());
    }

    public String getConfirmPassword() {
        return new String(this.confirmedNewPasswordTF.getPassword());
    }

    public SecurityLevel getSecurityLevel() {
        SecurityLevel securityLevel = null;
        try {
            securityLevel = SecurityLevel.from_int((int)this.securityLevelCB.getSelectedIndex());
        }
        catch (Exception exception) {
            db.finest("Exception in getSecurityLevel(), returning null " + exception);
        }
        return securityLevel;
    }

    public boolean getLockedOut() {
        return this.lockedOutCB.isSelected();
    }

    public boolean getUserDisabled() {
        return this.disabledCB.isSelected();
    }

    public boolean getUserForcePasswordChange() {
        return this.forcePasswordChangeCB.isSelected();
    }

    public boolean isPasswordValidPID() {
        boolean bl;
        block2: {
            bl = true;
            try {
                this.newPasswordTF.isValidPID();
            }
            catch (Exception exception) {
                this.exceptionMessage = exception.getMessage();
                bl = false;
                if (!db.on()) break block2;
                db.println("Exception caught in UserChangePane::isPasswordValidPID(): " + exception);
            }
        }
        return bl;
    }

    public boolean isPasswordSimple(String string) {
        boolean bl = false;
        try {
            this.newPasswordTF.isNotTooSimple(string);
        }
        catch (Exception exception) {
            this.exceptionMessage = exception.getMessage();
            bl = true;
        }
        return bl;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }
}

