/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.SecurityLevel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.TL1PasswordField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UserCreatePane
extends JPanel {
    static final int MIN_CHARS = 6;
    static final int MARGIN = 5;
    protected LetterOrDigitTextField nameTF;
    protected TL1PasswordField passwordTF;
    protected TL1PasswordField confirmedPasswordTF;
    protected JComboBox securityLevelCB;
    private String exceptionMessage = null;
    private static final SDebug db = new SDebug("UserCreatePane");

    public UserCreatePane() {
        this.add((Component)this.createAttrsPanel(), "Center");
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.add(this.createLabel("Name:", 110, 20));
        this.nameTF = new LetterOrDigitTextField(20);
        jPanel.add(this.nameTF);
        jPanel.add(this.createLabel("Password:", 110, 20));
        this.passwordTF = new TL1PasswordField(20);
        jPanel.add(this.passwordTF);
        jPanel.add(this.createLabel("Confirm Password:", 110, 20));
        this.confirmedPasswordTF = new TL1PasswordField(20);
        jPanel.add(this.confirmedPasswordTF);
        jPanel.add(this.createLabel("Security Level:", 110, 20));
        this.securityLevelCB = new JComboBox<String>(EnumStrings.getStrings((Class)SecurityLevel.class));
        jPanel.add(this.securityLevelCB);
        this.securityLevelCB.setSelectedItem(null);
        return jPanel;
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    public String getUserName() {
        return this.nameTF.getText();
    }

    public String getPassword() {
        return new String(this.passwordTF.getPassword());
    }

    public String getConfirmPassword() {
        return new String(this.confirmedPasswordTF.getPassword());
    }

    public SecurityLevel getSecurityLevel() {
        SecurityLevel securityLevel = null;
        try {
            securityLevel = SecurityLevel.from_int((int)this.securityLevelCB.getSelectedIndex());
        }
        catch (Exception exception) {
            db.fine("Exception in getSecurityLevel(): " + exception + "... returning null");
        }
        return securityLevel;
    }

    public boolean isPasswordValidPID() {
        boolean bl;
        block2: {
            bl = true;
            try {
                this.passwordTF.isValidPID();
            }
            catch (Exception exception) {
                this.exceptionMessage = exception.getMessage();
                bl = false;
                if (!db.on()) break block2;
                db.println("Exception caught in UserCreatePane::isPasswordValidPID(): " + exception);
            }
        }
        return bl;
    }

    public boolean isPasswordSimple(String string) {
        boolean bl = false;
        try {
            this.passwordTF.isNotTooSimple(string);
        }
        catch (Exception exception) {
            this.exceptionMessage = exception.getMessage();
            bl = true;
        }
        return bl;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }
}

