/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class VirtualLinkDataSource
extends AbstractRowDataSource
implements Runnable {
    private static final SDebug db = new SDebug("VirtualLinkDataSource");
    private VirtualLinksDirector vld;
    private INodeModel nm;
    private ArrayList rows = new ArrayList();
    private IAsyncObserver refreshObserver = null;

    public VirtualLinkDataSource(VirtualLinksDirector virtualLinksDirector, INodeModel iNodeModel) {
        this.vld = virtualLinksDirector;
        this.nm = iNodeModel;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rows.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection getAllObjects() {
        return new ArrayList(this.rows);
    }

    public void refresh(IAsyncObserver iAsyncObserver) {
        this.refreshObserver = iAsyncObserver;
        new Thread(this).start();
    }

    public void changed() {
        this.fireDataSourceChanged();
    }

    public void run() {
        Set set = this.vld.getVirtualLinks();
        if (this.nm != null) {
            this.filterVirtualLinks(set);
            this.updateVirtualLinks(set);
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)iterator.next();
                IEntityModel iEntityModel = iVirtualLinkModel.getOrigEntity();
                IEntityModel iEntityModel2 = iVirtualLinkModel.getTermEntity();
                if (iEntityModel != null && (iEntityModel.getEqType() == 139 || iEntityModel.getEqType() == 141)) {
                    iVirtualLinkModel.swap();
                    continue;
                }
                if (iEntityModel2 == null || iEntityModel2.getEqType() != 139 && iEntityModel2.getEqType() != 141) continue;
                iVirtualLinkModel.swap();
            }
        }
        this.rows = new ArrayList(set);
        Collections.sort(this.rows);
        this.changed();
        if (this.refreshObserver != null) {
            this.refreshObserver.asyncUpdate((Object)this, JobStatus.JOB_COMPLETE);
        }
    }

    private void filterVirtualLinks(Set set) {
        if (this.nm != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)iterator.next();
                if (iVirtualLinkModel.getOrigNode().compareTo((Object)this.nm.getIpConfig().getIpAddress()) == 0 || iVirtualLinkModel.getTermNode().compareTo((Object)this.nm.getIpConfig().getIpAddress()) == 0) continue;
                iterator.remove();
            }
        }
    }

    private void updateVirtualLinks(Set set) {
        if (this.nm != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)iterator.next();
                IEntityModel iEntityModel = iVirtualLinkModel.getOrigEntity();
                IEntityModel iEntityModel2 = iVirtualLinkModel.getTermEntity();
                if (iVirtualLinkModel.getOrigNode().compareTo((Object)this.nm.getIpConfig().getIpAddress()) != 0) {
                    iVirtualLinkModel.swap();
                    continue;
                }
                if (iEntityModel != null && (iEntityModel.getEqType() == 139 || iEntityModel.getEqType() == 141)) {
                    iVirtualLinkModel.swap();
                    continue;
                }
                if (iEntityModel2 == null || iEntityModel2.getEqType() != 139 && iEntityModel2.getEqType() != 141) continue;
                iVirtualLinkModel.swap();
            }
        }
    }
}

