/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.NetCmsCommFailException;
import cerent.cms.model.NoSuchVirtualLink;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.VirtualLinkCreationDialog;
import cerent.cms.ui.VirtualLinkDataSource;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IAsyncObserver;
import cerent.util.NEMC;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class VirtualLinkPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
IAsyncObserver {
    protected JButton createPB;
    protected JButton deletePB;
    protected VirtualLinksDirector vld = VirtualLinksDirector.instance();
    private VirtualLinkDataSource dataSource;
    private SortableRowTableModel tableModel;
    private boolean inited = false;
    private boolean shelfMode = false;
    private INodeModel nm = null;
    public static final String[] columnNames = new String[]{"Origination ID", "Origination Node", "Origination Shelf/Slot/Port", "Termination ID", "Termination Node", "Termination Shelf/Slot/Port"};
    private static final SDebug db = new SDebug("VirtualLinkPane");

    public VirtualLinkPane(String string, TabbedView tabbedView) {
        this(string, false, tabbedView);
    }

    public VirtualLinkPane(String string, boolean bl, TabbedView tabbedView) {
        super(string, tabbedView.getUiModel(), null);
        this.shelfMode = bl;
        this.nm = tabbedView.getUiModel().getNodeModel();
        this.vld.addObserver((Observer)((Object)this));
    }

    protected VirtualLinkCreationDialog getVirtualLinkCreationDialog() {
        return VirtualLinkCreationDialog.instance(this, new Object[]{this.shelfMode, this.nm});
    }

    protected void init() {
        this.setBorder(BorderFactory.createTitledBorder("Patchcord Terminations"));
        this.setLayout(new BorderLayout());
        ColumnRenderer[] columnRendererArray = this.createColumnRenderers();
        this.dataSource = new VirtualLinkDataSource(this.vld, this.shelfMode ? this.nm : null);
        this.tableModel = new SortableRowTableModel((RowDataSource)this.dataSource, columnRendererArray);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.tableModel.initTable(this.table);
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.getButtonBar(), "South");
        this.setEditDeleteEnabled(false);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.inited = true;
    }

    public void dispose() {
        this.vld.deleteObserver((Observer)((Object)this));
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    protected JPanel getButtonBar() {
        this.createPB = new JButton("Create...");
        this.createPB.addActionListener(this);
        this.enableComponent(this.createPB, (IModel)this.nm);
        this.deletePB = new JButton("Delete...");
        this.deletePB.addActionListener(this);
        this.enableComponent(this.deletePB, (IModel)this.nm);
        JPanel jPanel = VirtualLinkPane.createHorizontalPanel(null);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this.createPB);
        cSHelpButtonPane.addLeft(this.deletePB);
        jPanel.add(cSHelpButtonPane);
        return jPanel;
    }

    protected void clearTableSelection() {
        if (this.table != null && this.dataSource.getRowCount() != 0) {
            this.table.removeRowSelectionInterval(0, this.dataSource.getRowCount() - 1);
        }
    }

    protected void setEditDeleteEnabled(boolean bl) {
        if (!this.isUserAuthorized()) {
            bl = false;
        }
        if (!bl) {
            this.clearTableSelection();
        }
        this.deletePB.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    public void update(Observable observable, Object object) {
        db.fine("update(" + observable + ", " + object + ")");
        if (observable instanceof VirtualLinksDirector && this.inited) {
            this.refresh();
        }
    }

    public void enteringPage() {
        block3: {
            try {
                if (!this.inited) {
                    this.init();
                }
                this.refresh();
            }
            catch (Exception exception) {
                if (!VirtualLinkPane.db.on) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
        this.dataSource.refresh(this);
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.dataSource.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
        if (db.on()) {
            db.fine("refresh: " + this.dataSource.getRowCount() + " PPC returned");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.setEditDeleteEnabled(!listSelectionModel.isSelectionEmpty());
    }

    private void deleteVlinks(IVirtualLinkModel[] iVirtualLinkModelArray) {
        if (iVirtualLinkModelArray == null || iVirtualLinkModelArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_TERM_TYPE_SELECTED_PARAM_1, (Object)"Provisionable Patchcords");
            return;
        }
        db.info("Deleting " + iVirtualLinkModelArray.length + " patchcords.");
        ArrayList<IVirtualLinkModel> arrayList = new ArrayList<IVirtualLinkModel>();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
            IVirtualLinkModel iVirtualLinkModel = iVirtualLinkModelArray[i];
            db.info("Deleting " + iVirtualLinkModel + " ...");
            try {
                VirtualLinksDirector.deletionSanityCheck(iVirtualLinkModel);
                try {
                    this.vld.deleteVirtualLink(iVirtualLinkModel.getOrigNode(), iVirtualLinkModel.getOrigVLID());
                }
                catch (NoSuchVirtualLink noSuchVirtualLink) {
                    if (VirtualLinkPane.db.on) {
                        SDebug.printStackTrace((Throwable)noSuchVirtualLink);
                    }
                    db.println("Deleting of orig. node (" + iVirtualLinkModel + ") failed:\n" + noSuchVirtualLink.getMessage());
                }
                try {
                    this.vld.deleteVirtualLink(iVirtualLinkModel.getTermNode(), iVirtualLinkModel.getTermVLID());
                }
                catch (NoSuchVirtualLink noSuchVirtualLink) {
                    if (VirtualLinkPane.db.on) {
                        SDebug.printStackTrace((Throwable)noSuchVirtualLink);
                    }
                    db.println("Deleting of term. node (" + iVirtualLinkModel + ") failed:\n" + noSuchVirtualLink.getMessage());
                }
                arrayList.add(iVirtualLinkModel);
                continue;
            }
            catch (ResourceInUse resourceInUse) {
                if (VirtualLinkPane.db.on) {
                    SDebug.printStackTrace((Throwable)resourceInUse);
                }
                VirtualLinkPane.addFailureReason(NEMC.EID_PPC_IN_USE_BY_CIRCUIT, iVirtualLinkModel, arrayList2);
                bl = true;
                continue;
            }
            catch (NetCmsCommFailException netCmsCommFailException) {
                if (VirtualLinkPane.db.on) {
                    SDebug.printStackTrace((Throwable)((Object)netCmsCommFailException));
                }
                VirtualLinkPane.addFailureReason(NEMC.EID_NODE_COMM_FAILURE, iVirtualLinkModel, arrayList2);
                bl = true;
                continue;
            }
            catch (Exception exception) {
                if (VirtualLinkPane.db.on) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                VirtualLinkPane.addFailureReason(NEMC.EID_VIRTUAL_LINK_DELETE_FAILED, iVirtualLinkModel, arrayList2);
                bl = true;
            }
        }
        if (bl) {
            this.refresh();
        }
        db.info("Handling " + arrayList2.size() + " term deletion failures (" + arrayList.size() + " successes)");
        VirtualLinkPane.handleFailures((Component)((Object)this), arrayList, arrayList2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            VirtualLinkCreationDialog virtualLinkCreationDialog = this.getVirtualLinkCreationDialog();
            if (this.shelfMode) {
                virtualLinkCreationDialog.setShelfMode(this.nm);
            }
            virtualLinkCreationDialog.show();
        } else if (object == this.deletePB) {
            int[] nArray = this.table.getSelectedRows();
            Object[] objectArray = new IVirtualLinkModel[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n >= this.dataSource.getRowCount()) continue;
                objectArray[i] = (IVirtualLinkModel)this.tableModel.getValueAt(n, 0);
            }
            VlinkDeletionConfirmDialog vlinkDeletionConfirmDialog = new VlinkDeletionConfirmDialog(objectArray);
            vlinkDeletionConfirmDialog.show();
            if (vlinkDeletionConfirmDialog.isOk()) {
                this.deleteVlinks((IVirtualLinkModel[])objectArray);
            }
        }
    }

    private ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[6];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = this.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    private ColumnRenderer createColumnRenderer(int n) {
        VirtualLinkColumnRenderer virtualLinkColumnRenderer = null;
        switch (n) {
            case 0: {
                virtualLinkColumnRenderer = new VirtualLinkColumnRenderer(n, 75, true, 2);
                break;
            }
            case 1: {
                virtualLinkColumnRenderer = new VirtualLinkColumnRenderer(n, 100, true, 2);
                break;
            }
            case 2: {
                virtualLinkColumnRenderer = new VirtualLinkColumnRenderer(n, 250, true, 2);
                break;
            }
            case 3: {
                virtualLinkColumnRenderer = new VirtualLinkColumnRenderer(n, 75, true, 2);
                break;
            }
            case 4: {
                virtualLinkColumnRenderer = new VirtualLinkColumnRenderer(n, 100, true, 2);
                break;
            }
            case 5: {
                virtualLinkColumnRenderer = new VirtualLinkColumnRenderer(n, 250, true, 2);
            }
        }
        return virtualLinkColumnRenderer;
    }

    protected static void addFailureReason(EID eID, IVirtualLinkModel iVirtualLinkModel, ArrayList arrayList) {
        if (arrayList != null) {
            arrayList.add(iVirtualLinkModel.toString() + ":\n" + ErrorMsg.getString((EID)eID));
        }
    }

    protected static void handleFailures(Component component, ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2.size() > 0) {
            int n;
            ImageIcon imageIcon = CerentDialog.WARNING_ICON;
            String string = "";
            String string2 = "";
            int n2 = arrayList2.size();
            imageIcon = CerentDialog.FATAL_ICON;
            string = NEMC.EID_PPC_NOT_DELETED.getComposedMessage();
            string2 = string2 + n2 + " " + PluralisationUtil.s("Patchcord", n2) + " " + PluralisationUtil.s("was", n2) + " not deleted, as follows:\n";
            for (n = 0; n < arrayList2.size(); ++n) {
                string2 = string2 + (String)arrayList2.get(n) + "\n";
            }
            string2 = string2 + "\n";
            if (arrayList.size() > 0) {
                n = arrayList.size();
                string2 = string2 + "However, " + n + " " + PluralisationUtil.s("Patchcord", n) + " " + PluralisationUtil.s("was", n) + " deleted as follows:\n";
                for (int i = 0; i < arrayList.size(); ++i) {
                    IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)arrayList.get(i);
                    string2 = string2 + iVirtualLinkModel.toString() + "\n";
                }
            }
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(component), (String)"Error Processing Patchcords");
            detailedDialog.setText(string, imageIcon);
            detailedDialog.append(string2);
            detailedDialog.setSize(500, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.VirtualLinkPane;
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
    }

    protected class VlinkDeletionConfirmDialog {
        protected boolean ok = false;
        protected Object[] vlinksToDelete;

        public VlinkDeletionConfirmDialog(Object[] objectArray) {
            this.vlinksToDelete = objectArray;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void show() {
            String string = "Really delete selected Provisionable " + PluralisationUtil.s("Patchcord", this.vlinksToDelete.length) + "?";
            Object[] objectArray = new Object[]{new JLabel(string)};
            JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 0, CerentDialog.QUESTION_ICON);
            JDialog jDialog = jOptionPane.createDialog((Component)((Object)VirtualLinkPane.this), "Delete Provisionable " + PluralisationUtil.s("Patchcord", this.vlinksToDelete.length));
            jDialog.show();
            if (jOptionPane.getValue() != null && (Integer)jOptionPane.getValue() == 0) {
                this.ok = true;
            }
        }
    }

    protected class VirtualLinkColumnRenderer
    extends AbstractColumnRenderer {
        public static final int VL_ORIG_VLID_INDEX = 0;
        public static final int VL_ORIG_NODE_INDEX = 1;
        public static final int VL_ORIG_SLPO_INDEX = 2;
        public static final int VL_TERM_VLID_INDEX = 3;
        public static final int VL_TERM_NODE_INDEX = 4;
        public static final int VL_TERM_SLPO_INDEX = 5;
        public static final int COLUMN_NO = 6;

        public VirtualLinkColumnRenderer(int n, int n2, boolean bl, int n3) {
            super(columnNames[n], n2, bl, n3);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)object;
            object = this.getColumnContents(iVirtualLinkModel, n2);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            return defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String getColumnContents(IVirtualLinkModel iVirtualLinkModel, int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = Short.toString(iVirtualLinkModel.getOrigVLID());
                    break;
                }
                case 3: {
                    string = Short.toString(iVirtualLinkModel.getTermVLID());
                    break;
                }
                case 1: {
                    string = VirtualLinkPane.this.vld.getNodeNameByIp(iVirtualLinkModel.getOrigNode());
                    break;
                }
                case 4: {
                    string = VirtualLinkPane.this.vld.getNodeNameByIp(iVirtualLinkModel.getTermNode());
                    break;
                }
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer("");
                    IEntityModel iEntityModel = iVirtualLinkModel.getOrigEntity();
                    if (iEntityModel != null && iEntityModel.getModuleModel() != null) {
                        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(VirtualLinkPane.this.nm).createEntityCellRenderer(iEntityModel.getModuleModel());
                        INodeModel iNodeModel = iEntityModel.getNodeModel();
                        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                            stringBuffer.append(iEntityCellRenderer.getString((Object)iEntityModel, "shelf "));
                        } else {
                            stringBuffer.append(iEntityCellRenderer.getString((Object)iEntityModel, "slot "));
                        }
                    } else {
                        stringBuffer.append("Unknown");
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 5: {
                    StringBuffer stringBuffer = new StringBuffer("");
                    IEntityModel iEntityModel = iVirtualLinkModel.getTermEntity();
                    if (iEntityModel != null && iEntityModel.getModuleModel() != null) {
                        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(VirtualLinkPane.this.nm).createEntityCellRenderer(iEntityModel.getModuleModel());
                        INodeModel iNodeModel = iEntityModel.getNodeModel();
                        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                            stringBuffer.append(iEntityCellRenderer.getString((Object)iEntityModel, "shelf "));
                        } else {
                            stringBuffer.append(iEntityCellRenderer.getString((Object)iEntityModel, "slot "));
                        }
                    } else {
                        stringBuffer.append("Unknown");
                    }
                    string = stringBuffer.toString();
                }
            }
            return string;
        }

        public int compareColumn(Object object, Object object2, int n) {
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)object;
            IVirtualLinkModel iVirtualLinkModel2 = (IVirtualLinkModel)object2;
            String string = this.getColumnContents(iVirtualLinkModel, n);
            String string2 = this.getColumnContents(iVirtualLinkModel2, n);
            return string.compareTo(string2);
        }
    }
}

