/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingDataSource;
import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrUnprovisionException;
import cerent.cms.model.blsr.ExistingProtectionSwitchException;
import cerent.cms.model.blsr.LockOutSpanException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.blsr.BlsrRingColumnRenderer;
import cerent.cms.ui.blsr.RingCreationDialog;
import cerent.cms.ui.blsr.RingEditDialog;
import cerent.cms.ui.blsr.RingUpgradeDialog;
import cerent.cms.ui.circuits.ByNameTable;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class BlsrRingsPane
extends AbstractPane
implements ActionListener,
TableModelListener,
ListSelectionListener,
MouseListener {
    private String BLSR_TERM;
    public static String CREATE = "Create...";
    public static final String DELETE = "Delete";
    public static final String EDIT = "Edit...";
    public static final String UPGRADE = "Upgrade to 4-Fiber...";
    private UScrollPane scrollPane;
    private JPanel buttons;
    private JButton createPB;
    private JButton deletePB;
    private JButton editPB;
    private JButton upgradePB;
    private SortableRowTableModel model;
    private BlsrRingDataSource source;
    private boolean inited = false;
    private TDMTerminology tdmTerm;
    private boolean a2FTo4FUpgradeAttempted = false;
    private static final SDebug db = new SDebug("BlsrRingsPane");

    public BlsrRingsPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    public void enteringPage() {
        if (BlsrRingsPane.db.on) {
            db.println(">>> enteringPage()");
        }
        if (!this.inited) {
            if (db.on()) {
                db.println("initializing");
            }
            this.tdmTerm = this.getUiModel().getNodeModel().getTDMTerminology();
            this.BLSR_TERM = this.tdmTerm.getRingTerms(1);
            this.buttons = this.getButtonPane();
            this.source = new BlsrRingDataSource();
            this.model = new SortableRowTableModel((RowDataSource)this.source, BlsrRingColumnRenderer.createTableRenderers(0), BlsrRingModel.class);
            this.table = new ByNameTable(this.model);
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.scrollPane.getViewport().setScrollMode(1);
            this.add((Component)this.scrollPane, "Center");
            this.add(this.buttons, "South");
            this.inited = true;
        } else if (this.a2FTo4FUpgradeAttempted) {
            BlsrRingManager.instance().remove();
            BlsrRingDataSource blsrRingDataSource = new BlsrRingDataSource();
            this.model.setDataSource((RowDataSource)blsrRingDataSource);
            this.source = blsrRingDataSource;
            this.a2FTo4FUpgradeAttempted = false;
        }
        this.table.addMouseListener(this);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.model.addTableModelListener(this);
        this.syncButtons();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        if (BlsrRingsPane.db.on) {
            db.println("<<< enteringPage()");
        }
    }

    public void leavingPage() throws Exception {
        if (BlsrRingsPane.db.on) {
            db.println(">>> leavingPage()");
        }
        this.table.removeMouseListener(this);
        this.table.getSelectionModel().removeListSelectionListener(this);
        this.model.removeTableModelListener(this);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (BlsrRingsPane.db.on) {
            db.println("<<< leavingPage()");
        }
    }

    public void refresh() {
        if (db.on()) {
            db.println("refresh called");
        }
    }

    public void destroy() {
        if (BlsrRingsPane.db.on) {
            db.println(">>> destroy()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            if (null != this.source) {
                this.source.destroy();
            }
            if (null != this.model) {
                this.model.removeTableModelListener(this);
                this.model = null;
            }
            if (null != this.table) {
                this.table = null;
            }
        }
        super.destroy();
        if (BlsrRingsPane.db.on) {
            db.println("<<< destroy()");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (BlsrRingsPane.db.on) {
            db.println(">>> actionPerformed(e=" + actionEvent + ")");
        }
        if ((object = actionEvent.getSource()) == this.createPB) {
            this.startRingCreationWizard();
        } else if (object == this.deletePB) {
            BlsrRingModel blsrRingModel;
            block23: {
                blsrRingModel = null;
                try {
                    blsrRingModel = (BlsrRingModel)this.table.getValueAt(this.table.getSelectedRow(), 0);
                }
                catch (ClassCastException classCastException) {
                    if (!BlsrRingsPane.db.on) break block23;
                    db.println("ClassCastException caught trying to delete a BlsrRingModel: " + classCastException);
                }
            }
            if (null != blsrRingModel) {
                if (blsrRingModel.hasProtectionOp()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_DELETE_RING_MSG);
                } else {
                    StringBuffer stringBuffer = new StringBuffer("Are you sure you want to delete the " + this.BLSR_TERM + " named " + blsrRingModel.getRingName() + "?\n");
                    boolean bl = false;
                    if (blsrRingModel.hasDriConnections()) {
                        stringBuffer.append("\nNOTE: There is at least one DRI circuit on this " + this.BLSR_TERM + ".\n");
                        bl = true;
                    }
                    if (blsrRingModel.hasPCAConnections() && blsrRingModel.getBlsrRingInfo().isFourFiber()) {
                        stringBuffer.append("\nNOTE: If you proceed, PCA circuits on this " + this.BLSR_TERM + " will display " + "PARTIAL status,\n" + "but PCA traffic will " + "still flow.\n");
                        bl = true;
                    }
                    if (bl) {
                        stringBuffer.append("\nOK to continue?");
                    }
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirm Ring Deletion")) {
                        try {
                            blsrRingModel.delete();
                        }
                        catch (ExistingProtectionSwitchException existingProtectionSwitchException) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_EXISTING_PROTECTION_SWITCH_PARAM_1, (Object)this.BLSR_TERM);
                        }
                        catch (LockOutSpanException lockOutSpanException) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_DELETE_RING_MSG);
                        }
                        catch (BlsrUnprovisionException blsrUnprovisionException) {
                            BlsrNode[] blsrNodeArray = blsrUnprovisionException.getBlsrNodes();
                            StringBuffer stringBuffer2 = new StringBuffer();
                            for (int i = 0; i < blsrNodeArray.length; ++i) {
                                stringBuffer2.append(blsrNodeArray[i] + "\n");
                            }
                            ErrorMsg.displayError((Component)((Object)this), NEMC.EID_NODES_COULD_NOT_BE_UNPROVISIONED_PARAM_2, stringBuffer2, this.BLSR_TERM);
                        }
                    }
                }
            }
        } else if (object == this.editPB) {
            this.editBlsrAtRow(this.table.getSelectedRow());
        } else if (object == this.upgradePB) {
            this.startRingUpgradeWizard();
        }
        this.syncButtons();
        if (BlsrRingsPane.db.on) {
            db.println("<<< actionPerformed(e=" + actionEvent + ")");
        }
    }

    private void editBlsrAtRow(int n) {
        BlsrRingModel blsrRingModel;
        block5: {
            if (BlsrRingsPane.db.on) {
                db.println(">>> editBlsrRowAt(row=" + n + ")");
            }
            blsrRingModel = null;
            try {
                blsrRingModel = (BlsrRingModel)this.table.getValueAt(n, 0);
            }
            catch (ClassCastException classCastException) {
                if (!BlsrRingsPane.db.on) break block5;
                db.println("ClassCastException caught trying to edit a BlsrRingModel: " + classCastException);
            }
        }
        if (null != blsrRingModel) {
            RingEditDialog ringEditDialog = RingEditDialog.instance(blsrRingModel);
            ringEditDialog.setVisible(true);
        }
        if (BlsrRingsPane.db.on) {
            db.println("<<< editBlsrRowAt(row=" + n + ")");
        }
    }

    private void startRingCreationWizard() {
        RingCreationDialog ringCreationDialog = RingCreationDialog.instance((Component)((Object)this), this.getUiModel().getNodeModel(), 0, this.tdmTerm);
        ringCreationDialog.show();
        if (BlsrRingsPane.db.on) {
            db.println("<<< startRingCreationWizard()");
        }
    }

    private void startRingUpgradeWizard() {
        BlsrRingModel blsrRingModel;
        if (BlsrRingsPane.db.on) {
            db.println(">>> startRingUpgradeWizard()");
        }
        if ((blsrRingModel = (BlsrRingModel)this.table.getValueAt(this.table.getSelectedRow(), 0)) != null) {
            try {
                BlsrRingManager blsrRingManager = BlsrRingManager.instance();
                if (!blsrRingModel.isRingInUpgradeableState()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_UPGRAGE_RING_PARAM_1, (Object)("A " + this.BLSR_TERM + " that is being deleted cannot be upgraded."));
                } else if (!blsrRingModel.isRingSpeedAdequateForUpgrade()) {
                    ErrorMsg.displayError((Component)((Object)this), NEMC.EID_INADEQUATE_RING_SPEED_FOR_UPGRADE_PARAM_2, this.tdmTerm.getTermForPhysicalLink(2), this.BLSR_TERM);
                } else if (blsrRingModel.getNonUpgradableNodes().length > 0) {
                    BlsrNode[] blsrNodeArray = blsrRingModel.getNonUpgradableNodes();
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    for (int i = 0; i < blsrNodeArray.length; ++i) {
                        stringBuffer.append(blsrNodeArray[i].getNodeModel().getName());
                        if (!bl && blsrNodeArray[i].isFourFiber()) {
                            bl = true;
                        }
                        if (i + 1 >= blsrNodeArray.length) continue;
                        stringBuffer.append(", ");
                    }
                    if (bl) {
                        ErrorMsg.displayError((Component)((Object)this), NEMC.EID_ONE_FOUR_FIBER_MAX_PARAM_2, this.BLSR_TERM, stringBuffer);
                    } else {
                        ErrorMsg.displayError((Component)((Object)this), NEMC.EID_NON_UPGRADEABLE_NODES_PARAM_2, this.BLSR_TERM, stringBuffer);
                    }
                } else {
                    RingUpgradeDialog ringUpgradeDialog = RingUpgradeDialog.instance((JComponent)((Object)this), blsrRingModel);
                    ringUpgradeDialog.show();
                    this.a2FTo4FUpgradeAttempted = true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_UPGRAGE_RING_PARAM_1, (Object)illegalStateException.getMessage());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                String string = abstractCmsIOException.getMessage();
                if (string == null) {
                    string = abstractCmsIOException.toString();
                }
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_UPGRAGE_RING_PARAM_1, (Object)("Communication failure: " + string));
            }
        }
        if (BlsrRingsPane.db.on) {
            db.println("<<< startRingUpgradeWizard()");
        }
    }

    private JPanel getButtonPane() {
        if (BlsrRingsPane.db.on) {
            db.println(">>> getButtonPane()");
        }
        this.createPB = this.makeActionButton(CREATE);
        this.deletePB = this.makeActionButton(DELETE);
        this.editPB = this.makeActionButton(EDIT);
        this.upgradePB = this.makeActionButton(UPGRADE);
        this.enableComponent(this.editPB, this.getUiModel(), SecurityLevel.MAINTENANCE);
        this.enableComponent(this.createPB);
        this.deletePB.setEnabled(false);
        this.editPB.setEnabled(false);
        this.upgradePB.setEnabled(false);
        JPanel jPanel = BlsrRingsPane.createHorizontalPanel(null);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel2.add(this.createPB);
        jPanel2.add(this.editPB);
        jPanel2.add(this.deletePB);
        jPanel2.add(this.upgradePB);
        jPanel3.add(new CSHelpButton(NetCSHelpConst.BlsrRingsPane));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        if (BlsrRingsPane.db.on) {
            db.println("<<< getButtonPane()");
        }
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.enableComponent(jButton);
        return jButton;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (BlsrRingsPane.db.on) {
            db.println(">>> tableChanged(e=" + tableModelEvent + ")");
        }
        if (db.on()) {
            db.println("\nTableModelEvent recieved: " + tableModelEvent);
            int n = tableModelEvent.getType();
            String string = "UNKNOWN";
            switch (n) {
                case -1: {
                    string = "DELETE";
                    break;
                }
                case 0: {
                    string = "UPDATE";
                    break;
                }
                case 1: {
                    string = "INSERT";
                }
            }
            db.println("type=" + string + ", first row=" + tableModelEvent.getFirstRow() + ", last row=" + tableModelEvent.getLastRow());
        }
        this.syncButtons();
        if (BlsrRingsPane.db.on) {
            db.println("<<< tableChanged(e=" + tableModelEvent + ")");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (BlsrRingsPane.db.on) {
            db.println(">>> valueChanged()");
        }
        if (db.on()) {
            db.println("ListSelectionEvent received: " + listSelectionEvent + "  getValueIsAdjusting is: " + listSelectionEvent.getValueIsAdjusting());
        }
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.syncButtons();
        }
        if (BlsrRingsPane.db.on) {
            db.println("<<< valueChanged()");
        }
    }

    private void syncButtons() {
        if (BlsrRingsPane.db.on) {
            db.println(">>> syncButtons()");
        }
        this.enableComponent(this.createPB);
        if (this.table != null) {
            if (BlsrRingsPane.db.on) {
                db.println("table is not null...");
            }
            if (this.table.getSelectedRowCount() == 1) {
                BlsrRingModel blsrRingModel = (BlsrRingModel)this.table.getValueAt(this.table.getSelectedRow(), 0);
                if (BlsrRingsPane.db.on) {
                    db.println("There is one row selected (ring = " + blsrRingModel + ")");
                }
                if (blsrRingModel != null) {
                    if (BlsrRingsPane.db.on) {
                        db.println("The ring is not null...");
                    }
                    this.editPB.setEnabled(true);
                    this.enableComponent(this.deletePB);
                    if (blsrRingModel.isUpgradableTo4Fiber()) {
                        this.enableComponent(this.upgradePB);
                    } else {
                        this.upgradePB.setEnabled(false);
                    }
                } else {
                    this.disableAllButtons();
                }
            } else {
                this.disableAllButtons();
            }
        } else {
            this.disableAllButtons();
        }
        if (BlsrRingsPane.db.on) {
            db.println("<<< syncButtons()");
        }
    }

    private void disableAllButtons() {
        if (BlsrRingsPane.db.on) {
            db.println(">>> disableAllButtons()");
        }
        this.editPB.setEnabled(false);
        this.deletePB.setEnabled(false);
        this.upgradePB.setEnabled(false);
        if (BlsrRingsPane.db.on) {
            db.println("<<< disableAllButtons()");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.editBlsrAtRow(n);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

