/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.TablePrintRegionDialog;
import cerent.cms.ui.blsr.BlsrEditMap;
import cerent.cms.ui.blsr.BlsrMapLink;
import cerent.cms.ui.blsr.BlsrMapNode;
import cerent.cms.ui.blsr.IBlsrMapPane;
import cerent.cms.ui.blsr.RedRingProvPane;
import cerent.cms.ui.blsr.RingEditTabbedView;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.ComponentPrinter;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.TablePrintPane;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class RingEditDialog
extends TablePrintPane
implements IBlsrMapPane,
ActionListener {
    private static HashMap allRingEditFrames = new HashMap();
    private static final SDebug db = new SDebug("RingEditDialog");
    private static TDMTerminology tdmTerm;
    private static final String PREF = "ctc.RingEditDialog";
    private static final String XPOS = "x";
    private static final String YPOS = "y";
    private static final String WIDTH = "w";
    private static final String HEIGHT = "h";
    private static final Dimension INIT_DIM;
    private BlsrRingModel ringModel;
    private BlsrEditMap editMap;
    private RingEditTabbedView ringEditTabbedView;
    private BlsrRingModelNodeAddedObserver nodeAddedObserver;
    private BlsrRingModelNodeRemovedObserver nodeRemovedObserver;
    private BlsrRingModelSpanAddedObserver spanAddedObserver;
    private BlsrRingModelSpanRemovedObserver spanRemovedObserver;
    private BlsrRingModelStateChangeObserver ringModelStateChangeObserver;
    private BlsrRingModelReversionChangeObserver ringModelReversionChangeObserver;
    private BlsrMapNode selectedNode = null;
    private BlsrMapLink selectedLink = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RingEditDialog instance(BlsrRingModel blsrRingModel) {
        RingEditDialog ringEditDialog;
        HashMap hashMap = allRingEditFrames;
        synchronized (hashMap) {
            ringEditDialog = (RingEditDialog)allRingEditFrames.get(blsrRingModel);
            if (ringEditDialog != null) {
                return ringEditDialog;
            }
            ringEditDialog = new RingEditDialog(blsrRingModel);
            allRingEditFrames.put(blsrRingModel, ringEditDialog);
        }
        try {
            Preferences preferences = Preferences.instance();
            int n = preferences.getInt(PREF, XPOS, -1);
            int n2 = preferences.getInt(PREF, YPOS, 0);
            int n3 = preferences.getInt(PREF, WIDTH, RingEditDialog.INIT_DIM.width);
            int n4 = preferences.getInt(PREF, HEIGHT, RingEditDialog.INIT_DIM.height);
            if (n == -1) {
                ringEditDialog.setSize(new Dimension(n3, n4));
            } else {
                ringEditDialog.setBounds(n, n2, n3, n4);
            }
        }
        catch (Exception exception) {
            ringEditDialog.setSize(INIT_DIM);
        }
        ringEditDialog.setDialogTitle();
        return ringEditDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeEditWindow(BlsrRingModel blsrRingModel) {
        db.fine("closeEditWindow was called.");
        if (blsrRingModel != null) {
            RingEditDialog ringEditDialog;
            Object object = allRingEditFrames;
            synchronized (object) {
                ringEditDialog = (RingEditDialog)allRingEditFrames.get(blsrRingModel);
                if (ringEditDialog != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ringEditDialog.dispose();
                        }
                    });
                }
            }
            object = ErrorMsg.getString((EID)NEMC.WID_BLSR_RING_CHANGE_PARAM_2, (Object)(tdmTerm != null ? tdmTerm.getRingTerms(1) : "BLSR"), (Object)blsrRingModel.getRingName());
            ringEditDialog = new DetailedLog(1, (String)object);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)ringEditDialog);
        }
    }

    private RingEditDialog(BlsrRingModel blsrRingModel) {
        super(null, "Ring Edit Dialog");
        this.setDefaultCloseOperation(0);
        this.ringModel = blsrRingModel;
        BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
        tdmTerm = blsrNodeArray.length > 0 ? blsrNodeArray[0].getNodeModel().getTDMTerminology() : null;
        this.initContentPane();
        this.setDialogTitle();
        this.updateButtons();
    }

    protected void initContentPane() {
        Container container = this.getContentPane();
        this.ringEditTabbedView = new RingEditTabbedView(this.ringModel, this);
        this.ringEditTabbedView.showAndCatchException();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)this.ringEditTabbedView), "Center");
        if (this.editMap == null) {
            this.editMap = new BlsrEditMap(this, tdmTerm);
            this.editMap.getGraphWindow().setBorder(BorderFactory.createLoweredBevelBorder());
        }
        this.editMap.init(this);
        this.nodeAddedObserver = new BlsrRingModelNodeAddedObserver();
        this.ringModel.getNodeAddedNotifier().addObserver(this.nodeAddedObserver);
        this.nodeRemovedObserver = new BlsrRingModelNodeRemovedObserver();
        this.ringModel.getNodeRemovedNotifier().addObserver(this.nodeRemovedObserver);
        this.spanAddedObserver = new BlsrRingModelSpanAddedObserver();
        this.ringModel.getSpanAddedNotifier().addObserver(this.spanAddedObserver);
        this.spanRemovedObserver = new BlsrRingModelSpanRemovedObserver();
        this.ringModel.getSpanRemovedNotifier().addObserver(this.spanRemovedObserver);
        this.ringModelStateChangeObserver = new BlsrRingModelStateChangeObserver();
        this.ringModel.getStateChangeNotifier().addObserver(this.ringModelStateChangeObserver);
        this.ringModelReversionChangeObserver = new BlsrRingModelReversionChangeObserver();
        this.ringModel.getReversionChangeNotifier().addObserver(this.ringModelReversionChangeObserver);
        this.editMap.showBlsr();
        container.add((Component)this.editMap.getGraphWindow(), "Center");
        container.add((Component)jPanel, "South");
        this.pack();
        this.editMap.setViewToCenter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        db.fine("dispose() called.");
        this.setVisible(false);
        Cloneable cloneable = allRingEditFrames;
        synchronized (cloneable) {
            allRingEditFrames.remove(this.ringModel);
        }
        if (this.ringModel != null) {
            this.ringModel.getNodeAddedNotifier().deleteObserver(this.nodeAddedObserver);
            this.ringModel.getNodeRemovedNotifier().deleteObserver(this.nodeRemovedObserver);
            this.ringModel.getSpanAddedNotifier().deleteObserver(this.spanAddedObserver);
            this.ringModel.getSpanRemovedNotifier().deleteObserver(this.spanRemovedObserver);
            this.ringModel.getStateChangeNotifier().deleteObserver(this.ringModelStateChangeObserver);
            this.ringModel.getReversionChangeNotifier().deleteObserver(this.ringModelReversionChangeObserver);
            this.ringModel = null;
        }
        if (this.ringEditTabbedView != null) {
            this.ringEditTabbedView.destroy();
            this.ringEditTabbedView = null;
        }
        if (this.editMap != null) {
            this.editMap.dispose();
        }
        cloneable = this.getBounds();
        Preferences preferences = Preferences.instance();
        preferences.setProperty(PREF, XPOS, Integer.toString(((Rectangle)cloneable).x));
        preferences.setProperty(PREF, YPOS, Integer.toString(((Rectangle)cloneable).y));
        preferences.setProperty(PREF, WIDTH, Integer.toString(((Rectangle)cloneable).width));
        preferences.setProperty(PREF, HEIGHT, Integer.toString(((Rectangle)cloneable).height));
        this.getContentPane().removeAll();
        this.getRootPane().removeAll();
        this.removeAll();
        db.fine("calling super.dispose()");
        super.dispose();
        db.fine("returned from calling super.dispose()");
    }

    private void disposeByUser() throws Exception {
        db.fine("disposeByUser() called");
        if (this.ringEditTabbedView != null) {
            try {
                this.ringEditTabbedView.setShowing(false);
            }
            catch (LeavePageException leavePageException) {
                db.fine("dispose: canceled by user");
                return;
            }
            this.dispose();
        }
    }

    public void refreshProvPane() {
        block6: {
            db.fine("refreshProvPane was called.");
            try {
                if (this.ringEditTabbedView != null) {
                    if (this.ringEditTabbedView.getRedRingProvPane() != null) {
                        this.ringEditTabbedView.getRedRingProvPane().refreshFromModel();
                    } else {
                        db.fine("getRedRingProvPane() returned null");
                    }
                } else {
                    db.fine("ringEditTabbedView is null");
                }
            }
            catch (Exception exception) {
                db.fine("Exception caught: " + exception);
                if (!RingEditDialog.db.on) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void setDialogTitle() {
        db.fine("setDialogTitle was called.");
        String string = " ";
        if (tdmTerm != null) {
            string = tdmTerm.getRingTerms(1);
        }
        if (null != this.ringModel) {
            this.setTitle(string + " : " + this.ringModel.getRingName() + "  " + this.ringModel.getStateString());
        } else {
            this.setTitle("ERROR: " + string + " does not exist!");
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        block2: {
            try {
                this.disposeByUser();
            }
            catch (Exception exception) {
                db.fine("Caught " + exception + " when closing dialog.");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.editMap != null) {
            // empty if block
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        if (this.editMap != null) {
            // empty if block
        }
    }

    public BlsrRingModel getBlsrRingModel() {
        return this.ringModel;
    }

    public void clicked(MapNode mapNode) {
    }

    public void doubleClicked(MapNode mapNode) {
    }

    public void clicked(MapLink mapLink) {
    }

    public void doubleClicked(MapLink mapLink) {
    }

    public void clicked(MapDomain mapDomain) {
    }

    public void doubleClicked(MapDomain mapDomain) {
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        if (bl) {
            if (mapNode instanceof BlsrMapNode) {
                this.selectedNode = (BlsrMapNode)mapNode;
                this.selectedLink = null;
            } else {
                this.selectedNode = null;
                this.selectedLink = null;
            }
        } else {
            this.selectedNode = null;
        }
        this.updateButtons();
    }

    public void linkSelected(MapLink mapLink, boolean bl) {
        if (bl) {
            this.selectedLink = (BlsrMapLink)mapLink;
            this.selectedNode = null;
        } else {
            this.selectedLink = null;
        }
        this.updateButtons();
    }

    public void setLinkState(MapLink mapLink, int n) {
        db.fine("setLinkState was called -- stubbed out here.");
    }

    private void updateButtons() {
        RedRingProvPane redRingProvPane;
        if (null != this.ringEditTabbedView && null != (redRingProvPane = this.ringEditTabbedView.getRedRingProvPane())) {
            if (this.selectedLink != null) {
                redRingProvPane.getAddNodeWizardButton().setEnabled(true);
                redRingProvPane.getRemoveNodeWizardButton().setEnabled(false);
            } else if (this.selectedNode != null) {
                redRingProvPane.getAddNodeWizardButton().setEnabled(false);
                redRingProvPane.getRemoveNodeWizardButton().setEnabled(true);
            } else {
                redRingProvPane.getAddNodeWizardButton().setEnabled(false);
                redRingProvPane.getRemoveNodeWizardButton().setEnabled(false);
            }
        }
    }

    public void updatePrintableTable(JTable jTable) {
        this.setTable(jTable);
        if (jTable != null) {
            this.initAdapter(jTable);
        }
    }

    protected Printable getPrintableObject() {
        TablePrintRegionDialog tablePrintRegionDialog = new TablePrintRegionDialog(null, "PRINT", true, true, this.getTable());
        tablePrintRegionDialog.pack();
        int n = tablePrintRegionDialog.showDialog();
        if (n == 0) {
            int n2 = tablePrintRegionDialog.getPrintRegionSelection();
            if (n2 == 0) {
                return new ComponentPrinter((Component)this);
            }
            if (n2 == 1) {
                return new ComponentPrinter((Component)((Object)this.ringEditTabbedView));
            }
            return this.getTableContentPrinter();
        }
        return null;
    }

    protected void initAdapter(JTable jTable) {
        this.setAdapter(new TableModelAdapter(jTable.getModel(), jTable));
    }

    private void maybeShowOspfMessage() {
        Long l;
        if (null != this.ringModel && null != (l = this.ringModel.getOspfArea()) && l.equals(BlsrRingModel.OSPF_AREA_INCONSISTENT)) {
            ErrorMsg.displayWarning(this, (EID)NEMC.WID_INCONSISTANT_OSPF_AREA_IDS);
        }
    }

    public void setVisible(boolean bl) {
        db.fine("setVisible: " + bl);
        super.setVisible(bl);
        if (bl) {
            this.maybeShowOspfMessage();
        }
    }

    static {
        INIT_DIM = new Dimension(800, 600);
    }

    private class BlsrRingModelReversionChangeObserver
    implements Observer {
        private BlsrRingModelReversionChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            db.fine("BlsrRingModel ring reversion or span reversion has changed.");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RingEditDialog.this.refreshProvPane();
                }
            });
        }
    }

    private class BlsrRingModelStateChangeObserver
    implements Observer {
        private BlsrRingModelStateChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            BlsrRingModel blsrRingModel = (BlsrRingModel)object;
            String string = blsrRingModel.getStateString() + "(" + blsrRingModel.getState() + ")";
            db.fine("BlsrRingModel has changed: state=" + string + ", ringId=" + blsrRingModel.getRingName());
            if (666 == blsrRingModel.getState()) {
                RingEditDialog.closeEditWindow(blsrRingModel);
            } else {
                RingEditDialog.this.setDialogTitle();
            }
        }
    }

    private class BlsrRingModelSpanRemovedObserver
    implements Observer {
        private BlsrRingModelSpanRemovedObserver() {
        }

        public void update(Observable observable, Object object) {
            BlsrSpan blsrSpan = (BlsrSpan)object;
            db.fine("BlsrRingModel span removed: " + blsrSpan);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != RingEditDialog.this.editMap) {
                        RingEditDialog.this.editMap.showBlsr();
                    }
                }
            });
        }
    }

    private class BlsrRingModelSpanAddedObserver
    implements Observer {
        private BlsrRingModelSpanAddedObserver() {
        }

        public void update(Observable observable, Object object) {
            BlsrSpan blsrSpan = (BlsrSpan)object;
            db.fine("BlsrRingModel node removed: " + blsrSpan);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != RingEditDialog.this.editMap) {
                        RingEditDialog.this.editMap.showBlsr();
                    }
                }
            });
        }
    }

    private class BlsrRingModelNodeRemovedObserver
    implements Observer {
        private BlsrRingModelNodeRemovedObserver() {
        }

        public void update(Observable observable, Object object) {
            BlsrNode blsrNode = (BlsrNode)object;
            db.fine("BlsrRingModel node removed: " + blsrNode);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != RingEditDialog.this.editMap) {
                        RingEditDialog.this.editMap.showBlsr();
                    }
                }
            });
        }
    }

    private class BlsrRingModelNodeAddedObserver
    implements Observer {
        private BlsrRingModelNodeAddedObserver() {
        }

        public void update(Observable observable, Object object) {
            BlsrNode blsrNode = (BlsrNode)object;
            db.fine("BlsrRingModel node added: " + blsrNode);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != RingEditDialog.this.editMap) {
                        RingEditDialog.this.editMap.showBlsr();
                    }
                }
            });
        }
    }
}

