/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.RevertiveBehaviorCellEditor;
import cerent.cms.ui.RevertiveBehaviorRenderer;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.blsr.RingUpgradeDialog;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;

public class RudSpanReversionPane
extends WizardPane {
    private RingUpgradeDialog parent;
    private BlsrRingModel ringModel;
    private UScrollPane scrollPane;
    private JLabel spanRevLabel = new JLabel("Span Reversion:");
    private UComboBox spanRevCB = RevertiveBehaviorCellEditor.getComboBox(true);
    private boolean inited = false;
    private static final SDebug db = new SDebug("RudSpanReversionPane");

    public RudSpanReversionPane(String string, RingUpgradeDialog ringUpgradeDialog) {
        super(string, ringUpgradeDialog);
        this.parent = ringUpgradeDialog;
        this.setLayout(new BorderLayout());
    }

    protected boolean okToProceed() {
        return true;
    }

    public void validatePage() throws Exception {
        if (RudSpanReversionPane.db.on) {
            db.println("validatePage() called.");
        }
        this.parent.setSpanReversion((IRevertiveBehavior)this.spanRevCB.getSelectedItem());
    }

    public void refresh() throws Exception {
        if (RudSpanReversionPane.db.on) {
            db.println("refresh() called");
        }
        this.ringModel = this.parent.getBlsrRingModel();
        this.setSelectionForSpanReversion();
        this.parent.setNextEnabled(true);
        this.parent.setFinishEnabled(false);
    }

    private void setSelectionForSpanReversion() {
        int n = -1;
        IRevertiveBehavior iRevertiveBehavior = null;
        IRevertiveBehavior iRevertiveBehavior2 = null;
        if (null != this.ringModel) {
            if (RudSpanReversionPane.db.on) {
                db.println("ringModel is not null");
            }
            if (null != (iRevertiveBehavior = this.ringModel.getSpanReversion())) {
                n = iRevertiveBehavior.getReversionTime();
                if (RudSpanReversionPane.db.on) {
                    db.println("span reversion from BlsrRingModel is: " + n);
                }
            }
        }
        if (n == -1 && null != this.parent) {
            n = this.parent.getSpanReversionPreference();
            if (RudSpanReversionPane.db.on) {
                db.println("span reversion from preferences is: " + n);
            }
        }
        if (n == -1) {
            n = 300;
            if (RudSpanReversionPane.db.on) {
                db.println("Setting span reversion time to the the default value of 30");
            }
        }
        int n2 = 1;
        ComboBoxModel comboBoxModel = this.spanRevCB.getModel();
        if (null != comboBoxModel) {
            int n3 = comboBoxModel.getSize();
            for (int i = 0; i < n3; ++i) {
                iRevertiveBehavior2 = (IRevertiveBehavior)comboBoxModel.getElementAt(i);
                if (iRevertiveBehavior2.getReversionTime() != n) continue;
                n2 = i;
                if (!RudSpanReversionPane.db.on) continue;
                db.println("index of reversion time in ComboBox is: " + n2);
            }
        }
        this.spanRevCB.setSelectedIndex(n2);
    }

    public void dispose() {
        if (RudSpanReversionPane.db.on) {
            db.println("dispose() called");
        }
        this.removeAll();
        if (this.scrollPane != null) {
            this.scrollPane = null;
        }
        super.dispose();
    }

    public void enteringPage() throws Exception {
        if (RudSpanReversionPane.db.on) {
            db.println("enteringPage() called");
        }
        super.enteringPage();
        if (!this.inited) {
            this.initialize();
        }
        this.setSelectionForSpanReversion();
        this.parent.setNextEnabled(true);
        this.parent.setFinishEnabled(false);
    }

    public void leavingPage() throws Exception {
        if (RudSpanReversionPane.db.on) {
            db.println("leavingPage() called");
        }
        IRevertiveBehavior iRevertiveBehavior = (IRevertiveBehavior)this.spanRevCB.getSelectedItem();
        this.parent.putSpanReversionPreference(iRevertiveBehavior.getReversionTime());
        if (RudSpanReversionPane.db.on) {
            db.println("span reversion time written to prefs is: " + iRevertiveBehavior.getReversionTime());
        }
        super.leavingPage();
    }

    private void initialize() {
        if (RudSpanReversionPane.db.on) {
            db.println("initialize() called");
        }
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchor(17);
        gridBagPanel.inset(5, 10);
        gridBagPanel.add((Component)this.spanRevLabel, 1, 5);
        gridBagPanel.add((Component)this.spanRevCB, 2, 5);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(gridBagPanel);
        box.add(Box.createHorizontalGlue());
        this.add(box, "Center");
        this.parent.setNextEnabled(true);
        this.inited = true;
    }

    public String getStatusText() {
        if (RudSpanReversionPane.db.on) {
            db.println("getStatusText() called");
        }
        String string = new String();
        string = "Ring name: " + this.ringModel.getRingName();
        string = string + "\n\nRing Reversion: \n";
        string = string + RevertiveBehaviorRenderer.getString(this.ringModel.getRingReversion());
        string = string + "\n\nSpan Reversion: \n";
        string = string + RevertiveBehaviorRenderer.getString((IRevertiveBehavior)this.spanRevCB.getSelectedItem());
        return string;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RudSpanReversionPane;
    }
}

