/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetAdminState;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.topo.Network;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.Preferences;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.TextPanel;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public abstract class AbstractCcdAttrsPane
extends WzCcdPane {
    private static final String TL1_MODE_MSG = "By selecting this option:\n\n- You will not be able to select E-series Ethernet\n  cards as the circuit source or destination.\n\n- Nodes that do not support cross-connection\n  naming will ignore the \"Name\" field.\n";
    private static final String TL1_MODE_TITLE = "TL1-Style Circuit Creation";
    private static final String PREF_TL1_MODE_VALUE = "tl1ckt";
    private static final String PREF_TL1_MODE_DESCR = "Circuit Creation: TL1-Style Circuits created as UPGRADABLE";
    private static final int MAX_CKT_NUM = 9999;
    private static final int CKT_NAME_LEN = 48;
    protected static final int LABEL_WIDTH = 45;
    protected static final int TEXT_WIDTH = 80;
    protected CircuitTypeAttr circuitTypeAttr;
    protected CircuitNameAttr circuitNameAttr;
    protected CircuitSizeAttr circuitSizeAttr;
    protected BiDirAttr biDirAttr;
    protected DiagAttr diagAttr;
    protected AdminStateAttr adminStateAttr;
    protected TL1ModeAttr tl1ModeAttr;
    protected UpsrAttr upsrAttr;
    protected DropProtAttr dropProtAttr;
    private static final AttributeMaps attrMap = NetworkDefaults.getAttributeMap();
    private CircuitCreatInfo circuitInfo;
    private String circuitName;
    private int circuitType;
    private int circuitSize;
    private boolean circuitBiDir;
    private boolean circuitTL1Compatible;
    private int adminState;
    private int portsState;
    private boolean portGrouping;
    private boolean dropProtection;
    private IRevertiveBehavior upsrReversion;
    private Attribute upsrSfBerLevel;
    private Attribute upsrSdBerLevel;
    private boolean upsrSwitchOnPdip;
    private boolean upsrGoReturnRouting;

    public AbstractCcdAttrsPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string) {
        super(abstractCircuitDialog, wzDiagDebug, string);
        this.initVars();
    }

    protected void initVars() {
        this.circuitName = "";
        this.circuitBiDir = true;
        this.portGrouping = false;
        this.dropProtection = false;
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.circuitInfo;
    }

    public String getCircuitName() {
        return this.circuitName;
    }

    public int getCircuitType() {
        return this.circuitType;
    }

    public void setCircuitType(int n) {
        this.circuitType = n;
    }

    public int getCircuitSize() {
        return this.circuitSize;
    }

    public void setCircuitSize(int n) {
        this.circuitSize = n;
    }

    public boolean isCircuitBiDir() {
        return this.circuitBiDir;
    }

    public boolean isCircuitTL1Compatible() {
        return this.circuitTL1Compatible;
    }

    public void setCircuitTL1Compatible(boolean bl) {
        this.circuitTL1Compatible = bl;
    }

    public int getAdminState() {
        return this.adminState;
    }

    public void setAdminState(int n) {
        this.adminState = n;
    }

    public int getPortsState() {
        return this.portsState;
    }

    public void setPortsState(int n) {
        this.portsState = n;
    }

    public boolean getPortGrouping() {
        return this.portGrouping;
    }

    public void setPortGrouping(boolean bl) {
        this.portGrouping = bl;
    }

    public boolean getDropProtection() {
        return this.dropProtection;
    }

    public boolean getUpsrGoReturnRouting() {
        return this.upsrGoReturnRouting;
    }

    public void setUpsrGoReturnRouting(boolean bl) {
        this.upsrGoReturnRouting = bl;
        if (this.upsrAttr != null) {
            this.upsrAttr.goReturnRoutingCB.setSelected(bl);
            if (this.db.on()) {
                this.db.println("setUpsrGoReturnRouting() updated widget to " + bl);
            }
            Preferences preferences = Preferences.instance();
            this.getAbstractCktDlg();
            this.getAbstractCktDlg();
            preferences.setBoolean("ctc.circuit.creation", "upsrGoReturnRouting", bl);
        }
    }

    public boolean getUpsrSwitchOnPdip() {
        return this.upsrSwitchOnPdip;
    }

    public void setUpsrSwitchOnPdip(boolean bl) {
        this.upsrSwitchOnPdip = bl;
        if (this.upsrAttr != null) {
            this.upsrAttr.swOnPdipCB.setSelected(this.upsrSwitchOnPdip);
            if (this.db.on()) {
                this.db.println("setUpsrSwitchOnPdip() updated the widget to " + bl);
            }
            Preferences preferences = Preferences.instance();
            this.getAbstractCktDlg();
            this.getAbstractCktDlg();
            preferences.setBoolean("ctc.circuit.creation", "pdip", bl);
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        return this.upsrReversion;
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        this.upsrReversion = iRevertiveBehavior;
        if (this.upsrAttr != null && this.upsrReversion != null) {
            this.upsrAttr.upsrRBP.setRevertiveBehavior(this.upsrReversion);
            if (this.db.on()) {
                this.db.println("setUpsrReversion() updated the widget.");
            }
            Preferences preferences = Preferences.instance();
            this.getAbstractCktDlg();
            this.getAbstractCktDlg();
            preferences.setBoolean("ctc.circuit.creation", "revertive", this.upsrReversion.getReversionMode() == 2);
            this.getAbstractCktDlg();
            this.getAbstractCktDlg();
            preferences.setInt("ctc.circuit.creation", "revertTime", this.upsrReversion.getReversionTime());
        }
    }

    public Attribute getUpsrSfBerLevel() {
        return this.upsrSfBerLevel;
    }

    public void setUpsrSfBerLevel(Attribute attribute) {
        this.upsrSfBerLevel = attribute;
        if (this.upsrAttr != null && attribute != null) {
            this.upsrAttr.sfThCB.setSelectedItem((Object)this.upsrSfBerLevel);
        }
    }

    public Attribute getUpsrSdBerLevel() {
        return this.upsrSdBerLevel;
    }

    public void setUpsrSdBerLevel(Attribute attribute) {
        this.upsrSdBerLevel = attribute;
        if (this.upsrAttr != null && attribute != null) {
            this.upsrAttr.sdThCB.setSelectedItem((Object)this.upsrSdBerLevel);
        }
    }

    public void setCircuitInfo(CircuitCreatInfo circuitCreatInfo) {
        this.circuitInfo = circuitCreatInfo;
    }

    public void setCircuitName(String string) {
        this.circuitName = string;
    }

    public boolean isGoReturnRoutingSpecified() {
        return this.upsrAttr != null ? this.upsrAttr.goReturnRoutingSelected : false;
    }

    protected DefaultComboBoxModel getCircuitSizeCBModel(int n) {
        FramingType[] framingTypeArray = Network.instance().getSupportedFramingTypes();
        Object[] objectArray = CircuitSize.getCircuitSizes((int)n, (FramingType[])framingTypeArray);
        Arrays.sort(objectArray);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        return defaultComboBoxModel;
    }

    public void enteringPane() {
        super.enteringPane();
        if (this.circuitNameAttr != null) {
            this.circuitNameAttr.nameTP.requestFocus();
        }
    }

    protected String getNextPaneName() {
        this.getAbstractCktDlg().writeCircuitPrefs();
        if (this.parent instanceof UnprotectedToUpsrDialog) {
            this.getAbstractCktDlg();
            return "Circuit Routing Preferences";
        }
        this.getAbstractCktDlg();
        return "Source";
    }

    public void revalidateData() {
        boolean bl;
        boolean bl2;
        int n;
        block19: {
            int n2;
            if (this.upsrAttr != null) {
                this.upsrAttr.upsrRBP.setRevertiveBehavior(this.upsrReversion);
                this.upsrAttr.sfThCB.setSelectedItem((Object)this.upsrSfBerLevel);
                this.upsrAttr.sdThCB.setSelectedItem((Object)this.upsrSdBerLevel);
                this.upsrAttr.swOnPdipCB.setSelected(this.upsrSwitchOnPdip);
                this.upsrAttr.goReturnRoutingCB.setSelected(this.upsrGoReturnRouting);
            }
            if (this.parent instanceof UnprotectedToUpsrDialog) {
                return;
            }
            if (this.circuitInfo == null) {
                n2 = this.circuitSize;
                n = this.adminState;
                bl2 = this.getAbstractCktDlg().applyDropPortsPref;
                bl = this.circuitBiDir;
            } else {
                n2 = this.circuitInfo.size();
                n = this.circuitInfo.adminState();
                bl2 = this.getAbstractCktDlg().applyDropPorts;
                boolean bl3 = bl = this.circuitInfo.dir() == 1;
            }
            if (this.circuitNameAttr != null) {
                this.circuitNameAttr.setCircuitName(this.circuitName);
            }
            if (this.circuitSizeAttr != null) {
                try {
                    this.circuitSizeAttr.sizeCB.setSelectedItem((Object)CircuitSize.getCircuitSize((int)n2));
                }
                catch (Exception exception) {
                    this.circuitSizeAttr.sizeCB.setSelectedIndex(-1);
                    if (!this.db.on()) break block19;
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (this.biDirAttr != null) {
            this.biDirAttr.bidirCB.setSelected(bl);
        }
        if (this.adminStateAttr != null) {
            this.adminStateAttr.adminStatePanel.setAdminState(n);
            this.adminStateAttr.adminStatePanel.setApplyDropPorts(bl2);
        }
        if (this.dropProtAttr != null) {
            this.dropProtAttr.dropProtCB.setSelected(this.dropProtection);
        }
        if (this.tl1ModeAttr != null) {
            if (this.circuitInfo == null) {
                this.tl1ModeAttr.tl1ModeCB.setSelected(this.circuitTL1Compatible);
            } else if (this.circuitInfo != null && this.circuitInfo.monitor()) {
                this.tl1ModeAttr.tl1ModeCB.setSelected(false);
                this.tl1ModeAttr.tl1ModeCB.setEnabled(false);
            }
        }
        if (this.circuitInfo != null && this.circuitInfo.monitor()) {
            if (this.circuitSizeAttr != null) {
                this.circuitSizeAttr.sizeCB.setEnabled(false);
            }
            if (this.biDirAttr != null) {
                this.biDirAttr.bidirCB.setEnabled(false);
            }
            if (this.adminStateAttr != null) {
                this.adminStateAttr.adminStatePanel.disableAll();
            }
        }
    }

    public void validatePage() throws Exception {
        ICircuitSize iCircuitSize;
        ICircuitType iCircuitType;
        int n;
        if (this.upsrAttr != null) {
            this.upsrReversion = this.upsrAttr.getReversion();
            this.upsrSfBerLevel = this.upsrAttr.getSfBerLevel();
            if (this.upsrSfBerLevel == null) {
                throw new Exception("SF Threshold must be specified");
            }
            this.upsrSdBerLevel = this.upsrAttr.getSdBerLevel();
            if (this.upsrSdBerLevel == null) {
                throw new Exception("SD Threshold must be specified");
            }
            this.upsrSwitchOnPdip = this.upsrAttr.getSwitchOnPdip();
            this.upsrGoReturnRouting = this.upsrAttr.getGoReturnRouting();
        }
        if (this.parent instanceof UnprotectedToUpsrDialog) {
            return;
        }
        if (this.circuitNameAttr != null) {
            this.circuitName = this.circuitNameAttr.getCircuitName();
        }
        if (this.circuitSizeAttr != null) {
            if (this.circuitSizeAttr.getCircuitSize() == CircuitSize.UNDEFINED_SIZE) {
                throw new Exception("Circuit Size must be specified");
            }
            this.circuitSize = this.circuitSizeAttr.getCircuitSize();
        }
        if (this.biDirAttr != null) {
            this.circuitBiDir = this.biDirAttr.getBiDir();
        }
        if (this.adminStateAttr != null) {
            this.adminState = this.adminStateAttr.adminStatePanel.getAdminState();
            this.portsState = this.adminStateAttr.adminStatePanel.getPortsState();
            this.getAbstractCktDlg().applyDropPorts = this.adminStateAttr.adminStatePanel.isDropPortsSelected();
            this.getAbstractCktDlg().applyDropPortsPref = this.adminStateAttr.adminStatePanel.getApplyDropPorts();
        }
        this.circuitTL1Compatible = this.tl1ModeAttr != null ? this.tl1ModeAttr.isTL1Compatible() : false;
        String string = this.circuitName;
        if (this.circuitName.length() > 0 && this.getAbstractCktDlg().circuitCount > 1) {
            string = this.circuitName + ":" + CircuitMapUtil.circuitSuffix(this.getAbstractCktDlg().circuitNumber);
        }
        if (this.circuitInfo == null) {
            this.circuitInfo = new CircuitCreatInfo(this.circuitType, this.circuitSize, this.circuitBiDir ? 1 : 0, false, string, this.adminState, this.circuitTL1Compatible);
        } else {
            this.circuitInfo.setName(string);
            this.circuitInfo.setType(this.circuitType);
            this.circuitInfo.setSize(this.circuitSize);
            this.circuitInfo.setDir(this.circuitBiDir ? 1 : 0);
            this.circuitInfo.setAdminState(this.adminState);
            this.circuitInfo.setTL1Compatible(this.circuitTL1Compatible);
        }
        this.circuitInfo.isDiag(this.diagAttr != null && this.diagAttr.getDiag());
        this.circuitInfo.setTrafficDir(this.upsrGoReturnRouting);
        if (this.dropProtAttr != null) {
            this.dropProtection = this.dropProtAttr.getDropProtection();
        }
        if (this.circuitType != CircuitType.UNDEFINED_TYPE && this.circuitSize != CircuitSize.UNDEFINED_SIZE && this.getAbstractCktDlg().autoRange && this.getAbstractCktDlg().circuitCount > (n = this.getMaxAutoRangedCircuits(iCircuitType = CircuitType.getCircuitType((int)this.circuitType), iCircuitSize = CircuitSize.getCircuitSize((int)this.circuitSize)))) {
            this.displayMaxAutoRangedDialog(iCircuitType, iCircuitSize, n);
            this.getAbstractCktDlg().circuitCount = n;
        }
        if (this.db.on()) {
            this.db.println("circuitName=" + string);
            this.db.println("circuitType=" + this.circuitType);
            this.db.println("circuitSize=" + this.circuitSize);
            this.db.println("biDir=" + this.circuitBiDir);
            this.db.println("AdminState=" + this.adminState);
            this.db.println("PortsState=" + this.portsState);
            this.db.println("tl1Compatible=" + this.circuitTL1Compatible);
            this.db.println("upsrGoReturnRouting=" + this.upsrGoReturnRouting);
            this.db.println("diag circuit=" + this.circuitInfo.isDiag());
        }
    }

    protected void handlePostValidate() {
        AutorangeInfo autorangeInfo = this.getAutorangeInfo();
        if (autorangeInfo != null) {
            autorangeInfo.cktInfo = this.getCircuitInfo();
            if (autorangeInfo.cktInfo != null) {
                ICircuitType iCircuitType = CircuitType.getCircuitType((int)autorangeInfo.cktInfo.type());
                autorangeInfo.isTunnel = iCircuitType.isTunnelCircuitType();
            }
            autorangeInfo.cktBaseName = this.getCircuitName();
            autorangeInfo.upsrSwitchOnPdip = this.getUpsrSwitchOnPdip();
            autorangeInfo.upsrReversion = this.getUpsrReversion();
            autorangeInfo.upsrSfBerLevel = (short)this.getUpsrSfBerLevel().getIntValue();
            autorangeInfo.upsrSdBerLevel = (short)this.getUpsrSdBerLevel().getIntValue();
        }
    }

    protected String[] parseAttr(Object object) {
        String string;
        String[] stringArray = new String[2];
        String string2 = "???";
        String string3 = "???";
        if (object != null && (string = object.toString()) != null) {
            int n = string.indexOf(58);
            string2 = string.substring(0, n + 1);
            string3 = string.substring(n + 1, string.length());
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
        return stringArray;
    }

    protected ArrayList getAttrPairs() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (this.circuitNameAttr != null) {
            arrayList.add(this.parseAttr(this.circuitNameAttr));
        }
        if (this.circuitTypeAttr != null) {
            arrayList.add(this.parseAttr(this.circuitTypeAttr));
        }
        if (this.circuitSizeAttr != null) {
            arrayList.add(this.parseAttr(this.circuitSizeAttr));
        }
        if (this.biDirAttr != null) {
            arrayList.add(this.parseAttr(this.biDirAttr));
        }
        this.parseAdminAttr(arrayList);
        if (this.dropProtAttr != null) {
            arrayList.add(this.parseAttr(this.dropProtAttr));
        }
        if (this.tl1ModeAttr != null) {
            arrayList.add(this.parseAttr(this.tl1ModeAttr));
        }
        if (this.circuitType != 9 && this.circuitType != 14) {
            arrayList.add(new String[]{"Auto-ranging: ", String.valueOf(this.getAbstractCktDlg().autoRange)});
        }
        return arrayList;
    }

    protected void parseAdminAttr(ArrayList arrayList) {
        if (this.adminStateAttr != null && this.adminStateAttr.getUI().isVisible()) {
            arrayList.add(this.parseAttr(this.adminStateAttr.getStateString()));
            arrayList.add(this.parseAttr(this.adminStateAttr.getShortApplyDropString()));
        }
    }

    protected JComponent getStatusComponent() {
        return AbstractCcdAttrsPane.getGridPanel(this.getAttrPairs());
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.circuitNameAttr != null) {
            stringBuffer.append(this.circuitNameAttr.toString());
        }
        if (this.circuitTypeAttr != null) {
            stringBuffer.append("\n" + this.circuitTypeAttr.toString());
        }
        if (this.circuitSizeAttr != null) {
            stringBuffer.append("\n" + this.circuitSizeAttr.toString());
        }
        if (this.biDirAttr != null) {
            stringBuffer.append("\n" + this.biDirAttr.toString());
        }
        if (this.adminStateAttr != null && this.adminStateAttr.getUI().isVisible()) {
            stringBuffer.append("\n" + this.adminStateAttr.toString());
        }
        if (this.dropProtAttr != null) {
            stringBuffer.append("\n" + this.dropProtAttr.toString());
        }
        if (this.tl1ModeAttr != null) {
            stringBuffer.append("\n" + this.tl1ModeAttr.toString());
        }
        if (this.getAbstractCktDlg().autoRange && this.circuitType != 9 && this.circuitType != 14) {
            stringBuffer.append("Auto-ranging: Enabled");
        }
        return stringBuffer.toString();
    }

    private int getMaxAutoRangedCircuits(ICircuitType iCircuitType, ICircuitSize iCircuitSize) {
        int n = 9999;
        block0 : switch (iCircuitType.getEnum()) {
            case 1: {
                this.db.finest("getMaxAutoRangedCirctuits: type = STS_CIRCUIT");
                n = this.getAbstractCktDlg().maxAutoRangedSts;
                break;
            }
            case 2: {
                this.db.finest("getMaxAutoRangedCirctuits: type = VT_CIRCUIT");
                switch (iCircuitSize.getEnum()) {
                    case 0: {
                        n = this.getAbstractCktDlg().maxAutoRangedVt1_5;
                        break;
                    }
                    case 30: {
                        n = this.getAbstractCktDlg().maxAutoRangedVt2;
                    }
                }
                break;
            }
            case 3: {
                this.db.finest("getMaxAutoRangedCirctuits: type = VT_TUNNEL");
                break;
            }
            case 7: {
                this.db.finest("getMaxAutoRangedCirctuits: type = VT_AGGREGATION");
                break;
            }
            case 4: {
                this.db.finest("getMaxAutoRangedCirctuits: type = VC_HO_PATH_CIRCUIT");
                n = this.getAbstractCktDlg().maxAutoRangedVcHo;
                break;
            }
            case 5: {
                this.db.finest("getMaxAutoRangedCirctuits: type = VC_LO_PATH_CIRCUIT");
                switch (iCircuitSize.getEnum()) {
                    case 11: {
                        n = this.getAbstractCktDlg().maxAutoRangedVcLoVc3;
                        break block0;
                    }
                    case 10: {
                        n = this.getAbstractCktDlg().maxAutoRangedVcLoVc12;
                        break block0;
                    }
                    case 9: {
                        n = this.getAbstractCktDlg().maxAutoRangedVcLoVc11;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                this.db.finest("getMaxAutoRangedCirctuits: type = VC_LO_PATH_TUNNEL");
                break;
            }
            case 8: {
                this.db.finest("getMaxAutoRangedCirctuits: type = VC_LO_PATH_AGGREGATION");
                break;
            }
            default: {
                this.db.finest("getMaxAutoRangedCircuits: type = <other>");
            }
        }
        return n;
    }

    private void displayMaxAutoRangedDialog(ICircuitType iCircuitType, ICircuitSize iCircuitSize, int n) {
        String string = iCircuitType.getProtocolIndepCktTypeStr();
        String string2 = iCircuitSize.getCircuitSizeString();
        String string3 = "The maximum number of auto-ranged circuits for " + string + " (" + string2 + ") is " + n + ".\n\n" + "You can manually create more than " + n + " circuits by unchecking Auto-ranged.";
        CerentDialog.infoDialog((Component)this, (String)string3, (String)"Maximum Auto-ranged Circuits");
    }

    public void removeListeners() {
        if (this.upsrAttr != null) {
            this.upsrAttr.removeListeners();
        }
        super.removeListeners();
    }

    public void dispose() {
        this.circuitTypeAttr = null;
        this.circuitNameAttr = null;
        this.circuitSizeAttr = null;
        this.biDirAttr = null;
        this.adminStateAttr = null;
        this.tl1ModeAttr = null;
        this.upsrAttr = null;
        this.dropProtAttr = null;
        this.diagAttr = null;
        this.circuitInfo = null;
        this.upsrReversion = null;
        this.upsrSfBerLevel = null;
        this.upsrSdBerLevel = null;
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Circuit Info: " + this.circuitInfo + "\n");
        stringBuffer.append("Circuit Name: " + this.circuitName + "\n");
        stringBuffer.append("Circuit Type: " + this.circuitType + "\n");
        stringBuffer.append("Circuit Size: " + this.circuitSize + "\n");
        stringBuffer.append("Circuit BiDir: " + this.circuitBiDir + "\n");
        stringBuffer.append("Circuit TL1 Compat: " + this.circuitTL1Compatible + "\n");
        if (this.diagAttr != null) {
            stringBuffer.append("Circuit is diag: " + this.diagAttr.getDiag() + "\n");
        }
        stringBuffer.append("Admin State: " + this.adminState + "\n");
        stringBuffer.append("Ports State: " + this.portsState + "\n");
        stringBuffer.append("Port Grouping: " + this.portGrouping + "\n");
        stringBuffer.append("Drop Protection: " + this.dropProtection + " \n");
        stringBuffer.append("UPSR Reversion: " + this.upsrReversion);
        if (this.upsrReversion != null) {
            stringBuffer.append("\tMode= " + this.upsrReversion.getReversionMode() + "\tTime= " + this.upsrReversion.getReversionTime());
        }
        stringBuffer.append("\n");
        stringBuffer.append("UPSR SF BER: " + this.upsrSfBerLevel);
        if (this.upsrSfBerLevel != null) {
            stringBuffer.append(" => " + this.upsrSfBerLevel.getIntValue());
        }
        stringBuffer.append("\n");
        stringBuffer.append("UPSR SD BER: " + this.upsrSdBerLevel);
        if (this.upsrSdBerLevel != null) {
            stringBuffer.append(" => " + this.upsrSdBerLevel.getIntValue());
        }
        stringBuffer.append("\n");
        stringBuffer.append("Switch UPSR on PDIP: " + this.upsrSwitchOnPdip + "\n");
        stringBuffer.append("UPSR Go Return Routing: " + this.upsrGoReturnRouting + "\n");
        return stringBuffer.toString();
    }

    class CircuitSizeCBRenderer
    extends DefaultListCellRenderer {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();

        CircuitSizeCBRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.renderer = (DefaultListCellRenderer)this.renderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.renderer.setText(AbstractCcdAttrsPane.this.getAbstractCktDlg().ckt.getCircuitSizeObj().getCircuitSizeString());
            } else if (object != null && object instanceof ICircuitSize) {
                this.renderer.setText(((ICircuitSize)object).getCircuitSizeString());
            }
            return this.renderer;
        }
    }

    class UpsrAttr
    implements ActionListener {
        protected RevertiveBehaviorPanel upsrRBP;
        protected JCheckBox swOnPdipCB;
        protected UComboBox sfThCB;
        protected UComboBox sdThCB;
        protected JCheckBox goReturnRoutingCB;
        private JPanel p = WzPane.createVerticalPanel(null);
        protected boolean goReturnRoutingSelected;

        UpsrAttr() {
            this.p.setAlignmentX(0.0f);
            JPanel jPanel = WzPane.createHorizontalPanel(null);
            this.goReturnRoutingCB = new JCheckBox("Provision working go & return on primary path");
            jPanel.add(this.goReturnRoutingCB);
            this.goReturnRoutingCB.addActionListener(this);
            this.p.add(jPanel);
            this.upsrRBP = new RevertiveBehaviorPanel(null);
            this.p.add(this.upsrRBP);
            jPanel = WzPane.createHorizontalPanel(null);
            jPanel.add(new JLabel("SF threshold: "));
            this.sfThCB = new UComboBox((Object[])attrMap.getAttributeArray("declareSfBerLevel"));
            jPanel.add((Component)this.sfThCB);
            this.p.add(jPanel);
            jPanel = WzPane.createHorizontalPanel(null);
            jPanel.add(new JLabel("SD threshold: "));
            if (AbstractCcdAttrsPane.this.circuitType == 2 || AbstractCcdAttrsPane.this.circuitType == 11) {
                this.sdThCB = new UComboBox((Object[])attrMap.getAttributeArray("declareVTSdBerLevel"));
                jPanel.add((Component)this.sdThCB);
            } else {
                this.sdThCB = new UComboBox((Object[])attrMap.getAttributeArray("declareSdBerLevel"));
                jPanel.add((Component)this.sdThCB);
            }
            this.p.add(jPanel);
            jPanel = WzPane.createHorizontalPanel(null);
            this.swOnPdipCB = new JCheckBox("Switch on " + CircuitMapUtil.PDIP_TERM, false);
            jPanel.add(this.swOnPdipCB);
            this.p.add(jPanel);
        }

        public void removeListeners() {
            if (this.goReturnRoutingCB != null) {
                this.goReturnRoutingCB.removeActionListener(this);
            }
        }

        public JPanel getUI() {
            return this.p;
        }

        public void setUpsrComponents(TDMTerminology tDMTerminology, boolean bl, boolean bl2, boolean bl3) {
            this.p.setBorder(BorderFactory.createTitledBorder(tDMTerminology.getRingTerms(0)));
            this.upsrRBP.setRevertiveEnabled(bl);
            if (!bl) {
                this.upsrRBP.setRevertive(false);
            }
            this.sfThCB.setEnabled(bl2);
            this.sdThCB.setEnabled(bl2);
            this.swOnPdipCB.setEnabled(bl3);
            if (!bl3) {
                this.swOnPdipCB.setSelected(false);
            }
        }

        public IRevertiveBehavior getReversion() {
            return this.upsrRBP.getRevertiveBehavior();
        }

        public Attribute getSfBerLevel() {
            return (Attribute)this.sfThCB.getSelectedItem();
        }

        public Attribute getSdBerLevel() {
            return (Attribute)this.sdThCB.getSelectedItem();
        }

        public boolean getSwitchOnPdip() {
            return this.swOnPdipCB.isSelected();
        }

        public boolean getGoReturnRouting() {
            return this.goReturnRoutingCB.isSelected();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.goReturnRoutingSelected |= actionEvent.getSource() == this.goReturnRoutingCB;
        }
    }

    class TL1ModeAttr {
        protected JCheckBox tl1ModeCB;
        private JPanel p = WzPane.createHorizontalPanel(null);

        TL1ModeAttr() {
            this.p.setAlignmentX(0.0f);
            this.tl1ModeCB = new JCheckBox("Create cross-connects only (TL1-like)");
            this.p.add(this.tl1ModeCB);
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.tl1ModeCB.setEnabled(false);
            }
        }

        public JPanel getUI() {
            return this.p;
        }

        public void displayIgnorableDialog() {
            IgnorableDialog.warningDialog((Component)AbstractCcdAttrsPane.this, (String)AbstractCcdAttrsPane.TL1_MODE_MSG, (String)AbstractCcdAttrsPane.TL1_MODE_TITLE, (String)AbstractCcdAttrsPane.PREF_TL1_MODE_VALUE, (String)AbstractCcdAttrsPane.PREF_TL1_MODE_DESCR);
        }

        public boolean isTL1Compatible() {
            return this.tl1ModeCB.isSelected();
        }

        public String toString() {
            if (this.isTL1Compatible()) {
                return "Mode: TL1-like";
            }
            return "";
        }
    }

    class AdminStateAttr {
        protected IAdminStatePanel adminStatePanel = this.getAdminStatePanel();

        AdminStateAttr() {
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.adminStatePanel.setAdminState(AbstractCcdAttrsPane.this.getAbstractCktDlg().ckt.getAdminState());
                this.adminStatePanel.disableAll();
            }
        }

        protected IAdminStatePanel getAdminStatePanel() {
            return new AdminStatePanel("State", CircuitType.getCircuitType((int)AbstractCcdAttrsPane.this.getAbstractCktDlg().getCircuitType()), false);
        }

        public JPanel getUI() {
            return this.adminStatePanel.getPanel();
        }

        public String toString() {
            return this.getStateString() + this.getApplyDropString();
        }

        public String getStateString() {
            return "State: " + NetAdminState.getAdminStateStringFromAdminState(this.adminStatePanel.getAdminState());
        }

        public String getApplyDropString() {
            String string = this.adminStatePanel.getApplyDropPorts() ? "True" : "False";
            return "Apply ckt state to drop ports: " + string;
        }

        public String getShortApplyDropString() {
            String string = this.adminStatePanel.getApplyDropPorts() ? "True" : "False";
            return "Ckt state to drops: " + string;
        }
    }

    class DropProtAttr {
        protected JCheckBox dropProtCB;
        private JPanel p = WzPane.createHorizontalPanel(null);

        DropProtAttr() {
            this.p.setAlignmentX(0.0f);
            this.dropProtCB = new JCheckBox("Protected Drops (non-Ethernet)");
            this.p.add(this.dropProtCB);
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.dropProtCB.setEnabled(false);
            }
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean getDropProtection() {
            return this.dropProtCB.isSelected();
        }

        public String toString() {
            return "Protected Drops: " + (this.getDropProtection() ? "Yes" : "No");
        }
    }

    class DiagAttr {
        protected JCheckBox diagCB;
        private JPanel p = WzPane.createHorizontalPanel(null);

        DiagAttr() {
            this.p.setAlignmentX(0.0f);
            this.diagCB = new JCheckBox("Diagnostic");
            this.p.add(this.diagCB);
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.diagCB.setSelected(AbstractCcdAttrsPane.this.getAbstractCktDlg().ckt.isDiag());
                this.diagCB.setEnabled(false);
            }
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean getDiag() {
            return this.diagCB.isSelected();
        }

        public String toString() {
            return "Diagnostic circuit";
        }
    }

    class BiDirAttr {
        protected JCheckBox bidirCB;
        private JPanel p = WzPane.createHorizontalPanel(null);

        BiDirAttr() {
            this.p.setAlignmentX(0.0f);
            this.bidirCB = new JCheckBox("Bidirectional");
            this.p.add(this.bidirCB);
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.bidirCB.setSelected(AbstractCcdAttrsPane.this.getAbstractCktDlg().ckt.isBidirectional());
                this.bidirCB.setEnabled(false);
            }
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean getBiDir() {
            return this.bidirCB.isSelected();
        }

        public void setEnabled(boolean bl) {
            this.bidirCB.setEnabled(bl);
        }

        public String toString() {
            return "Direction: " + NetworkDefaults.circuitDirectionToString(this.getBiDir() ? 1 : 0);
        }
    }

    class CircuitNameAttr {
        protected TextPanel nameTP = new TextPanel("Name: ", 32);
        private String circuitName = "";

        CircuitNameAttr() {
            JTextField jTextField;
            this.nameTP.setAlignmentX(0.0f);
            JLabel jLabel = this.nameTP.getLabel();
            if (jLabel != null) {
                jLabel.setPreferredSize(new Dimension(45, jLabel.getHeight()));
            }
            if ((jTextField = this.nameTP.getTextField()) != null) {
                jTextField.setPreferredSize(new Dimension(80, jTextField.getPreferredSize().height));
            }
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.setCircuitName(AbstractCcdAttrsPane.this.getAbstractCktDlg().ckt.getCircuitName());
                this.setEnabled(false);
            }
        }

        public void setEnabled(boolean bl) {
            this.nameTP.setEnabled(bl);
        }

        public JPanel getUI() {
            return this.nameTP;
        }

        public void setCircuitName(String string) {
            this.nameTP.setText(string);
        }

        public String getCircuitName() throws Exception {
            this.circuitName = this.nameTP.getText();
            if (AbstractCcdAttrsPane.this.parent instanceof CircuitCreationDialog) {
                int n = 48;
                if (AbstractCcdAttrsPane.this.getAbstractCktDlg().circuitCount > 1) {
                    n -= 1 + CircuitMapUtil.circuitSuffix(AbstractCcdAttrsPane.this.getAbstractCktDlg().circuitNumber).length();
                } else if (AbstractCcdAttrsPane.this.getPortGrouping()) {
                    n -= 5;
                }
                if (this.circuitName.length() > n) {
                    throw new Exception("Circuit name is too long (max " + n + ")");
                }
            }
            return this.circuitName;
        }

        public String toString() {
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                return "Name: " + ((UnprotectedToUpsrDialog)((AbstractCcdAttrsPane)AbstractCcdAttrsPane.this).parent).ckt.getCircuitName();
            }
            return "Name: " + (this.circuitName.length() == 0 ? "<auto-assigned>" : ((CircuitCreationDialog)AbstractCcdAttrsPane.this.parent).getCircuitModdedName());
        }
    }

    class CircuitSizeAttr {
        protected UComboBox sizeCB;
        protected JPanel p;
        protected JLabel lbl;

        protected CircuitSizeAttr() {
        }

        CircuitSizeAttr(int n) {
            int n2 = 120;
            this.p = WzPane.createHorizontalPanel(null);
            this.p.setAlignmentX(0.0f);
            this.lbl = new JLabel("Size: ");
            this.lbl.setPreferredSize(new Dimension(45, this.lbl.getHeight()));
            this.p.add(this.lbl);
            if (n == 9) {
                n2 = 180;
            }
            this.sizeCB = new UComboBox((ComboBoxModel)AbstractCcdAttrsPane.this.getCircuitSizeCBModel(n), n2);
            this.p.add((Component)this.sizeCB);
            this.sizeCB.setRenderer((ListCellRenderer)new CircuitSizeCBRenderer());
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                this.lbl.setEnabled(false);
                this.sizeCB.setEnabled(false);
                AbstractCcdAttrsPane.this.setCircuitSize(AbstractCcdAttrsPane.this.getAbstractCktDlg().ckt.getCircuitSize());
            }
        }

        public JPanel getUI() {
            return this.p;
        }

        public void setEnabled(boolean bl) {
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                return;
            }
            this.lbl.setEnabled(bl);
            this.sizeCB.setEnabled(bl);
        }

        public int getCircuitSize() {
            if (this.sizeCB.getSelectedIndex() == -1) {
                return CircuitSize.UNDEFINED_SIZE;
            }
            return ((CircuitSize)this.sizeCB.getSelectedItem()).getEnum();
        }

        public String toString() {
            if (this.getCircuitSize() != CircuitSize.UNDEFINED_SIZE) {
                ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)this.getCircuitSize());
                return "Size: " + iCircuitSize.getCircuitSizeString();
            }
            return "Size: Unknown";
        }
    }

    class CircuitTypeAttr {
        private TextPanel cktTypeTP;
        private int circuitType;

        CircuitTypeAttr(int n) {
            JTextField jTextField;
            this.circuitType = n;
            this.cktTypeTP = new TextPanel("Type: ", 32);
            this.cktTypeTP.setAlignmentX(0.0f);
            JLabel jLabel = this.cktTypeTP.getLabel();
            if (jLabel != null) {
                jLabel.setPreferredSize(new Dimension(45, jLabel.getHeight()));
            }
            if ((jTextField = this.cktTypeTP.getTextField()) != null) {
                jTextField.setPreferredSize(new Dimension(80, jTextField.getPreferredSize().height));
            }
            this.cktTypeTP.setEnabled(false);
            ICircuitType iCircuitType = null;
            if (AbstractCcdAttrsPane.this.parent instanceof UnprotectedToUpsrDialog) {
                iCircuitType = AbstractCcdAttrsPane.this.getAbstractCktDlg().ckt.getCircuitTypeObj();
                AbstractCcdAttrsPane.this.setCircuitType(iCircuitType.getEnum());
                this.circuitType = iCircuitType.getEnum();
            } else {
                iCircuitType = CircuitType.getCircuitType((int)n);
            }
            this.cktTypeTP.setText(iCircuitType.getProtocolIndepCktTypeStr());
        }

        public JPanel getUI() {
            return this.cktTypeTP;
        }

        public String toString() {
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.circuitType);
            return "Type: " + iCircuitType.getProtocolIndepCktTypeStr();
        }
    }
}

