/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CcdWizardInfo;
import cerent.cms.ui.circuits.CircuitCreationWizard;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractCircuitDialog
extends WzDialog {
    public static final int VIGN_WIDTH = 200;
    public static final String WZPANE_GET_ATTRS = "Circuit Attributes";
    public static final String WZPANE_SOURCE = "Source";
    public static final String WZPANE_DEST = "Destination";
    public static final String WZPANE_GET_VLANS = "Circuit VLAN Selection";
    public static final String WZPANE_GET_ROUTE_PREFS = "Circuit Routing Preferences";
    public static final String WZPANE_GET_VCAT_ROUTE_PREFS = "VCat Circuit Routing Preferences";
    public static final String WZPANE_GET_LO = CircuitMapUtil.LO_TERM + " Matrix Optimization";
    public static final String WZPANE_GET_ROUTE_CONSTR = "Circuit Constraints For Automatic Routing";
    public static final String WZPANE_GET_XM_ROUTE_CONSTR = "Conversion Circuit Constraints For Automatic Routing";
    public static final String WZPANE_REVIEW_EDIT = "Route Review/Edit";
    public static final String WZPANE_LAP_DEST = "LAP Dest";
    public static final String PREF_PATH = "ctc.circuit.creation";
    public static final String PREF_REVERTIVE = "revertive";
    public static final String PREF_REVERT_TIME = "revertTime";
    public static final String PREF_UPSR_GO_RETURN_ROUTING = "upsrGoReturnRouting";
    public static final String PREF_PDIP = "pdip";
    protected INetCircuit ckt;
    private ArrayList relatedCktList = new ArrayList();
    protected CircuitCreationWizard wizard = null;
    protected CcdWizardInfo wizardInfo = null;
    protected UiToolkit uiToolkit = UiToolkit.instance();
    boolean autoRange;
    int circuitCount;
    int circuitNumber;
    public boolean destinationAdded;
    protected boolean applyDropPorts;
    protected boolean applyDropPortsPref;
    int maxAutoRangedSts;
    int maxAutoRangedVt1_5;
    int maxAutoRangedVt2;
    int maxAutoRangedVcHo;
    int maxAutoRangedVcLoVc3;
    int maxAutoRangedVcLoVc12;
    int maxAutoRangedVcLoVc11;
    public static final int FALLBACK_STS_SF_BER = 4;
    public static final int FALLBACK_STS_SD_BER = 6;
    public static final int FALLBACK_VT_SF_BER = 3;
    public static final int FALLBACK_VT_SD_BER = 5;

    public AbstractCircuitDialog(Frame frame, String string, WzDiagDebug wzDiagDebug) {
        this(frame, string, wzDiagDebug, true, true);
    }

    public AbstractCircuitDialog(Frame frame, String string, WzDiagDebug wzDiagDebug, boolean bl) {
        this(frame, string, wzDiagDebug, bl, true);
    }

    public AbstractCircuitDialog(Frame frame, String string, WzDiagDebug wzDiagDebug, boolean bl, boolean bl2) {
        super(frame, string, wzDiagDebug, bl, bl2);
    }

    protected static boolean isSonet() {
        return NetworkModel.instance().getCmsHostModel().getNodeModel().getFramingTypeObj().isSonet();
    }

    public String getPcaWarningMsg() {
        return "Protection Channel Access circuit will be routed\non a " + CircuitMapUtil.BLSR_TERM + " protection channel.  Circuit traffic will be \n" + "pre-empted during a ring or span switch.  If a " + CircuitMapUtil.BLSR_TERM + "\n" + "protection channel is not available, the circuit will be\n" + "routed as an unprotected circuit.";
    }

    public INetCircuit getCircuit() {
        return this.ckt;
    }

    protected ArrayList getRelatedCircuitList() {
        return new ArrayList(this.relatedCktList);
    }

    void addRelatedCircuit(INetCircuit iNetCircuit) {
        if (!this.relatedCktList.contains(iNetCircuit)) {
            this.relatedCktList.add(iNetCircuit);
            if (this.db.on()) {
                this.db.println("added CKT= " + iNetCircuit + " from related ckt list.");
            }
        }
    }

    void removeRelatedCircuit(INetCircuit iNetCircuit) {
        if (this.relatedCktList.contains(iNetCircuit)) {
            this.relatedCktList.remove(iNetCircuit);
            if (this.db.on()) {
                this.db.println("removed CKT= " + iNetCircuit + " from related ckt list.");
            }
        }
    }

    protected void clearRelatedCircuits() {
        if (this.db.on()) {
            Iterator iterator = this.relatedCktList.iterator();
            while (iterator.hasNext()) {
                this.db.println("Removing these circuits from the Related list; they are in no danger of deletion.");
                this.db.println("\t* " + iterator.next().toString());
            }
        }
        this.relatedCktList.clear();
    }

    protected void destroyRelatedCircuits() {
        if (this.db.on()) {
            this.db.println("destroy related circuits, size of " + this.relatedCktList.size());
        }
        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
        Iterator iterator = this.relatedCktList.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            if (this.db.on()) {
                this.db.println("Destroying this related circuit:");
                iNetCircuit.prettyPrint(this.db);
            }
            try {
                iNetCircuit.destroyCircuit();
                arrayList.add(iNetCircuit);
            }
            catch (Exception exception) {
                this.db.println("Could not destroy circuit!");
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        this.relatedCktList.removeAll(arrayList);
    }

    boolean isVlanCapable() throws IncorrectCircuitState {
        if (this.getPortGrouping()) {
            return false;
        }
        return this.getCircuit().isVlanCapable();
    }

    protected boolean isVcatType(int n) {
        if (n == CircuitType.UNDEFINED_TYPE) {
            if (this.db.on()) {
                this.db.println("UNDEFINED_TYPE_ERROR IN getting vcat type");
            }
            return false;
        }
        return CircuitType.getCircuitType((int)n).isVcatCircuitType();
    }

    public boolean isVcatType() {
        return this.isVcatType(this.getCircuitType());
    }

    public boolean isLoCkt() {
        return this.getCircuitInfo().type() == 2 || this.getCircuitInfo().type() == 5 || this.getCircuitInfo().type() == 13 || this.getCircuitInfo().type() == 11;
    }

    public void setFinishEnabled(boolean bl) {
        this.setButtonsEnabled(this.nextButton.isEnabled(), bl);
        if (this.finishButton.isEnabled()) {
            this.finishButton.requestFocus();
        }
    }

    public void setNextEnabled(boolean bl) {
        this.setButtonsEnabled(bl, !bl);
    }

    public void setButtonsEnabled(boolean bl, boolean bl2) {
        super.setButtonsEnabled(bl, bl2);
        if (!this.backButton.isEnabled()) {
            this.backButton.setEnabled(this.wizard != null);
        }
    }

    protected void errorMsgDisplayError() {
        ErrorMsg.displayError((Component)this, (EID)this.getNoRouteEmcErrorId());
    }

    protected void cerentDialogDisplayError(DetailedLog detailedLog) {
        CerentDialog.errorDialog((Component)this, (String)ErrorMsg.getString((EID)this.getNoRouteEmcErrorId()), (String)"Route Error", (DetailedLog)detailedLog, (boolean)false);
    }

    public boolean handleFinishException(Exception exception) {
        Object object;
        if (exception instanceof AnnotatedException) {
            object = (AnnotatedException)((Object)exception);
            exception = object.getChild();
        }
        if (exception instanceof NoRoute) {
            object = (NoRoute)((Object)exception);
            DetailedLog detailedLog = ((NoRoute)((Object)object)).getDetailedLog();
            if (detailedLog == null) {
                this.errorMsgDisplayError();
            } else {
                this.cerentDialogDisplayError(detailedLog);
            }
            return true;
        }
        return super.handleFinishException(exception);
    }

    protected void displayValidationError(Exception exception) {
        if (exception instanceof SanityCheckException) {
            ErrorMsg.displayError(this, NEMC.EID_SANITY_CHECK_FAILED_PARAM_2, ((SanityCheckException)((Object)exception)).getSanityObjects(), AbstractCircuitDialog.closeSentence(exception.getMessage()));
        } else {
            super.displayValidationError(exception);
        }
    }

    protected abstract EID getNoRouteEmcErrorId();

    protected void addDestination(boolean bl) throws Exception {
    }

    protected void deleteDestination() throws Exception {
    }

    protected void destroyCircuit() {
    }

    public void createCircuit() throws Exception {
    }

    public synchronized void setCircuit(INetCircuit iNetCircuit) {
        this.ckt = iNetCircuit;
    }

    void writeCircuitPrefs() {
    }

    protected AbstractCcdAttrsPane getAttrsPane() {
        return (AbstractCcdAttrsPane)this.wzPaneMap.get(WZPANE_GET_ATTRS);
    }

    public abstract boolean getPortGrouping();

    public abstract CircuitCreatInfo getCircuitInfo();

    public abstract boolean getDropProtection();

    public abstract int getCircuitType();

    public int getCircuitSize() {
        if (this.ckt != null) {
            return this.ckt.getCircuitSize();
        }
        return CircuitSize.UNDEFINED_SIZE;
    }

    public INodeModel getSourceNode() {
        return null;
    }

    public INodeModel getAltSourceNode() {
        return null;
    }

    public INodeModel getDestNode() {
        return null;
    }

    public INodeModel getAltDestNode() {
        return null;
    }

    public INetCircuitEnd getSource() {
        return null;
    }

    public INetCircuitEnd getAltSource() {
        return null;
    }

    public INetCircuitEnd getDest() {
        return null;
    }

    public INetCircuitEnd getAltDest() {
        return null;
    }

    public abstract boolean isAutoRoute();

    public abstract boolean isRrbc();

    public abstract boolean isUrn();

    public abstract boolean isPathProt();

    public abstract void setPathProt(boolean var1);

    public abstract RoutePrefs getRoutePrefs();

    public abstract boolean isPca();

    public abstract void setPca(boolean var1);

    public abstract Attribute getUpsrSfBerLevel();

    public abstract Attribute getUpsrSdBerLevel();

    public abstract IRevertiveBehavior getUpsrReversion();

    public abstract void setUpsrReversion(IRevertiveBehavior var1);

    public abstract boolean getUpsrSwitchOnPdip();

    public abstract void setUpsrSwitchOnPdip(boolean var1);

    public abstract ArrayList getVcatMemberPrefs();

    public abstract void setVcatCommonFiberRouting(boolean var1);

    public abstract boolean isVcatCommonFiberRouting();

    public abstract int getVcatTxMembers();

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Net Circuit: " + this.ckt + "\n");
        stringBuffer.append("Wizard: " + this.wizard + "\n");
        stringBuffer.append("Wizard Info: " + this.wizardInfo + "\n");
        stringBuffer.append("AutoRange: " + this.autoRange + "\n");
        stringBuffer.append("Circuit Count (Total): " + this.circuitCount + "\n");
        stringBuffer.append("Circuit Number (Current): " + this.circuitNumber + "\n");
        return stringBuffer.toString();
    }
}

