/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CoreNodeModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.network.AbstractNetworkMap;
import cerent.cms.ui.network.CircuitMapLine;
import cerent.cms.ui.network.CircuitMapLink;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.ColorUtil;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapLine;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public abstract class AbstractCircuitMap
extends AbstractNetworkMap
implements PropertyChangeListener {
    protected INetElement srcNE;
    protected TreeSet circuitNodes;
    public static String PREFS_CIRCUIT_KEY = "ctc.circuits";
    public static String PREFS_ACTIVE_SPAN = "activespan";
    public static String PREFS_STANDBY_SPAN = "standbyspan";
    public static final Color COLOR_DEFAULT_ACTIVE = Color.green;
    public static final Color COLOR_DEFAULT_STANDBY = new Color(128, 0, 192);
    protected boolean showLOT = true;

    public AbstractCircuitMap(SDebug sDebug, int n, IMapFactory iMapFactory) {
        this(sDebug, n, iMapFactory, true);
    }

    public AbstractCircuitMap(SDebug sDebug, int n, IMapFactory iMapFactory, boolean bl) {
        super(sDebug, n, iMapFactory, bl);
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        NetMapLink.LINK_ACTIVE_COLOR = AbstractCircuitMap.getPrefColor(PREFS_ACTIVE_SPAN);
        NetMapLink.LINK_STANDBY_COLOR = AbstractCircuitMap.getPrefColor(PREFS_STANDBY_SPAN);
        this.updateView();
        this.circuitNodes = new TreeSet(new NetElemComparator());
    }

    protected void resetLinks(boolean bl, boolean bl2) {
        this.loTopo = bl;
        this.pcaTopo = bl2;
        this.deleteAllLinks();
        this.initializeMapLinks(this.netModel.getNetLinks());
        Collection collection = this.getLinkUserObjects();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            INetLink iNetLink = (INetLink)e;
            if (iNetLink != null) continue;
            iNetLink = this.findReverseLink(iNetLink);
        }
    }

    protected void resetLinks(boolean bl) {
        this.resetLinks(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNodeMarkers() {
        AbstractCircuitMap abstractCircuitMap = this;
        synchronized (abstractCircuitMap) {
            MapNode[] mapNodeArray = this.getMapNodes();
            for (int i = 0; i < mapNodeArray.length; ++i) {
                MapNode mapNode = mapNodeArray[i];
                if (!this.nodeIsForwardable(mapNode)) continue;
                mapNode.setDesc(null);
            }
        }
    }

    public String getLinkDesc(MapLink mapLink) {
        INetLink iNetLink = (INetLink)mapLink.getUserObject();
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        if (mapLink.isSrcArrowEnabled()) {
            iNetLink = this.findReverseLink(iNetLink);
            iLinkModel = iNetLink.getLinkModel();
        }
        NetMapLink netMapLink = (NetMapLink)mapLink;
        String string = iLinkModel.src() instanceof CoreNodeModel ? iLinkModel.src().getName() : netMapLink.getSrcEntityString();
        String string2 = iLinkModel.dst() instanceof CoreNodeModel ? iLinkModel.dst().getName() : netMapLink.getDstEntityString();
        String string3 = string + " - " + string2;
        if (mapLink.isSrcArrowEnabled()) {
            string3 = string2 + " - " + string;
        }
        return string3 + " (" + netMapLink.getProtectionTypeString() + " " + netMapLink.getLinkTypeString() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jumpToSourceNodeDomain() {
        INodeModel iNodeModel = this.getCktSrcNodeModel();
        if (iNodeModel != null) {
            AbstractCircuitMap abstractCircuitMap = this;
            synchronized (abstractCircuitMap) {
                MapNode[] mapNodeArray = this.getMapNodes();
                for (int i = 0; i < mapNodeArray.length; ++i) {
                    MapNode mapNode = mapNodeArray[i];
                    if (!this.nodeIsForwardable(mapNode) || mapNode.getUserObject() != iNodeModel) continue;
                    this.displayDomain(mapNode.getDomain());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapLink getMapLink(INetLinkSpan iNetLinkSpan) {
        ILinkModel iLinkModel = null;
        ILinkModel iLinkModel2 = null;
        INetLink iNetLink = iNetLinkSpan.getLink();
        INetLink iNetLink2 = iNetLinkSpan.getReverseLink();
        if (iNetLink2 == null) {
            iLinkModel = iNetLink.getLinkModel();
            if (iLinkModel == null) {
                return null;
            }
            this.dbg.finest("getMapLink fwd=" + iLinkModel + "\n" + "srcIdx fwd=" + iLinkModel.srcEntityIndex() + "\n" + "dstIdx fwd=" + iLinkModel.dstEntityIndex() + "\n" + "src fwd=" + iLinkModel.src() + "\n" + "dst fwd=" + iLinkModel.dst());
        } else {
            iLinkModel = iNetLink.getLinkModel();
            iLinkModel2 = iNetLink2.getLinkModel();
            if (iLinkModel == null || iLinkModel2 == null) {
                return null;
            }
            this.dbg.finest("getMapLink fwd=" + iLinkModel + " rev=" + iLinkModel2 + "\n" + "srcIdx fwd=" + iLinkModel.srcEntityIndex() + " rev=" + iLinkModel2.srcEntityIndex() + "\n" + "dstIdx fwd=" + iLinkModel.dstEntityIndex() + " rev=" + iLinkModel2.dstEntityIndex() + "\n" + "src fwd=" + iLinkModel.src() + " rev=" + iLinkModel2.src() + "\n" + "dst fwd=" + iLinkModel.dst() + " rev=" + iLinkModel2.dst());
        }
        AbstractCircuitMap abstractCircuitMap = this;
        synchronized (abstractCircuitMap) {
            Iterator iterator = this.getLinkUserObjects().iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink3 = (INetLink)iterator.next();
                MapLink mapLink = this.getMapLink(iNetLink3);
                Object object = mapLink.getUserObject();
                if (!(object instanceof INetLink)) continue;
                INetLink iNetLink4 = (INetLink)object;
                ILinkModel iLinkModel3 = iNetLink4.getLinkModel();
                this.dbg.finest("srcIdx=" + iLinkModel3.srcEntityIndex() + " dstIdx=" + iLinkModel3.dstEntityIndex() + " src=" + iLinkModel3.src() + " dst=" + iLinkModel3.dst());
                if (iLinkModel3 == null) continue;
                if (iLinkModel2 == null) {
                    if (iLinkModel3.srcEntityIndex() != iLinkModel.srcEntityIndex() || iLinkModel3.src() != iLinkModel.src() || iLinkModel3.dst() != iLinkModel.dst() || iLinkModel3.dstEntityIndex() != iLinkModel.dstEntityIndex() || iLinkModel3.linkType() != iLinkModel.linkType() || iLinkModel3.isPca() != iLinkModel.isPca()) continue;
                    return mapLink;
                }
                if ((iLinkModel3.srcEntityIndex() != iLinkModel.srcEntityIndex() || iLinkModel3.src() != iLinkModel.src() || iLinkModel3.dst() != iLinkModel.dst() || iLinkModel3.dstEntityIndex() != iLinkModel.dstEntityIndex() || iLinkModel3.linkType() != iLinkModel.linkType() || iLinkModel3.isPca() != iLinkModel.isPca()) && (iLinkModel3.srcEntityIndex() != iLinkModel2.srcEntityIndex() || iLinkModel3.src() != iLinkModel2.src() || iLinkModel3.dst() != iLinkModel2.dst() || iLinkModel3.dstEntityIndex() != iLinkModel2.dstEntityIndex() || iLinkModel3.linkType() != iLinkModel2.linkType() || iLinkModel3.isPca() != iLinkModel2.isPca())) continue;
                return mapLink;
            }
        }
        return null;
    }

    public INetLink findReverseLink(INetLink iNetLink) {
        return this.netModel.findReverseLink(iNetLink);
    }

    protected String getPoint(INetCircuitEnd iNetCircuitEnd) {
        if (iNetCircuitEnd == null) {
            if (this.dbg.on()) {
                this.dbg.println("ckt end is null");
            }
            return null;
        }
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
    }

    public String getDstEndPoint(int n) {
        INetCircuit iNetCircuit = this.getNetCircuit();
        if (iNetCircuit == null) {
            return null;
        }
        ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
        if (iCircuitType.isTunnelCircuitType()) {
            return null;
        }
        INetCircuitEnd iNetCircuitEnd = this.getDstDropEndpoint(n);
        if (iNetCircuitEnd == null) {
            if (this.dbg.on()) {
                this.dbg.println("getDstEndPoint - CircuitEnd==null");
            }
            return null;
        }
        if (iNetCircuitEnd.getEntityIndex() == 0) {
            return null;
        }
        return this.getPoint(iNetCircuitEnd);
    }

    protected void addSourceNodeMarker() {
        MapNode mapNode;
        INodeModel iNodeModel = this.getCktSrcNodeModel();
        if (iNodeModel != null && (mapNode = this.getMapNode(iNodeModel)) != null) {
            mapNode.addDesc("Source");
            INetCircuit iNetCircuit = this.getNetCircuit();
            if (iNetCircuit == null) {
                if (this.dbg.on()) {
                    this.dbg.println("get src points - ckt==null");
                }
            } else {
                if (iNetCircuit.isDiag()) {
                    mapNode.addDesc("PRBS Generator");
                    return;
                }
                ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
                if (!iCircuitType.isEthernetCircuitType() && !iCircuitType.isTunnelCircuitType()) {
                    List list = iNetCircuit.getSources();
                    for (int i = 0; i < list.size(); ++i) {
                        INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)list.get(i);
                        MapNode mapNode2 = this.getMapNode(iNetCircuitEnd.getNodeModel());
                        if (mapNode2 == null) continue;
                        if (i == 1) {
                            mapNode2.addDesc("Secondary Source");
                        }
                        mapNode2.addDesc(this.getPoint(iNetCircuitEnd));
                    }
                }
            }
        }
    }

    public void clicked(MapPort mapPort) {
        super.clicked(mapPort);
    }

    protected void clicked(MapLink mapLink) {
        super.clicked(mapLink);
    }

    public void doubleClicked(MapPort mapPort) {
        super.doubleClicked(mapPort);
        System.out.println("Double clicked on port: " + mapPort);
    }

    abstract INetCircuit getNetCircuit();

    protected abstract INodeModel getCktSrcNodeModel();

    protected abstract INodeModel getCktDstNodeModel(int var1);

    protected abstract INetCircuitEnd getDstDropEndpoint(int var1);

    protected void setStateUsingUpsrSpanState(CircuitMapLink circuitMapLink, int n, int n2, boolean bl) {
        if (circuitMapLink != null) {
            circuitMapLink.setStateUsingUpsrSpanState(n, n2, bl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CircuitMapLink circuitMapLink;
        Object object;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(PREFS_ACTIVE_SPAN)) {
            NetMapLink.LINK_ACTIVE_COLOR = AbstractCircuitMap.getPrefColor(PREFS_ACTIVE_SPAN);
        }
        if (string.equals(PREFS_STANDBY_SPAN)) {
            NetMapLink.LINK_STANDBY_COLOR = AbstractCircuitMap.getPrefColor(PREFS_STANDBY_SPAN);
        }
        Iterator iterator = this.getLinkUserObjects().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            MapLink mapLink = this.getMapLink(object);
            if (!(mapLink instanceof CircuitMapLink)) continue;
            circuitMapLink = (CircuitMapLink)mapLink;
            if (this.isDetailed()) {
                this.setStateUsingUpsrSpanState(circuitMapLink, circuitMapLink.getSrcUpsrSpanState(), circuitMapLink.getDstUpsrSpanState(), false);
                continue;
            }
            circuitMapLink.setState(circuitMapLink.getState());
        }
        object = this.getMapNodes();
        for (int i = 0; i < ((E)object).length; ++i) {
            int n;
            circuitMapLink = object[i];
            if (!(circuitMapLink instanceof CircuitMapNode)) continue;
            ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>();
            arrayList.add(circuitMapLink);
            MapNode[] mapNodeArray = ((MapNode)((Object)circuitMapLink)).getVNodes();
            for (n = 0; n < mapNodeArray.length; ++n) {
                if (!(mapNodeArray[n] instanceof CircuitMapNode)) continue;
                arrayList.add(mapNodeArray[n]);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                CircuitMapNode circuitMapNode = (CircuitMapNode)arrayList.get(n);
                MapLine[] mapLineArray = circuitMapNode.getLines();
                for (int j = 0; j < mapLineArray.length; ++j) {
                    if (!(mapLineArray[j] instanceof CircuitMapLine)) continue;
                    CircuitMapLine circuitMapLine = (CircuitMapLine)mapLineArray[j];
                    circuitMapLine.setState(circuitMapLine.getState());
                }
            }
        }
        this.updateView();
    }

    public void dispose() {
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        super.dispose();
    }

    protected void showCircuitObjects() {
        this.srcNE = this.netModel.getNetElem(this.getCktSrcNodeModel().getNodeId());
        this.circuitNodes.add(this.srcNE);
        this.findConnectedNEs(this.srcNE);
        INetElement iNetElement = this.netModel.getNetElem(this.getCktDstNodeModel(1).getNodeId());
        if (!this.circuitNodes.contains(iNetElement)) {
            this.initializeMap(2);
            ErrorMsg.displayError(null, (EID)NEMC.EID_SRC_AND_DEST_NOT_CONN);
            return;
        }
        Iterator iterator = this.circuitNodes.iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel = ((INetElement)iterator.next()).getNodeModel();
            this.addNode(iNodeModel, true, null);
        }
        this.circuitNodes.clear();
    }

    private void findConnectedNEs(INetElement iNetElement) {
        List list = this.netModel.findAllNetLinksWithNetElem(iNetElement);
        if (list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractNetLink abstractNetLink = (AbstractNetLink)iterator.next();
            INetElement iNetElement2 = abstractNetLink.getSrc();
            INetElement iNetElement3 = abstractNetLink.getDst();
            if (!(iNetElement2.equals(iNetElement) || iNetElement2.equals(this.srcNE) || this.circuitNodes.contains(iNetElement2))) {
                this.circuitNodes.add(iNetElement2);
                this.findConnectedNEs(iNetElement2);
                continue;
            }
            if (iNetElement3.equals(iNetElement) || iNetElement3.equals(this.srcNE) || this.circuitNodes.contains(iNetElement3)) continue;
            this.circuitNodes.add(iNetElement3);
            this.findConnectedNEs(iNetElement3);
        }
    }

    public static Color getPrefColor(String string) {
        String string2 = Preferences.instance().getProperty(PREFS_CIRCUIT_KEY, string, null);
        if (string.equals(PREFS_ACTIVE_SPAN)) {
            return ColorUtil.getColor(string2, COLOR_DEFAULT_ACTIVE);
        }
        return ColorUtil.getColor(string2, COLOR_DEFAULT_STANDBY);
    }
}

