/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.RoutePrefs;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AddVcatMemAttrsPane;
import cerent.cms.ui.circuits.AddVcatMemReviewEditPane;
import cerent.cms.ui.circuits.AddVcatMemRouteConstraintsPane;
import cerent.cms.ui.circuits.AddVcatMemRoutePrefsPane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;

public class AddVcatMembersDialog
extends AbstractCircuitDialog
implements ProgressDialogControl {
    private static final String TITLE = "Add Members";
    AddVcatMemAttrsPane attrPane;
    AddVcatMemRoutePrefsPane vcatRoutePane;
    static final int SHORT = 400;
    static final String PREF_TL1 = "createTL1Like";
    static final int ADMIN_STATE_DEFAULT = 3;
    AddVcatMemRouteConstraintsPane constraintPane;
    AddVcatMemReviewEditPane revEditPane;
    public static final String GET_MEM_ATTRS = "Circuit Attributes";
    public static final String GET_MEM_ROUTE_PREFS = "Routing and Member Preferences";
    public static final String GET_MEM_ROUTE_CONSTR = "Constraints For Automatic Routing";
    public static final String GET_MEM_LO = CircuitMapUtil.LO_TERM + " Circuit Options";
    public static final String MEM_REVIEW_EDIT = "Route Review and Edit";
    private static final int WIDTH = 850;
    private CircuitCreatInfo circuitInfo;
    private INetCircuitEnd cktSource = null;
    private INetCircuitEnd cktDestination = null;
    int vcatTxMembers = 0;
    int addMemCount;
    private INetCircuit[] newCkts;
    protected IRevertiveBehavior upsrReversion;
    protected short upsrSdBerLevel;
    protected short upsrSfBerLevel;
    protected boolean upsrSwitchOnPdip;

    public int getCircuitType() {
        return this.ckt.getCircuitType();
    }

    public int getCircuitSize() {
        return this.ckt.getCircuitSize();
    }

    public INetCircuitEnd getSource() {
        return this.cktSource;
    }

    public INetCircuitEnd getDest() {
        return this.cktDestination;
    }

    public INodeModel getSourceNode() {
        return this.cktSource != null ? this.cktSource.getNodeModel() : null;
    }

    public INodeModel getDestNode() {
        return this.cktDestination != null ? this.cktDestination.getNodeModel() : null;
    }

    public boolean getPortGrouping() {
        return false;
    }

    public boolean getDropProtection() {
        return false;
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.circuitInfo;
    }

    public RoutePrefs getRoutePrefs() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.getRoutePrefs();
        }
        this.db.severe("addVcatMemberDialog failed getRoutePrefs");
        return null;
    }

    public boolean isAutoRoute() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.isAutoRoute();
        }
        this.db.severe("addVcatMembersDialog failed isAutoRoute");
        return false;
    }

    public boolean isRrbc() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.isRrbc();
        }
        this.db.severe("addVcatMembersDialog failed isRrbc");
        return false;
    }

    public boolean isUrn() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.isUrn();
        }
        this.db.severe("addVcatMembersDialog failed isUrn");
        return false;
    }

    public boolean isPathProt() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.isPathProt();
        }
        this.db.severe("addVcatMembersDialog failed isPathProt");
        return false;
    }

    public void setPathProt(boolean bl) {
        if (this.vcatRoutePane != null) {
            this.vcatRoutePane.setPathProt(bl);
        } else {
            this.db.severe("addVcatMembersDialog failed setPathProt");
        }
    }

    public boolean isPca() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.isPca();
        }
        this.db.severe("addVcatMembersDialog failed isPca");
        return false;
    }

    public void setPca(boolean bl) {
        if (this.vcatRoutePane != null) {
            this.vcatRoutePane.setPca(bl);
        } else {
            this.db.severe("addVcatMembersDialog failed setPca");
        }
    }

    public INetCircuit[] getNewCkts() {
        return this.newCkts;
    }

    public ArrayList getVcatMemberPrefs() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.getVcatMemberPrefs();
        }
        this.db.severe("addVcatMembersDialog failed getVcatMemberPrefs");
        return null;
    }

    public boolean isVcatCommonFiberRouting() {
        if (this.vcatRoutePane != null) {
            return this.vcatRoutePane.isVcatCommonFiberRouting();
        }
        this.db.severe("addVcatMembersDialog failed isVcatCommonFiberRouting");
        return false;
    }

    public void setVcatCommonFiberRouting(boolean bl) {
        if (this.vcatRoutePane != null) {
            this.vcatRoutePane.setVcatCommonFiberRouting(bl);
        } else {
            this.db.severe("addVcatMembersDialog failed setVcatCommonFiberRouting");
        }
    }

    public int getVcatTxMembers() {
        return this.vcatTxMembers;
    }

    public void setVcatTxMembers(int n) {
        this.vcatTxMembers = n;
    }

    public void setAddMemCount(int n) {
        this.addMemCount = n;
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        if (this.db.on()) {
            this.db.println("AddVcatMembersDialog: empty imp setUpsrReversion()");
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        if (this.db.on()) {
            this.db.println("AddVcatMembersDialog: empty imp getUpsrReversion()");
        }
        return null;
    }

    public Attribute getUpsrSfBerLevel() {
        if (this.db.on()) {
            this.db.println("AddVcatMembersDialog: empty imp getUpsrSfBerLevel()");
        }
        return null;
    }

    public Attribute getUpsrSdBerLevel() {
        if (this.db.on()) {
            this.db.println("AddVcatMembersDialog: empty imp getUpsrSdBerLevel()");
        }
        return null;
    }

    public boolean getUpsrSwitchOnPdip() {
        if (this.db.on()) {
            this.db.println("AddVcatMembersDialog: empty imp getUpsrSwitchOnPdip()");
        }
        return false;
    }

    public void setUpsrSwitchOnPdip(boolean bl) {
        if (this.db.on()) {
            this.db.println("AddVcatMembersDialog: empty imp setUpsrSwitchOnPdip()");
        }
    }

    public AddVcatMembersDialog(Frame frame, INetCircuit iNetCircuit, boolean bl) {
        super(frame, TITLE, new WzDiagDebug("AddVcatMembersDialog"), bl);
        this.setCircuit(iNetCircuit);
        this.initializeCircuitInfo();
        this.createPanesAndSetCurrent();
        this.setVcatCommonFiberRouting(this.ckt.getVcatRoutingPref() == 1);
        this.initUpsrAttributes();
        this.setHeight(400);
        this.setLocationRelativeTo(frame);
    }

    private void initializeCircuitInfo() {
        Preferences preferences = Preferences.instance();
        boolean bl = preferences.getBoolean("ctc.circuit.creation", PREF_TL1, false);
        this.circuitInfo = new CircuitCreatInfo(this.getCircuitType(), this.getCircuitSize(), this.ckt.getCircuitDir(), false, "", 3, bl);
    }

    public synchronized void setCircuit(INetCircuit iNetCircuit) {
        this.ckt = iNetCircuit;
        this.cktSource = this.ckt.getPrimarySource();
        List list = this.ckt.getDrops();
        if (list.size() > 0) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)list.get(0);
            this.cktDestination = netCircuitDropInfo.getNetCktEnd();
        }
    }

    protected void createPanesAndSetCurrent() {
        this.attrPane = new AddVcatMemAttrsPane(this, this.makeChildDebug("MemAttrs"), GET_MEM_ATTRS);
        this.wzPaneMap.put(GET_MEM_ATTRS, this.attrPane);
        this.vcatRoutePane = new AddVcatMemRoutePrefsPane(this, this.makeChildDebug("MemRoutePrefs"), GET_MEM_ROUTE_PREFS);
        this.wzPaneMap.put(GET_MEM_ROUTE_PREFS, this.vcatRoutePane);
        this.constraintPane = new AddVcatMemRouteConstraintsPane(this, this.makeChildDebug("MemRouteConstraints"), GET_MEM_ROUTE_CONSTR, true);
        this.wzPaneMap.put(GET_MEM_ROUTE_CONSTR, this.constraintPane);
        this.revEditPane = new AddVcatMemReviewEditPane(this, this.makeChildDebug("MemReviewEdit"), MEM_REVIEW_EDIT);
        this.wzPaneMap.put(MEM_REVIEW_EDIT, this.revEditPane);
        this.setCurrentPane(GET_MEM_ATTRS);
    }

    protected void apply() throws Exception {
        try {
            this.ckt.sanityCheck();
            if (this.db.on) {
                this.db.println("apply: ckt.sanityCheck() succeeded");
            }
            this.ckt.setUpsrSelectorAttributes(this.upsrReversion, this.upsrSfBerLevel, this.upsrSdBerLevel, this.upsrSwitchOnPdip);
        }
        catch (Exception exception) {
            if (exception instanceof SanityCheckFailed) {
                throw new SanityCheckException("", "spans are", exception);
            }
            throw new AnnotatedException("Circuit sanity check failed", exception);
        }
        ProgressDialog progressDialog = ProgressDialog.start(this, "Circuit Provision", "Circuits are being created.  Please wait...", this, 2000, 10, false, false);
        Exception exception = progressDialog.getResultException();
        if (exception != null) {
            throw new AnnotatedException("Unable to provision member circuits", exception);
        }
    }

    protected void handleFinish() {
        super.handleFinish();
    }

    protected void handleCancel() {
        try {
            if (this.newCkts != null) {
                ((NetVcatCircuit)this.ckt).deleteNewMemberCkts();
            }
        }
        catch (Exception exception) {
            ErrorMsg.displayDetailed((Component)this, NEMC.EID_CIRCUIT_DESTROY_FAILED, exception.toString());
        }
    }

    private void setHeight(int n) {
        this.setSize(new Dimension(850, n));
        this.invalidate();
    }

    protected EID getNoRouteEmcErrorId() {
        return NEMC.EID_CKT_CREATE_ROUTE_ERROR;
    }

    protected void createNewMemCkts() throws Exception {
        if (this.newCkts != null) {
            this.deleteNewMemCkts();
        }
        this.newCkts = ((NetVcatCircuit)this.ckt).createNewMemberCkts(this.circuitInfo);
    }

    protected void deleteNewMemCkts() throws Exception {
        ((NetVcatCircuit)this.ckt).deleteNewMemberCkts();
        this.newCkts = null;
    }

    protected void addDestination(boolean bl) throws Exception {
        if (this.destinationAdded) {
            if (this.db.on) {
                this.db.println("addDestination: destination already added");
            }
            return;
        }
        String string = "???";
        try {
            if (this.isAutoRoute() && bl) {
                string = "route";
                ((NetVcatCircuit)this.ckt).routeNewMemberCkts(this.getRoutePrefs());
            } else {
                string = "add";
                ((NetVcatCircuit)this.ckt).addDropForNewMemberCkts();
            }
            this.destinationAdded = true;
        }
        catch (Exception exception) {
            throw new AnnotatedException("Unable to " + string + " drop", exception);
        }
    }

    protected void deleteDestination() throws Exception {
        if (!this.destinationAdded) {
            if (this.db.on) {
                this.db.println("deleteDestination: no destination added");
            }
            return;
        }
        try {
            ((NetVcatCircuit)this.ckt).deleteDropForNewMemberCkts();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Unable to delete drop", exception);
        }
        this.destinationAdded = false;
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        return null;
    }

    public void executeTask(Observer observer) throws Exception {
        if (this.newCkts != null && this.newCkts.length > 0) {
            ((NetVcatCircuit)this.ckt).provisionNewMemberCkts();
        }
    }

    public void stop() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return false;
    }

    private void initUpsrAttributes() {
        Preferences preferences = Preferences.instance();
        this.db.info("ckt.getUpsrAttributes=" + this.ckt.getUpsrAttributes());
        IHoUpsrAttributes iHoUpsrAttributes = this.ckt.getUpsrAttributes();
        if (iHoUpsrAttributes != null) {
            this.upsrReversion = iHoUpsrAttributes.getUpsrReversion();
            this.upsrSfBerLevel = iHoUpsrAttributes.getUpsrSfBerLevel();
            this.upsrSdBerLevel = iHoUpsrAttributes.getUpsrSdBerLevel();
            this.upsrSwitchOnPdip = iHoUpsrAttributes.getUpsrSwitchOnPdiP();
            if (this.db.on()) {
                this.db.println("Obtained upsr attributes from circuit.");
            }
        } else {
            block9: {
                INodeModel iNodeModel;
                int n = preferences.getBoolean("ctc.circuit.creation", "revertive", false) ? 2 : 1;
                int n2 = preferences.getInt("ctc.circuit.creation", "revertTime", 300);
                if (n2 == 0) {
                    n2 = 30;
                }
                this.upsrReversion = new RevertiveBehavior(n, n2);
                int n3 = 2;
                this.upsrSfBerLevel = (short)4;
                this.upsrSdBerLevel = (short)6;
                if (this.ckt.getCircuitTypeObj().isLoCircuitType()) {
                    n3 = 1;
                    this.upsrSfBerLevel = (short)3;
                    this.upsrSdBerLevel = (short)5;
                }
                if ((iNodeModel = NetworkModel.instance().getCmsHostModel()) != null && iNodeModel.isInited()) {
                    try {
                        this.upsrSfBerLevel = iNodeModel.getUpsrSfBerLevel(n3);
                        this.upsrSdBerLevel = iNodeModel.getUpsrSdBerLevel(n3);
                    }
                    catch (Exception exception) {
                        this.db.severe("Could not get default bers:" + exception);
                        this.upsrSfBerLevel = (short)4;
                        this.upsrSdBerLevel = (short)6;
                        if (n3 != 1) break block9;
                        this.upsrSfBerLevel = (short)3;
                        this.upsrSdBerLevel = (short)5;
                    }
                }
            }
            this.upsrSwitchOnPdip = preferences.getBoolean("ctc.circuit.creation", "pdip", false);
            if (this.db.on()) {
                this.db.println("set " + CircuitMapUtil.UPSR_TERM + " selector attributes:");
                this.db.println(" upsrReversion=" + this.upsrReversion.getReversionMode());
                this.db.println(" upsrSfBerLevel=" + this.upsrSfBerLevel);
                this.db.println(" upsrSdBerLevel=" + this.upsrSdBerLevel);
                this.db.println(" upsrSwitchOnPdip=" + this.upsrSwitchOnPdip);
            }
        }
    }
}

