/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.SrgViolation;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.BlsrDriDialog;
import cerent.cms.ui.circuits.CcdReviewEditPane;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RoutingConstraint;
import cerent.cms.ui.circuits.VcatMemberTableData;
import cerent.util.AnnotatedException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CcdVcatReviewEditPane
extends CcdReviewEditPane {
    private int selectedRowNum = -1;
    private INetCircuit selectedMemberCkt = null;
    private HashMap spansMap = new HashMap();
    protected HashMap blsrDriNodesMap = new HashMap();
    private boolean bVcatCkt = false;
    JComboBox memberCB;
    ArrayList memberNumList = new ArrayList();
    boolean bIsBlsrDriCkt = false;

    public CcdVcatReviewEditPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
    }

    public String getShortName() {
        return "VCat Route Review/Edit";
    }

    public void localCleanup() {
        if (this.db.on()) {
            this.db.println("localCleanup");
        }
        if (this.olm != null) {
            if (this.olm.getContent() != null && this.getAbstractCktDlg().getCircuit() != null) {
                for (int i = this.olm.getContent().size(); i > 0; --i) {
                    if (!(this.olm.getContent().get(i - 1) instanceof NetLinkSpan)) continue;
                    INetLinkSpan iNetLinkSpan = (INetLinkSpan)this.olm.getContent().get(i - 1);
                    this.olm.remove(iNetLinkSpan);
                    this.deleteCircuitSpan(iNetLinkSpan);
                    if (!this.db.on()) continue;
                    this.db.println("localCleanup: removed span " + iNetLinkSpan);
                }
            }
            this.olm.clearAll();
            this.olm.syncButtons();
        }
        this.deleteRemainingCktSpans();
        if (this.hoLoPane != null) {
            this.hoLoPane.disablePane();
        }
        if (this.activeCktSpans != null) {
            this.activeCktSpans.clear();
        }
        if (this.blsrDriListModel != null) {
            this.blsrDriListModel.clear();
        }
        this.unSetNode();
        this.unSetLink();
        this.memberNumList = null;
        this.selectedRowNum = -1;
        this.selectedMemberCkt = null;
        this.spansMap = null;
        this.blsrDriNodesMap = null;
    }

    public void enteringPane() {
        super.enteringPane();
        this.bVcatCkt = this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isVcatCircuitType();
        this.selectedRowNum = 0;
        if (this.spansMap == null) {
            this.spansMap = new HashMap();
        }
        if (this.blsrDriNodesMap == null) {
            this.blsrDriNodesMap = new HashMap();
        }
        VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.membersTableModel.tabData.get(this.selectedRowNum);
        boolean bl = vcatMemberTableData.protectionType == 4;
        this.getAbstractCktDlg().setPca(bl);
        Iterator iterator = this.membersTableModel.tabData.iterator();
        if (this.memberNumList == null) {
            this.memberNumList = new ArrayList();
        }
        while (iterator.hasNext()) {
            vcatMemberTableData = (VcatMemberTableData)iterator.next();
            this.memberNumList.add(vcatMemberTableData.memberNumber);
        }
        this.memberCB.setModel(new DefaultComboBoxModel<Object>(this.memberNumList.toArray()));
        this.memberCB.setSelectedIndex(this.selectedRowNum);
        this.memberCB.addActionListener(this);
        this.srcNodeModel = this.getAbstractCktDlg().getSourceNode();
        this.altSrcNodeModel = this.getAbstractCktDlg().getAltSourceNode();
        this.dstNodeModel = this.getAbstractCktDlg().getDestNode();
        this.altDstNodeModel = this.getAbstractCktDlg().getAltDestNode();
        this.setCurrentNode(this.srcNodeModel);
        this.cleanup();
        this.initialization();
        this.initBlsrDriUI();
        this.initBlsrDriNodesMap();
        this.initBlsrDriNodeList();
        this.bIsBlsrDriCkt = false;
    }

    void getMoreUIs() {
        super.getMoreUIs();
        JPanel jPanel = CcdVcatReviewEditPane.createHorizontalPanel(null);
        JLabel jLabel = new JLabel("Route Member number:");
        jPanel.add(jLabel);
        this.memberCB = new JComboBox();
        jPanel.add(this.memberCB);
        jPanel.add(Box.createHorizontalGlue());
        this.add((Component)jPanel, "North");
        this.memberCB.setModel(new DefaultComboBoxModel());
    }

    public void leavingPane() {
        if (this.selectedRowNum != -1) {
            this.getAbstractCktDlg().getVcatMemberPrefs().get(0);
            VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.getAbstractCktDlg().getVcatMemberPrefs().get(0);
            boolean bl = vcatMemberTableData.protectionType == 4;
            this.getAbstractCktDlg().setPca(bl);
        }
        this.memberCB.removeActionListener(this);
        ((DefaultComboBoxModel)this.memberCB.getModel()).removeAllElements();
        this.selectedMemberCkt = null;
        super.leavingPane();
    }

    protected void initialization() {
        if (this.bVcatCkt) {
            INetCircuit iNetCircuit = this.getSelectedMemCkt();
            if (iNetCircuit == null) {
                return;
            }
            this.mapExistingSpans(iNetCircuit.getCircuitSpans());
            return;
        }
        this.mapExistingSpans(this.getAbstractCktDlg().getCircuit().getCircuitSpans());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.memberCB) {
            this.memberSelChanged(this.memberCB.getSelectedIndex());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void validatePage() throws Exception {
        try {
            ArrayList arrayList;
            int n = this.blsrDriListModel.size();
            Integer n2 = (Integer)this.memberNumList.get(this.selectedRowNum);
            if (n > 0) {
                arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.blsrDriListModel.get(i));
                }
                this.blsrDriNodesMap.put(n2, arrayList);
            } else if (this.blsrDriNodesMap.containsKey(n2)) {
                this.blsrDriNodesMap.remove(n2);
            }
            this.storeDriNodePrefs();
            if (this.bIsBlsrDriCkt) {
                this.validateUpsrReversion();
            }
            arrayList = new ArrayList(this.olm.getContent());
            this.spansMap.put(n2, arrayList);
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error storing node prefs", exception);
        }
        this.performSanityChecks();
    }

    protected String makeFriendlyViolation(SrgViolation srgViolation) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = srgViolation.getViolationObject();
        Integer n = null;
        if (object instanceof INetLink) {
            INetLink iNetLink = (INetLink)object;
            Set set = this.spansMap.keySet();
            Iterator iterator = set.iterator();
            block0: while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                ArrayList arrayList = (ArrayList)this.spansMap.get(n2);
                for (int i = 0; i < arrayList.size(); ++i) {
                    INetLinkSpan iNetLinkSpan;
                    INetLink iNetLink2;
                    if (!(arrayList.get(i) instanceof INetLinkSpan) || !((Object)iNetLink).equals(iNetLink2 = (iNetLinkSpan = (INetLinkSpan)arrayList.get(i)).getLink()) && !((Object)iNetLink.getReverseLink()).equals(iNetLink2)) continue;
                    n = n2;
                    continue block0;
                }
            }
            if (n != null) {
                stringBuffer.append(srgViolation.getDescriptor() + "  (Member " + n + ")\n");
                stringBuffer.append("Span: " + this.getLinkDesc((INetLink)object));
                return stringBuffer.toString();
            }
        }
        return super.makeFriendlyViolation(srgViolation);
    }

    protected String getThisRouteString() {
        if (this.memberNumList.size() > 1) {
            return "These member circuits have ";
        }
        return super.getThisRouteString();
    }

    protected void deleteCircuitSpan(INetLinkSpan iNetLinkSpan) {
        INetCircuit iNetCircuit = this.getSelectedMemCkt();
        if (iNetCircuit != null) {
            iNetCircuit.deleteCircuitSpan(iNetLinkSpan);
        }
    }

    protected void addCircuitSpan(INetLinkSpan iNetLinkSpan) {
        INetCircuit iNetCircuit = this.getSelectedMemCkt();
        if (iNetCircuit != null) {
            iNetCircuit.addCircuitSpan(iNetLinkSpan);
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdVcatReviewEditPane;
    }

    protected void memberSelChanged(int n) {
        if (this.selectedRowNum != -1 && this.selectedRowNum != n) {
            boolean bl;
            ArrayList arrayList = new ArrayList(this.olm.getContent());
            ArrayList arrayList2 = new ArrayList();
            VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.membersTableModel.tabData.get(this.selectedRowNum);
            Integer n2 = (Integer)this.memberNumList.get(this.selectedRowNum);
            Integer n3 = (Integer)this.memberNumList.get(n);
            this.spansMap.put(n2, arrayList);
            boolean bl2 = this.blsrDriListModel.size();
            if (bl2 > false) {
                for (bl = false; bl < bl2; bl += 1) {
                    arrayList2.add(this.blsrDriListModel.get(bl ? 1 : 0));
                }
                this.blsrDriNodesMap.put(n2, arrayList2);
            } else if (this.blsrDriNodesMap.containsKey(n2)) {
                this.blsrDriNodesMap.remove(n2);
            }
            this.selectedRowNum = n;
            this.selectedMemberCkt = null;
            this.reinit();
            vcatMemberTableData = (VcatMemberTableData)this.membersTableModel.tabData.get(this.selectedRowNum);
            bl = vcatMemberTableData.protectionType == 4;
            this.getAbstractCktDlg().setPca(bl);
            this.setCurrentNode(this.srcNodeModel);
            this.cleanup();
            this.initialization();
            this.initBlsrDriUI();
            if (this.blsrDriNodesMap.containsKey(n3)) {
                arrayList2 = (ArrayList)this.blsrDriNodesMap.get(n3);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    this.blsrDriListModel.addElement(arrayList2.get(i));
                }
                this.updateBlsrDriMapNodes();
            }
        }
    }

    protected void reinit() {
        if (this.db.on()) {
            this.db.println("reinit()");
        }
        if (this.olm != null) {
            this.olm.clearAll();
            this.olm.syncButtons();
        }
        if (this.blsrDriListModel != null) {
            this.blsrDriListModel.clear();
        }
        this.unSetNode();
        this.unSetLink();
    }

    protected INetCircuit getSelectedMemCkt() {
        if (this.selectedMemberCkt == null) {
            if (this.selectedRowNum == -1) {
                return null;
            }
            List list = ((NetVcatCircuit)this.getAbstractCktDlg().getCircuit()).getAllMemberCircuits();
            VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.getAbstractCktDlg().getVcatMemberPrefs().get(this.selectedRowNum);
            int n = vcatMemberTableData.memberNumber;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                if (iNetCircuit.getMemberNumber() != n) continue;
                this.selectedMemberCkt = iNetCircuit;
            }
        }
        return this.selectedMemberCkt;
    }

    protected void deleteRemainingCktSpans() {
        if (this.getAbstractCktDlg().getCircuit() == null || this.spansMap == null) {
            return;
        }
        List list = ((NetVcatCircuit)this.getAbstractCktDlg().getCircuit()).getAllMemberCircuits();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n;
            ArrayList arrayList;
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            if (iNetCircuit == this.getSelectedMemCkt() || (arrayList = (ArrayList)this.spansMap.remove(n = new Integer(iNetCircuit.getMemberNumber()))) == null) continue;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator2.next();
                if (!(iNetLinkSpan instanceof NetLinkSpan)) continue;
                iNetCircuit.deleteCircuitSpan(iNetLinkSpan);
            }
        }
        this.spansMap.clear();
    }

    public void removeListeners() {
        if (this.topPanel != null) {
            this.topPanel.removeKeyListener(this);
        }
        if (this.memberCB != null) {
            this.memberCB.removeActionListener(this);
        }
        super.removeListeners();
    }

    public void dispose() {
        this.selectedMemberCkt = null;
        if (this.spansMap != null) {
            this.spansMap.clear();
            this.spansMap = null;
        }
        if (this.memberNumList != null) {
            this.memberNumList.clear();
            this.memberNumList = null;
        }
        if (this.blsrDriNodesMap != null) {
            this.blsrDriNodesMap.clear();
        }
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Spans Map: " + this.spansMap + "\n");
        if (this.spansMap != null) {
            stringBuffer.append("Size= " + this.spansMap.size() + "\n");
            Iterator iterator = this.spansMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = this.spansMap.get(k);
                stringBuffer.append("Key= " + k + ", Val= " + v + "\n");
            }
        }
        stringBuffer.append("bVcatCkt: " + this.bVcatCkt + "\n");
        stringBuffer.append("Member Num List: " + this.memberNumList + "\n");
        if (this.memberNumList != null) {
            stringBuffer.append("Size= " + this.memberNumList.size() + "\n");
            for (int i = 0; i < this.memberNumList.size(); ++i) {
                stringBuffer.append("# " + (i + 1) + ": " + this.memberNumList.get(i) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected boolean isPossibleBlsrDri() {
        boolean bl = false;
        VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.membersTableModel.tabData.get(this.selectedRowNum);
        boolean bl2 = vcatMemberTableData.protectionType == 5;
        bl = bl2 && (this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoCircuitType() || this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoVcatCircuitType());
        return bl;
    }

    protected MemberPrefs getCurrentMemberPrefs(RoutePrefs routePrefs) {
        MemberPrefs memberPrefs = null;
        Integer n = (Integer)this.memberCB.getSelectedItem();
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList == null) {
            return memberPrefs;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)iterator.next();
            memberPrefs = memberGroupPrefs.getMemberPrefs();
            if (memberPrefs.getMemberId() != n.intValue()) continue;
            return memberPrefs;
        }
        return memberPrefs;
    }

    protected MemberPrefs getMemberPref(RoutePrefs routePrefs, int n) {
        MemberPrefs memberPrefs = null;
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList == null) {
            return memberPrefs;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)iterator.next();
            memberPrefs = memberGroupPrefs.getMemberPrefs();
            if (memberPrefs.getMemberId() != n) continue;
            return memberPrefs;
        }
        return memberPrefs;
    }

    protected void storeDriNodePrefs() {
        for (int i = 0; i < this.memberNumList.size(); ++i) {
            Integer n = (Integer)this.memberNumList.get(i);
            if (this.db.on()) {
                this.db.println("storeDriNodePrefs(): Member # : " + n);
            }
            ArrayList arrayList = (ArrayList)this.blsrDriNodesMap.get(n);
            MemberPrefs memberPrefs = this.getMemberPref(this.getAbstractCktDlg().getRoutePrefs(), n);
            if (this.db.on()) {
                CcdRouteConstraintPane.dumpDriNodesFromPrefs(memberPrefs, this.db, "Before redoing Dri Prefs in Review Edit");
            }
            memberPrefs.clearDriNodePrefs();
            if (arrayList != null) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    RoutingConstraint routingConstraint = (RoutingConstraint)arrayList.get(j);
                    DriNodes driNodes = RoutingConstraint.driNodesFromRoutingConstraint(routingConstraint);
                    if (driNodes != null) {
                        memberPrefs.addDriNodes(driNodes);
                    }
                    this.bIsBlsrDriCkt = true;
                }
            }
            if (!this.db.on()) continue;
            CcdRouteConstraintPane.dumpDriNodesFromPrefs(memberPrefs, this.db, "After redoing Dri Prefs in Review Edit");
        }
    }

    protected void initBlsrDriNodesMap() {
        for (int i = 0; i < this.memberNumList.size(); ++i) {
            MemberPrefs memberPrefs;
            List list;
            ArrayList<RoutingConstraint> arrayList = new ArrayList<RoutingConstraint>();
            Integer n = (Integer)this.memberNumList.get(i);
            if (this.db.on()) {
                this.db.println("initBlsrDriNodesMap(): Member # : " + n);
            }
            if ((list = (memberPrefs = this.getMemberPref(this.getAbstractCktDlg().getRoutePrefs(), n)).getDriNodePrefs()) != null && !list.isEmpty()) {
                for (int j = 0; j < list.size(); ++j) {
                    DriNodes driNodes = (DriNodes)list.get(j);
                    boolean bl = driNodes.isSecPca();
                    int n2 = driNodes.getDriType();
                    int n3 = 1;
                    if (n2 == 1) {
                        n3 = 2;
                    } else if (n2 == 2) {
                        n3 = 3;
                    }
                    RoutingConstraint routingConstraint = new RoutingConstraint(n3);
                    routingConstraint.setUsePca(bl);
                    List list2 = driNodes.getNodePairs();
                    String string = "       ";
                    String string2 = list2.size() > 1 ? "Traditional" : "Non-Traditional";
                    string2 = string2 + " " + CircuitMapUtil.BLSRDRI_TERM;
                    for (int k = 0; k < list2.size(); ++k) {
                        DriNodePair driNodePair = (DriNodePair)list2.get(k);
                        INetElement iNetElement = driNodePair.getPrimary();
                        INetElement iNetElement2 = driNodePair.getSecondary();
                        routingConstraint.addElementConstraint(iNetElement, iNetElement2);
                        string2 = string2 + "\n" + string + "Pri #" + (k + 1) + "= " + iNetElement.getName() + ", Sec #" + (k + 1) + "= " + iNetElement2.getName();
                    }
                    if (this.db.on() && bl) {
                        this.db.println(string2 + " specified PCA.");
                        string2 = string2 + "\n" + string + BlsrDriDialog.USE_RIP_STRING;
                    }
                    routingConstraint.setLabel(string2);
                    if (routingConstraint == null) continue;
                    arrayList.add(routingConstraint);
                }
            }
            if (arrayList.size() <= 0) continue;
            this.blsrDriNodesMap.put(n, arrayList);
        }
    }
}

