/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ObjDuplicate;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.RoutingConstraint;
import cerent.cms.ui.circuits.VcatMemberTableData;
import cerent.util.AnnotatedException;
import cerent.util.gui.GridPanel;
import cerent.util.gui.MultiLineLabelUI;
import com.cisco.ctc.util.map.MapLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class CcdVcatRouteConstraintPane
extends CcdRouteConstraintPane
implements ActionListener {
    JComboBox memberCB;
    JPanel memSelPanel;
    int curRowIndex = -1;
    int newSelectedRowIndex = -1;
    HashMap includeMap = new HashMap();
    HashMap excludeMap = new HashMap();

    public CcdVcatRouteConstraintPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
    }

    void getMoreUIs() {
        super.getMoreUIs();
        this.memSelPanel = CcdVcatRouteConstraintPane.createHorizontalPanel(null);
        JLabel jLabel = new JLabel("Route Member number:");
        this.memSelPanel.add(jLabel);
        this.memberCB = new JComboBox();
        this.memSelPanel.add(this.memberCB);
        this.memSelPanel.add(Box.createHorizontalGlue());
        this.memberCB.setModel(new DefaultComboBoxModel());
        this.memSelPanel.setVisible(false);
    }

    protected void enteringPaneBackwards() {
        if (this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            super.enteringPaneBackwards();
        }
    }

    public void enteringPane() {
        super.enteringPane();
        if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            this.topPanel.add((Component)this.memSelPanel, "North");
            this.memSelPanel.setVisible(true);
            Iterator iterator = this.membersTableModel.tabData.iterator();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.memberCB.getModel();
            while (iterator.hasNext()) {
                VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)iterator.next();
                defaultComboBoxModel.addElement(vcatMemberTableData.memberNumber);
            }
            this.memberCB.setSelectedIndex(0);
            this.curRowIndex = -1;
            this.fillInIncludesAndExcludes(0);
        } else {
            this.memSelPanel.setVisible(false);
        }
        this.initBlsrDriUI();
        this.memberCB.addActionListener(this);
        if (this.db.on()) {
            this.db.println("End of enteringPane()");
            this.dbDumpIncludesExcludes();
        }
    }

    public void leavingPane() {
        this.setVcatProtectionType(0);
        if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            this.memberCB.removeActionListener(this);
            ((DefaultComboBoxModel)this.memberCB.getModel()).removeAllElements();
            this.memSelPanel.setVisible(false);
        }
        super.leavingPane();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.memberCB) {
            this.memberSelChanged(this.memberCB.getSelectedIndex());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void memberSelChanged(int n) {
        if (this.curRowIndex != -1 && this.curRowIndex != n) {
            Integer n2 = (Integer)this.memberCB.getItemAt(this.curRowIndex);
            Integer n3 = (Integer)this.memberCB.getItemAt(n);
            if (this.olm.getSize() > 0) {
                ArrayList arrayList = new ArrayList(this.olm.getContent());
                this.includeMap.put(n2, arrayList);
                this.olm.clearAll();
            } else if (this.includeMap.containsKey(n2)) {
                this.includeMap.remove(n2);
            }
            if (!this.exclusionArrayList.isEmpty()) {
                ArrayList arrayList = new ArrayList(this.exclusionArrayList);
                this.excludeMap.put(n2, arrayList);
                this.exclusionArrayList.clear();
                this.exclusionListModel.clear();
            } else if (this.excludeMap.containsKey(n2)) {
                this.excludeMap.remove(n2);
            }
            if (n == -1) {
                return;
            }
            this.fillInIncludesAndExcludes(n);
        }
    }

    private void fillInIncludesAndExcludes(int n) {
        ArrayList arrayList;
        String string;
        MapLink mapLink;
        Object e;
        Iterator iterator;
        Integer n2 = (Integer)this.memberCB.getItemAt(n);
        this.unSetNode();
        this.unSetLink();
        this.setVcatProtectionType(n);
        this.cleanup();
        ArrayList arrayList2 = (ArrayList)this.includeMap.get(n2);
        if (arrayList2 != null) {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                RoutingConstraint routingConstraint = (RoutingConstraint)iterator.next();
                if (routingConstraint.isElemConstraint()) {
                    this.addRoutingConstraintToOlm(routingConstraint, routingConstraint.getLabel());
                    continue;
                }
                if (!routingConstraint.isLinkConstraint()) continue;
                ArrayList arrayList3 = routingConstraint.getLinkConstraintList();
                this.addRoutingConstraintToOlm(routingConstraint, routingConstraint.getLabel());
                for (int i = 0; i < arrayList3.size(); ++i) {
                    e = arrayList3.get(i);
                    mapLink = this.getMapLink((INetLink)e);
                    if (routingConstraint.arrowType == 2) {
                        mapLink.reverseArrow();
                    }
                    string = this.circuitMap.getLinkDesc(mapLink);
                }
            }
        }
        if ((arrayList = (ArrayList)this.excludeMap.get(n2)) != null) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (e instanceof INetElement) {
                    string = ((INetElement)e).getNodeModel().getName();
                    this.exclusionArrayList.add(e);
                    this.exclusionListModel.addElement(string);
                    continue;
                }
                if (!(e instanceof INetLink)) continue;
                mapLink = this.getMapLink((INetLink)e);
                string = this.circuitMap.getLinkDesc(mapLink);
                this.exclusionArrayList.add(e);
                this.exclusionListModel.addElement(string);
            }
        }
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.curRowIndex = n;
        this.initBlsrDriUI();
        this.mapConstraints();
    }

    public void validatePage() throws Exception {
        if (!this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            Integer n = (Integer)this.memberCB.getItemAt(this.curRowIndex);
            if (this.olm.getSize() > 0) {
                ArrayList arrayList = new ArrayList(this.olm.getContent());
                this.includeMap.put(n, arrayList);
                this.olm.clearAll();
            } else if (this.includeMap.containsKey(n)) {
                this.includeMap.remove(n);
            }
            if (!this.exclusionArrayList.isEmpty()) {
                ArrayList arrayList = new ArrayList(this.exclusionArrayList);
                this.excludeMap.put(n, arrayList);
                this.exclusionArrayList.clear();
                this.exclusionListModel.clear();
            } else if (this.excludeMap.containsKey(n)) {
                this.excludeMap.remove(n);
            }
            this.storeVcatRoutePrefs();
            if (this.bIsBlsrDriCkt) {
                this.validateUpsrReversion();
            }
            this.addOrRouteNewCircuit();
            this.storeStatusText();
            if (this.db.on()) {
                this.db.println("post store text: dumping includes/excludes");
                this.dbDumpIncludesExcludes();
            }
        } else {
            super.validatePage();
        }
    }

    private void dbDumpIncludesExcludes() {
        int n;
        List list;
        Integer n2;
        Iterator iterator = this.excludeMap.keySet().iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            this.db.println("Excludes, Member #: " + n2);
            list = (List)this.excludeMap.get(n2);
            for (n = 0; n < list.size(); ++n) {
                this.db.println(n + "\t" + list.get(n));
            }
        }
        iterator = this.includeMap.keySet().iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            this.db.println("Includes, Member #: " + n2);
            list = (List)this.includeMap.get(n2);
            for (n = 0; n < list.size(); ++n) {
                this.db.println(n + "\t" + list.get(n));
            }
        }
    }

    void storeVcatRoutePrefs() throws Exception {
        this.clearAllVcatRoutePrefConstraints(this.getAbstractCktDlg().getRoutePrefs());
        int n = this.memberCB.getItemCount();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)this.memberCB.getItemAt(i);
            ArrayList arrayList = (ArrayList)this.includeMap.get(n2);
            ArrayList arrayList2 = (ArrayList)this.excludeMap.get(n2);
            MemberPrefs memberPrefs = this.getMemberPref(this.getAbstractCktDlg().getRoutePrefs(), n2);
            if (memberPrefs != null) {
                try {
                    this.storeRoutePrefs(n2, memberPrefs, arrayList, arrayList2);
                    continue;
                }
                catch (ObjDuplicate objDuplicate) {
                    this.clearAllVcatRoutePrefConstraints(this.getAbstractCktDlg().getRoutePrefs());
                    int n3 = this.getMemProtectionType(n2);
                    if (n3 == 6 || n3 == 0) {
                        String string = "Make sure constraints only apply to working path of the protected circuit.\n";
                        throw new AnnotatedException(string, (Exception)((Object)objDuplicate));
                    }
                    String string = "Unable to find a route from the set of constraints. \nPlease verfiy your constraint list.\n";
                    throw new AnnotatedException(string, (Exception)((Object)objDuplicate));
                }
            }
            this.db.println("storeVcatRoutePrefs(): memberPrefs not found for member id : " + n2 + "this should not happen");
        }
    }

    void clearAllVcatRoutePrefConstraints(RoutePrefs routePrefs) {
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        LinkedList linkedList2 = new LinkedList();
        if (linkedList == null) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MemberPrefs memberPrefs;
            block6: {
                MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)iterator.next();
                memberPrefs = memberGroupPrefs.getMemberPrefs();
                try {
                    memberPrefs.setReqEntityList(linkedList2);
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block6;
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                memberPrefs.setExcEntityList(linkedList2);
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void removeListeners() {
        if (this.memberCB != null) {
            this.memberCB.removeActionListener(this);
        }
        super.removeListeners();
    }

    protected MemberPrefs getMemberPref(RoutePrefs routePrefs, int n) {
        MemberPrefs memberPrefs = null;
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList == null) {
            return memberPrefs;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)iterator.next();
            memberPrefs = memberGroupPrefs.getMemberPrefs();
            if (memberPrefs.getMemberId() != n) continue;
            return memberPrefs;
        }
        return memberPrefs;
    }

    protected void initBlsrDriUI() {
        boolean bl = this.useDRI() && (this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoCircuitType() || this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoVcatCircuitType());
        this.blsrDriButton.setVisible(bl);
    }

    protected boolean useDRI() {
        boolean bl;
        block4: {
            bl = false;
            if (this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
                return bl;
            }
            try {
                VcatMemberTableData vcatMemberTableData = (VcatMemberTableData)this.membersTableModel.tabData.get(this.curRowIndex);
                if (vcatMemberTableData.protectionType == 5) {
                    bl = true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!this.db.on()) break block4;
                WzDiagDebug.printStackTrace((Throwable)indexOutOfBoundsException);
            }
        }
        return bl;
    }

    protected JComponent getStatusComponent() {
        Serializable serializable;
        if (this.getAbstractCktDlg().isVcatCommonFiberRouting()) {
            return super.getStatusComponent();
        }
        WzStatusPanel wzStatusPanel = new WzStatusPanel(false);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = this.includeMap.keySet().iterator();
        while (iterator.hasNext()) {
            serializable = (Integer)iterator.next();
            if (arrayList.contains(serializable)) continue;
            arrayList.add((Integer)serializable);
        }
        iterator = this.excludeMap.keySet().iterator();
        while (iterator.hasNext()) {
            serializable = (Integer)iterator.next();
            if (arrayList.contains(serializable)) continue;
            arrayList.add((Integer)serializable);
        }
        Collections.sort(arrayList);
        if (arrayList.isEmpty()) {
            wzStatusPanel.push(new JLabel("No constraints for any member circuits specified."), null, true);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            GridPanel gridPanel;
            GridPanel gridPanel2;
            JLabel jLabel;
            JPanel jPanel;
            ArrayList<GridPanel> arrayList2;
            serializable = new WzStatusPanel(false);
            Integer n = (Integer)arrayList.get(i);
            JLabel jLabel2 = new JLabel("Constraints For Member " + n);
            ((WzStatusPanel)serializable).push(jLabel2, null, true);
            List list = (List)this.includeMap.get(n);
            if (list != null && list.size() > 0) {
                arrayList2 = new ArrayList<GridPanel>();
                jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jLabel = new JLabel();
                jLabel.setUI((LabelUI)new MultiLineLabelUI());
                jLabel.setText("Required Nodes/Links:");
                jPanel.add((Component)jLabel, "North");
                for (int j = 0; j < list.size(); ++j) {
                    gridPanel2 = new GridPanel[]{"#" + String.valueOf(j + 1), list.get(j).toString()};
                    arrayList2.add(gridPanel2);
                }
                gridPanel = CcdVcatRouteConstraintPane.getGridPanel(arrayList2);
                jPanel.add((Component)gridPanel, "Center");
                ((WzStatusPanel)serializable).push(jPanel, null, true);
            }
            if ((arrayList2 = (ArrayList<GridPanel>)this.excludeMap.get(n)) != null && arrayList2.size() > 0) {
                jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jLabel = new JLabel();
                jLabel.setUI((LabelUI)new MultiLineLabelUI());
                jLabel.setText("Excluded Nodes/Links:");
                jPanel.add((Component)jLabel, "North");
                gridPanel = new ArrayList();
                for (int j = 0; j < arrayList2.size(); ++j) {
                    Object e = arrayList2.get(j);
                    String string = null;
                    if (e instanceof INetElement) {
                        string = this.getModel(this.getMapNode((INetElement)e)).getName();
                    } else if (e instanceof INetLink) {
                        string = this.circuitMap.getLinkDesc(this.getMapLink((INetLink)e));
                    }
                    String[] stringArray = new String[]{"#" + String.valueOf(j + 1), string};
                    gridPanel.add(stringArray);
                }
                gridPanel2 = CcdVcatRouteConstraintPane.getGridPanel((List)gridPanel);
                jPanel.add((Component)gridPanel2, "Center");
                ((WzStatusPanel)serializable).push(jPanel, null, true);
            }
            wzStatusPanel.push((JComponent)serializable, null, true);
            wzStatusPanel.push(new JLabel(" "), null, false);
        }
        return wzStatusPanel;
    }
}

