/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CircuitNodeAdditionDialog;
import cerent.cms.ui.circuits.NetCircuitNodeCellRenderer;
import cerent.cms.ui.circuits.NetCircuitNodeComparator;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class CedNodePane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    public static final String CREATE = "Add...";
    public static final String DELETE = "Remove...";
    private INetCircuit ckt;
    private DefaultListModel nodeListModel;
    private JLabel sourceLB;
    private JList nodeList;
    private JButton createPB;
    private JButton deletePB;
    private boolean needsRefresh = true;
    private static final SDebug db = new SDebug("CedNodePane");

    public CedNodePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        NetCircuitModel netCircuitModel = (NetCircuitModel)tabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.ckt.addObserver((Observer)((Object)this));
        this.setLayout(new BorderLayout(5, 5));
        this.sourceLB = new JLabel();
        this.add(this.sourceLB, "North");
        this.nodeListModel = new DefaultListModel();
        this.nodeList = new JList(this.nodeListModel);
        this.nodeList.setCellRenderer(new NetCircuitNodeCellRenderer());
        this.nodeList.setVisibleRowCount(6);
        this.nodeList.addListSelectionListener(this);
        this.add((Component)new UScrollPane((Component)this.nodeList), "Center");
        this.add(this.getButtonBar(), "South");
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        this.ckt.deleteObserver((Observer)((Object)this));
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update in CedNodePane, obs=" + observable + ", arg=" + object);
        }
        if (object == ModelUpdateType.DELETED) {
            return;
        }
        this.requestRefresh(this, null);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.deletePB.setEnabled(this.isUserAuthorized() && !this.nodeList.getSelectionModel().isSelectionEmpty());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            new CircuitNodeAdditionDialog((Component)((Object)this), this.ckt);
        } else if (object == this.deletePB) {
            Object[] objectArray = this.nodeList.getSelectedValues();
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Warning: nodes removed from the end of a linear\nEthernet circuit cannot be added back later.\n\nReally remove selected nodes?", (String)"Remove Circuit Nodes")) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        INetElement iNetElement = ((INetCircuitNode)objectArray[i]).getNetElement();
                        this.ckt.deleteNetElement(iNetElement);
                        this.nodeListModel.removeElement(objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_REMOVING_CKT_NODE);
                }
            }
        }
    }

    private JPanel getButtonBar() {
        this.createPB = new JButton(CREATE);
        this.createPB.addActionListener(this);
        this.deletePB = new JButton(DELETE);
        this.deletePB.addActionListener(this);
        this.deletePB.setEnabled(false);
        JPanel jPanel = CedNodePane.createHorizontalPanel(null);
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(this.createPB);
        jPanel.add(this.deletePB);
        return jPanel;
    }

    public void leavingPage() throws Exception {
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage");
        }
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.refresh();
        }
    }

    public void refresh() {
        if (db.on()) {
            db.println("refresh: start");
        }
        if (this.isDestroyed() || !this.ckt.isCircuitRefValid()) {
            if (db.on()) {
                db.println("Destroyed or ckt is invalid ref");
            }
            return;
        }
        INetCircuitEnd iNetCircuitEnd = this.ckt.getPrimarySource();
        if (iNetCircuitEnd == null) {
            if (db.on()) {
                db.println("refresh: ckt.getPrimarySource returned null, returning");
            }
            return;
        }
        INodeModel iNodeModel = null;
        iNodeModel = iNetCircuitEnd.getNodeModel();
        if (iNodeModel == null) {
            if (db.on()) {
                db.println("CedNodePane INetCircuitEnd unable to retrieve source node!!");
            }
            return;
        }
        this.sourceLB.setText("Source node: " + iNodeModel.getName());
        List list = new ArrayList();
        try {
            list = this.ckt.getEtherCircuitNodes();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            // empty catch block
        }
        List list2 = this.ckt.getCircuitNodes();
        list2.removeAll(list);
        this.createPB.setEnabled(this.isUserAuthorized() && list2.size() > 0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (iNodeModel.getNodeId() != iNetCircuitNode.getNodeModel().getNodeId()) continue;
            iterator.remove();
            break;
        }
        Collections.sort(list, new NetCircuitNodeComparator());
        this.nodeListModel.setSize(list.size());
        int n = 0;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.nodeListModel.setElementAt(iterator.next(), n++);
        }
        this.deletePB.setEnabled(this.isUserAuthorized() && this.nodeList.getSelectedValues().length > 0);
        if (db.on()) {
            db.println("refresh: finish");
        }
    }
}

