/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AbstractCircuitMap;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CircuitMapFactory;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.util.Observable;

public class CircuitDesignMap
extends AbstractCircuitMap {
    private static final SDebug db = new SDebug("CircuitDesignMap");
    private CcdCircuitDesignPane circuitDesignPane;
    private AbstractCircuitDialog container;
    private boolean pcaOverride = false;

    CircuitDesignMap(AbstractCircuitDialog abstractCircuitDialog) {
        super(db, 0, CircuitMapFactory.instance());
        this.container = abstractCircuitDialog;
        this.resetMarkers(true);
    }

    public void init(CcdCircuitDesignPane ccdCircuitDesignPane) {
        this.circuitDesignPane = ccdCircuitDesignPane;
    }

    void resetMarkers(boolean bl) {
        this.clearNodeMarkers();
        this.addSourceNodeMarker();
        this.addDestNodeMarker();
        this.jumpToSourceNodeDomain();
        if (bl) {
            this.updateView();
        }
    }

    void addDestNodeMarker() {
        String string;
        MapNode mapNode;
        INodeModel iNodeModel = this.container.getDestNode();
        INodeModel iNodeModel2 = this.container.getAltDestNode();
        if (iNodeModel != null && (mapNode = this.getMapNode(iNodeModel)) != null) {
            mapNode.addDesc("Dest");
            string = this.getDstEndPoint(1);
            if (string != null) {
                mapNode.addDesc(string);
            }
        }
        if (iNodeModel2 != null && (mapNode = this.getMapNode(iNodeModel2)) != null) {
            mapNode.addDesc("Secondary Dest");
            string = this.getDstEndPoint(2);
            if (string != null) {
                mapNode.addDesc(string);
            }
        }
    }

    void addGenericMarker(INodeModel iNodeModel, String string, String string2) {
        MapNode mapNode;
        if (iNodeModel != null && (mapNode = this.getMapNode(iNodeModel)) != null) {
            if (string != null) {
                mapNode.addDesc(string);
            }
            if (string2 != null) {
                mapNode.addDesc(string2);
            }
        }
    }

    protected INetCircuit getNetCircuit() {
        return this.container.getCircuit();
    }

    protected INodeModel getCktSrcNodeModel() {
        return this.container.getSourceNode();
    }

    protected INodeModel getCktDstNodeModel(int n) {
        if (n == 1) {
            return this.container.getDestNode();
        }
        if (n == 2 && this.container.getAltDest() != null) {
            return this.container.getDestNode();
        }
        return null;
    }

    protected INetCircuitEnd getDstDropEndpoint(int n) {
        if (n == 1) {
            return this.container.getDest();
        }
        if (n == 2 && this.container.getAltDest() != null) {
            return this.container.getAltDest();
        }
        return null;
    }

    public void linkSelected(MapLink mapLink, boolean bl) {
        if (this.circuitDesignPane != null) {
            this.circuitDesignPane.linkSelected(mapLink, bl);
        }
    }

    protected void clicked(MapLink mapLink) {
        this.circuitDesignPane.clicked(mapLink);
    }

    public void domainDisplayed(MapNode mapNode) {
        if (this.circuitDesignPane != null) {
            this.circuitDesignPane.domainDisplayed(mapNode);
        }
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        this.circuitDesignPane.nodeSelected(mapNode, bl);
    }

    public void nodeDoubleClicked(MapNode mapNode) {
    }

    public void update(Observable observable, Object object) {
    }

    public void updateReceived(MapNode mapNode, Observable observable, Object object) {
    }

    public void setPcaOverride(boolean bl) {
        this.pcaOverride = bl;
    }

    public boolean isLinkAcceptable(INetLink iNetLink) {
        boolean bl = iNetLink.isRoutable();
        boolean bl2 = super.isLinkAcceptable(iNetLink);
        if (db.on()) {
            db.println("is link acceptable: " + iNetLink.prettyString());
            db.println("\troutable: " + bl + "\tsuperAcceptable: " + bl2);
        }
        boolean bl3 = false;
        if (this.pcaOverride) {
            boolean bl4 = bl3 = !this.loTopo && !this.pcaTopo && this.notLot(iNetLink) && iNetLink.isPca();
            if (db.on()) {
                db.println("\tpcaOverrideOk: " + bl3);
            }
            return bl && (bl2 || bl3);
        }
        return bl && bl2;
    }

    public void dispose() {
        this.circuitDesignPane = null;
        this.container = null;
        super.dispose();
    }
}

