/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.RevertiveBehaviorRenderer;
import cerent.cms.ui.TablePrintRegionDialog;
import cerent.cms.ui.circuits.CedUpsrTableModel;
import cerent.cms.ui.circuits.CedVcatMembersPane;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.circuits.CircuitMap;
import cerent.cms.ui.circuits.CircuitStateDialog;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventMaskUtil;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.ComponentPrinter;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.TablePrintPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableModel;

public class CircuitEditDialog
extends TablePrintPane
implements ActionListener,
Observer {
    private static HashMap allCircuitFrames = new HashMap();
    private static final SDebug db = new SDebug("CircuitEditDialog");
    private static final String PREFS_MAP = "ctc.map";
    private static final String PREFS_USEDETAILED = "usedetailed";
    private static final String PREF = "ctc.CircuitEditDialog";
    private static final String XPOS = "x";
    private static final String YPOS = "y";
    private static final String WIDTH = "w";
    private static final String HEIGHT = "h";
    private static final Dimension INIT_DIM = new Dimension(800, 600);
    private static final String SPLIT_LOC = "split";
    private static final int INIT_SPLIT_LOC = 300;
    private static final String DETAILED = "Show Detailed Map";
    private static final String SHOW_DWDM = "Show WDM Topology";
    private static final String SHOW_OCHNC = "Show OCHNC Topology";
    private static final String selectedLoTip = "If de-selected, logical VT Tunnel links will be replaced by actual links.";
    private static final String unselectedLoTip = "If selected, actual links will be replaced by logical VT Tunnel links where applicable.";
    private static final String selectedDwdmTip = "If de-selected, actual links will be replaced by logical WDM links where applicable.";
    private static final String unselectedDwdmTip = "If selected, logical WDM links will be replaced by actual links.";
    private static final String selectedOchncTip = "If de-selected, OCHNC layer links will not be shown.";
    private static final String unselectedOchncTip = "If selected, OCHNC layer links will be shown.";
    private JCheckBox detailedButton;
    private JCheckBox showLoCB;
    private JCheckBox showDwdmCB;
    private JCheckBox showOchncCB;
    private CircuitEditTabbedView circuitEditTabs;
    private INetCircuit ckt;
    private CircuitMap circuitMap;
    private JSplitPane mainSplitPane;
    private JPanel mainPanel;
    private boolean disposed = false;
    private boolean deleted = false;
    private static ArrayList cktDebugNameList = new ArrayList();
    private String debugName;
    private ArrayList connList = new ArrayList();
    private int oldCircuitState = -1;
    private CSHelpButton helpButton;
    private JMenu toolsMenu;
    private JMenuItem unprotected2UpsrMi;
    private JMenuItem stateChangeMi;
    private static String toolsStr = "Tools";
    private static String unprotected2UpsrStr = "Convert Unprotected to UPSR...";
    private static String stateChangeStr = "Set Circuit State...";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CircuitEditDialog instance(INetCircuit iNetCircuit) {
        CircuitEditDialog circuitEditDialog;
        HashMap hashMap = allCircuitFrames;
        synchronized (hashMap) {
            circuitEditDialog = (CircuitEditDialog)allCircuitFrames.get(iNetCircuit);
            if (circuitEditDialog != null) {
                return circuitEditDialog;
            }
            circuitEditDialog = new CircuitEditDialog(iNetCircuit);
            allCircuitFrames.put(iNetCircuit, circuitEditDialog);
        }
        try {
            Preferences preferences = Preferences.instance();
            int n = preferences.getInt(PREF, XPOS, -1);
            int n2 = preferences.getInt(PREF, YPOS, 0);
            int n3 = preferences.getInt(PREF, WIDTH, CircuitEditDialog.INIT_DIM.width);
            int n4 = preferences.getInt(PREF, HEIGHT, CircuitEditDialog.INIT_DIM.height);
            if (n == -1) {
                circuitEditDialog.setSize(new Dimension(n3, n4));
            } else {
                circuitEditDialog.setBounds(n, n2, n3, n4);
            }
        }
        catch (Exception exception) {
            circuitEditDialog.setSize(INIT_DIM);
        }
        circuitEditDialog.addComponentListener(new MyComponentAdapter(circuitEditDialog));
        circuitEditDialog.setDialogTitle();
        circuitEditDialog.updateSplitPane();
        return circuitEditDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeCircuitWindow(INetCircuit iNetCircuit) {
        if (iNetCircuit != null) {
            HashMap hashMap = allCircuitFrames;
            synchronized (hashMap) {
                CircuitEditDialog circuitEditDialog = (CircuitEditDialog)allCircuitFrames.get(iNetCircuit);
                if (circuitEditDialog != null) {
                    circuitEditDialog.dispose();
                }
            }
        }
    }

    private CircuitEditDialog(INetCircuit iNetCircuit) {
        super(null, "Circuit Edit Dialog");
        this.setDefaultCloseOperation(0);
        this.ckt = iNetCircuit;
        this.initContentPane();
        this.setDialogTitle();
        if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
            this.stateChangeMi = new JMenuItem(stateChangeStr, 83);
            this.stateChangeMi.addActionListener(this);
            this.stateChangeMi.setActionCommand(stateChangeStr);
            this.unprotected2UpsrMi = new JMenuItem(unprotected2UpsrStr, 80);
            this.unprotected2UpsrMi.addActionListener(this);
            this.unprotected2UpsrMi.setActionCommand(unprotected2UpsrStr);
            this.toolsMenu = new JMenu(toolsStr);
            this.toolsMenu.setMnemonic(84);
            this.toolsMenu.add(this.stateChangeMi);
            if (((NetVcatCircuit)iNetCircuit).isSplitRoutingEnabled()) {
                this.toolsMenu.add(this.unprotected2UpsrMi);
            }
            this.toolsMenu.addMenuListener(new MenuListener(){

                public void menuSelected(MenuEvent menuEvent) {
                    CircuitEditDialog.this.stateChangeMi.setEnabled(CircuitEditDialog.this.circuitEditTabs.getCurrentPane() instanceof CedVcatMembersPane);
                    CircuitEditDialog.this.unprotected2UpsrMi.setEnabled(CircuitEditDialog.this.circuitEditTabs.getCurrentPane() instanceof CedVcatMembersPane);
                }

                public void menuCanceled(MenuEvent menuEvent) {
                }

                public void menuDeselected(MenuEvent menuEvent) {
                }
            });
            this.getPaneMenuBar().add(this.toolsMenu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initContentPane() {
        Preferences preferences;
        String string;
        Container container = this.getContentPane();
        this.mainPanel = new JPanel(new BorderLayout());
        this.initSubTabs();
        this.mainPanel.add((Component)this.getButtonPanel(), "South");
        if (this.circuitMap == null) {
            this.debugName = "cmap" + (this.ckt != null ? SDebug.getDebugFriendlyName((int)1, (String)this.ckt.getCircuitName()) : "NULL");
            int n = 0;
            string = this.debugName;
            ArrayList arrayList = cktDebugNameList;
            synchronized (arrayList) {
                while (Collections.binarySearch(cktDebugNameList, string) >= 0) {
                    string = this.debugName + String.valueOf(n++);
                }
                this.debugName = string;
                cktDebugNameList.add(this.debugName);
                Collections.sort(cktDebugNameList);
            }
            this.circuitMap = new CircuitMap(new SDebug(this.debugName), this);
            this.circuitMap.getGraphWindow().setBorder(BorderFactory.createLoweredBevelBorder());
        }
        if ((string = (preferences = Preferences.instance()).getProperty(PREFS_MAP, PREFS_USEDETAILED, null)) != null && string.equals("1") && this.allowDetailedButton()) {
            this.detailedButton.setSelected(true);
        }
        this.showCircuit();
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setDividerSize(2);
        this.mainSplitPane.setTopComponent(this.circuitMap.getGraphWindow());
        this.mainSplitPane.setBottomComponent(this.mainPanel);
        this.circuitMap.getGraphWindow().setMinimumSize(new Dimension(100, 100));
        this.mainPanel.setMinimumSize(new Dimension(100, 200));
        container.add((Component)this.mainSplitPane, "Center");
        this.pack();
        this.ckt.addObserver(this);
    }

    private void initSubTabs() {
        int n = this.ckt.getState();
        if (n == this.oldCircuitState) {
            if (db.on()) {
                db.println("Asked to init subtabs, but will not since state  of circuit is still " + n);
            }
            return;
        }
        this.oldCircuitState = n;
        if (db.on()) {
            db.println("initSubTabs... state is " + n);
        }
        String string = null;
        if (this.circuitEditTabs != null) {
            this.mainPanel.remove((Component)((Object)this.circuitEditTabs));
            string = this.circuitEditTabs.getSelectedTitle();
            this.circuitEditTabs.destroy();
        }
        this.circuitEditTabs = new CircuitEditTabbedView(this.ckt, this);
        this.circuitEditTabs.showAndCatchException();
        this.mainPanel.add((Component)((Object)this.circuitEditTabs), "Center");
        this.validate();
        if (string != null) {
            if (db.on()) {
                db.println("attempting to navigate to subtab= " + string);
            }
            if (!this.circuitEditTabs.gotoTitle(string) && db.on()) {
                db.println("could not navigate to subtab= " + string);
            }
        }
    }

    private JComponent getButtonPanel() {
        this.detailedButton = new JCheckBox(DETAILED);
        this.detailedButton.addActionListener(this);
        String string = "Show " + NetworkDefaults.getCmsHostTDMTerms().getGeneralTerms(1) + " Topology";
        this.showLoCB = new JCheckBox(string, true);
        this.showLoCB.addActionListener(this);
        this.showDwdmCB = new JCheckBox(SHOW_DWDM, true);
        this.showDwdmCB.addActionListener(this);
        this.showOchncCB = new JCheckBox(SHOW_OCHNC, false);
        this.showOchncCB.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel2.add(this.detailedButton);
        jPanel2.add(this.showLoCB);
        jPanel2.add(this.showDwdmCB);
        jPanel2.add(this.showOchncCB);
        this.helpButton = new CSHelpButton(this);
        jPanel3.add(this.helpButton);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        this.updateButtons();
        this.initSubTabs();
        return jPanel;
    }

    private void updateButtons() {
        boolean bl;
        List list;
        if (this.ckt == null) {
            return;
        }
        if (!this.detailedButton.isSelected()) {
            list = this.ckt.getSources();
            bl = this.ckt.getCircuitNodes().size() > 0 || list != null && list.size() > 0;
            this.detailedButton.setVisible(bl);
        }
        if (!(list = this.ckt.getCircuitTypeObj()).isLoCircuitType()) {
            this.showLoCB.setSelected(false);
            this.showLoCB.setVisible(false);
        } else {
            this.showLoCB.setVisible(true);
        }
        this.showOchncCB.setSelected(false);
        this.showOchncCB.setVisible(false);
        if (list.isOchncType()) {
            this.showDwdmCB.setSelected(false);
            this.showDwdmCB.setVisible(false);
        } else if (list.isOchccCircuitType()) {
            this.showDwdmCB.setSelected(false);
            this.showDwdmCB.setVisible(false);
            this.showOchncCB.setVisible(true);
        } else if (list.isOchTrailTunnelCircuitType()) {
            this.showDwdmCB.setSelected(false);
            this.showDwdmCB.setVisible(false);
        } else {
            bl = CircuitMap.hasCompositeNetLink(this.ckt);
            if (this.showDwdmCB.isVisible() != bl) {
                this.showDwdmCB.setVisible(bl);
                if (!bl) {
                    this.showDwdmCB.setSelected(false);
                }
            }
        }
        if (!this.allowDetailedButton()) {
            this.detailedButton.setSelected(false);
            this.detailedButton.setVisible(false);
        }
    }

    private boolean allowDetailedButton() {
        boolean bl = false;
        if (this.ckt != null && !this.ckt.getCircuitTypeObj().isVcatCircuitType()) {
            bl = true;
        }
        return bl;
    }

    private void updateToolTips() {
        this.showLoCB.setToolTipText(this.showLoCB.isSelected() ? selectedLoTip : unselectedLoTip);
        this.showDwdmCB.setToolTipText(this.showDwdmCB.isSelected() ? selectedDwdmTip : unselectedDwdmTip);
        this.showOchncCB.setToolTipText(this.showOchncCB.isSelected() ? selectedOchncTip : unselectedOchncTip);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
        if (object == this.detailedButton || object == this.showLoCB || object == this.showDwdmCB || object == this.showOchncCB) {
            this.updateToolTips();
            this.showCircuit();
        } else if (string.equals("Close")) {
            this.disposeByUser();
        } else if (string.equals(CSHelpButton.getCaption())) {
            this.helpButton.launchHelp(this.circuitEditTabs.getHelpID());
        } else if (string.equals(stateChangeStr)) {
            INetCircuit[] iNetCircuitArray = this.circuitEditTabs.getSelectedVcatCircuits();
            if (iNetCircuitArray.length >= 1) {
                CircuitStateDialog circuitStateDialog = new CircuitStateDialog((Frame)this, iNetCircuitArray);
            }
        } else if (string.equals(unprotected2UpsrStr)) {
            INetCircuit[] iNetCircuitArray = this.circuitEditTabs.getSelectedVcatCircuits();
            if (iNetCircuitArray.length == 1) {
                UnprotectedToUpsrDialog unprotectedToUpsrDialog = new UnprotectedToUpsrDialog(iNetCircuitArray[0], (JComponent)((Object)this.circuitEditTabs), !bl);
                unprotectedToUpsrDialog.show();
            } else if (iNetCircuitArray.length > 1) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ONE_CIRCUIT_A_TIME);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void enableHelp(boolean bl) {
        if (this.helpButton != null) {
            this.helpButton.setEnabled(bl);
        }
    }

    private void showCircuit() {
        if (this.detailedButton != null) {
            if (this.detailedButton.isSelected()) {
                if (this.ckt.getState() == 8) {
                    this.circuitMap.traceBridgeRollCircuit(this.ckt, this.showLoCB.isSelected(), this.showDwdmCB.isSelected());
                } else {
                    this.circuitMap.traceDetailedCircuit(this.ckt, this.showLoCB.isSelected(), this.showDwdmCB.isSelected(), this.showOchncCB.isSelected());
                }
            } else {
                this.circuitMap.traceCircuit(this.ckt, this.showLoCB.isSelected(), this.showDwdmCB.isSelected(), this.showOchncCB.isSelected());
            }
        } else {
            db.println("showCircuit(): DetailedButton is null!");
        }
    }

    public void addObservableObject(Object object) {
        if (object != null && object instanceof IHoConnectionModel) {
            IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)object;
            this.connList.add(iHoConnectionModel);
            iHoConnectionModel.addObserver((Observer)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Preferences preferences;
        Cloneable cloneable;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CircuitEditDialog.this.dispose();
                }
            });
            return;
        }
        if (db.on()) {
            db.println("dispose");
        }
        this.disposed = true;
        if (allCircuitFrames != null) {
            cloneable = allCircuitFrames;
            synchronized (cloneable) {
                allCircuitFrames.remove(this.ckt);
            }
        }
        if (cktDebugNameList != null && this.debugName != null) {
            cloneable = cktDebugNameList;
            synchronized (cloneable) {
                cktDebugNameList.remove(this.debugName);
                Collections.sort(cktDebugNameList);
            }
        }
        if (this.circuitEditTabs != null) {
            this.circuitEditTabs.destroy();
            this.circuitEditTabs = null;
        }
        if (this.connList != null && this.connList.size() > 0) {
            for (int i = 0; i < this.connList.size(); ++i) {
                preferences = (IHoConnectionModel)this.connList.get(i);
                if (preferences == null) continue;
                preferences.deleteObserver((Observer)this);
            }
        }
        if (this.ckt != null) {
            this.ckt.deleteObserver(this);
            this.ckt = null;
        }
        if (this.circuitMap != null) {
            this.circuitMap.dispose();
            this.circuitMap = null;
        }
        Rectangle rectangle = this.getBounds();
        preferences = Preferences.instance();
        preferences.setProperty(PREF, XPOS, Integer.toString(rectangle.x));
        preferences.setProperty(PREF, YPOS, Integer.toString(rectangle.y));
        preferences.setProperty(PREF, WIDTH, Integer.toString(rectangle.width));
        preferences.setProperty(PREF, HEIGHT, Integer.toString(rectangle.height));
        preferences.setProperty(PREF, SPLIT_LOC, Integer.toString(this.mainSplitPane.getDividerLocation()));
        this.getContentPane().removeAll();
        this.getRootPane().removeAll();
        this.removeAll();
        super.dispose();
    }

    private void disposeByUser() {
        block5: {
            if (this.circuitEditTabs != null) {
                try {
                    this.circuitEditTabs.setShowing(false);
                }
                catch (LeavePageException leavePageException) {
                    if (db.on()) {
                        db.println("dispose: canceled by user");
                    }
                    return;
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("exception in dispose");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.dispose();
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update " + observable + ", arg " + object);
        }
        if (object == ModelUpdateType.DELETED) {
            this.deleted = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CircuitEditDialog.this.runUpdate();
            }
        });
    }

    private void runUpdate() {
        if (!this.disposed) {
            boolean bl = this.ckt.isCircuitRefValid();
            if (!this.deleted && bl) {
                if (db.on()) {
                    db.println("run: circuit still valid and no delete update.");
                    db.println("--- straight from the circuit refresh START");
                    this.ckt.prettyPrint(db);
                    db.println("--- straight from the circuit refresh END");
                }
                this.setDialogTitle();
                this.updateButtons();
                this.showCircuit();
                this.initSubTabs();
            } else {
                if (db.on()) {
                    db.println("run: circuit valid? " + bl);
                    db.println("run: circuit deleted? " + this.deleted);
                }
                this.dispose();
            }
        }
    }

    public void setDialogTitle() {
        String string = "Edit Circuit: ";
        if (this.ckt.isMemberOfVcat()) {
            string = "Edit Member Circuit: ";
        }
        string = string + this.ckt.getCircuitName();
        int n = this.ckt.getState();
        if (n != 1) {
            string = string + " (Status: ";
            string = string + NetworkDefaults.circuitStateToString(n);
            string = string + ")";
        }
        this.setTitle(string);
    }

    public void updateSplitPane() {
        Preferences preferences = Preferences.instance();
        int n = preferences.getInt(PREF, SPLIT_LOC, 300);
        this.mainSplitPane.setDividerLocation(n);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.disposeByUser();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.circuitMap != null) {
            // empty if block
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        if (this.circuitMap != null) {
            // empty if block
        }
    }

    protected Printable getPrintableObject() {
        TablePrintRegionDialog tablePrintRegionDialog = new TablePrintRegionDialog(null, "PRINT", true, true, this.getTable());
        tablePrintRegionDialog.pack();
        int n = tablePrintRegionDialog.showDialog();
        if (n == 0) {
            int n2 = tablePrintRegionDialog.getPrintRegionSelection();
            if (n2 == 0) {
                return new ComponentPrinter((Component)this);
            }
            if (n2 == 1) {
                return new ComponentPrinter((Component)((Object)this.circuitEditTabs));
            }
            return this.getTableContentPrinter();
        }
        return null;
    }

    public void updatePrintableTable(JTable jTable) {
        this.setTable(jTable);
        if (jTable != null) {
            this.initAdapter(jTable);
        }
    }

    protected void initAdapter(JTable jTable) {
        if (jTable.getModel() instanceof CedUpsrTableModel) {
            class UpsrTableAdapter
            extends TableModelAdapter {
                private final /* synthetic */ JTable val$myTable;

                UpsrTableAdapter(TableModel tableModel, JTable jTable, JTable jTable2) {
                    this.val$myTable = jTable2;
                    super(tableModel, jTable);
                }

                public String getColumnName(int n) {
                    return this.val$myTable.getColumnName(n);
                }

                public Object getValueAt(int n, int n2) {
                    String string;
                    Object object = this.val$myTable.getValueAt(n, n2);
                    String string2 = string = object != null ? object.toString() : "<null>";
                    if (object instanceof IRevertiveBehavior) {
                        string = RevertiveBehaviorRenderer.getString((IRevertiveBehavior)object);
                    } else {
                        Component component;
                        String string3 = this.val$myTable.getColumnName(n2);
                        if ((string3.equals("Working Path") || string3.equals("Protect Path")) && (component = this.val$myTable.getCellRenderer(n, n2).getTableCellRendererComponent(this.val$myTable, object, false, false, n, n2)) instanceof JLabel) {
                            string = object.toString() + " " + CircuitColumnRenderer.getStateStringFromColor(((JLabel)component).getBackground());
                        }
                    }
                    return string;
                }
            }
            this.setAdapter(new UpsrTableAdapter(jTable.getModel(), jTable, jTable));
        } else {
            this.setAdapter(new TableModelAdapter(jTable.getModel(), jTable));
        }
    }

    static class MyComponentAdapter
    extends ComponentAdapter {
        CircuitEditDialog dlg;

        MyComponentAdapter(CircuitEditDialog circuitEditDialog) {
            this.dlg = circuitEditDialog;
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (this.dlg.getHeight() < 250) {
                this.dlg.setSize(this.dlg.getWidth(), 250);
                this.dlg.mainSplitPane.setDividerLocation(0.5);
            }
        }
    }
}

