/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeShelfModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingManager;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.circuits.CircuitDataSource;
import cerent.cms.model.circuits.CircuitFilter;
import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DeletionWarning;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.IPreselectCircuits;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitCreationWizard;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.CircuitFilterDialog;
import cerent.cms.ui.circuits.CircuitSearchDialog;
import cerent.cms.ui.circuits.CircuitsByNameTable;
import cerent.cms.ui.circuits.CircuitsTableModel;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.cms.ui.circuits.RollVcatMemberSelectionDialog;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.cms.ui.circuits.UpgradeOchncDialog;
import cerent.cms.ui.event.AlarmPane;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.EventMaskUtil;
import cerent.util.IAsyncObserver;
import cerent.util.NEMC;
import cerent.util.PluralisationUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowDataSourceListener;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;

public class CircuitsPane
extends AbstractPane
implements ActionListener,
IAsyncObserver,
IPreselectCircuits,
TableModelListener,
RowDataSourceListener,
ListSelectionListener,
MouseListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    public static final String EDIT = "Edit...";
    public static final String SEARCH = "Search...";
    public static final String FILTER = "Filter...";
    protected static final String SCOPE_LABEL = "Scope:";
    protected static final String SCOPE_NET = "Network";
    protected static final String SCOPE_NODE = "Node";
    protected static final String SCOPE_SHELF = "Shelf";
    protected static final String SCOPE_CARD = "Card";
    private static final String SCOPE_NET_ALL = "Network (All)";
    private static final String SCOPE_NET_DWDM = "Network (DWDM)";
    private static final String SCOPE_NET_TDM = "Network (TDM)";
    private int netViewLayer;
    private final ImageIcon FILTER_ENABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter.gif"));
    private final ImageIcon FILTER_DISABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter-Gray.gif"));
    UScrollPane scrollPane;
    private JPanel buttons;
    private JButton createPB;
    private JButton deletePB;
    private JButton editPB;
    private JButton searchPB;
    private JButton filterPB;
    protected JComboBox scopeCB;
    protected JToggleButton filterIndicator;
    private Vector circuitsVector;
    private CircuitsTableModel model;
    private CircuitDataSource source;
    private boolean inited = false;
    private CircuitSearchDialog csd = null;
    private ColumnRenderer[] columnRenderers = null;
    private List preselectedCircuitIds = null;
    private Set possibleBlsrCircuitIds = null;
    protected static final int MAX_RECOMMENDED_DIALOGS = 7;
    private boolean preselectionsActive = false;
    private boolean notifyCktDeletionCompletion = false;
    private static final SDebug db = new SDebug("CircuitsPane");
    private static final int ALLOWS_STATE_APPLICATION_TO_DROPS = 0;
    private static final int NUMBER_OF_CIRCUIT_CHARACTERISTICS = 1;

    public CircuitsPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    public void enteringPage() {
        if (db.on()) {
            db.println(">>>  enteringPage");
        }
        if (!this.inited) {
            this.buttons = this.getButtonBar();
            this.setDefaultCircuitScope();
            this.source = new CircuitDataSource(this.getCurrentCircuitScope());
            this.source.addRowDataSourceListener(this);
            this.columnRenderers = CircuitColumnRenderer.createTableRenderers(0);
            this.model = new CircuitsTableModel((RowDataSource)this.source, this.columnRenderers, INetCircuit.class);
            this.table = new CircuitsByNameTable(this.model);
            this.updateCircuitSearchInfo();
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.add((Component)this.scrollPane, "Center");
            this.add(this.buttons, "South");
            this.table.addMouseListener(this);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.model.addTableModelListener(this);
            this.inited = true;
        }
        this.loadCircuitFilterPreferences();
        this.source.setEnabled(true);
        this.updateColumnWidths();
        this.refresh();
        this.source.setNetworkViewLayerFilter(this.netViewLayer);
        if (db.on()) {
            db.println("<<< enteringPage()");
        }
    }

    protected void loadCircuitFilterPreferences() {
        this.setFilterActive(CircuitFilter.isLastFilterActive());
    }

    private void updateColumnWidths() {
        if (db.on()) {
            db.println(">>> updateColumnWidths()");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            CircuitColumnRenderer circuitColumnRenderer = (CircuitColumnRenderer)this.columnRenderers[i];
            circuitColumnRenderer.setWidth(tableColumnModel.getColumn(i).getPreferredWidth());
        }
    }

    public void leavingPage() throws Exception {
        if (CircuitsPane.db.on) {
            db.println(">>> leavingPage()");
        }
        this.source.setEnabled(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void setNetworkViewLayerFilter(int n) {
        this.source.setNetworkViewLayerFilter(n);
        this.setDefaultCircuitScope();
    }

    public void refresh() {
    }

    protected void removeActionListeners() {
        this.createPB.removeActionListener(this);
        this.editPB.removeActionListener(this);
        this.deletePB.removeActionListener(this);
        this.filterPB.removeActionListener(this);
        this.searchPB.removeActionListener(this);
        this.scopeCB.removeActionListener(this);
        this.filterIndicator.removeActionListener(this);
    }

    public void destroy() {
        if (db.on()) {
            db.println(">>>  destroy()");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.removeActionListeners();
            this.table.removeMouseListener(this);
            this.table.getSelectionModel().removeListSelectionListener(this);
            this.model.removeTableModelListener(this);
            this.model.release();
            if (this.source != null) {
                this.source.removeRowDataSourceListener(this);
                this.source.removeCircuitFilterListener();
                this.source.dispose();
                this.source = null;
            }
        }
        this.preselectedCircuitIds = null;
        this.columnRenderers = null;
        super.destroy();
    }

    public boolean isInited() {
        return this.inited;
    }

    public CircuitFilter getCircuitFilter() {
        return this.source.getCircuitFilter();
    }

    public List getAllCircuits() {
        return new ArrayList(this.source.getAllObjects());
    }

    protected void filterChanged() {
        this.source.filterChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
            this.createCircuit(!bl);
        } else if (object == this.deletePB) {
            int[] nArray = new int[1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
            INetCircuit[] iNetCircuitArray = this.getSelectedCircuits("Delete", nArray, false, "");
            if (iNetCircuitArray.length > 0) {
                new CircuitDeletionDialog(iNetCircuitArray, nArray).show();
            }
        } else if (object == this.editPB) {
            this.editSelectedCircuits(this.getSelectedCircuits("Edit", false));
        } else if (object == this.searchPB) {
            this.csd = CircuitSearchDialog.instance((JComponent)((Object)this), this.table, this.scrollPane, this.circuitsVector);
            if (this.table.getSelectedRowCount() > 0) {
                INetCircuit iNetCircuit = (INetCircuit)this.table.getValueAt(this.table.getSelectedRow(), 0);
                this.csd.setSelectedCircuit(iNetCircuit);
            }
            this.csd.show();
        } else if (object == this.scopeCB && this.source != null) {
            IModel iModel = this.getCurrentCircuitScope();
            this.source.setCircuitScope(iModel);
        } else if (object == this.filterPB) {
            this.showFilterDialog();
        } else if (object == this.filterIndicator) {
            if (this.source.getCircuitFilter().size() <= 0) {
                this.showFilterDialog();
            } else {
                this.setFilterActive(this.filterIndicator.isSelected());
            }
        }
        this.syncButtons(true);
    }

    private void setFilterActive(boolean bl) {
        this.source.getCircuitFilter().setActive(bl);
        this.filterIndicator.setSelected(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCircuit(boolean bl) {
        try {
            this.createPB.setEnabled(false);
            CircuitCreationWizard circuitCreationWizard = new CircuitCreationWizard(JOptionPane.getFrameForComponent((Component)((Object)this)), bl, this.uiModel);
            IModel iModel = this.getUiModel();
            if (iModel instanceof NodeModel) {
                circuitCreationWizard.setSourceNode((NodeModel)iModel);
                circuitCreationWizard.setDestNode((NodeModel)iModel);
            } else if (iModel instanceof IModuleModel) {
                INodeModel iNodeModel = iModel.getNodeModel();
                if (iNodeModel instanceof NodeModel) {
                    circuitCreationWizard.setSourceNode((NodeModel)iNodeModel);
                    circuitCreationWizard.setDestNode((NodeModel)iNodeModel);
                } else {
                    circuitCreationWizard.setSourceNode(null);
                    circuitCreationWizard.setDestNode(null);
                }
            }
            circuitCreationWizard.show();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("createCircuit: exception caught when attempting to display CCD.");
            }
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.createPB.setEnabled(true);
        }
    }

    public void upgradeCircuit(INetCircuit iNetCircuit, boolean bl) {
        try {
            INetCircuit iNetCircuit2 = iNetCircuit;
            UnprotectedToUpsrDialog unprotectedToUpsrDialog = new UnprotectedToUpsrDialog(iNetCircuit2, (JComponent)((Object)this), !bl);
            unprotectedToUpsrDialog.show();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("upgradeCircuit: exception caught when attempting to display CCD.");
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void upgradeOchncCircuit(OchncCircuit ochncCircuit, boolean bl) {
        UpgradeOchncDialog upgradeOchncDialog = null;
        try {
            upgradeOchncDialog = new UpgradeOchncDialog(ochncCircuit, (JComponent)((Object)this), !bl);
        }
        catch (Exception exception) {
            CerentDialog.errorDialog((Component)((Object)this), (String)exception.getMessage(), (String)"Error");
        }
        try {
            if (upgradeOchncDialog != null) {
                upgradeOchncDialog.show();
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("upgradeOchncCircuit: exception caught when attempting to display CCD.");
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public boolean isCircuitSelected() {
        return this.getSelectedCircuitNum() != 0;
    }

    public int getSelectedCircuitNum() {
        return this.table.getSelectedRows().length;
    }

    public INetCircuit[] getSelectedCircuits(String string, boolean bl) {
        return this.getSelectedCircuits(string, null, bl, "");
    }

    private INetCircuit[] getSelectedCircuits(String string, int[] nArray, boolean bl, String string2) {
        int[] nArray2 = this.table.getSelectedRows();
        INetCircuit[] iNetCircuitArray = new INetCircuit[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            iNetCircuitArray[i] = (INetCircuit)this.model.getValueAt(nArray2[i], 0);
            if (nArray == null || !NetAdminState.circuitAllowsStateApplicationToDrops(iNetCircuitArray[i])) continue;
            nArray[0] = nArray[0] + 1;
        }
        if (iNetCircuitArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_CIRCUITS_SELECTED_PARAM_1, (Object)(string + " circuit."));
        } else if (bl && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string2 = string2 + "Really " + string.toLowerCase() + (iNetCircuitArray.length == 1 ? " selected circuit?" : " " + iNetCircuitArray.length + " selected circuits?")), (String)(string + " Circuit"))) {
            iNetCircuitArray = new INetCircuit[]{};
        }
        return iNetCircuitArray;
    }

    private void deleteSelectedCircuits(INetCircuit[] iNetCircuitArray, int n) {
        int[] nArray = NetCircuitManager.instance().deleteCheck(iNetCircuitArray);
        INetCircuit[] iNetCircuitArray2 = iNetCircuitArray;
        int n2 = iNetCircuitArray.length;
        if (nArray != null) {
            int n3;
            String string = "Deleting partial circuit";
            Object[] objectArray = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            boolean bl = false;
            int n4 = 2;
            n2 = iNetCircuitArray.length - nArray.length;
            INetCircuit iNetCircuit = null;
            for (n3 = 0; n3 < nArray.length && !bl; ++n3) {
                String string2;
                iNetCircuit = iNetCircuitArray[nArray[n3]];
                if (iNetCircuit.getState() == 8) {
                    n4 = 2;
                    string2 = iNetCircuitArray[nArray[n3]].getCircuitName();
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_CANNOT_DELETE_CIRCUIT_PARAM_1, (Object)string2);
                } else {
                    string2 = "Circuit \"" + iNetCircuitArray[nArray[n3]].getCircuitName() + "\"" + "is partial; deletion may strand bandwidth." + "\nOK to force deletion?";
                    n4 = CerentDialog.optionDialog((Component)((Object)this), (String)string2, (String)string, (Object[])objectArray, (Object)objectArray[2]);
                }
                if (n4 == 1) {
                    n2 = iNetCircuitArray.length;
                    bl = true;
                    break;
                }
                if (n4 == 2) continue;
                if (n4 == 3) {
                    n2 = 0;
                    break;
                }
                if (n4 != 0) continue;
                nArray[n3] = -1;
                ++n2;
            }
            if (n2 > 0) {
                if (bl) {
                    iNetCircuitArray2 = iNetCircuitArray;
                } else {
                    iNetCircuitArray2 = new INetCircuit[n2];
                    n3 = 0;
                    int n5 = 0;
                    for (int i = 0; i < iNetCircuitArray.length; ++i) {
                        if (n3 < nArray.length && i == nArray[n3]) {
                            ++n3;
                            continue;
                        }
                        if (n5 >= n2) continue;
                        iNetCircuitArray2[n5++] = iNetCircuitArray[i];
                        if (n3 >= nArray.length || nArray[n3] != -1) continue;
                        ++n3;
                    }
                }
            }
        }
        try {
            if (n2 > 0) {
                for (int i = 0; i < iNetCircuitArray2.length; ++i) {
                    CircuitEditDialog.closeCircuitWindow(iNetCircuitArray2[i]);
                }
                if (!this.isSonetType(iNetCircuitArray2) && PortGrouping.containsPGCkts(iNetCircuitArray2)) {
                    iNetCircuitArray2 = this.deletePGCircuits(iNetCircuitArray2, n);
                }
                NetCircuitManager.instance().deleteSelectedCircuits(iNetCircuitArray2, n, this);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_CIRCUIT_DELETION_ERROR, exception.getMessage());
        }
    }

    private INetCircuit[] deletePGCircuits(INetCircuit[] iNetCircuitArray, int n) throws ProvisionError, UnsupportedOperation, AnnotatedException {
        LinkedList linkedList = new LinkedList();
        INetCircuit[] iNetCircuitArray2 = PortGrouping.removePGCkts(iNetCircuitArray, linkedList);
        if (CerentDialog.questionDialog((Component)((Object)this), (String)"Deleting a port group circuit deletes all the VC3 circuits in the group and the wrapping tunnel?", (String)"Delete Port Grouping Circuit") == 0) {
            int n2 = PortGrouping.deletePortGroupingCircuits(linkedList, n);
            if (this.notifyCktDeletionCompletion) {
                String string = n2 + " port group " + PluralisationUtil.s("circuit", n2) + " " + PluralisationUtil.s("was", n2) + " successfully deleted.";
                DetailedLog detailedLog = new DetailedLog(1, string);
                EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            }
        }
        return iNetCircuitArray2;
    }

    private boolean isSonetType(INetCircuit[] iNetCircuitArray) {
        INodeModel iNodeModel = null;
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            List list;
            INetCircuit iNetCircuit = iNetCircuitArray[i];
            if (iNetCircuit.getPrimarySource() != null) {
                iNodeModel = iNetCircuit.getPrimarySource().getNodeModel();
            } else {
                list = iNetCircuit.getCircuitNodes();
                if (list.size() != 0 && (INetCircuitNode)list.get(0) != null) {
                    iNodeModel = ((INetCircuitNode)list.get(0)).getNodeModel();
                }
            }
            if (iNodeModel != null) {
                return iNodeModel.getFramingTypeObj().isSonet();
            }
            list = iNetCircuit.getCircuitTypeObj();
            if (list == null) continue;
            return list.isSonetType();
        }
        return true;
    }

    private void editSelectedCircuits(INetCircuit[] iNetCircuitArray) {
        String string;
        if (iNetCircuitArray.length > 7 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string = "You have chosen to open " + iNetCircuitArray.length + " Edit Circuit Dialogs at once.\n" + "The recommended maximum is " + 7 + ".\n" + "Are you sure you wish to do this?"), (String)("Open " + iNetCircuitArray.length + " Edit Circuit Dialogs"))) {
            return;
        }
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            CircuitEditDialog.instance(iNetCircuitArray[i]).show();
        }
    }

    protected JPanel getButtonBar() {
        this.createPB = this.makeActionButton(CREATE);
        this.editPB = this.makeActionButton(EDIT);
        this.deletePB = this.makeActionButton(DELETE);
        this.filterPB = this.makeActionButton(FILTER);
        this.filterPB.setEnabled(true);
        this.enableComponent(this.editPB, this.getUiModel(), SecurityLevel.MAINTENANCE);
        this.editPB.setEnabled(true);
        this.searchPB = this.makeActionButton(SEARCH);
        this.searchPB.setEnabled(true);
        this.scopeCB = new JComboBox<Object>(new Object[]{SCOPE_NET_ALL});
        this.scopeCB.addActionListener(this);
        this.filterIndicator = new JToggleButton(this.FILTER_DISABLE_IMG);
        this.filterIndicator.setSelectedIcon(this.FILTER_ENABLE_IMG);
        this.filterIndicator.setFocusPainted(false);
        this.filterIndicator.setPreferredSize(new Dimension(27, 25));
        this.filterIndicator.setToolTipText("Turn on/off circuit filter");
        this.filterIndicator.addActionListener(this);
        JPanel jPanel = CircuitsPane.createHorizontalPanel(null);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add(this.createPB);
        jPanel2.add(this.editPB);
        jPanel2.add(this.deletePB);
        jPanel2.add(this.filterPB);
        jPanel2.add(this.searchPB);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 5, 5));
        jPanel2.add(new JLabel(SCOPE_LABEL, 4));
        jPanel2.add(this.scopeCB);
        jPanel2.add(this.filterIndicator);
        jPanel2.add(new CSHelpButton(NetCSHelpConst.CircuitsPane));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    private void setDefaultCircuitScope() {
        String string;
        IModel iModel = this.getUiModel();
        String string2 = Preferences.instance().getProperty("ctc", "network.view.filter.node.type", "");
        if (string2.equals("DWDM")) {
            string = SCOPE_NET_DWDM;
            this.netViewLayer = 1;
        } else if (string2.equals("TDM")) {
            string = SCOPE_NET_TDM;
            this.netViewLayer = 2;
        } else {
            string = SCOPE_NET_ALL;
            this.netViewLayer = 0;
        }
        this.scopeCB.removeAllItems();
        boolean bl = false;
        if (iModel instanceof IEntityModel && iModel.getNodeModel().provides(Feature.MULTISHELF) && iModel.getNodeModel().isMultishelf()) {
            bl = true;
        }
        if (iModel instanceof IModuleModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.addItem(string);
            this.scopeCB.addItem(SCOPE_NODE);
            if (bl) {
                this.scopeCB.addItem(SCOPE_SHELF);
            }
            this.scopeCB.addItem(SCOPE_CARD);
            this.scopeCB.setSelectedItem(SCOPE_CARD);
        } else if (iModel instanceof INodeShelfModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.addItem(string);
            this.scopeCB.addItem(SCOPE_NODE);
            if (bl) {
                this.scopeCB.addItem(SCOPE_SHELF);
                this.scopeCB.setSelectedItem(SCOPE_SHELF);
            } else {
                this.scopeCB.setSelectedItem(SCOPE_NODE);
            }
        } else {
            this.scopeCB.setEnabled(false);
            this.scopeCB.addItem(string);
            this.scopeCB.setSelectedItem(string);
        }
    }

    public IModel getCurrentCircuitScope() {
        Object object = this.scopeCB.getSelectedItem();
        INodeModel iNodeModel = null;
        if (SCOPE_NET_ALL.equals(object) || SCOPE_NET_TDM.equals(object) || SCOPE_NET_DWDM.equals(object)) {
            iNodeModel = null;
        } else if (SCOPE_NODE.equals(object)) {
            iNodeModel = this.getUiModel().getNodeModel();
        } else if (SCOPE_SHELF.equals(object)) {
            iNodeModel = this.getUiModel();
        } else if (SCOPE_CARD.equals(object)) {
            iNodeModel = this.getUiModel();
        }
        return iNodeModel;
    }

    public void rollSelectedCircuits(INetCircuit[] iNetCircuitArray, boolean bl) {
        if (iNetCircuitArray.length == 1) {
            Object object;
            Object object2;
            if (iNetCircuitArray[0].getCircuitTypeObj().isVcatCircuitType()) {
                object2 = new RollVcatMemberSelectionDialog(UiToolkit.instance().getApplicationFrame(), iNetCircuitArray[0]);
                ((Dialog)object2).show();
                if (!((RollVcatMemberSelectionDialog)object2).isOk()) {
                    return;
                }
                object = ((RollVcatMemberSelectionDialog)object2).getChoice();
                if (object != null) {
                    iNetCircuitArray[0] = object;
                }
            }
            if (iNetCircuitArray[0].getState() != 1 && iNetCircuitArray[0].getState() != 5) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CKT_ROLL_FAILURE_WRONG_STATE);
            } else if (iNetCircuitArray[0].isMonitorCircuit()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NO_MONITOR_SUPPORT);
            } else if (iNetCircuitArray[0].isDiag()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NO_DIAG_SUPPORT);
            } else if (iNetCircuitArray[0].getCircuitTypeObj().isOchncType()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NO_OCHNC_SUPPORT);
            } else {
                Object object3;
                object2 = null;
                object = null;
                if (iNetCircuitArray[0].hasNullCircuitId()) {
                    object2 = ErrorMsg.getString((EID)NEMC.WID_BRIDGE_AND_ROLL_TL1_CIRCUIT);
                    object = "TL1 Circuits";
                } else if (this.isHybridCkt(iNetCircuitArray[0])) {
                    object2 = ErrorMsg.getString((EID)NEMC.WID_BRIDGE_AND_ROLL_HYBRID_CIRCUIT);
                    object = "Hybrid Circuits";
                }
                if (object2 != null) {
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)object2, (String)object)) {
                        object3 = CircuitMergeManager.instance();
                        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
                        arrayList.add(iNetCircuitArray[0]);
                        ((CircuitMergeManager)object3).init(arrayList, 2);
                        try {
                            ((CircuitMergeManager)object3).mergeCircuits();
                        }
                        catch (CircuitMergeError circuitMergeError) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_UPGRADE_PARAM_1, (Object)circuitMergeError.getMessage());
                            return;
                        }
                    } else {
                        return;
                    }
                }
                object3 = new RollCreationDialog((JComponent)((Object)this), iNetCircuitArray[0], null, !bl);
                ((Dialog)object3).show();
            }
        } else if (iNetCircuitArray.length == 2) {
            Object object;
            Object object4;
            if (iNetCircuitArray[0].getCircuitTypeObj().isVcatCircuitType()) {
                if (iNetCircuitArray[1].getCircuitTypeObj().isVcatCircuitType()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NO_VCAT_SUPPORT);
                } else {
                    object4 = new RollVcatMemberSelectionDialog(UiToolkit.instance().getApplicationFrame(), iNetCircuitArray[0]);
                    ((Dialog)object4).show();
                    object = ((RollVcatMemberSelectionDialog)object4).getChoice();
                    if (object != null) {
                        iNetCircuitArray[0] = object;
                    }
                }
            } else if (iNetCircuitArray[1].getCircuitTypeObj().isVcatCircuitType()) {
                object4 = new RollVcatMemberSelectionDialog(UiToolkit.instance().getApplicationFrame(), iNetCircuitArray[1]);
                ((Dialog)object4).show();
                object = ((RollVcatMemberSelectionDialog)object4).getChoice();
                if (object != null) {
                    iNetCircuitArray[1] = object;
                }
            }
            if (iNetCircuitArray[0].getState() != 1 && iNetCircuitArray[0].getState() != 5 || iNetCircuitArray[1].getState() != 1 && iNetCircuitArray[1].getState() != 5) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CKT_ROLL_FAILURE_WRONG_STATE);
            } else if (iNetCircuitArray[0].isMonitorCircuit() || iNetCircuitArray[1].isMonitorCircuit()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NO_MONITOR_SUPPORT);
            } else if (iNetCircuitArray[0].isDiag() || iNetCircuitArray[1].isDiag()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NO_DIAG_SUPPORT);
            } else if (iNetCircuitArray[0].getCircuitTypeObj().isOchncType() || iNetCircuitArray[1].getCircuitTypeObj().isOchncType()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NO_OCHNC_SUPPORT);
            } else if (iNetCircuitArray[0].getCircuitSize() != iNetCircuitArray[1].getCircuitSize()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_WRONG_SIZE);
            } else if (this.isPortGroupingCkt(iNetCircuitArray[0]) || this.isPortGroupingCkt(iNetCircuitArray[1])) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_PG_CIRCUIT);
            } else {
                Object object5;
                object4 = null;
                object = null;
                if (iNetCircuitArray[0].hasNullCircuitId() && iNetCircuitArray[1].hasNullCircuitId()) {
                    object4 = ErrorMsg.getString((EID)NEMC.WID_BRIDGE_AND_ROLL_TL1_CIRCUIT);
                    object = "TL1 Circuits";
                } else if (this.isHybridCkt(iNetCircuitArray[0]) || this.isHybridCkt(iNetCircuitArray[1])) {
                    object4 = ErrorMsg.getString((EID)NEMC.WID_BRIDGE_AND_ROLL_HYBRID_CIRCUIT);
                    object = "Hybrid Circuits";
                }
                if (object4 != null) {
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)object4, (String)object)) {
                        object5 = CircuitMergeManager.instance();
                        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
                        for (int i = 0; i < 2; ++i) {
                            arrayList.add(iNetCircuitArray[i]);
                            ((CircuitMergeManager)object5).init(arrayList, 2);
                            try {
                                ((CircuitMergeManager)object5).mergeCircuits();
                            }
                            catch (CircuitMergeError circuitMergeError) {
                                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_UPGRADE_PARAM_1, (Object)circuitMergeError.getMessage());
                                return;
                            }
                            arrayList.clear();
                        }
                    } else {
                        return;
                    }
                }
                object5 = new RollCreationDialog((JComponent)((Object)this), iNetCircuitArray[0], iNetCircuitArray[1], !bl);
                ((Dialog)object5).show();
            }
        } else if (iNetCircuitArray.length > 2) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BRIDGE_AND_ROLL_NUM_CKTS);
        }
    }

    protected boolean isPortGroupingCkt(INetCircuit iNetCircuit) {
        try {
            return PortGrouping.isPortGroupingCircuit(iNetCircuit);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            return false;
        }
        catch (ProvisionError provisionError) {
            return false;
        }
    }

    private boolean isHybridCkt(INetCircuit iNetCircuit) {
        Iterator iterator = iNetCircuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.connectionless() || !NetCircuit.isNullCircuitId(netCircuitNode.getCircuitId())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCircuitSearchInfo() {
        if (db.on()) {
            db.println(">>> updateCircuitSearchInfo()");
        }
        int n = this.model.getRowCount();
        this.circuitsVector = new Vector(n);
        for (int i = 0; i < n; ++i) {
            try {
                INetCircuit iNetCircuit = (INetCircuit)this.table.getValueAt(i, 0);
                this.circuitsVector.add(iNetCircuit);
                continue;
            }
            catch (Exception exception) {
                db.finest("Exception in updateCircuitSearchInfo() " + exception);
            }
        }
        if (CircuitsPane.db.on) {
            db.println("CircuitsPane:updateCircuitSearchInfo: " + this.circuitsVector.toString());
        }
        if (this.csd == null) {
            return;
        }
        CircuitSearchDialog circuitSearchDialog = this.csd;
        synchronized (circuitSearchDialog) {
            this.csd.setCircuitsVector(this.circuitsVector);
            this.csd.setTable(this.table);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        INetCircuit iNetCircuit;
        if (db.on()) {
            db.println(">>> tableChanged()");
        }
        this.updateCircuitSearchInfo();
        if (this.csd != null && (iNetCircuit = this.csd.getSelectedCircuit()) != null && this.circuitsVector.contains(iNetCircuit)) {
            if (db.on()) {
                db.println("relocating the circuit  " + iNetCircuit.getCircuitName());
            }
            this.csd.setSelectedCircuit(iNetCircuit);
        }
        this.syncButtons(false);
        if (this.preselectionsActive) {
            this.selectPreselectedCircuits(false);
        }
    }

    protected boolean isAnyBlsr(int n) {
        return n == 0 || n == 4 || n == 11;
    }

    protected boolean selectThisCircuit(INetCircuit iNetCircuit) {
        if (CircuitsPane.db.on) {
            db.println("selectThisCircuit(" + iNetCircuit + ") called");
        }
        boolean bl = false;
        if (iNetCircuit != null) {
            ICircuitId iCircuitId;
            if (CircuitsPane.db.on) {
                db.println("   circuit is not null - it is: " + iNetCircuit.getCircuitName());
            }
            if (this.preselectedCircuitIds.contains(iCircuitId = iNetCircuit.getCircuitId())) {
                if (db.on()) {
                    db.println("selecting CircuitId " + iCircuitId.longValue());
                }
                bl = true;
            } else if (this.isAnyBlsr(iNetCircuit.getProtType()) && this.possibleBlsrCircuitIds.contains(iCircuitId)) {
                if (db.on()) {
                    db.println("selecting CircuitId " + iCircuitId.longValue());
                }
                bl = true;
            }
        }
        return bl;
    }

    private void selectPreselectedCircuits(boolean bl) {
        Object object;
        int n = 0;
        if (null != this.table) {
            this.table.clearSelection();
            object = null;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                object = (INetCircuit)this.table.getValueAt(i, 0);
                if (CircuitsPane.db.on) {
                    db.println("Evaluating circuit: " + object);
                }
                if (null != object) {
                    if (!this.selectThisCircuit((INetCircuit)object)) continue;
                    if (n == 0) {
                        this.table.getSelectionModel().setSelectionInterval(i, i);
                    } else {
                        this.table.getSelectionModel().addSelectionInterval(i, i);
                    }
                    ++n;
                    continue;
                }
                if (!CircuitsPane.db.on) continue;
                db.println("netCircuit was null");
            }
        } else if (CircuitsPane.db.on) {
            db.println("table was null");
        }
        if (bl && n < 1) {
            object = this.netViewLayer == 1 ? "No circuits affected by this alarm\nin the current network view scope (DWDM)." : (this.netViewLayer == 2 ? "No circuits affected by this alarm\nin the current network view scope (TDM)." : "No circuits affected by this alarm.");
            CerentDialog.infoDialog((Component)((Object)this), (String)object, (String)"Select Affected Circuits");
        }
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        db.fine("asynchronous update received:" + jobStatus.getResult());
        db.fine("asynchronous update received value:" + jobStatus.value());
        Object object2 = jobStatus.getResult();
        DetailedLog detailedLog = null;
        if (jobStatus.value() == 2) {
            String string = ErrorMsg.getString((EID)NEMC.EID_CIRCUIT_DELETION_ERROR) + "\n" + object2.toString();
            Exception exception = null;
            if (object2 instanceof Exception) {
                exception = (Exception)object2;
            }
            detailedLog = new DetailedLog(3, string, exception);
        } else if (object2 instanceof DeletionWarning) {
            SwingUtilities.invokeLater(new DeletionWarningMsg(object2));
        } else if (object2 instanceof DeletionError) {
            Exception exception = null;
            if (object2 instanceof Exception) {
                exception = (Exception)object2;
            }
            String string = ErrorMsg.getString((EID)NEMC.EID_CIRCUIT_DELETION_ERROR) + "\n" + exception.getMessage();
            detailedLog = new DetailedLog(3, string, exception);
        } else if (this.notifyCktDeletionCompletion) {
            detailedLog = new DetailedLog(1, object2.toString());
        }
        if (detailedLog != null) {
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, detailedLog);
        }
    }

    public void setPreselectedCircuitIds(List list) {
        this.preselectedCircuitIds = list;
        this.possibleBlsrCircuitIds = this.getPossibleBlsrCircuitIds();
        this.preselectionsActive = true;
        this.delayedSelectPreselectedCircuits(true);
    }

    protected Set getPossibleBlsrCircuitIds() {
        String string = "getPossibleBlsrCircuitIds(): ";
        HashSet hashSet = new HashSet();
        if (this.preselectedCircuitIds.size() == 0) {
            return hashSet;
        }
        Object e = this.preselectedCircuitIds.get(0);
        if (e != null && e instanceof ITdmPortModel) {
            Object object;
            BlsrRingModel blsrRingModel;
            IEntityModel iEntityModel;
            BlsrRingManager blsrRingManager = BlsrRingManager.instance();
            Set set = blsrRingManager.getBlsrRingModels();
            IEntityModel iEntityModel2 = new HashSet();
            boolean bl = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                iEntityModel = new HashSet();
                blsrRingModel = (BlsrRingModel)iterator.next();
                object = blsrRingModel.getBlsrNodes();
                for (int i = 0; i < ((BlsrNode[])object).length; ++i) {
                    if (object[i] == null) continue;
                    iEntityModel.add(object[i].getEastPort());
                    iEntityModel.add(object[i].getWestPort());
                    iEntityModel.add(object[i].getWestProtectPort());
                    iEntityModel.add(object[i].getEastProtectPort());
                }
                if (!iEntityModel.contains(e)) continue;
                bl = true;
                iEntityModel2 = iEntityModel;
                break;
            }
            if (bl && iEntityModel2 != null) {
                iterator = iEntityModel2.iterator();
                while (iterator.hasNext()) {
                    iEntityModel = (IEntityModel)iterator.next();
                    if (iEntityModel == null || iEntityModel == e || !(iEntityModel instanceof ITdmPortModel)) continue;
                    blsrRingModel = (ITdmPortModel)iEntityModel;
                    object = AlarmPane.getCircuitIdsFromPort((IPortModel)blsrRingModel);
                    hashSet.addAll(object);
                }
            }
            hashSet.removeAll(this.preselectedCircuitIds);
        }
        return hashSet;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.syncButtons(true);
        }
    }

    protected void showFilterDialog() {
        CircuitFilterDialog circuitFilterDialog = new CircuitFilterDialog(this, this.source.getCircuitFilter());
        circuitFilterDialog.show();
        if (circuitFilterDialog.okPressed()) {
            if (this.source.getCircuitFilter().size() <= 0) {
                this.filterIndicator.setSelected(false);
                this.setFilterActive(false);
            } else {
                this.filterIndicator.setSelected(true);
                this.setFilterActive(true);
            }
        } else if (this.source.getCircuitFilter().size() <= 0) {
            this.filterIndicator.setSelected(false);
        }
    }

    protected void syncButtons(boolean bl) {
        int n;
        int n2 = this.table != null ? this.table.getSelectedRowCount() : -1;
        int n3 = n = this.table != null ? this.table.getRowCount() : -1;
        if (db.on()) {
            db.println("syncButtons " + (n2 != -1 && n != -1 ? n2 + "/" + n + " (Sel/Tot)" + (n2 > n ? " !!!" : "") : "table is null"));
        }
        if (this.table != null) {
            boolean bl2;
            boolean bl3 = bl2 = n > 0 && n2 > 0;
            if (bl2) {
                this.enableComponent(this.deletePB);
                this.editPB.setEnabled(true);
                if (bl) {
                    this.updateCircuitSearchInfo();
                }
            } else {
                this.editPB.setEnabled(false);
                this.deletePB.setEnabled(false);
            }
        } else {
            this.editPB.setEnabled(false);
            this.deletePB.setEnabled(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        this.preselectionsActive = false;
        this.preselectedCircuitIds = null;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.editSelectedCircuits(this.getSelectedCircuits("Edit", false));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void rowsAdded(int n, int n2) {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void rowsUpdated(int n, int n2) {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void rowsDeleted(int n, int n2) {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void dataSourceChanged() {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void dataStructureChanged() {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void bulkRowAdded(int n, Object object) {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void bulkRowUpdated(int n, Object object, Object object2) {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void bulkRowDeleted(int n, Object object) {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void bulkDataSourceChanged() {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    public void bulkUpdateView() {
        if (this.preselectionsActive) {
            this.delayedSelectPreselectedCircuits(false);
        }
    }

    private void delayedSelectPreselectedCircuits(boolean bl) {
        PreselectCircuitsThread preselectCircuitsThread = new PreselectCircuitsThread(bl);
        SwingUtilities.invokeLater(preselectCircuitsThread);
    }

    class CircuitDeletionDialog {
        private INetCircuit[] circuitsToDelete;
        private int[] circuitCharacteristics;
        AdminStatePanel adminStateCB;

        public CircuitDeletionDialog(INetCircuit[] iNetCircuitArray, int[] nArray) {
            this.circuitsToDelete = iNetCircuitArray;
            this.circuitCharacteristics = nArray;
        }

        public void show() {
            JCheckBox jCheckBox;
            block6: {
                int n;
                block7: {
                    JLabel jLabel = new JLabel(ErrorMsg.getString((EID)NEMC.WID_DELETING_SERVICE_AFFECTING_PARAM_1, (Object)((this.circuitsToDelete.length < 2 ? "a " : "") + PluralisationUtil.s("circuit", this.circuitsToDelete.length))));
                    String string = this.circuitsToDelete.length < 2 ? "" : " " + this.circuitsToDelete.length;
                    String string2 = "Really delete the " + string + " selected " + PluralisationUtil.s("circuit", this.circuitsToDelete.length) + "?";
                    boolean bl = false;
                    String string3 = "";
                    this.adminStateCB = new AdminStatePanel(null, this.circuitsToDelete, false, true);
                    this.adminStateCB.setAdminState(0);
                    if (this.circuitCharacteristics[0] == 0) {
                        bl = true;
                    } else if (this.circuitCharacteristics[0] < this.circuitsToDelete.length) {
                        string3 = "Note that only " + this.circuitCharacteristics[0] + " " + PluralisationUtil.s("circuit", this.circuitCharacteristics[0]) + " " + PluralisationUtil.pluralise("support", this.circuitCharacteristics[0], 3) + " changing the state of drop ports.";
                    }
                    String string4 = "Notify when completed";
                    jCheckBox = new JCheckBox(string4, false);
                    Object[] objectArray = null;
                    objectArray = bl ? new Object[]{jLabel, new JLabel(string2), new JLabel("\n"), jCheckBox} : new Object[]{jLabel, new JLabel(string2), new JLabel("\n"), this.adminStateCB, new JLabel(string3), jCheckBox};
                    Object[] objectArray2 = new Object[]{"Yes", "No"};
                    int n2 = JOptionPane.showOptionDialog((Component)((Object)CircuitsPane.this), objectArray, "Delete Circuits", -1, 3, null, objectArray2, objectArray2[1]);
                    if (n2 != 0) break block6;
                    CircuitsPane.this.notifyCktDeletionCompletion = jCheckBox.isSelected();
                    boolean bl2 = this.adminStateCB.isDropPortsSelected();
                    int n3 = n = bl2 ? this.adminStateCB.getAdminState() : -1;
                    if (!bl2 || n == 0) break block7;
                    if (!AdminStatePanel.ConfirmDialog((JComponent)((Object)CircuitsPane.this), n, bl2)) break block6;
                }
                CircuitsPane.this.deleteSelectedCircuits(this.circuitsToDelete, n);
            }
            jCheckBox = null;
            this.adminStateCB = null;
        }
    }

    class PreselectCircuitsThread
    implements Runnable {
        boolean show = false;

        public PreselectCircuitsThread(boolean bl) {
            this.show = bl;
        }

        public void run() {
            try {
                Thread.sleep(300L);
                CircuitsPane.this.selectPreselectedCircuits(this.show);
            }
            catch (Exception exception) {
                db.finest("Exception in delayedSelectPreselectedCircuits() " + exception);
            }
        }
    }

    class DeletionWarningMsg
    implements Runnable {
        private Object res = null;

        DeletionWarningMsg(Object object) {
            this.res = object;
        }

        public void run() {
            DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent((Component)((Object)CircuitsPane.this)), (String)"Circuit Deletion Warning");
            DeletionWarning deletionWarning = (DeletionWarning)this.res;
            int n = deletionWarning.getPortCount();
            detailedDialog.setText(ErrorMsg.getString((EID)NEMC.WID_ADMIN_STATE_NOT_ALLOWED_PARAM_2, (Object)deletionWarning.getAdminStateTerm(), (Object)(n + " " + PluralisationUtil.s("port", n))), CerentDialog.WARNING_ICON);
            detailedDialog.append(((Exception)this.res).getMessage());
            detailedDialog.setSize(500, detailedDialog.getHeight());
            detailedDialog.show();
        }
    }
}

