/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILoPathTraceSupport;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.circuits.AbstractPathTrace;
import cerent.cms.ui.circuits.IJTrace;
import cerent.util.SDebug;

public class J2PathTrace
extends AbstractPathTrace
implements IJTrace {
    private static final SDebug db = new SDebug("J2PathTrace");
    public static final String DISABLE_AIS = " Disable AIS and RDI on J2-TIM";
    public static final String DISABLE_MISMATCH = " Disable AIS on LO SLM";
    int oldState = 0;
    private IInterfaceModel[] loModels;
    protected final boolean circuitLevel;
    protected INetCircuit netCircuit;

    public J2PathTrace(IInterfaceModel[] iInterfaceModelArray, INetCircuit iNetCircuit, boolean bl) {
        super(iInterfaceModelArray[0]);
        this.circuitLevel = bl;
        this.netCircuit = iNetCircuit;
        this.loModels = iInterfaceModelArray;
    }

    public boolean providesCommonFeature() {
        boolean bl = false;
        if (this.loModels != null && this.loModels[0] != null) {
            INodeModel iNodeModel = this.loModels[0].getNodeModel();
            bl = iNodeModel.provides(Feature.J2_COMMON);
        }
        return bl;
    }

    public boolean providesNoAis() {
        boolean bl = false;
        if (this.loModels != null && this.loModels[0] != null) {
            for (int i = 0; i < this.loModels.length; ++i) {
                INodeModel iNodeModel = this.loModels[i].getNodeModel();
                if (!iNodeModel.provides(Feature.J2_NOAIS)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean providesAutoMode(int n) {
        INodeModel iNodeModel;
        boolean bl = true;
        if (this.loModels != null && this.loModels[0] != null && this.loModels[n] != null && (iNodeModel = this.loModels[n].getNodeModel()) != null) {
            bl = !Feature.provides((INodeModel)iNodeModel, (Feature)Feature.NO_J1_AUTOMODE);
        }
        return bl;
    }

    public String getDisableAisString() {
        return DISABLE_AIS;
    }

    public int numModels() {
        int n = 0;
        if (this.loModels != null) {
            n = this.loModels.length;
        }
        return n;
    }

    public String getDisableMismatchString() {
        return DISABLE_MISMATCH;
    }

    public int getPathTraceMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.loModels != null && this.loModels[0] != null) {
            if (this.pathTraceCleanupSupported) {
                return ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getPathTraceMode();
            }
            return ((ITdmLoModel)this.loModels[0]).getLoPathTraceMode();
        }
        return 0;
    }

    public int getPayloadMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.loModels != null && this.loModels[0] != null) {
            if (this.pathTraceCleanupSupported) {
                return ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getPayloadMode();
            }
            return ((ITdmLoModel)this.loModels[0]).getLoPayloadMode();
        }
        return 0;
    }

    public void setPathTraceMode(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.loModels != null && this.loModels[n] != null) {
            if (this.pathTraceCleanupSupported) {
                ((ILoPathTraceSupport)this.loModels[n]).getLoPathTraceModel().setPathTraceMode(n2);
            } else {
                ((ITdmLoModel)this.loModels[n]).setLoPathTraceMode(n2);
            }
        }
    }

    public void setPayloadMode(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.loModels != null && this.loModels[n] != null) {
            if (this.pathTraceCleanupSupported) {
                ((ILoPathTraceSupport)this.loModels[n]).getLoPathTraceModel().setPayloadMode(n2);
            } else {
                ((ITdmLoModel)this.loModels[n]).setLoPayloadMode(n2);
            }
        }
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        byte by = 0;
        if (this.loModels != null && this.loModels[0] != null) {
            by = this.pathTraceCleanupSupported ? ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getCurrentPayloadLabel() : ((ITdmLoModel)this.loModels[0]).getLoTermCurrentPayloadLabel();
        }
        return by;
    }

    public byte getExpectedPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.loModels != null && this.loModels[0] != null) {
            if (this.pathTraceCleanupSupported) {
                return ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getExpectedPayloadCode();
            }
            return ((ITdmLoModel)this.loModels[0]).getLoTermExpectedPayloadCode();
        }
        return 0;
    }

    public void setSendPathTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.loModels != null && this.loModels[n] != null) {
            if (this.pathTraceCleanupSupported) {
                ((ILoPathTraceSupport)this.loModels[n]).getLoPathTraceModel().setSendPathTrace(string);
            } else {
                ((ITdmLoModel)this.loModels[n]).setLoSendPathTrace(string);
            }
        }
    }

    public char[] getSendPathTrace() {
        char[] cArray = null;
        try {
            String string = null;
            if (this.loModels != null && this.loModels[0] != null) {
                string = this.pathTraceCleanupSupported ? ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getSendPathTrace() : ((ITdmLoModel)this.loModels[0]).getLoSendPathTrace();
            }
            if (string != null) {
                cArray = string.toCharArray();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            cArray = "<unable to retrieve transmit path trace from card>".toCharArray();
        }
        return cArray;
    }

    public void setExpectedPathTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.loModels != null && this.loModels[n] != null) {
            if (this.pathTraceCleanupSupported) {
                ((ILoPathTraceSupport)this.loModels[n]).getLoPathTraceModel().setExpectedPathTrace(string);
            } else {
                ((ITdmLoModel)this.loModels[n]).setLoExpectedPathTrace(string);
            }
        }
    }

    public char[] getExpectedPathTrace() {
        char[] cArray = null;
        try {
            if (this.loModels != null && this.loModels[0] != null) {
                cArray = this.pathTraceCleanupSupported ? ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getExpectedPathTrace() : ((ITdmLoModel)this.loModels[0]).getLoExpectedPathTrace();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            cArray = "<unable to retrieve expected path trace from card>".toCharArray();
        }
        return cArray;
    }

    public char[] getReceivedPathTrace() {
        char[] cArray = null;
        try {
            if (this.loModels != null && this.loModels[0] != null) {
                cArray = this.pathTraceCleanupSupported ? ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getReceivedPathTrace() : ((ITdmLoModel)this.loModels[0]).getLoReceivedPathTrace();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            cArray = "<unable to retrieve received path trace from card>".toCharArray();
        }
        return cArray;
    }

    public void setPathTraceFormat(int n, int n2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.loModels != null && this.loModels[n] != null) {
            if (this.pathTraceCleanupSupported) {
                ((ILoPathTraceSupport)this.loModels[n]).getLoPathTraceModel().setPathTraceFormat(n2);
            } else {
                ((ITdmLoModel)this.loModels[n]).setLoPathTraceFormat(n2);
            }
        }
    }

    public int getPathTraceFormat() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        int n = 0;
        if (this.loModels != null && this.loModels[0] != null) {
            n = this.pathTraceCleanupSupported ? ((ILoPathTraceSupport)this.loModels[0]).getLoPathTraceModel().getPathTraceFormat() : ((ITdmLoModel)this.loModels[0]).getLoPathTraceFormat();
        }
        return n;
    }
}

