/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetServiceState;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class NetCircuitNodeColumnRenderer
extends AbstractColumnRenderer {
    private static TDMTerminology tdmTerm;
    public static final int NODE = 0;
    public static final int NAME = 1;
    public static final int END1 = 2;
    public static final int END2 = 3;
    public static final int ADMIN_STATE = 4;
    public static final int SERVICE_STATE = 5;
    static final int PER_NODE = 0;
    static final int[][] columns;
    private JLabel label;
    private JTextArea textArea;
    private int mode;
    private static int EBW;
    private static EmptyBorder emptyBorder;
    private static final SDebug db;

    public NetCircuitNodeColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.textArea = new JTextArea();
        this.textArea.setOpaque(true);
        this.textArea.setForeground(Color.black);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        this.textArea.setLineWrap(true);
        this.label.setBorder(emptyBorder);
        this.textArea.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = this.label;
        this.label.setText("");
        INetCircuitNode iNetCircuitNode = (INetCircuitNode)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (this.mode) {
            case 0: {
                this.label.setText(iNetCircuitNode.getNodeModel().getName());
                break;
            }
            case 1: {
                String string = iNetCircuitNode.getConnNameFromNE();
                if (string != null) {
                    this.label.setText(string);
                    break;
                }
                this.label.setText("");
                break;
            }
            case 2: {
                jComponent = this.textArea;
                this.textArea.setText(NetCircuitNodeColumnRenderer.getSource(iNetCircuitNode, true));
                break;
            }
            case 3: {
                jComponent = this.textArea;
                this.textArea.setText(NetCircuitNodeColumnRenderer.getSource(iNetCircuitNode, false));
                break;
            }
            case 4: {
                this.label.setText(NetAdminState.getAdminStateStringFromAdminState(iNetCircuitNode.getAdminState()));
                break;
            }
            case 5: {
                this.label.setText(NetServiceState.getServiceStateStringFromServiceState(iNetCircuitNode.getServiceState()));
            }
        }
        ((Component)jComponent).setForeground(color);
        ((Component)jComponent).setBackground(color2);
        if (jComponent == this.textArea) {
            int n3 = this.textArea.getPreferredSize().height;
            int n4 = jTable.getRowHeight();
            if (n4 < n3) {
                if (NetCircuitNodeColumnRenderer.db.on) {
                    db.println("Increasing table row height from " + n4 + " to " + n3);
                }
                jTable.setRowHeight(n3);
            }
        }
        return jComponent;
    }

    static ColumnRenderer[] createTableRenderers(int n) {
        if (n < 0 || n >= columns.length) {
            return null;
        }
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columns[n].length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = NetCircuitNodeColumnRenderer.createNetCircuitNodeColumnRenderer(columns[n][i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createNetCircuitNodeColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Node";
                n3 = 150;
                bl = true;
                n2 = 0;
                break;
            }
            case 1: {
                string = "Name";
                n3 = 150;
                bl = true;
                n2 = 0;
                break;
            }
            case 2: {
                string = "End A";
                n3 = 150;
                bl = true;
                n2 = 0;
                break;
            }
            case 3: {
                string = "End B";
                n3 = 150;
                bl = true;
                n2 = 0;
                break;
            }
            case 4: {
                string = "CRS Admin State";
                n3 = 150;
                bl = true;
                n2 = 0;
                break;
            }
            case 5: {
                string = "CRS Service State";
                n3 = 150;
                bl = true;
                n2 = 0;
                break;
            }
            default: {
                string = "???";
                n3 = 150;
                bl = false;
                n2 = 2;
            }
        }
        return new NetCircuitNodeColumnRenderer(n, string, n3, bl, n2);
    }

    public static String getSource(INetCircuitNode iNetCircuitNode, boolean bl) {
        int n;
        int[] nArray = new int[]{-1, -1};
        switch (iNetCircuitNode.getConnectionType()) {
            case 0: 
            case 1: 
            case 9: {
                nArray[0] = 0;
                break;
            }
            case 2: 
            case 4: {
                nArray[0] = 2;
                break;
            }
            case 17: {
                nArray[0] = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                nArray[0] = 0;
                nArray[1] = 1;
                break;
            }
            default: {
                if (db.on()) {
                    db.println("Could not determine connection type " + iNetCircuitNode.getConnectionType() + " in " + "getSource() for " + iNetCircuitNode);
                }
                return "";
            }
        }
        Object[] objectArray = iNetCircuitNode.getPathList().toArray();
        StringBuffer stringBuffer = new StringBuffer(64);
        for (n = 0; n < objectArray.length; ++n) {
            if (n == nArray[0] || n == nArray[1]) {
                if (!bl) continue;
                stringBuffer.append(NetCircuitNodeColumnRenderer.getPathDefString(objectArray[n])).append(',');
                continue;
            }
            if (bl) continue;
            stringBuffer.append(NetCircuitNodeColumnRenderer.getPathDefString(objectArray[n])).append(',');
        }
        n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.deleteCharAt(n - 1);
        } else if (iNetCircuitNode instanceof LoTunnelNode) {
            if (bl) {
                return "Tunnel";
            }
            IConnectionModel iConnectionModel = ((LoTunnelNode)iNetCircuitNode).getConn();
            if (iConnectionModel instanceof ILoAditModel) {
                return NetCircuitNodeColumnRenderer.getPathDefString(((ILoAditModel)iConnectionModel).getHo());
            }
        }
        return stringBuffer.toString();
    }

    public static IHoNum physicalHoNum(IHoPathDefModel iHoPathDefModel) {
        IHoNum iHoNum = iHoPathDefModel.getStartingHo();
        short s = iHoPathDefModel.getPool().includedPath().getStartingHo().getIdlHoNum();
        if (s == 1) {
            return iHoNum;
        }
        return HoLoFactory.idlSts2HoNum(iHoNum.getFramingType(), s + iHoNum.getIdlHoNum() - 1);
    }

    public static String getPathDefString(Object object) {
        ILoDefModel iLoDefModel;
        block11: {
            short s;
            ILoNum iLoNum;
            block10: {
                iLoNum = null;
                s = 0;
                if (object instanceof ILoDefModel) {
                    iLoDefModel = (ILoDefModel)object;
                    IHoPathDefModel iHoPathDefModel = iLoDefModel.getLoAdit().getHo();
                    iLoNum = iLoDefModel.getLoNum();
                    INodeModel iNodeModel = iHoPathDefModel.getNodeModel();
                    IEntityModel iEntityModel = null;
                    try {
                        if (iNodeModel.provides(Feature.VCAT)) {
                            s = iLoDefModel.getPathIdentifier();
                            iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(iLoDefModel.getPortIndex());
                        }
                        IEntityModel iEntityModel2 = iEntityModel == null ? iHoPathDefModel.getPool().getEntityModel() : iEntityModel;
                        return CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel2, NetCircuitNodeColumnRenderer.physicalHoNum(iHoPathDefModel), iLoNum, s);
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block10;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            if (object instanceof IHoPathDefModel) {
                iLoDefModel = (IHoPathDefModel)object;
                if (s == 0 && iLoDefModel.getNodeModel().provides(Feature.VCAT)) {
                    s = iLoDefModel.getPathIdentifier();
                }
                try {
                    return CircuitEndCellRenderer.asSlashSeparatedString(iLoDefModel.getPool().getEntityModel(), NetCircuitNodeColumnRenderer.physicalHoNum((IHoPathDefModel)iLoDefModel), iLoNum, s);
                }
                catch (Exception exception) {
                    if (!db.on()) break block11;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (object instanceof IOchncPathDefModel) {
            iLoDefModel = (IOchncPathDefModel)object;
            return CircuitEndCellRenderer.asSlashSeparatedString((IOchncPathDefModel)iLoDefModel);
        }
        if (object instanceof IOchccPathDefModel) {
            iLoDefModel = (IOchccPathDefModel)object;
            return CircuitEndCellRenderer.asSlashSeparatedString((IOchccPathDefModel)iLoDefModel);
        }
        return "unknown";
    }

    static {
        columns = new int[][]{{0, 1, 2, 3, 4, 5}};
        EBW = 2;
        emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
        db = new SDebug("NetCircuitNodeColumnRenderer");
    }
}

