/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.circuits.OchccProtectedCircuitMapNode;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLinkConnector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class OchccProtectedCircuitMapPort
extends CircuitMapPort {
    private static final String UNLOCK_STR = "UNLOCK";
    private static final String LOCK_OUT_STR = "LOCK OUT";
    private static final String LOCK_ON_STR = "LOCK ON";
    private static final String CMD_SELECTOR_OP = "PS";
    private SDebug db = new SDebug("OchccProtectedCircuitMapPort");
    private int trunkIndex;
    protected String protectionString;

    public OchccProtectedCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, int n) {
        super(detailedMapNode, mapLinkConnector);
        this.trunkIndex = n;
    }

    int getTrunkIndex() {
        return this.trunkIndex;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        super.initPopupMenu(uPopupMenu);
        JMenu jMenu = new JMenu("Protection Group");
        uPopupMenu.add((JMenuItem)jMenu);
        Object object = this.parentNode.getUserObject();
        if (object != null && object instanceof INodeModel) {
            boolean bl;
            INodeModel iNodeModel = (INodeModel)object;
            boolean bl2 = AbstractPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.MAINTENANCE);
            int n = 0;
            CircuitMapNode circuitMapNode = (CircuitMapNode)this.parentNode;
            IEntityModel iEntityModel = this.getTrunk();
            if (iEntityModel == null) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Selector information unavailable.", 42);
                return;
            }
            boolean bl3 = OchTrailHelper.isWorkingPort(iEntityModel);
            JMenu jMenu2 = new JMenu("Switch Commands");
            jMenu.add(jMenu2);
            JMenu jMenu3 = new JMenu("Inhibit Switching");
            jMenu.add(jMenu3);
            try {
                n = OchTrailHelper.getProtectionOp(iEntityModel);
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Protection Op unavailable.", 42);
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                return;
            }
            boolean bl4 = n == 1 || n == 2;
            boolean bl5 = bl = n == 4 || n == 3;
            if (bl3) {
                Attribute attribute = OchccProtectedCircuitMapNode.getAttributeForVal(0);
                this.addMenuItem(jMenu2, attribute, n, bl2 && !bl4);
                Attribute attribute2 = OchccProtectedCircuitMapNode.getAttributeForVal(6);
                this.addMenuItem(jMenu2, attribute2, n, bl2 && !bl4 && !bl);
                Attribute attribute3 = OchccProtectedCircuitMapNode.getAttributeForVal(4);
                this.addMenuItem(jMenu2, attribute3, n, bl2 && !bl4);
                Attribute attribute4 = new Attribute(UNLOCK_STR, 0);
                this.addMenuItem(jMenu3, attribute4, n, bl2 && bl4);
                Attribute attribute5 = new Attribute(LOCK_ON_STR, 1);
                this.addMenuItem(jMenu3, attribute5, n, bl2 && !bl4);
            } else {
                Attribute attribute = OchccProtectedCircuitMapNode.getAttributeForVal(0);
                this.addMenuItem(jMenu2, attribute, n, bl2 && !bl4);
                Attribute attribute6 = OchccProtectedCircuitMapNode.getAttributeForVal(5);
                this.addMenuItem(jMenu2, attribute6, n, bl2 && !bl4 && !bl);
                Attribute attribute7 = OchccProtectedCircuitMapNode.getAttributeForVal(3);
                this.addMenuItem(jMenu2, attribute7, n, bl2 && !bl4);
                Attribute attribute8 = new Attribute(UNLOCK_STR, 0);
                this.addMenuItem(jMenu3, attribute8, n, bl2 && bl4);
                Attribute attribute9 = new Attribute(LOCK_OUT_STR, 1);
                this.addMenuItem(jMenu3, attribute9, n, bl2 && !bl4);
            }
        }
    }

    private void addMenuItem(JMenu jMenu, Attribute attribute, int n, boolean bl) {
        if (attribute != null) {
            boolean bl2;
            boolean bl3 = bl2 = attribute.getIntValue() == n;
            if (bl2 && attribute.toString().equals(UNLOCK_STR)) {
                bl2 = false;
            } else if (n == 4 && attribute.getIntValue() == 3) {
                bl2 = true;
            } else if (n == 3 && attribute.getIntValue() == 4) {
                bl2 = true;
            } else if (n == 6 && attribute.getIntValue() == 5) {
                bl2 = true;
            } else if (n == 5 && attribute.getIntValue() == 6) {
                bl2 = true;
            }
            AttributeMenuItem attributeMenuItem = new AttributeMenuItem(attribute, attribute.toString() + (bl2 ? " (current operation)" : ""));
            attributeMenuItem.setEnabled(bl && !bl2);
            if (!bl2) {
                attributeMenuItem.setActionCommand(CMD_SELECTOR_OP);
                attributeMenuItem.addActionListener(this);
            }
            jMenu.add(attributeMenuItem);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_SELECTOR_OP)) {
            AttributeMenuItem attributeMenuItem = (AttributeMenuItem)actionEvent.getSource();
            String string2 = attributeMenuItem.getText();
            int n = attributeMenuItem.getAttribute().getIntValue();
            if (n == -1) {
                ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_CANT_MATCH_MENU_ITEM_PARAM_1, (Object)string2);
                return;
            }
            IEntityModel iEntityModel = this.getTrunk();
            if (iEntityModel != null) {
                boolean bl = n == 5 || n == 3;
                try {
                    if (bl && !CerentDialog.yesNoDialog((Component)this.mtk.getGraphWindow(), (String)(NEMC.WID_SWITCH_TO_ACTIVE_WARNING + "\n\nOK to continue?"), (String)"Confirm Selector Switch")) {
                        return;
                    }
                    if (!CerentDialog.yesNoDialog((Component)this.mtk.getGraphWindow(), (String)("Switching selector to " + string2 + ";\n" + "OK to continue?"), (String)"Confirm Selector Switch")) {
                        return;
                    }
                    OchTrailHelper.setProtectionOp(iEntityModel, n);
                }
                catch (InvalidProtectionOp invalidProtectionOp) {
                    SDebug.printStackTrace((Throwable)invalidProtectionOp);
                    ErrorMsg.displayDetailed((Component)this.mtk.getGraphWindow(), NEMC.EID_INVALID_PROTECTION_OPER, invalidProtectionOp.getMessage());
                }
                catch (InternalCommError internalCommError) {
                    SDebug.printStackTrace((Throwable)internalCommError);
                    ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)internalCommError.getMessage());
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                    ErrorMsg.displayDetailed(null, NEMC.EID_CANNOT_FIND_ELEMENT_MODEL_PARAM1, abstractCmsNoSuchElementException.getMessage());
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public String getProtectionString() {
        return this.protectionString;
    }

    public void setProtectionString(String string) {
        this.protectionString = string;
    }

    public String getToolTipText() {
        return super.getToolTipText() + this.protectionString;
    }

    IEntityModel getTrunk() {
        Object object = this.parentNode.getUserObject();
        if (object != null && object instanceof INodeModel) {
            INodeModel iNodeModel = (INodeModel)object;
            CircuitMapNode circuitMapNode = (CircuitMapNode)this.parentNode;
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            int n = circuitMapNode.getEntityIndex(this);
            try {
                return iEntityTableModel.getEntityModelByIndex(n);
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Cannot find trunk EM for " + Integer.toHexString(n) + ": " + exception.getMessage());
                }
                return null;
            }
        }
        if (this.db.on()) {
            this.db.println("parentKey is not a valid INodeModel instance: " + object);
        }
        return null;
    }

    class AttributeMenuItem
    extends JMenuItem {
        private Attribute attr;

        AttributeMenuItem(Attribute attribute, String string) {
            super(string);
            this.attr = attribute;
        }

        Attribute getAttribute() {
            return this.attr;
        }
    }

    public static class InternalCircuitMapPort
    extends OchccProtectedCircuitMapPort {
        private static final double PORTWIDTH = 8.0;
        private static final double PORTHEIGHT = 8.0;

        public InternalCircuitMapPort(AbstractInternalPG abstractInternalPG, DetailedMapNode detailedMapNode, int n) {
            super(detailedMapNode, null, n);
            this.setInternalPG(abstractInternalPG);
        }

        public void graphicallyInitPort() {
            super.graphicallyInitPort();
            this.setSize(8.0, 8.0);
        }
    }
}

