/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OchncLinesPanel
extends JPanel {
    private static final String OUT_PORT = "Out:";
    private static final String IN_PORT = "In:";
    private static final String OUT_WORKING_PORT = "Out[w]:";
    private static final String IN_WORKING_PORT = "In[w]:";
    private static final String OUT_PROTECTION_PORT = "Out[p]:";
    private static final String IN_PROTECTION_PORT = "In[p]:";
    private static final String UNKNOWN_PORT = "Unknown";
    private SDebug db;
    private boolean isOchnc;
    private boolean isOchTrail;
    private int cktOptChannel;
    private boolean isBidirectional;
    private boolean isValid;
    private String errorMessage;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();

    public OchncLinesPanel(SDebug sDebug, CircuitCreatInfo circuitCreatInfo) {
        this.db = sDebug;
        this.isBidirectional = circuitCreatInfo.dir() == 1;
        this.cktOptChannel = circuitCreatInfo.cktOptChannel();
        this.isOchnc = circuitCreatInfo.type() == 9;
        this.isOchTrail = circuitCreatInfo.type() == 14;
        this.init();
        this.initLayout();
        this.setBorder(BorderFactory.createTitledBorder("OTS Lines"));
    }

    public OchncLinesPanel(SDebug sDebug, int n) {
        this.db = sDebug;
        this.cktOptChannel = n;
        this.isBidirectional = true;
        this.isOchnc = false;
        this.isOchTrail = true;
        this.init();
        this.initLayout();
        this.setBorder(BorderFactory.createTitledBorder("OTS Lines"));
    }

    public void setSelectedEntity(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        this.reset();
        if (this.isOchnc) {
            this.setSelectedEntityForOchnc(iNetCircuitEnd, bl);
        } else if (this.isOchTrail) {
            this.setSelectedEntityForOchTrail(iNetCircuitEnd, bl);
        }
        this.gbl.layoutContainer(this);
        this.repaint();
    }

    public void setSelectedEntity(IEntityModel iEntityModel, boolean bl) {
        this.reset();
        if (this.isOchnc) {
            this.setSelectedEntityForOchnc(iEntityModel, bl);
        } else if (this.isOchTrail) {
            this.setSelectedEntityForOchTrail(iEntityModel, bl);
        }
        this.gbl.layoutContainer(this);
        this.repaint();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setSelectedEntityForOchTrail(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        INodeModel iNodeModel = iNetCircuitEnd.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            if (this.db.on()) {
                this.db.println("Cannot find endpoint entity model for " + iNetCircuitEnd);
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            this.isValid = false;
            this.errorMessage = "Cannot find entity model for endpoint:\n" + iNetCircuitEnd + "\nError: " + objNotFound.getMessage();
            return;
        }
        this.setSelectedEntityForOchTrail(iEntityModel, bl);
    }

    public void setSelectedEntityForOchTrail(IEntityModel iEntityModel, boolean bl) {
        IEntityModel iEntityModel2;
        IEntityModel iEntityModel3;
        int n;
        IEntityModel[][] iEntityModelArrayArray;
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        int n2 = iEntityModel.getEqType();
        int n3 = iEntityModel.getModuleModel().getEqType();
        boolean bl2 = OchTrailHelper.isClientPort(n2);
        boolean bl3 = !bl2 && OchTrailHelper.isTrunkPort(n2);
        boolean bl4 = OchTrailHelper.isProtected(n3);
        IEntityModel[] iEntityModelArray = new IEntityModel[]{};
        if (bl2) {
            iEntityModelArrayArray = iNodeModel.getEntityTable();
            try {
                iEntityModelArray = OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex());
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Cannot find trunk ports for client " + iEntityModel);
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.isValid = false;
                this.errorMessage = "Failed to get trunk ports for client " + iEntityModel + "\nError: " + exception.getMessage();
            }
        } else {
            iEntityModelArray = new IEntityModel[]{iEntityModel};
        }
        if (this.isValid && bl4 && iEntityModelArray.length != 2) {
            this.isValid = false;
            this.errorMessage = "Protected cards must have 2 trunk ports (found " + iEntityModelArray.length + ")";
        }
        iEntityModelArrayArray = new IEntityModel[iEntityModelArray.length][];
        boolean bl5 = false;
        for (n = 0; n < iEntityModelArray.length; ++n) {
            iEntityModelArrayArray[n] = new IEntityModel[0];
            try {
                iEntityModelArrayArray[n] = OchTrailHelper.getColocatedOchPorts(iEntityModelArray[n]);
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Cannot find colocated ports for trunk " + iEntityModelArray[n]);
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.isValid = false;
                this.errorMessage = "Failed to get colocated OCH ports for trunk:\n" + iEntityModelArray[n] + "\nError: " + exception.getMessage();
            }
            if (bl5) continue;
            bl5 = iEntityModelArrayArray[n].length > 0;
        }
        if (!bl5) {
            if (this.db.on()) {
                this.db.println("Non colocated trunk ports. No OTS Lines.");
            }
            return;
        }
        if (this.isValid) {
            for (n = 0; this.isValid && n < iEntityModelArray.length; ++n) {
            }
        }
        this.initLayout();
        JLabel[] jLabelArray = new JLabel[]{};
        JLabel[] jLabelArray2 = new JLabel[]{};
        if (bl4) {
            jLabelArray = new JLabel[]{new JLabel(OUT_WORKING_PORT), new JLabel(OUT_PROTECTION_PORT)};
            jLabelArray2 = new JLabel[]{new JLabel(IN_WORKING_PORT), new JLabel(IN_PROTECTION_PORT)};
        } else {
            jLabelArray = new JLabel[]{new JLabel(OUT_PORT)};
            jLabelArray2 = new JLabel[]{new JLabel(IN_PORT)};
        }
        JTextField[] jTextFieldArray = new JTextField[jLabelArray.length];
        JTextField[] jTextFieldArray2 = new JTextField[jLabelArray2.length];
        for (int i = 0; i < 2; ++i) {
            if (bl && i < jLabelArray.length) {
                jTextFieldArray[i] = this.addTF(jLabelArray[i], this.gbc);
            }
            if (i < jLabelArray2.length) {
                jTextFieldArray2[i] = this.addTF(jLabelArray2[i], this.gbc);
            }
            if (bl || i >= jLabelArray.length) continue;
            jTextFieldArray[i] = this.addTF(jLabelArray[i], this.gbc);
        }
        String string = UNKNOWN_PORT;
        if (iEntityModelArrayArray[0].length > 0 && (iEntityModel3 = OchPortsHelper.getOutLinePort(this.cktOptChannel, iEntityModelArrayArray[0][0])) != null) {
            string = CircuitMapUtil.getSpanLabel(iEntityModel3, null, null);
        }
        jTextFieldArray[0].setText(string);
        string = UNKNOWN_PORT;
        if (iEntityModelArrayArray[0].length > 1 && (iEntityModel2 = OchPortsHelper.getInLinePort(this.cktOptChannel, iEntityModelArrayArray[0][1])) != null) {
            string = CircuitMapUtil.getSpanLabel(iEntityModel2, null, null);
        }
        jTextFieldArray2[0].setText(string);
        if (bl4) {
            IEntityModel iEntityModel4;
            string = UNKNOWN_PORT;
            if (iEntityModelArrayArray[1].length > 0 && (iEntityModel4 = OchPortsHelper.getOutLinePort(this.cktOptChannel, iEntityModelArrayArray[1][0])) != null) {
                string = CircuitMapUtil.getSpanLabel(iEntityModel4, null, null);
            }
            jTextFieldArray[1].setText(string);
            string = UNKNOWN_PORT;
            if (iEntityModelArrayArray[1].length > 1 && (iEntityModel2 = OchPortsHelper.getInLinePort(this.cktOptChannel, iEntityModelArrayArray[1][1])) != null) {
                string = CircuitMapUtil.getSpanLabel(iEntityModel2, null, null);
            }
            jTextFieldArray2[1].setText(string);
        }
    }

    public void setSelectedEntityForOchnc(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        INodeModel iNodeModel = iNetCircuitEnd.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            if (this.db.on()) {
                this.db.println("Cannot find endpoint entity model for " + iNetCircuitEnd);
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            this.isValid = false;
            this.errorMessage = "Cannot find entity model for endpoint:\n" + iNetCircuitEnd + "\nError: " + objNotFound.getMessage();
            return;
        }
        this.setSelectedEntityForOchnc(iEntityModel, bl);
    }

    public void setSelectedEntityForOchnc(IEntityModel iEntityModel, boolean bl) {
        int n = iEntityModel.getEqType();
        int n2 = iEntityModel.getModuleModel().getEqType();
        boolean bl2 = OchPortsHelper.isAddPort(iEntityModel);
        this.initLayout();
        JLabel[] jLabelArray = new JLabel[]{};
        JLabel[] jLabelArray2 = new JLabel[]{};
        if (this.isBidirectional) {
            jLabelArray = new JLabel[]{new JLabel(OUT_PORT)};
            jLabelArray2 = new JLabel[]{new JLabel(IN_PORT)};
        } else if (bl2) {
            jLabelArray = new JLabel[]{new JLabel(OUT_PORT)};
        } else {
            jLabelArray2 = new JLabel[]{new JLabel(IN_PORT)};
        }
        JTextField[] jTextFieldArray = new JTextField[jLabelArray.length];
        JTextField[] jTextFieldArray2 = new JTextField[jLabelArray2.length];
        for (int i = 0; i < 2; ++i) {
            if (bl2 && i < jLabelArray.length) {
                jTextFieldArray[i] = this.addTF(jLabelArray[i], this.gbc);
            }
            if (i < jLabelArray2.length) {
                jTextFieldArray2[i] = this.addTF(jLabelArray2[i], this.gbc);
            }
            if (bl2 || i >= jLabelArray.length) continue;
            jTextFieldArray[i] = this.addTF(jLabelArray[i], this.gbc);
        }
        if (bl2 || this.isBidirectional) {
            IEntityModel iEntityModel2 = OchPortsHelper.getOutLinePort(this.cktOptChannel, iEntityModel);
            if (iEntityModel2 != null) {
                jTextFieldArray[0].setText(CircuitMapUtil.getSpanLabel(iEntityModel2, null, null));
            } else {
                jTextFieldArray[0].setText(UNKNOWN_PORT);
                this.isValid = false;
                this.errorMessage = "Cannot find Out OTS line for selected endpoint";
            }
        }
        if (!bl2 || this.isBidirectional) {
            IEntityModel iEntityModel3 = OchPortsHelper.getInLinePort(this.cktOptChannel, iEntityModel);
            if (iEntityModel3 != null) {
                jTextFieldArray2[0].setText(CircuitMapUtil.getSpanLabel(iEntityModel3, null, null));
            } else {
                jTextFieldArray2[0].setText(UNKNOWN_PORT);
                this.isValid = false;
                this.errorMessage = "Cannot find In OTS line for selected endpoint";
            }
        }
    }

    protected JTextField addTF(JLabel jLabel, GridBagConstraints gridBagConstraints) {
        jLabel.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints.gridx = 0;
        JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(250, 22));
        jTextField.setMinimumSize(new Dimension(100, 22));
        jTextField.setEditable(false);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)jTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jTextField;
    }

    void reset() {
        this.removeAll();
        this.isValid = true;
        this.errorMessage = null;
        this.repaint();
    }

    private void init() {
        this.setLayout(this.gbl);
    }

    private void initLayout() {
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 5, 0, 0);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
    }
}

