/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.OchncSpanDataSource;
import cerent.cms.model.circuits.OchncSpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.OchncSpanColumnRenderer;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.TableModel;

public class OchncSpanCircuitsPane
extends AbstractPane
implements MouseListener,
PropertyChangeListener {
    RowTableModel model;
    OchncSpanDataSource source;
    private static final SDebug db = new SDebug("OchncSpanCircuitsPane");

    public OchncSpanCircuitsPane() {
        super("OchncSpanCircuitsPane", (IModel)NetworkModel.instance().getCmsHostModel(), null);
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        CircuitColumnRenderer.loadColors();
        this.source = new OchncSpanDataSource();
        this.model = new RowTableModel((RowDataSource)this.source, OchncSpanColumnRenderer.createTableRenderers(0));
        this.table = new UTable((TableModel)this.model);
        this.model.initTable(this.table);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.table.addMouseListener(this);
    }

    public void setLink(INetLink iNetLink) {
        this.source.setNetLink(iNetLink);
    }

    public void destroy() {
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        this.model.release();
        this.model = null;
        this.source.dispose();
        this.source = null;
        super.destroy();
    }

    public void enteringPage() throws Exception {
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            OchncSpanRow ochncSpanRow = (OchncSpanRow)this.source.getObjectAtRow(n);
            INetCircuit iNetCircuit = ochncSpanRow.circuit;
            if (iNetCircuit != null) {
                CircuitEditDialog.instance(iNetCircuit).show();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CircuitColumnRenderer.loadColors();
        this.table.repaint();
    }
}

