/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.Busy;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.FailedBulkRoll;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IRollModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidRollMode;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.RollDestNoBandwidth;
import cerent.cms.model.RollDestNotAligned;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.RollCreateInfo;
import cerent.cms.ncp.RollManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SlotSrg;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RollAttrsPane;
import cerent.cms.ui.circuits.RollConversionCktPane;
import cerent.cms.ui.circuits.RollEndpointsPane;
import cerent.cms.ui.circuits.RollLoPane;
import cerent.cms.ui.circuits.RollPointPane;
import cerent.cms.ui.circuits.RollReviewEditPane;
import cerent.cms.ui.circuits.RollRouteConstraintPane;
import cerent.cms.ui.circuits.RollRoutePane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SdhAu4LoNum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class RollCreationDialog
extends AbstractCircuitDialog {
    public static final String TITLE = "Roll Creation";
    public static final String GET_ROLL_ATTRS = "Roll Attributes";
    public static final String GET_ROLL_POINT_1 = "Pivot/Fixed Point 1";
    public static final String GET_ROLL_POINT_2 = "Pivot/Fixed Point 2";
    public static final String GET_ROLL_NEW_END_POINT = "Select New End Point";
    public static final String END_POINT = "New End Point";
    public static final String UNSPECIFIED_NAME = "<auto-assigned>";
    private static final int WIDTH = 880;
    private static final int SHORT = 375;
    RollManager rollMgr = RollManager.instance();
    String circuitName;
    RollAttrsPane attrPane;
    RollPointPane bNr1Pane;
    RollPointPane bNr2Pane;
    RollRoutePane routePane;
    RollRouteConstraintPane constraintPane;
    RollReviewEditPane revEditPane;
    RollEndpointsPane endpointPane;
    RollLoPane rollLoPane;
    INetCircuitEnd bNr1;
    INetCircuitEnd bNr2;
    INetCircuitEnd rollFrom1;
    INetCircuitEnd rollFrom2;
    INetCircuitEnd rollTo1;
    INetCircuitEnd rollTo2;
    INetCircuitEnd newSrc;
    INetCircuitEnd newDst;
    INetCircuit rollFromCkt;
    INetCircuit rollToCkt;
    INetCircuit newCkt;
    List newSpans;
    List newRoute;
    List oldRoute;
    int oldRouteProtType = -1;
    List changedNodeList;
    List changedSpanList;
    Map cktSpansMap;
    Map cktNodesMap;
    Set srgs;
    boolean applySuccessful;
    int guiRollMode = -1;
    String rollType;
    protected CircuitCreatInfo circuitInfo;
    protected boolean portGrouping;
    protected boolean dropProtection;
    protected boolean isOldRouteUPSR;
    private IRevertiveBehavior upsrReversion;
    private Attribute upsrSfBerLevel;
    private Attribute upsrSdBerLevel;
    private boolean upsrSwitchOnPdip;
    INetCircuitEnd[] xmCircuitEnds;

    public boolean getPortGrouping() {
        return this.portGrouping;
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.circuitInfo;
    }

    public boolean getDropProtection() {
        return this.dropProtection;
    }

    public int getCircuitType() {
        return this.ckt.getCircuitType();
    }

    public RoutePrefs getRoutePrefs() {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            return rollRoutePane.getRoutePrefs();
        }
        return null;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            rollRoutePane.setRoutePrefs(routePrefs);
        }
    }

    public boolean isPathProt() {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            return rollRoutePane.isPathProt();
        }
        return false;
    }

    public void setPathProt(boolean bl) {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            rollRoutePane.setPathProt(bl);
        } else {
            this.db.severe("could not get route pane!");
        }
    }

    public boolean isRrbc() {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            return rollRoutePane.isRrbc();
        }
        return false;
    }

    public boolean isAutoRoute() {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            return rollRoutePane.isAutoRoute();
        }
        return false;
    }

    public boolean isUrn() {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            return rollRoutePane.isUrn();
        }
        return false;
    }

    public boolean isPca() {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            return rollRoutePane.isPca();
        }
        return false;
    }

    public void setPca(boolean bl) {
        RollRoutePane rollRoutePane = (RollRoutePane)this.wzPaneMap.get("Circuit Routing Preferences");
        if (rollRoutePane != null) {
            rollRoutePane.setPca(bl);
        } else {
            this.db.severe("could not set PCA!");
        }
    }

    public INodeModel getLapDstNode() {
        if (this.db.on()) {
            this.db.println("RollCreationDialog: empty imp getLapDstNode()");
        }
        return null;
    }

    public void setLapDstNode(INodeModel iNodeModel) {
        if (this.db.on()) {
            this.db.println("RollCreationDialog: empty imp setLapDstNode()");
        }
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        this.upsrReversion = iRevertiveBehavior;
    }

    public IRevertiveBehavior getUpsrReversion() {
        return this.upsrReversion;
    }

    public void setUpsrSfBerLevel(Attribute attribute) {
        this.upsrSfBerLevel = attribute;
    }

    public Attribute getUpsrSfBerLevel() {
        return this.upsrSfBerLevel;
    }

    public void setUpsrSdBerLevel(Attribute attribute) {
        this.upsrSdBerLevel = attribute;
    }

    public Attribute getUpsrSdBerLevel() {
        return this.upsrSdBerLevel;
    }

    public boolean getUpsrSwitchOnPdip() {
        return this.upsrSwitchOnPdip;
    }

    public void setUpsrSwitchOnPdip(boolean bl) {
        this.upsrSwitchOnPdip = bl;
    }

    public ArrayList getVcatMemberPrefs() {
        if (this.db.on()) {
            this.db.println("RollCreationDialog: empty imp getVcatMemberPrefs");
        }
        return null;
    }

    public boolean isVcatCommonFiberRouting() {
        if (this.db.on()) {
            this.db.println("RollCreationDialog: empty imp isVcatCommonFiberRouting");
        }
        return false;
    }

    public void setVcatCommonFiberRouting(boolean bl) {
        if (this.db.on()) {
            this.db.println("RollCreationDialog: empty imp setVcatCommonFiberRouting");
        }
    }

    public int getVcatTxMembers() {
        if (this.db.on()) {
            this.db.println("RollCreationDialog: empty imp getVcatTxMembers");
        }
        return 0;
    }

    public RollCreationDialog(JComponent jComponent, INetCircuit iNetCircuit, INetCircuit iNetCircuit2, boolean bl) {
        super(JOptionPane.getFrameForComponent(jComponent), TITLE, new WzDiagDebug("RollCreationDialog"), bl);
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        this.saveCircuits(iNetCircuit, iNetCircuit2);
        this.setHeight(375);
        this.setFinishEnabled(false);
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
    }

    protected void resetPanes() {
        if (this.bNr1Pane != null) {
            this.bNr1Pane.reset();
        }
        if (this.bNr2Pane != null) {
            this.bNr2Pane.reset();
        }
        if (this.endpointPane != null) {
            this.endpointPane.reset();
        }
    }

    void setHeight(int n) {
        this.setSize(new Dimension(880, n));
        this.invalidate();
    }

    protected void createPanesAndSetCurrent() {
        this.attrPane = new RollAttrsPane(this, this.makeChildDebug("RollAttrs"), GET_ROLL_ATTRS);
        this.wzPaneMap.put(GET_ROLL_ATTRS, this.attrPane);
        this.bNr1Pane = new RollPointPane(this, this.makeChildDebug("RollPoint1"), GET_ROLL_POINT_1);
        this.wzPaneMap.put(GET_ROLL_POINT_1, this.bNr1Pane);
        this.endpointPane = new RollEndpointsPane(this, this.makeChildDebug("RollEndpoint"), GET_ROLL_NEW_END_POINT, END_POINT);
        this.wzPaneMap.put(GET_ROLL_NEW_END_POINT, this.endpointPane);
        this.bNr2Pane = new RollPointPane(this, this.makeChildDebug("RollPoint2"), GET_ROLL_POINT_2);
        this.wzPaneMap.put(GET_ROLL_POINT_2, this.bNr2Pane);
        this.routePane = new RollRoutePane(this, this.makeChildDebug("RollRoutePrefs"), "Circuit Routing Preferences");
        this.wzPaneMap.put("Circuit Routing Preferences", this.routePane);
        this.wzPaneMap.put("Conversion Circuit Constraints For Automatic Routing", new RollConversionCktPane(this, this.makeChildDebug("XmRoute"), "Conversion Circuit Constraints For Automatic Routing"));
        this.constraintPane = new RollRouteConstraintPane(this, this.makeChildDebug("RollRouteConstraints"), "Circuit Constraints For Automatic Routing", true);
        this.wzPaneMap.put("Circuit Constraints For Automatic Routing", this.constraintPane);
        this.rollLoPane = new RollLoPane(this, this.makeChildDebug("RollLoOption"), WZPANE_GET_LO);
        this.wzPaneMap.put(WZPANE_GET_LO, this.rollLoPane);
        this.revEditPane = new RollReviewEditPane(this, this.makeChildDebug("RollReviewEdit"), "Route Review/Edit", false);
        this.wzPaneMap.put("Route Review/Edit", this.revEditPane);
        this.readCircuitPrefs();
        this.circuitCount = 1;
        this.circuitNumber = 1;
        this.dropProtection = false;
        this.autoRange = false;
        this.oldRouteProtType = -1;
        this.guiRollMode = -1;
        this.rollType = "";
        this.applySuccessful = false;
        this.setCurrentPane(GET_ROLL_ATTRS);
    }

    private void readCircuitPrefs() {
        int n;
        int n2;
        int n3;
        boolean bl;
        Preferences preferences;
        block11: {
            INodeModel iNodeModel;
            this.circuitInfo = new CircuitCreatInfo(this.rollFromCkt.getCircuitType(), this.rollFromCkt.getCircuitSize(), this.rollFromCkt.getCircuitDir());
            String string = new String(this.rollFromCkt.getCircuitName()) + "_ROLL**";
            if (string.length() > 48) {
                string = string.substring(string.length() - 48);
            }
            this.circuitInfo.setName(string);
            this.circuitInfo.setAdminState(this.rollFromCkt.getAdminState());
            if (this.rollFromCkt.isMemberOfVcat() && this.rollFromCkt.getAdminState() == 4) {
                this.circuitInfo.setAdminState(2);
            }
            int n4 = this.rollFromCkt.getSrcCircuitNode().getNetElement().getNodeModel().getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n4);
            if (this.rollFromCkt.getCircuitTypeObj().isTunnelCircuitType() || this.rollFromCkt.getCircuitTypeObj().isLAPCircuitType() || this.rollFromCkt.getCircuitTypeObj().isEthernetCircuitType()) {
                this.circuitInfo.setType(iFramingType.getHoCircuitType());
            }
            RoutePrefs routePrefs = new RoutePrefs();
            routePrefs.setPathProt(((NetCircuitDropInfo)this.rollFromCkt.getDrops().get(0)).getPathProt());
            routePrefs.setDiversityOption(1);
            this.setRoutePrefs(routePrefs);
            this.portGrouping = this.isPortGroupingCkt(this.rollFromCkt);
            preferences = Preferences.instance();
            bl = false;
            n3 = 300;
            ICircuitType iCircuitType = this.rollFromCkt.getCircuitTypeObj();
            int n5 = 2;
            n2 = 4;
            n = 6;
            if (iCircuitType.isLoCircuitType()) {
                n5 = 1;
                n2 = 3;
                n = 5;
            }
            if ((iNodeModel = NetworkModel.instance().getCmsHostModel()) != null && iNodeModel.isInited()) {
                try {
                    IRevertiveBehavior iRevertiveBehavior = iNodeModel.getUpsrReversion();
                    if (iRevertiveBehavior != null) {
                        bl = iRevertiveBehavior.getReversionMode() == 2;
                        n3 = iRevertiveBehavior.getReversionTime();
                    }
                }
                catch (Exception exception) {
                    this.db.println("Can't retrieve default revertive behavior from node");
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
                try {
                    n2 = iNodeModel.getUpsrSfBerLevel(n5);
                    n = iNodeModel.getUpsrSdBerLevel(n5);
                }
                catch (Exception exception) {
                    this.db.severe("Cannot get default bers:" + exception);
                    n2 = 4;
                    n = 6;
                    if (n5 != 1) break block11;
                    n2 = 3;
                    n = 5;
                }
            }
        }
        int n6 = preferences.getBoolean("ctc.circuit.creation", "revertive", bl) ? 2 : 1;
        int n7 = preferences.getInt("ctc.circuit.creation", "revertTime", n3);
        if (n7 == 0) {
            n7 = 30;
        }
        this.setUpsrReversion(new RevertiveBehavior(n6, n7));
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        this.setUpsrSfBerLevel(attributeMaps.getAttributeForVal("declareSfBerLevel", n2));
        this.setUpsrSdBerLevel(attributeMaps.getAttributeForVal("declareSdBerLevel", n));
        this.setUpsrSwitchOnPdip(preferences.getBoolean("ctc.circuit.creation", "pdip", false));
    }

    protected boolean isPortGroupingCkt(INetCircuit iNetCircuit) {
        try {
            return PortGrouping.isPortGroupingCircuit(iNetCircuit);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            return false;
        }
        catch (ProvisionError provisionError) {
            return false;
        }
    }

    private void saveCircuits(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        this.rollFromCkt = iNetCircuit;
        this.rollToCkt = iNetCircuit2;
        if (this.db.on()) {
            if (this.rollFromCkt != null) {
                this.rollFromCkt.prettyPrint(this.db);
            }
            if (this.rollToCkt != null) {
                this.rollToCkt.prettyPrint(this.db);
            }
        }
    }

    protected void swapTwoCircuits() {
        INetCircuit iNetCircuit = this.rollFromCkt;
        this.rollFromCkt = this.rollToCkt;
        this.rollToCkt = iNetCircuit;
        this.readCircuitPrefs();
    }

    protected void apply() throws Exception {
        try {
            this.uiToolkit.setCursor(3);
            if (this.portGrouping && this.rollType.equals("Dual") || this.newSrc != null && this.newDst != null) {
                this.createNewCircuit();
            }
            if (this.rollType.equals("Single")) {
                if (this.rollFrom1 == null) {
                    throw new Exception("Roll From path is null.");
                }
                if (this.rollTo1 == null) {
                    throw new Exception("Roll To path is null.");
                }
                INetCircuitEnd[] iNetCircuitEndArray = this.createCktEndArray(this.rollFrom1);
                INetCircuitEnd[] iNetCircuitEndArray2 = this.createCktEndArray(this.rollTo1);
                INetCircuit[] iNetCircuitArray = this.createFromCktArray(iNetCircuitEndArray, this.rollFromCkt);
                INetCircuit[] iNetCircuitArray2 = this.createToCktArray(this.rollToCkt);
                this.createRolls(iNetCircuitEndArray, iNetCircuitEndArray2, iNetCircuitArray, iNetCircuitArray2, this.rollFrom1.getNetElement(), 1, true);
                if (this.portGrouping) {
                    for (int i = 0; i < iNetCircuitEndArray2.length; ++i) {
                        INetCircuitEnd iNetCircuitEnd = iNetCircuitEndArray2[i];
                        PortGrouping.setPortGroupState(iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum(), true);
                    }
                }
            } else {
                if (this.rollFrom1 == null) {
                    throw new Exception("Roll From path 1 is null.");
                }
                if (this.rollTo1 == null) {
                    throw new Exception("Roll To path 1 is null.");
                }
                if (this.rollFrom2 == null) {
                    throw new Exception("Roll From path 2 is null.");
                }
                if (this.rollTo2 == null) {
                    throw new Exception("Roll To path 2 is null.");
                }
                INetCircuitEnd[] iNetCircuitEndArray = this.createCktEndArray(this.rollFrom1);
                INetCircuitEnd[] iNetCircuitEndArray3 = this.createCktEndArray(this.rollTo1);
                INetCircuitEnd[] iNetCircuitEndArray4 = this.createCktEndArray(this.rollFrom2);
                INetCircuitEnd[] iNetCircuitEndArray5 = this.createCktEndArray(this.rollTo2);
                INetCircuit[] iNetCircuitArray = this.createFromCktArray(iNetCircuitEndArray, this.rollFromCkt);
                INetCircuit[] iNetCircuitArray3 = this.createToCktArray(this.rollToCkt);
                IRollModel iRollModel = this.createRolls(iNetCircuitEndArray, iNetCircuitEndArray3, iNetCircuitArray, iNetCircuitArray3, this.rollFrom1.getNetElement(), 2, true);
                try {
                    this.createRolls(iNetCircuitEndArray4, iNetCircuitEndArray5, iNetCircuitArray, iNetCircuitArray3, this.rollFrom2.getNetElement(), 2, false);
                }
                catch (Exception exception) {
                    NetRoll netRoll;
                    if (this.db.on()) {
                        this.db.println("Second roll could not be created, first roll cancelled");
                    }
                    if ((netRoll = this.rollMgr.findNetRoll(iRollModel)) == null) {
                        this.rollMgr.createNewNetRoll(iRollModel);
                        netRoll = this.rollMgr.findNetRoll(iRollModel);
                    }
                    if (netRoll != null) {
                        netRoll.cancelAndDestroyRoll();
                    }
                    throw exception;
                }
                if (this.portGrouping) {
                    INetCircuitEnd iNetCircuitEnd;
                    int n;
                    for (n = 0; n < iNetCircuitEndArray3.length; ++n) {
                        iNetCircuitEnd = iNetCircuitEndArray3[n];
                        PortGrouping.setPortGroupState(iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum(), true);
                    }
                    for (n = 0; n < iNetCircuitEndArray5.length; ++n) {
                        iNetCircuitEnd = iNetCircuitEndArray5[n];
                        PortGrouping.setPortGroupState(iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum(), true);
                    }
                }
            }
            this.applySuccessful = true;
        }
        catch (AnnotatedException annotatedException) {
            this.applySuccessful = false;
            this.destroyRelatedCircuits();
            throw annotatedException;
        }
        catch (Exception exception) {
            this.applySuccessful = false;
            this.destroyRelatedCircuits();
            throw exception;
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    private INetCircuitEnd[] createCktEndArray(INetCircuitEnd iNetCircuitEnd) {
        INetCircuitEnd[] iNetCircuitEndArray;
        if (this.portGrouping) {
            IEntityModel iEntityModel;
            iNetCircuitEndArray = new INetCircuitEnd[3];
            INodeModel iNodeModel = iNetCircuitEnd.getNodeModel();
            IHoNum iHoNum = iNetCircuitEnd.getHoNum();
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                iEntityModel = null;
            }
            for (int i = 0; i < 3; ++i) {
                SdhAu4LoNum sdhAu4LoNum = HoLoFactory.createVc3SdhAu4LoNum(i + 1);
                iNetCircuitEndArray[i] = new NetCircuitEnd(iNodeModel, iEntityModel, iHoNum, (ILoNum)sdhAu4LoNum, false);
            }
        } else {
            iNetCircuitEndArray = new INetCircuitEnd[]{iNetCircuitEnd};
        }
        return iNetCircuitEndArray;
    }

    private INetCircuit[] createFromCktArray(INetCircuitEnd[] iNetCircuitEndArray, INetCircuit iNetCircuit) {
        INetCircuit[] iNetCircuitArray;
        if (this.portGrouping) {
            iNetCircuitArray = new INetCircuit[3];
            if (iNetCircuit != null) {
                List list = PortGrouping.getVc3CircuitsInPortGroup(iNetCircuit);
                for (int i = 0; i < 3; ++i) {
                    Iterator iterator = list.iterator();
                    NetCcatCircuit netCcatCircuit = null;
                    while (iterator.hasNext()) {
                        netCcatCircuit = (NetCcatCircuit)iterator.next();
                        if (!netCcatCircuit.containsCktEnd(iNetCircuitEndArray[i])) continue;
                        iNetCircuitArray[i] = netCcatCircuit;
                    }
                }
            }
        } else {
            iNetCircuitArray = new INetCircuit[]{iNetCircuit};
        }
        return iNetCircuitArray;
    }

    private INetCircuit[] createToCktArray(INetCircuit iNetCircuit) {
        INetCircuit[] iNetCircuitArray = this.portGrouping ? new INetCircuit[3] : new INetCircuit[1];
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            iNetCircuitArray[i] = iNetCircuit;
        }
        return iNetCircuitArray;
    }

    private IRollModel createRolls(INetCircuitEnd[] iNetCircuitEndArray, INetCircuitEnd[] iNetCircuitEndArray2, INetCircuit[] iNetCircuitArray, INetCircuit[] iNetCircuitArray2, INetElement iNetElement, int n, boolean bl) throws Exception {
        int n2 = this.guiRollMode;
        short s = (short)this.guiRollMode;
        if (!this.rollFromCkt.isBidirectional() && this.rollType.equals("Dual") && this.guiRollMode == 0) {
            if (bl) {
                n2 = 1;
            }
            s = 2;
        } else if (this.rollFromCkt.isBidirectional() && this.rollType.equals("Dual") && this.guiRollMode == 0) {
            n2 = 1;
            s = 2;
        }
        RollCreateInfo[] rollCreateInfoArray = this.portGrouping ? new RollCreateInfo[3] : new RollCreateInfo[1];
        for (int i = 0; i < rollCreateInfoArray.length; ++i) {
            INetCircuit iNetCircuit = iNetCircuitArray[i];
            INetCircuit iNetCircuit2 = iNetCircuitArray2[i] != null ? iNetCircuitArray2[i] : (this.newCkt != null ? this.newCkt : iNetCircuitArray[i]);
            INetCircuitEnd iNetCircuitEnd = iNetCircuitEndArray[i];
            INetCircuitEnd iNetCircuitEnd2 = iNetCircuitEndArray2[i];
            if (this.db.on()) {
                this.db.println("create a NetRoll: ");
                this.db.println("rollFrom is " + ((NetCircuitEnd)iNetCircuitEnd).prettyString());
                this.db.println("rollTo is " + ((NetCircuitEnd)iNetCircuitEnd2).prettyString());
            }
            rollCreateInfoArray[i] = new RollCreateInfo(iNetCircuitEnd, iNetCircuitEnd2, n2, iNetCircuit, iNetCircuit2, (short)n, s);
        }
        return this.createRoll(iNetElement, rollCreateInfoArray);
    }

    private IRollModel createRoll(INetElement iNetElement, RollCreateInfo[] rollCreateInfoArray) throws Exception {
        IRollModel iRollModel = null;
        try {
            iRollModel = this.rollMgr.createNewRollModel(iNetElement, rollCreateInfoArray, false);
        }
        catch (Busy busy) {
            throw new Exception("Unable to create roll:\nNode is busy.");
        }
        catch (DropsExceedMax dropsExceedMax) {
            throw new Exception("Unable to create roll:\nDrops exceed maximum.");
        }
        catch (ConnectionInRoll connectionInRoll) {
            throw new Exception("Unable to create roll:\nConnection is in roll.");
        }
        catch (ConnectionInTestAccess connectionInTestAccess) {
            throw new Exception("Unable to create roll:\nConnection is in test access.");
        }
        catch (ConnectionInLoopback connectionInLoopback) {
            throw new Exception("Unable to create roll:\nConnection is in loopback.");
        }
        catch (ConnectionTypeError connectionTypeError) {
            throw new Exception("Unable to create roll:\nConnection type is wrong.");
        }
        catch (PathInUse pathInUse) {
            throw new Exception("Unable to create roll:\nRollTo path is in use.");
        }
        catch (InvalidPath invalidPath) {
            throw new Exception("Unable to create roll:\nRollTo path is invalid.");
        }
        catch (InvalidRollMode invalidRollMode) {
            throw new Exception("Unable to create roll:\nRoll mode is invalid.");
        }
        catch (RollDestNotAligned rollDestNotAligned) {
            throw new Exception("Unable to create roll:\nRoll destination is not aligned.");
        }
        catch (RollDestNoBandwidth rollDestNoBandwidth) {
            throw new Exception("Unable to create roll:\nRoll destination doesn't have enough bandwidth.");
        }
        catch (BlsrSpanSwitched blsrSpanSwitched) {
            throw new Exception("Unable to create roll:\n" + CircuitMapUtil.BLSR_TERM + " switch is active.");
        }
        catch (NoSuchConnection noSuchConnection) {
            throw new Exception("Unable to create roll:\nNo such connection is found.");
        }
        catch (LoopbackActive loopbackActive) {
            throw new Exception("Unable to create roll:\nLoopback is active on RollTo path.");
        }
        catch (ProvisionError provisionError) {
            throw new Exception("Unable to create roll:\nProvision error is encountered.");
        }
        catch (FailedBulkRoll failedBulkRoll) {
            throw new Exception("Unable to create roll:\n" + failedBulkRoll.getMessage());
        }
        return iRollModel;
    }

    public void getNewCircuitInfo() throws Exception {
        NodeModel nodeModel = (NodeModel)this.rollFrom1.getNodeModel();
        NodeModel nodeModel2 = (NodeModel)this.rollFrom2.getNodeModel();
        NetLinkSpan netLinkSpan = null;
        NetLinkSpan netLinkSpan2 = null;
        INetLink iNetLink = null;
        INetLink iNetLink2 = null;
        NodeModel nodeModel3 = null;
        NodeModel nodeModel4 = null;
        this.newSpans = new LinkedList();
        Iterator iterator = this.newRoute.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            NetLinkSpan netLinkSpan3 = (NetLinkSpan)netCircuitSpan.getNetLinkSpan();
            INetLink iNetLink3 = netLinkSpan3.getLink();
            ILinkModel iLinkModel = iNetLink3.getLinkModel();
            if ((NodeModel)iLinkModel.src() == nodeModel || (NodeModel)iLinkModel.dst() == nodeModel2) {
                if ((NodeModel)iLinkModel.src() == nodeModel && netLinkSpan == null) {
                    netLinkSpan = netLinkSpan3;
                    iNetLink = iNetLink3;
                    nodeModel3 = (NodeModel)iLinkModel.dst();
                }
                if ((NodeModel)iLinkModel.dst() != nodeModel2 || netLinkSpan2 != null) continue;
                netLinkSpan2 = netLinkSpan3;
                iNetLink2 = iNetLink3;
                nodeModel4 = (NodeModel)iLinkModel.src();
                continue;
            }
            this.newSpans.add(this.cktSpansMap.get(iNetLink3));
        }
        if (iNetLink == null) {
            throw new Exception("New route doesn't start at Pivot/Fixed Point 1.");
        }
        if (iNetLink2 == null) {
            throw new Exception("New route doesn't end at Pivot/Fixed Point 2.");
        }
        this.rollTo1 = CircuitMapUtil.getCircuitEnd(nodeModel, iNetLink.getSrcEntityIndex(), netLinkSpan.getSrcHoNum(), netLinkSpan.getLoNum());
        this.rollTo2 = CircuitMapUtil.getCircuitEnd(nodeModel2, iNetLink2.getDstEntityIndex(), netLinkSpan2.getDstHoNum(), netLinkSpan2.getLoNum());
        if (netLinkSpan != netLinkSpan2) {
            this.newSrc = CircuitMapUtil.getCircuitEnd(nodeModel3, iNetLink.getDstEntityIndex(), netLinkSpan.getDstHoNum(), netLinkSpan.getLoNum());
            this.newDst = CircuitMapUtil.getCircuitEnd(nodeModel4, iNetLink2.getSrcEntityIndex(), netLinkSpan2.getSrcHoNum(), netLinkSpan2.getLoNum());
        } else {
            this.newSrc = null;
            this.newDst = null;
        }
    }

    public boolean checkNewRouteForUPSR() {
        int n = 0;
        int n2 = 0;
        NodeModel nodeModel = (NodeModel)this.bNr1.getNodeModel();
        NodeModel nodeModel2 = (NodeModel)this.bNr2.getNodeModel();
        Iterator iterator = this.newRoute.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            ILinkModel iLinkModel = netCircuitSpan.getLink().getLinkModel();
            NodeModel nodeModel3 = (NodeModel)iLinkModel.src();
            NodeModel nodeModel4 = (NodeModel)iLinkModel.dst();
            if (nodeModel3 == nodeModel) {
                ++n;
            }
            if (nodeModel4 != nodeModel2) continue;
            ++n2;
        }
        return n >= 2 || n2 >= 2;
    }

    protected void setExcludeEntities(RoutePrefs routePrefs) throws Exception {
        List list = this.getExcludeEntities();
        routePrefs.setExcEntityList(list);
        if (this.srgs != null) {
            routePrefs.addExcludeSrgs(this.srgs);
        }
    }

    protected List getExcludeEntities() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        INetElement iNetElement = this.rollFrom1.getNetElement();
        INetElement iNetElement2 = this.rollFrom2.getNetElement();
        if (this.isOldRouteUPSR) {
            CmsObservable cmsObservable;
            List list = this.ckt.getCircuitNodes();
            list.removeAll(this.changedNodeList);
            List list2 = this.ckt.getCircuitSpans();
            list2.removeAll(this.changedSpanList);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                cmsObservable = (NetCircuitNode)iterator.next();
                linkedList.add(((NetCircuitNode)cmsObservable).getNetElement());
            }
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                cmsObservable = (NetCircuitSpan)iterator.next();
                if (((NetCircuitSpan)cmsObservable).getLink().isLOTunnel() || ((NetCircuitSpan)cmsObservable).getLink().isLAP()) {
                    object2 = ((NetCircuitSpan)cmsObservable).getLink().getNodesList().iterator();
                    while (object2.hasNext()) {
                        object = (INetElement)object2.next();
                        if (linkedList.contains(object) || object == iNetElement || object == iNetElement2) continue;
                        linkedList.add(object);
                    }
                }
                linkedList.add(((NetCircuitSpan)cmsObservable).getLink());
                this.srgs = new HashSet();
                if (((NetCircuitSpan)cmsObservable).getLink().getSrc() == iNetElement) {
                    object2 = ((NetCircuitSpan)cmsObservable).getLink();
                    object = new SlotSrg(object2.getSrc(), object2.getSrcSlotNumber(), true);
                    this.srgs.add(object);
                    continue;
                }
                if (((NetCircuitSpan)cmsObservable).getLink().getDst() != iNetElement2) continue;
                object2 = ((NetCircuitSpan)cmsObservable).getLink();
                object = new SlotSrg(object2.getDst(), object2.getDstSlotNumber(), false);
                this.srgs.add(object);
            }
        }
        return linkedList;
    }

    protected void routeNewCircuit() throws Exception {
        block14: {
            String string = "???";
            ICircuitType iCircuitType = this.ckt.getCircuitTypeObj();
            if (iCircuitType.isLoCircuitType() || iCircuitType.isHoCircuitType() || iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType() || iCircuitType.isEthernetCircuitType()) {
                Object object;
                Object object2;
                RoutePrefs routePrefs;
                List list;
                block13: {
                    this.newRoute = new LinkedList();
                    list = null;
                    this.addBlsrDriRoutePrefs();
                    routePrefs = new RoutePrefs(this.getRoutePrefs());
                    if (this.xmCircuitEnds != null && !routePrefs.getRequiredNodes().contains(this.xmCircuitEnds[0].getNetElement())) {
                        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
                        linkedList.add(this.xmCircuitEnds[0].getNetElement());
                        try {
                            routePrefs.setReqEntityList(linkedList);
                        }
                        catch (ObjDuplicate objDuplicate) {
                            if (!this.db.on()) break block13;
                            this.db.println("routeDrop: hit ObjDuplicate exception");
                        }
                    }
                }
                try {
                    list = ((NetCcatCircuit)this.ckt).findRouteForBridgeRoll(routePrefs, this.isOldRouteUPSR);
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Unable to route drop", exception);
                }
                boolean bl = false;
                if (this.oldRouteProtType == 17) {
                    object2 = (NetCircuitNode)this.rollFromCkt.getCircuitNodeFromNE(this.rollFrom1.getNetElement());
                    object = (NetCircuitNode)this.rollFromCkt.getCircuitNodeFromNE(this.rollFrom2.getNetElement());
                    bl = ((NetCircuitNode)object2).isDriCktEnd(this.rollFrom1) || ((NetCircuitNode)object).isDriCktEnd(this.rollFrom2);
                }
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (NetLinkSpan)object2.next();
                    if (bl) {
                        ((NetLinkSpan)object).setOmni(true);
                    }
                    if (this.db.on()) {
                        this.db.println("findRouteForBridgeRoll() found this link : " + ((NetLinkSpan)object).prettyString());
                    }
                    NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)this.ckt, (NetLinkSpan)object);
                    if (this.isOldRouteUPSR) {
                        netCircuitSpan.setUpsrLink(true);
                    }
                    this.newRoute.add(netCircuitSpan);
                }
                break block14;
            }
            throw new Exception("addDestination: unexpected circuit type: " + this.ckt.getCircuitType());
        }
    }

    protected void addDestination(boolean bl) throws Exception {
    }

    protected void deleteDestination() throws Exception {
    }

    public INodeModel getSourceNode() {
        return this.bNr1.getNodeModel();
    }

    public INodeModel getDestNode() {
        return this.bNr2.getNodeModel();
    }

    public INetCircuitEnd getSource() {
        return this.bNr1;
    }

    public INetCircuitEnd getDest() {
        return this.bNr2;
    }

    /*
     * Unable to fully structure code
     */
    private void createNewCircuit() throws Exception {
        if (this.db.on) {
            this.db.println("create a new circuit : ");
        }
        if (this.portGrouping) {
            if (this.db.on) {
                this.db.println("srcEnd is : " + ((NetCircuitEnd)this.bNr1).prettyString());
            }
            if (this.db.on) {
                this.db.println("dstEnd is : " + ((NetCircuitEnd)this.bNr2).prettyString());
            }
            if ((var1_1 = NetCircuitFactory.newCircuit(this.circuitInfo, this.bNr1)) == null) {
                throw new Exception("createNewCircuit: newCircuit returned null");
            }
            if (this.isOldRouteUPSR) {
                var2_4 = new RoutePrefs();
                var2_4.setPathProt(2);
                var2_4.setDiversityOption(2);
            } else {
                var2_4 = this.getRoutePrefs();
            }
            this.setExcludeEntities(var2_4);
            var3_6 = PortGrouping.getInstance().initForBridgeAndRoll(this.bNr1, this.bNr2, var1_1, var2_4);
            if (var3_6.size() > 0) {
                var4_7 = (LoTunnelInfo)var3_6.get(0);
                var5_8 = var4_7.tunnel();
                this.addRelatedCircuit(var4_7.tunnel());
                var6_9 = var5_8.getLotLink();
                var7_10 = var5_8.getReverseLotLink();
                var8_11 = new NetLinkSpan(var6_9, var7_10, var6_9.getSrcHo(), var6_9.getDstHo(), null);
                var9_12 = NetCircuitSpanFactory.createCircuitSpan(this.rollFromCkt, var8_11);
                this.newRoute = new LinkedList<E>();
                this.newRoute.add(var9_12);
                var10_13 = ((NetCcatCircuit)this.ckt).getCircuitSpanFromSrcCktEnd(this.rollFrom1);
                if (var10_13 != null) {
                    var11_14 = ((NetLink)var10_13.getLink()).getLotCircuit();
                    var12_15 = var11_14.getCircuitName();
                    var13_16 = 48;
                    var14_17 = "_ROLL**";
                    if (var12_15.length() > var13_16 - var14_17.length()) {
                        var12_15 = var12_15.substring(0, var13_16 - var14_17.length());
                    }
                    var5_8.rename(var12_15 + var14_17);
                }
                this.getNewCircuitInfo();
            }
        } else {
            if (this.db.on) {
                this.db.println("newSrc is : " + ((NetCircuitEnd)this.newSrc).prettyString());
            }
            if (this.db.on) {
                this.db.println("newDst is : " + ((NetCircuitEnd)this.newDst).prettyString());
            }
            if (this.circuitInfo.dir() == 0 && this.isOldRouteUPSR) {
                this.circuitInfo.setDir(1);
            }
            this.newCkt = NetCircuitFactory.newCircuit(this.circuitInfo, this.newSrc);
            if (this.newCkt == null) {
                throw new Exception("createNewCircuit: newCircuit returned null");
            }
            if (this.xmCircuitEnds != null) {
                this.newCkt.setXmCircuitEnds(this.xmCircuitEnds);
            }
            if (this.isOldRouteUPSR) {
                var1_2 = new RoutePrefs();
                var1_2.setPathProt(2);
                var1_2.setDiversityOption(2);
                this.newCkt.addDrop(this.newDst, (RoutePrefs)var1_2);
            } else {
                this.newCkt.addDrop(this.newDst, this.getRoutePrefs());
            }
            if (!((NetCcatCircuit)this.rollFromCkt).routeEqual(this.oldRoute) || this.xmCircuitEnds != null) {
                var1_2 = this.newSpans.iterator();
                while (var1_2.hasNext()) {
                    this.newCkt.addCircuitSpan(((NetCircuitSpan)var1_2.next()).getNetLinkSpan());
                }
                try {
                    this.newCkt.sanityCheck();
                    if (!this.db.on) ** GOTO lbl71
                    this.db.println("createNewCircuit: sanityCheck() succeeded");
                }
                catch (SanityCheckFailed var2_5) {
                    throw new SanityCheckException("Circuit sanity check failed", "spans are", var2_5);
                }
            } else {
                ((NetCcatCircuit)this.newCkt).addSpansAndNodes(this.newSpans, this.cktNodesMap);
            }
lbl71:
            // 3 sources

            this.newCkt.setUpsrSelectorAttributes(this.getUpsrReversion(), (short)this.getUpsrSfBerLevel().getIntValue(), (short)this.getUpsrSdBerLevel().getIntValue(), this.getUpsrSwitchOnPdip());
            try {
                this.newCkt.provision();
                if (this.db.on) {
                    this.db.println("apply: newCkt provision() succeeded");
                }
            }
            catch (Exception var1_3) {
                throw new AnnotatedException("Unable to provision the newCkt", var1_3);
            }
        }
    }

    protected void addBlsrDriRoutePrefs() {
        if (!this.getRoutePrefs().getDri()) {
            return;
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)this.rollFromCkt;
        List list = netCcatCircuit.getDriNodes();
        if (!list.isEmpty()) {
            if (!((MemberGroupPrefs)this.getRoutePrefs().getFwdDropPrefs().getMemberGroupPrefs().get(0)).getMemberPrefs().getDriNodePrefs().isEmpty()) {
                return;
            }
            DriNodes driNodes = null;
            LinkedList<DriNodes> linkedList = new LinkedList<DriNodes>();
            if (list.size() == 2) {
                driNodes = new DriNodes(2, false);
                driNodes.addNodePair(new DriNodePair((INetElement)list.get(0), (INetElement)list.get(1)));
                driNodes.addRequiredRings((String)netCcatCircuit.getRingNames().get(0), (String)netCcatCircuit.getRingNames().get(1));
                linkedList.add(driNodes);
            } else if (list.size() == 4) {
                driNodes = new DriNodes(1, false);
                driNodes.addNodePair(new DriNodePair((INetElement)list.get(0), (INetElement)list.get(1)));
                driNodes.addNodePair(new DriNodePair((INetElement)list.get(2), (INetElement)list.get(3)));
                driNodes.addRequiredRings((String)netCcatCircuit.getRingNames().get(0), (String)netCcatCircuit.getRingNames().get(1));
                linkedList.add(driNodes);
            }
            ((MemberGroupPrefs)this.getRoutePrefs().getFwdDropPrefs().getMemberGroupPrefs().get(0)).getMemberPrefs().setDriNodePrefs(linkedList);
        }
    }

    protected void destroyRelatedCircuits() {
        if (!this.applySuccessful && this.newCkt != null) {
            try {
                this.newCkt.destroyCircuit();
                this.newCkt = null;
                if (this.db.on) {
                    this.db.println("destroyRelatedCircuits: newCkt.destroy() succeeded");
                }
            }
            catch (Exception exception) {
                WzDiagDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NEW_CIRCUIT_DESTROY_FAILED);
            }
        }
        super.destroyRelatedCircuits();
    }

    protected void savePostRollCktSpansAndNodes(List list, List list2) {
        CmsObservable cmsObservable;
        this.cktNodesMap = new TreeMap(new NetElemComparator());
        this.cktSpansMap = new TreeMap(new NetLinkComparator());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            cmsObservable = (NetCircuitNode)iterator.next();
            this.cktNodesMap.put(((NetCircuitNode)cmsObservable).getNetElement(), cmsObservable);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            cmsObservable = (NetCircuitSpan)iterator.next();
            this.cktSpansMap.put(((NetCircuitSpan)cmsObservable).getLink(), cmsObservable);
        }
    }

    public void dispose() {
        this.circuitInfo = null;
        this.rollFromCkt = null;
        this.rollToCkt = null;
        this.newCkt = null;
        this.ckt = null;
        this.rollFrom1 = null;
        this.rollTo1 = null;
        this.rollFrom2 = null;
        this.rollTo2 = null;
        this.bNr1 = null;
        this.bNr2 = null;
        this.newSrc = null;
        this.newDst = null;
        this.upsrReversion = null;
        this.upsrSfBerLevel = null;
        this.upsrSdBerLevel = null;
        this.xmCircuitEnds = null;
        if (this.newSpans != null) {
            this.newSpans.clear();
            this.newSpans = null;
        }
        if (this.newRoute != null) {
            this.newRoute.clear();
            this.newRoute = null;
        }
        if (this.oldRoute != null) {
            this.oldRoute.clear();
            this.oldRoute = null;
        }
        if (this.changedNodeList != null) {
            this.changedNodeList.clear();
            this.changedNodeList = null;
        }
        if (this.changedSpanList != null) {
            this.changedSpanList.clear();
            this.changedSpanList = null;
        }
        if (this.cktSpansMap != null) {
            this.cktSpansMap.clear();
            this.cktSpansMap = null;
        }
        if (this.cktNodesMap != null) {
            this.cktNodesMap.clear();
            this.cktNodesMap = null;
        }
        if (this.srgs != null) {
            this.srgs.clear();
            this.srgs = null;
        }
        if (this.portGrouping) {
            PortGrouping.getInstance().dispose();
        }
        super.dispose();
    }

    protected EID getNoRouteEmcErrorId() {
        return NEMC.EID_ROLL_CREATE_ROUTE_ERROR;
    }

    public void maybeInitEndpointPane() {
        if (this.endpointPane != null) {
            this.endpointPane.setLastNode(this.rollFrom1.getNodeModel());
        }
    }

    protected void displayValidationError(Exception exception) {
        if (exception instanceof AnnotatedException && ((AnnotatedException)((Object)exception)).getChild() instanceof ConnectionInLoopback) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_BRIDGE_AND_ROLL_CREATION_FAILED_PARAM_1, (Object)"\nA cross-connect loopback is active.");
        } else {
            super.displayValidationError(exception);
        }
    }

    public String getDiagString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Roll From Ckt: " + this.rollFromCkt + "\n");
        stringBuffer.append("Roll To Ckt: " + this.rollToCkt + "\n");
        stringBuffer.append("BNR1: " + this.bNr1 + "\n");
        stringBuffer.append("BNR2: " + this.bNr2 + "\n");
        stringBuffer.append("Roll From1: " + this.rollFrom1 + "\n");
        stringBuffer.append("Roll From2: " + this.rollFrom2 + "\n");
        stringBuffer.append("Roll To1: " + this.rollTo1 + "\n");
        stringBuffer.append("Roll To2: " + this.rollTo2 + "\n");
        stringBuffer.append("Gui roll mode: " + this.guiRollMode + "\n");
        stringBuffer.append("Roll type: " + this.rollType + "\n");
        stringBuffer.append("Port Grouping: " + this.portGrouping + "\n");
        stringBuffer.append("Drop Protection: " + this.dropProtection + "\n");
        stringBuffer.append("Old Route Prot. Type: " + this.oldRouteProtType + "\n");
        stringBuffer.append("Old Route: " + this.oldRoute + "\n");
        if (this.oldRoute != null) {
            stringBuffer.append("Size= " + this.oldRoute.size() + "\n");
            for (n = 0; n < this.oldRoute.size(); ++n) {
                stringBuffer.append("\t#" + n + ": " + ((NetCircuitSpan)this.oldRoute.get(n)).prettyString() + "\n");
            }
        }
        stringBuffer.append("ChangedNodeList: " + this.changedNodeList + "\n");
        if (this.changedNodeList != null) {
            stringBuffer.append("Size= " + this.changedNodeList.size() + "\n");
            for (n = 0; n < this.changedNodeList.size(); ++n) {
                stringBuffer.append("\t#" + n + ": " + ((NetCircuitNode)this.changedNodeList.get(n)).getName() + "\n");
            }
        }
        stringBuffer.append("ChangedSpanList: " + this.changedSpanList + "\n");
        if (this.changedSpanList != null) {
            stringBuffer.append("Size= " + this.changedSpanList.size() + "\n");
            for (n = 0; n < this.changedSpanList.size(); ++n) {
                stringBuffer.append("\t#" + n + ": " + ((NetCircuitSpan)this.changedSpanList.get(n)).prettyString() + "\n");
            }
        }
        stringBuffer.append("cktSpansMap: " + this.cktSpansMap + "\n");
        if (this.cktSpansMap != null) {
            stringBuffer.append("Size= " + this.cktSpansMap.size() + "\n");
            LinkedList linkedList = new LinkedList(this.cktSpansMap.values());
            for (int i = 0; i < this.cktSpansMap.size(); ++i) {
                stringBuffer.append("\t#" + i + ": " + ((NetCircuitSpan)linkedList.get(i)).prettyString() + "\n");
            }
        }
        stringBuffer.append("Circuit Create Info: " + this.circuitInfo + "\n");
        stringBuffer.append("New Ckt: " + this.newCkt + "\n");
        stringBuffer.append("New Src: " + this.newSrc + "\n");
        stringBuffer.append("New Dst: " + this.newDst + "\n");
        stringBuffer.append("New Route: " + this.newRoute + "\n");
        if (this.newRoute != null) {
            stringBuffer.append("Size= " + this.newRoute.size() + "\n");
            for (int i = 0; i < this.newRoute.size(); ++i) {
                stringBuffer.append("\t#" + i + ": " + ((NetCircuitSpan)this.newRoute.get(i)).prettyString() + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

