/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.util.gui.IgnorableDialog;
import com.cisco.ctc.util.map.MapNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;

public class RollRouteConstraintPane
extends CcdRouteConstraintPane {
    private ArrayList unRemoveableList = new ArrayList();

    public RollRouteConstraintPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
    }

    protected boolean useDRI() {
        return this.getAbstractCktDlg().getRoutePrefs().getDri();
    }

    public void enteringPane() {
        super.enteringPane();
        this.leftPanel.setBorder(BorderFactory.createTitledBorder("Required Nodes / Links: "));
        List list = ((NetCcatCircuit)((RollCreationDialog)this.parent).rollFromCkt).getDriNodes();
        List list2 = ((RollCreationDialog)this.parent).getExcludeEntities();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof INetElement) {
                if (list.contains(e)) continue;
                this.excludeNode(this.getMapNode((INetElement)e));
                this.unRemoveableList.add(e);
                continue;
            }
            if (!(e instanceof INetLink)) continue;
            this.excludeLink(this.getMapLink((INetLink)e));
            this.unRemoveableList.add(e);
        }
    }

    protected boolean isRemoveable(Object object) {
        for (int i = 0; i < this.unRemoveableList.size(); ++i) {
            Object e = this.unRemoveableList.get(i);
            if (object instanceof INetElement && e instanceof INetElement) {
                if ((INetElement)e != (INetElement)object) continue;
                return false;
            }
            if (!(object instanceof INetLink) || !(e instanceof INetLink)) continue;
            if (((INetLink)e).getSrc() == ((INetLink)object).getSrc() && ((INetLink)e).getDst() == ((INetLink)object).getDst()) {
                return false;
            }
            if (((INetLink)e).getSrc() != ((INetLink)object).getDst() || ((INetLink)e).getDst() != ((INetLink)object).getSrc()) continue;
            return false;
        }
        return true;
    }

    protected void cleanup() {
        super.cleanup();
        if (this.circuitMap != null) {
            this.circuitMap.clearNodeMarkers();
            this.addSrcNodeMarker();
            this.addDstNodeMarker();
            this.circuitMap.updateView();
        }
    }

    protected void addSrcNodeMarker() {
        this.circuitMap.addGenericMarker(this.srcNode, "Pivot/Fixed Point1", this.circuitMap.getPoint(((RollCreationDialog)this.parent).bNr1));
    }

    protected void addDstNodeMarker() {
        this.circuitMap.addGenericMarker(this.dstNode, "Pivot/Fixed Point2", this.circuitMap.getPoint(((RollCreationDialog)this.parent).bNr2));
    }

    protected void addOrRouteNewCircuit() throws Exception {
        if (!this.getAbstractCktDlg().isLoCkt()) {
            ((RollCreationDialog)this.parent).routeNewCircuit();
        }
        if (!this.getAbstractCktDlg().isRrbc() && !this.getAbstractCktDlg().isLoCkt()) {
            try {
                if (((RollCreationDialog)this.parent).checkNewRouteForUPSR()) {
                    throw new Exception(CircuitMapUtil.UPSR_TERM + " ring is detected between Pivot/Fixed Point 1 and Pivot/Fixed Point 2.");
                }
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)((RollCreationDialog)this.parent).ckt;
                LinkedList linkedList = new LinkedList();
                LinkedList linkedList2 = new LinkedList();
                netCcatCircuit.getNewSpanAndNodeList(((RollCreationDialog)this.parent).newRoute, ((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2);
                ((RollCreationDialog)this.parent).addBlsrDriRoutePrefs();
                netCcatCircuit.sanityCheckBridgeRollRouting(((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2, this.getAbstractCktDlg().getRoutePrefs());
                if (this.db.on()) {
                    this.db.println("validatePage: sanityCheckManualRouting succeeded");
                }
                ((RollCreationDialog)this.parent).savePostRollCktSpansAndNodes(linkedList, linkedList2);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckException("", "spans are", sanityCheckFailed);
            }
            ((RollCreationDialog)this.parent).getNewCircuitInfo();
        }
    }

    protected void addLapAsConstraint(INetCircuit iNetCircuit) {
    }

    protected void addXmNodeAsConstraint() {
        if (((RollCreationDialog)this.parent).xmCircuitEnds == null) {
            return;
        }
        INetElement iNetElement = ((RollCreationDialog)this.parent).xmCircuitEnds[0].getNetElement();
        INodeModel iNodeModel = iNetElement.getNodeModel();
        String string = iNodeModel.getName();
        MapNode mapNode = this.getMapNode(iNetElement);
        if (mapNode == null) {
            return;
        }
        if (!this.olmContainsRoutingConstraint(iNetElement)) {
            this.addRoutingConstraintToOlm(iNetElement, string);
        }
        Object object = this.olm.getSelectedEntry();
        this.updateRmUpDownButtons(object);
    }

    protected void storeRoutePrefs() throws Exception {
        super.storeRoutePrefs();
        if (((RollCreationDialog)this.getAbstractCktDlg()).srgs != null) {
            this.getAbstractCktDlg().getRoutePrefs().addExcludeSrgs(((RollCreationDialog)this.getAbstractCktDlg()).srgs);
        }
    }

    protected void openDialog() {
        IgnorableDialog.infoDialog((Component)this.parent, (String)"If this is a DRI circuit under B&R, reselect primary and\nsecondary nodes may result in the failure of subsequent\nrouting. The best practice is to leave them\nunchanged unless you are B&R the circuit completely out\nof the existing DRI rings to a new set of DRI rings\n", (String)this.BLSRDRI_TITLE, (String)this.PREF_BLSRDRI_VALUE, (String)this.PREF_BLSRDRI_DESCR);
    }

    public void dispose() {
        if (this.unRemoveableList != null) {
            this.unRemoveableList.clear();
            this.unRemoveableList = null;
        }
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Unremovable List: " + this.unRemoveableList + "\n");
        if (this.unRemoveableList != null) {
            stringBuffer.append("Size= " + this.unRemoveableList.size() + "\n");
            for (int i = 0; i < this.unRemoveableList.size(); ++i) {
                stringBuffer.append("#" + i + " " + this.unRemoveableList.get(i));
            }
        }
        return stringBuffer.toString();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RollRouteConstraintPane;
    }
}

