/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CannotCancelRoll;
import cerent.cms.model.FailedBulkRoll;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidRollMode;
import cerent.cms.model.NoRollCondition;
import cerent.cms.model.NoRollValidSignal;
import cerent.cms.model.RollNotConnected;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SiblingRollNotComplete;
import cerent.cms.model.circuits.RollDataSource;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.RollManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.circuits.ByNameTable;
import cerent.cms.ui.circuits.RollColumnRenderer;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RollsPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static SDebug db = new SDebug("RollsPane");
    private static final String SCOPE_LABEL = "Scope:";
    private static final String SCOPE_NET = "Network";
    private static final String SCOPE_NODE = "Node";
    private static final String SCOPE_CARD = "Card";
    private static final String COMPLETE = "Complete";
    private static final String FORCE_COMPLETE = "Force Valid Signal";
    private static final String FINISH = "Finish";
    private static final String CANCEL = "Cancel";
    private static final String ALL = "All";
    private static final String WARN_TITLE = "Cancel Dual Rolls";
    private static final String WARN_MSG = "Cancelling dual rolls with a valid signal can cause a traffic hit.\n\nIf both rolls have a valid signal, to return to original paths, it is\nrecommended to complete rolls and roll back to original paths.\n\nContinue with cancellation?";
    private static final String FORCE_MSG = "For rolls in dual roll mode, if one of the two rolls has a valid\nsignal, both rolls must be selected and cancelled together.";
    private JComboBox scopeCB;
    private JButton completePB;
    private JButton forceCompletePB;
    private JButton finishPB;
    private JButton cancelPB;
    private UScrollPane scrollPane;
    private SortableRowTableModel rollTableModel;
    private RollDataSource rollDataSource;
    private boolean inited = false;

    public RollsPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    public void enteringPage() {
        if (!this.inited) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = this.getButtonPanel();
            this.setDefaultRollScope();
            this.rollDataSource = new RollDataSource(this.getCurrentRollScope());
            this.rollTableModel = new SortableRowTableModel((RowDataSource)this.rollDataSource, RollColumnRenderer.createTableRenderers(), NetRoll.class);
            this.rollTableModel.addTableModelListener(this);
            this.table = new ByNameTable(this.rollTableModel);
            this.table.setSelectionMode(2);
            this.scrollPane = new UScrollPane((Component)this.table, 20, 30);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.add((Component)this.scrollPane, "Center");
            this.add(jPanel, "South");
            this.inited = true;
        } else {
            this.rollDataSource.setEnabled(true);
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.rollDataSource.setRollScope(this.getCurrentRollScope());
        this.syncButtonsUsingSelectedRoll();
    }

    public void leavingPage() {
        this.rollDataSource.setEnabled(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    private JPanel getButtonPanel() {
        this.completePB = this.makeActionButton(COMPLETE);
        this.forceCompletePB = this.makeActionButton(FORCE_COMPLETE);
        this.finishPB = this.makeActionButton(FINISH);
        this.cancelPB = this.makeActionButton(CANCEL);
        JPanel jPanel = RollsPane.createHorizontalPanel(null);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add(this.completePB);
        jPanel2.add(this.forceCompletePB);
        jPanel2.add(this.finishPB);
        jPanel2.add(this.cancelPB);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel2 = new JPanel();
        this.scopeCB = new JComboBox<Object>(new Object[]{SCOPE_NET, SCOPE_NODE});
        this.scopeCB.addActionListener(this);
        jPanel2.setLayout(new FlowLayout(2, 5, 5));
        jPanel2.add(new JLabel(SCOPE_LABEL, 4));
        jPanel2.add(this.scopeCB);
        jPanel2.add(new CSHelpButton(NetCSHelpConst.RollsPane));
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.enableComponent(jButton);
        return jButton;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.syncButtonsUsingSelectedRoll();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.syncButtonsUsingSelectedRoll();
        }
    }

    private void syncButtonsUsingSelectedRoll() {
        this.completePB.setEnabled(false);
        this.forceCompletePB.setEnabled(false);
        this.cancelPB.setEnabled(false);
        this.finishPB.setEnabled(false);
        if (this.table.getSelectedRowCount() > 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            NetRoll netRoll = null;
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                block20: {
                    block19: {
                        block18: {
                            netRoll = (NetRoll)((Object)this.rollTableModel.getValueAt(nArray[i], 0));
                            if (netRoll.getExceptionString().length() > 0) {
                                ErrorMsg.displayDetailed((Component)((Object)this), NEMC.EID_ERROR_DURING_CIRCUIT_PROCESSING, netRoll.getExceptionString());
                                netRoll.clearExceptionString();
                                return;
                            }
                            try {
                                if (netRoll.canBeCancelled()) {
                                    ++n4;
                                }
                            }
                            catch (Exception exception) {
                                if (!db.on()) break block18;
                                db.println("Reason for cannot cancel roll: " + exception.getMessage());
                            }
                        }
                        try {
                            if (netRoll.canBeCompleted()) {
                                ++n;
                            }
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block19;
                            db.println("Reason for cannot complete roll: " + exception.getMessage());
                        }
                    }
                    try {
                        if (netRoll.canBeForceCompleted()) {
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block20;
                        db.println("Reason for cannot force valid signal: " + exception.getMessage());
                    }
                }
                try {
                    if (!netRoll.canBeFinished()) continue;
                    ++n3;
                    continue;
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Reason for cannot finish roll: " + exception.getMessage());
                }
            }
            if (n > 0) {
                this.enableComponent(this.completePB);
            }
            if (n2 > 0) {
                this.enableComponent(this.forceCompletePB);
            }
            if (n3 > 0) {
                this.enableComponent(this.finishPB);
            }
            if (n4 > 0) {
                this.enableComponent(this.cancelPB);
            }
        }
    }

    private void setDefaultRollScope() {
        IModel iModel = this.getUiModel();
        if (iModel instanceof IModuleModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.addItem(SCOPE_CARD);
            this.scopeCB.setSelectedItem(SCOPE_CARD);
        } else if (iModel instanceof INodeModel) {
            this.scopeCB.setEnabled(true);
            this.scopeCB.setSelectedItem(SCOPE_NODE);
        } else {
            this.scopeCB.setEnabled(false);
            this.scopeCB.setSelectedItem(SCOPE_NET);
        }
    }

    private IModel getCurrentRollScope() {
        Object object = this.scopeCB.getSelectedItem();
        INodeModel iNodeModel = null;
        if (SCOPE_NET.equals(object)) {
            iNodeModel = null;
        } else if (SCOPE_NODE.equals(object)) {
            iNodeModel = this.getUiModel().getNodeModel();
        } else if (SCOPE_CARD.equals(object)) {
            iNodeModel = this.getUiModel();
        }
        return iNodeModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.scopeCB && this.rollDataSource != null) {
            this.rollDataSource.setRollScope(this.getCurrentRollScope());
        } else if (object == this.completePB) {
            this.completePB.setEnabled(false);
            this.editSelectedRolls(this.getSelectedRolls(COMPLETE), 0);
        } else if (object == this.forceCompletePB) {
            this.forceCompletePB.setEnabled(false);
            this.editSelectedRolls(this.getSelectedRolls(FORCE_COMPLETE), 3);
        } else if (object == this.cancelPB) {
            this.cancelPB.setEnabled(false);
            NetRoll[] netRollArray = this.getValidDualRolls(this.getSelectedRolls(CANCEL));
            this.editSelectedRolls(netRollArray, 2);
        } else if (object == this.finishPB) {
            this.finishPB.setEnabled(false);
            this.editSelectedRolls(this.getSelectedRolls(FINISH), 1);
        }
    }

    private NetRoll[] getValidDualRolls(NetRoll[] netRollArray) {
        LinkedList<NetRoll> linkedList = new LinkedList<NetRoll>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < netRollArray.length; ++i) {
            if (netRollArray[i].isDualRollWithValidSignal()) {
                if (this.isBothRollsSelected(netRollArray[i], netRollArray)) {
                    if (!bl) {
                        bl3 = CerentDialog.yesNoDialog((Component)((Object)this), (String)WARN_MSG, (String)WARN_TITLE);
                        bl = true;
                    }
                    if (!bl3) continue;
                    linkedList.add(netRollArray[i]);
                    continue;
                }
                if (bl2) continue;
                CerentDialog.infoDialog((Component)((Object)this), (String)FORCE_MSG, (String)WARN_TITLE);
                bl2 = true;
                continue;
            }
            linkedList.add(netRollArray[i]);
        }
        if (bl && !bl3 || bl2) {
            this.syncButtonsUsingSelectedRoll();
        }
        return linkedList.toArray(new NetRoll[0]);
    }

    private boolean isBothRollsSelected(NetRoll netRoll, NetRoll[] netRollArray) {
        NetRoll netRoll2 = netRoll.getSiblingRoll();
        for (int i = 0; i < netRollArray.length; ++i) {
            if (netRoll2 != netRollArray[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editSelectedRolls(NetRoll[] netRollArray, int n) {
        this.uiToolkit.setCursor(3);
        try {
            RollManager.instance().editBulkRoll(netRollArray, n);
        }
        catch (InvalidRollMode invalidRollMode) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_ROLL_MODE_PARAM_1, (Object)invalidRollMode.getMessage());
        }
        catch (NoRollCondition noRollCondition) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ROLL_NOT_READY_PARAM_1, (Object)noRollCondition.getMessage());
        }
        catch (RollNotConnected rollNotConnected) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ROLL_NOT_CONNECTED_PARAM_1, (Object)rollNotConnected.getMessage());
        }
        catch (SiblingRollNotComplete siblingRollNotComplete) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_SIBLING_ROLL_NOT_COMPLETE_PARAM_1, (Object)siblingRollNotComplete.getMessage());
        }
        catch (CannotCancelRoll cannotCancelRoll) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_CANCEL_ROLL_PARAM_1, (Object)cannotCancelRoll.getMessage());
        }
        catch (NoRollValidSignal noRollValidSignal) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ROLL_NOT_VALID_SIGNAL_PARAM_1, (Object)noRollValidSignal.getMessage());
        }
        catch (FailedBulkRoll failedBulkRoll) {
            failedBulkRoll.printStackTrace();
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_EDIT_BULK_ROLL_FAILED_PARAM_1, (Object)failedBulkRoll.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    public NetRoll[] getSelectedRolls(String string) {
        NetRoll[] netRollArray;
        if (this.table == null) {
            return new NetRoll[0];
        }
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NO_ROLLS_SELECTED_PARAM_1, (Object)(string + " roll"));
            return new NetRoll[0];
        }
        NetRoll[] netRollArray2 = new NetRoll[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            netRollArray2[i] = (NetRoll)((Object)this.rollTableModel.getValueAt(nArray[i], 0));
        }
        NetRoll[] netRollArray3 = netRollArray2;
        if (!this.isSonetType(netRollArray2)) {
            try {
                netRollArray3 = PortGrouping.addPGRolls(netRollArray2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NetRoll[] netRollArray4 = new NetRoll[netRollArray3.length];
        int n = 0;
        for (int i = 0; i < netRollArray4.length; ++i) {
            netRollArray = netRollArray3[i];
            try {
                if (!(string.equals(CANCEL) && netRollArray.canBeCancelled() || string.equals(COMPLETE) && netRollArray.canBeCompleted() || string.equals(FORCE_COMPLETE) && netRollArray.canBeForceCompleted() || string.equals(FINISH) && netRollArray.canBeFinished()) && !string.equals(ALL)) continue;
                netRollArray4[i] = netRollArray;
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NetRoll[] netRollArray5 = new NetRoll[n];
        netRollArray = new NetRoll[netRollArray3.length - n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < netRollArray3.length; ++i) {
            if (netRollArray4[i] != null) {
                netRollArray5[n2++] = netRollArray4[i];
                continue;
            }
            netRollArray[n3++] = netRollArray3[i];
        }
        if (netRollArray.length != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cannot perform ");
            stringBuffer.append(string.toLowerCase());
            stringBuffer.append(" on following rolls:");
            for (n3 = 0; n3 < netRollArray.length; ++n3) {
                stringBuffer.append("\nRollFrom = ");
                stringBuffer.append(netRollArray[n3].getNetElement().getName());
                stringBuffer.append("/");
                stringBuffer.append(NetRoll.slashSeparatedStr(netRollArray[n3].getRollFromCktEnd()));
                stringBuffer.append(", RollTo = ");
                stringBuffer.append(netRollArray[n3].getNetElement().getName());
                stringBuffer.append("/");
                stringBuffer.append(NetRoll.slashSeparatedStr(netRollArray[n3].getRollToCktEnd()));
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ROLL_ERROR_PARAM_1, (Object)stringBuffer.toString());
        }
        return netRollArray5;
    }

    private boolean isSonetType(NetRoll[] netRollArray) {
        NetRoll netRoll = null;
        INodeModel iNodeModel = null;
        for (int i = 0; i < netRollArray.length; ++i) {
            netRoll = netRollArray[i];
            if (netRoll != null) {
                iNodeModel = netRoll.getNodeModel();
            }
            if (iNodeModel == null) continue;
            return iNodeModel.getFramingTypeObj().isSonet();
        }
        return true;
    }

    public void refresh() {
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this.inited) {
            this.rollDataSource.dispose();
            this.rollTableModel.release();
            this.inited = false;
        }
        super.destroy();
    }
}

