/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.ui.circuits.AbstractSdhHoLoPane;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.SdhAu3LoNum;
import java.awt.event.ActionEvent;
import java.util.SortedMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SdhAu3HoLoPane
extends AbstractSdhHoLoPane {
    private SDebug dbg;

    public SdhAu3HoLoPane(SDebug sDebug) {
        super(sDebug);
        this.dbg = sDebug;
    }

    protected void addMoreRows() {
        this.vc4LB = new JLabel("Source VC4");
        this.vc4CB = new JComboBox();
        this.vc4CB.addActionListener(this);
        this.gridPanel.addRow(this.vc4LB, this.vc4CB);
        this.vc3LB = new JLabel("VC3");
        this.vc3CB = new JComboBox();
        this.vc3CB.addActionListener(this);
        this.gridPanel.addRow(this.vc3LB, this.vc3CB);
        this.tug2LB = new JLabel("TUG2");
        this.tug2CB = new JComboBox();
        this.tug2CB.addActionListener(this);
        this.gridPanel.addRow(this.tug2LB, this.tug2CB);
        this.vc11_12LB = new JLabel("VC12");
        this.vc11_12CB = new JComboBox();
        this.gridPanel.addRow(this.vc11_12LB, this.vc11_12CB);
    }

    protected void initCB() {
        this.vc3CB.removeAllItems();
        this.vc3CB.setEnabled(false);
        this.tug2CB.removeAllItems();
        this.tug2CB.setEnabled(false);
        this.vc11_12CB.removeAllItems();
        this.vc11_12CB.setEnabled(false);
    }

    protected JComboBox getHoCB() {
        if (this.circuitSize.getEnum() == 11) {
            return this.vc3CB;
        }
        return this.vc4CB;
    }

    protected void selectHoCB(IHoNum iHoNum) {
        this.vc3CB.setSelectedItem(iHoNum);
    }

    protected void selectLoCB(ILoNum iLoNum) {
        SdhAu3LoNum sdhAu3LoNum = (SdhAu3LoNum)iLoNum;
        this.tug2CB.setSelectedItem(new Integer(sdhAu3LoNum.getGroupNum()));
        if (sdhAu3LoNum.isVc11Num()) {
            this.vc11_12CB.setSelectedItem(new Integer(sdhAu3LoNum.getVc11()));
        } else if (sdhAu3LoNum.isVc12Num()) {
            this.vc11_12CB.setSelectedItem(new Integer(sdhAu3LoNum.getVc12()));
        }
    }

    protected void disableControls() {
        this.vc4CB.setEnabled(false);
        this.vc3CB.setEnabled(false);
        this.tug2CB.setEnabled(false);
        this.vc11_12CB.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getHoCB()) {
            if (this.circuitSize.getEnum() == 9 || this.circuitSize.getEnum() == 10) {
                this.initCB();
            }
        } else if (actionEvent.getSource() == this.tug2CB) {
            if (this.tug2CB.isEnabled() && this.tug2CB.getSelectedIndex() >= 0) {
                Integer n = (Integer)this.tug2CB.getSelectedItem();
                this.vc11_12Map = (SortedMap)this.tug2Map.get(n);
                this.vc11_12CB.setModel(new DefaultComboBoxModel<Object>(this.vc11_12Map.keySet().toArray()));
                this.vc11_12CB.setEnabled(true);
                this.vc11_12CB.setSelectedIndex(0);
            }
            this.addButton.setEnabled(this.vc11_12CB.isEnabled() && this.vc11_12CB.getSelectedIndex() >= 0);
        }
    }

    public void enable(INetLinkSpan iNetLinkSpan) {
        this.setEnabledControls(false);
        this.from.setEnabled(false);
        this.addButton.setEnabled(false);
        this.setNetLink(iNetLinkSpan.getLink());
        this.setUniqueItem(this.getHoCB(), iNetLinkSpan.getSrcHoNum(), true);
        SdhAu3LoNum sdhAu3LoNum = (SdhAu3LoNum)iNetLinkSpan.getLoNum();
        if (sdhAu3LoNum != null) {
            this.setUniqueItem(this.tug2CB, new Integer(sdhAu3LoNum.getTug2()), true);
            this.setUniqueItem(this.vc11_12CB, new Integer(sdhAu3LoNum.getVc11_12()), false);
        }
    }

    public INetLinkSpan getNetLinkSpan() {
        NetLinkSpan netLinkSpan = null;
        if (this.getNetLink() != null) {
            IHoNum iHoNum;
            IHoNum iHoNum2;
            SdhAu3LoNum sdhAu3LoNum = HoLoFactory.createSdhAu3LoNum(this.circuitSize.getEnum(), 0, 0);
            if (this.getNetLink().isLOTunnel()) {
                iHoNum2 = this.getNetLink().getSrcHo();
                iHoNum = this.getNetLink().getDstHo();
            } else {
                iHoNum = iHoNum2 = (IHoNum)this.getHoCB().getSelectedItem();
            }
            if (this.vc11_12CB.getSelectedIndex() == -1) {
                return null;
            }
            if (this.circuitSize != null) {
                sdhAu3LoNum = HoLoFactory.createSdhAu3LoNum(this.circuitSize.getEnum(), (Integer)this.tug2CB.getSelectedItem(), (Integer)this.vc11_12CB.getSelectedItem());
            }
            netLinkSpan = new NetLinkSpan(this.getNetLink(), this.cktMap.findReverseLink(this.getNetLink()), iHoNum2, iHoNum, (ILoNum)sdhAu3LoNum);
        }
        return netLinkSpan;
    }
}

