/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndComparator;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AbstractSdhCcdEndpointPanel;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SdhAu4LoNum;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SdhAu4CcdEndpointPanel
extends AbstractSdhCcdEndpointPanel {
    protected JLabel vc4LB;
    protected JComboBox vc4CB;
    protected List vc3LoParts;
    private NetCircuitEndComparator comp = new NetCircuitEndComparator();

    public SdhAu4CcdEndpointPanel(String string, AbstractCircuitDialog abstractCircuitDialog, CcdEndpointsPane ccdEndpointsPane) {
        super(string, abstractCircuitDialog, ccdEndpointsPane);
    }

    protected void reset() {
        super.reset();
        this.resetLoNum();
    }

    protected void resetLoNum() {
        this.loNum = null;
        this.vc11_12 = null;
        this.tug2 = null;
        this.vc3 = null;
    }

    protected void setLoComponents(ILoNum iLoNum) {
        if (iLoNum == null) {
            db.fine("LoNum is null for 'setLoComponents'");
            return;
        }
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iLoNum;
        this.vc3CB.setSelectedItem(new Integer(sdhAu4LoNum.getVc3()));
        if (!sdhAu4LoNum.isVc3Num()) {
            this.tug2CB.setSelectedItem(new Integer(sdhAu4LoNum.getTug2()));
            this.vc11_12CB.setSelectedItem(new Integer(sdhAu4LoNum.getVc11_12()));
        }
    }

    protected void addComponents(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridheight = 1;
        this.vc4LB = new JLabel("VC4:", 4);
        this.vc4CB = this.addCB(this.vc4LB, "vc4CB", gridBagConstraints);
        this.vc3LB = new JLabel("VC3:", 4);
        this.vc3CB = this.addCB(this.vc3LB, "vc3CB", gridBagConstraints);
        this.tug2LB = new JLabel("TUG2:", 4);
        this.tug2CB = this.addCB(this.tug2LB, "tug2CB", gridBagConstraints);
        this.vc11_12LB = new JLabel("", 4);
        this.vc11_12CB = this.addCB(this.vc11_12LB, "vc11_12CB", gridBagConstraints);
        this.hoParts.add(this.vc4CB);
        this.vc3LoParts = new ArrayList();
        this.vc11_12LoParts = new ArrayList();
        this.vc3LoParts.add(this.vc3LB);
        this.vc3LoParts.add(this.vc3CB);
        this.vc11_12LoParts.add(this.tug2LB);
        this.vc11_12LoParts.add(this.tug2CB);
        this.vc11_12LoParts.add(this.vc11_12LB);
        this.vc11_12LoParts.add(this.vc11_12CB);
        this.loParts.addAll(this.vc3LoParts);
        this.loParts.addAll(this.vc11_12LoParts);
    }

    protected List getLoParts() {
        if (this.loParts.size() == 0) {
            if (this.vc3LoParts.size() == 0) {
                this.vc3LoParts.add(this.vc3LB);
                this.vc3LoParts.add(this.vc3CB);
            }
            if (this.vc11_12LoParts.size() == 0) {
                this.vc11_12LoParts.add(this.tug2LB);
                this.vc11_12LoParts.add(this.tug2CB);
                this.vc11_12LoParts.add(this.vc11_12LB);
                this.vc11_12LoParts.add(this.vc11_12CB);
            }
            this.loParts.addAll(this.vc3LoParts);
            this.loParts.addAll(this.vc11_12LoParts);
        }
        return this.loParts;
    }

    protected void setLoNumsFromEndpoint() {
        super.setLoNumsFromEndpoint();
        if (this.loNum == null) {
            this.vc11_12 = null;
            this.tug2 = null;
            this.vc3 = null;
        } else {
            this.vc3 = new Integer(((SdhAu4LoNum)this.loNum).getVc3());
            if (((SdhAu4LoNum)this.loNum).isVc3Num()) {
                this.vc11_12 = null;
                this.tug2 = null;
            } else {
                this.tug2 = new Integer(((SdhAu4LoNum)this.loNum).getTug2());
                this.vc11_12 = new Integer(((SdhAu4LoNum)this.loNum).getVc11_12());
            }
        }
    }

    protected void setLoComponentsFromEndpoint() {
        this.setCBList(this.vc3CB, this.vc3 != null ? Collections.singleton(this.vc3) : null);
        this.vc3CB.setSelectedItem(this.vc3);
        this.setCBList(this.tug2CB, this.tug2 != null ? Collections.singleton(this.tug2) : null);
        this.tug2CB.setSelectedItem(this.tug2);
        this.setCBList(this.vc11_12CB, this.vc11_12 != null ? Collections.singleton(this.vc11_12) : null);
        this.vc11_12CB.setSelectedItem(this.vc11_12);
    }

    protected JComboBox getHoCB() {
        return this.vc4CB;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        block26: {
            Object object;
            block28: {
                block27: {
                    block25: {
                        object = actionEvent.getSource();
                        if (object != this.portCB) break block25;
                        SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
                        if (this.isNull(sortablePortString, "newPort")) {
                            return;
                        }
                        if (db.on()) {
                            db.println(this.title + " actionPerformed: port " + this.port + " -> " + sortablePortString);
                        }
                        this.port = sortablePortString;
                        try {
                            this.setEntity((IEntityModel)this.portMap.get(this.port));
                        }
                        catch (AnnotatedException annotatedException) {
                            if (db.on()) {
                                db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                            }
                            this.clearEntity(annotatedException, false);
                        }
                        break block26;
                    }
                    if (object != this.vc4CB) break block27;
                    IHoNum iHoNum = (IHoNum)this.vc4CB.getSelectedItem();
                    if (this.isNull(iHoNum, "newVc4")) {
                        return;
                    }
                    if (db.on()) {
                        db.println(this.title + " actionPerformed: vc4 " + this.hoNum + " -> " + iHoNum);
                    }
                    this.hoNum = iHoNum;
                    this.endpoint.setHoNum(this.hoNum);
                    Object v = this.endpointMap.get(this.hoNum);
                    if (this.isNull(v, "endpointMap value for VC4 " + this.hoNum.toString())) {
                        return;
                    }
                    if (v instanceof INetCircuitEnd) break block26;
                    if (v instanceof SortedMap) {
                        this.setCBList(this.tug2CB, null);
                        this.setCBList(this.vc11_12CB, null);
                        this.vc3Map = (SortedMap)v;
                        this.setCBList(this.vc3CB, this.vc3Map.keySet());
                        if (this.vc3Map.size() == 1) {
                            this.vc3CB.setSelectedItem(this.vc3Map.firstKey());
                            this.vc3CB.setEnabled(false);
                        }
                        break block26;
                    } else {
                        if (db.on()) {
                            db.fine(this.title + " actionPerformed: endpointMap value " + "has wrong class: " + v.getClass().toString());
                        }
                        return;
                    }
                }
                if (object != this.vc3CB) break block28;
                Integer n = (Integer)this.vc3CB.getSelectedItem();
                if (this.isNull(n, "newVc3")) {
                    return;
                }
                n = (Integer)this.getValidSelectedItem(this.vc3CB, n);
                if (db.on()) {
                    db.println(this.title + " actionPerformed: vc3 " + this.vc3 + " -> " + n);
                }
                this.vc3 = n;
                if (this.getCircuitInfoSize() == 11) {
                    this.loNum = HoLoFactory.createVc3LoNum(this.vc3);
                    this.endpoint.setLoNum(this.loNum);
                    break block26;
                } else {
                    this.setCBList(this.vc11_12CB, null);
                    this.tug2Map = (SortedMap)this.vc3Map.get(this.vc3);
                    this.setCBList(this.tug2CB, this.tug2Map.keySet());
                    if (this.tug2Map.size() == 1) {
                        this.tug2CB.setSelectedItem(this.tug2Map.firstKey());
                        this.tug2CB.setEnabled(false);
                    }
                }
                break block26;
            }
            if (object == this.tug2CB) {
                Integer n = (Integer)this.tug2CB.getSelectedItem();
                if (this.isNull(n, "newTug2")) {
                    return;
                }
                n = (Integer)this.getValidSelectedItem(this.tug2CB, n);
                if (db.on()) {
                    db.println(this.title + " actionPerformed: tug2 " + this.tug2 + " -> " + n);
                }
                this.tug2 = n;
                this.vc11_12Map = (SortedMap)this.tug2Map.get(this.tug2);
                this.setCBList(this.vc11_12CB, this.vc11_12Map.keySet());
                if (this.vc11_12Map.size() == 1) {
                    this.vc11_12CB.setSelectedItem(this.vc11_12Map.firstKey());
                    this.vc11_12CB.setEnabled(false);
                }
            } else if (object == this.vc11_12CB) {
                Integer n = (Integer)this.vc11_12CB.getSelectedItem();
                if (this.isNull(n, "newVc11_12")) {
                    return;
                }
                n = (Integer)this.getValidSelectedItem(this.vc11_12CB, n);
                if (db.on()) {
                    db.println(this.title + " actionPerformed: vc11_12 " + this.vc11_12 + " -> " + n);
                }
                this.vc11_12 = n;
                this.loNum = HoLoFactory.createSdhAu4LoNum(this.getCircuitInfoSize(), this.vc3, this.tug2, this.vc11_12);
                this.endpoint.setLoNum(this.loNum);
            }
        }
        super.actionPerformed(actionEvent);
    }

    protected boolean useDs1EndpointAsPort(IEntityModel iEntityModel) {
        if (super.useDs1EndpointAsPort(iEntityModel)) {
            return true;
        }
        int n = this.getCircuitInfoSize();
        if (iEntityModel == null || this.parent != null && this.getPortGrouping()) {
            return false;
        }
        return n == 11 && this.isE3_DS3Card(iEntityModel) || n == 10 && this.isE1Card(iEntityModel);
    }

    protected void localRefresh(ICircuitType iCircuitType, int n) {
        if (!iCircuitType.isLoCircuitType() && !iCircuitType.isLoVcatCircuitType()) {
            this.endpoint.setLoNum(null);
            this.vc11_12 = null;
            this.tug2 = null;
            this.vc3 = null;
            SdhAu4CcdEndpointPanel.setComponentsVisible(this.loParts, false);
        } else {
            SdhAu4CcdEndpointPanel.setComponentsVisible(this.vc3LoParts, true);
            if (n == 11) {
                this.vc11_12 = null;
                this.tug2 = null;
                this.vc3LB.setText("VC3:");
                SdhAu4CcdEndpointPanel.setComponentsVisible(this.vc11_12LoParts, false);
            } else {
                this.vc3LB.setText("TUG3:");
                SdhAu4CcdEndpointPanel.setComponentsVisible(this.vc11_12LoParts, true);
                if (n == 9) {
                    this.vc11_12LB.setText("VC11:");
                } else {
                    this.vc11_12LB.setText("VC12:");
                }
            }
        }
    }

    protected void setLoNumsFromDropPoints() {
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)this.loNum;
        this.vc3 = new Integer(sdhAu4LoNum.getVc3());
        if (!sdhAu4LoNum.isVc3Num()) {
            this.tug2 = new Integer(sdhAu4LoNum.getTug2());
            this.vc11_12 = new Integer(sdhAu4LoNum.getVc11_12());
        } else {
            this.vc11_12 = null;
            this.tug2 = null;
        }
    }

    protected void setPortGroupingUI(boolean bl) {
        if (bl) {
            this.portLB.setVisible(false);
            this.portCB.setVisible(false);
            this.vc4LB.setText("Port Group:");
        } else {
            this.portLB.setVisible(true);
            this.portCB.setVisible(true);
            this.vc4LB.setText("VC4:");
        }
    }

    protected void putInLoMap(SortedMap sortedMap, INetCircuitEnd iNetCircuitEnd) {
        if (this.getCircuitInfoType() != 5 && this.getCircuitInfoType() != 13) {
            throw new IllegalArgumentException("The circuit type should be VC_LO_CIRCUIT");
        }
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iNetCircuitEnd.getLoNum();
        if (sdhAu4LoNum != null) {
            Integer n = new Integer(sdhAu4LoNum.getVc3());
            if (sdhAu4LoNum.getCorrespondingCircuitSize() != this.getCircuitInfoSize()) {
                throw new IllegalArgumentException("The circuit size doesn't match");
            }
            if (sdhAu4LoNum.isVc3Num()) {
                sortedMap.put(n, iNetCircuitEnd);
            } else {
                TreeMap<Integer, INetCircuitEnd> treeMap;
                Integer n2 = new Integer(sdhAu4LoNum.getTug2());
                Integer n3 = new Integer(sdhAu4LoNum.getVc11_12());
                TreeMap<Integer, TreeMap<Integer, INetCircuitEnd>> treeMap2 = (TreeMap<Integer, TreeMap<Integer, INetCircuitEnd>>)sortedMap.get(n);
                if (treeMap2 == null) {
                    treeMap2 = new TreeMap<Integer, TreeMap<Integer, INetCircuitEnd>>();
                    sortedMap.put(n, treeMap2);
                }
                if ((treeMap = (TreeMap<Integer, INetCircuitEnd>)treeMap2.get(n2)) == null) {
                    treeMap = new TreeMap<Integer, INetCircuitEnd>();
                    treeMap2.put(n2, treeMap);
                }
                treeMap.put(n3, iNetCircuitEnd);
            }
        }
    }

    protected boolean inLoMap(SortedMap sortedMap, ILoNum iLoNum) {
        if (sortedMap == null) {
            return false;
        }
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iLoNum;
        Integer n = new Integer(sdhAu4LoNum.getVc3());
        if (sdhAu4LoNum.isVc3Num()) {
            return sortedMap.get(n) != null;
        }
        SortedMap sortedMap2 = (SortedMap)sortedMap.get(n);
        Integer n2 = new Integer(sdhAu4LoNum.getTug2());
        Integer n3 = new Integer(sdhAu4LoNum.getVc11_12());
        SortedMap sortedMap3 = (SortedMap)sortedMap2.get(n2);
        if (sortedMap3 == null) {
            return false;
        }
        return sortedMap3.containsKey(n3);
    }

    protected ILoNum getFirstLoFromLoMap(SortedMap sortedMap, int n) {
        Integer n2 = (Integer)sortedMap.firstKey();
        if (sortedMap.get(n2) instanceof SortedMap) {
            SortedMap sortedMap2 = (SortedMap)sortedMap.get(n2);
            Integer n3 = (Integer)sortedMap2.firstKey();
            SortedMap sortedMap3 = (SortedMap)sortedMap2.get(n3);
            Integer n4 = (Integer)sortedMap3.firstKey();
            return HoLoFactory.createSdhAu4LoNum(n, n2, n3, n4);
        }
        return HoLoFactory.createVc3LoNum(n2);
    }

    public void recycle() {
        super.recycle();
        this.vc11_12Map = null;
        this.tug2Map = null;
        this.vc3Map = null;
        if (this.vc4CB != null) {
            this.vc4CB.removeActionListener(this);
        }
        if (this.vc3CB != null) {
            this.vc3CB.removeActionListener(this);
        }
        if (this.tug2CB != null) {
            this.tug2CB.removeActionListener(this);
        }
        if (this.vc11_12CB != null) {
            this.vc11_12CB.removeActionListener(this);
        }
    }

    protected boolean fullySelected() {
        if (!super.fullySelected()) {
            return false;
        }
        if (!(this.getCircuitInfoType() != 5 && this.getCircuitInfoType() != 13 || this.isEther)) {
            if (this.vc3CB.getSelectedItem() == null) {
                return false;
            }
            if (this.getCircuitInfoSize() != 11 && this.vc11_12CB.getSelectedItem() == null) {
                return false;
            }
        }
        return true;
    }

    protected void debugEndpoint(String string) {
        super.debugEndpoint(string);
        if (db.on()) {
            if (this.endpoint.getHoNum() != null) {
                db.println(string + "vc4 = " + this.endpoint.getHoNum().toString());
            }
            if ((SdhAu4LoNum)this.endpoint.getLoNum() != null) {
                SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)this.endpoint.getLoNum();
                db.println(string + sdhAu4LoNum.prettyString());
            }
        }
    }

    protected IHoLoNum getNextHoLoNum(IHoLoNum iHoLoNum, IEntityModel iEntityModel) {
        if (iEntityModel.getEqType() == 83 || iEntityModel.getEqType() == 64 || iEntityModel.getEqType() == 108 || iEntityModel.getEqType() == 109) {
            IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
            return HoLoFactory.addGroupOffset(iHoLoNum2, 1);
        }
        return super.getNextHoLoNum(iHoLoNum, iEntityModel);
    }
}

