/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TablePrintRegionDialog;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.OchncSpanCircuitsPane;
import cerent.cms.ui.circuits.SpanCircuitsPane;
import cerent.util.BusEvent;
import cerent.util.EventBus;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.ComponentPrinter;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.TablePrintPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.Printable;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SpanCircuitsDialog
extends TablePrintPane
implements Observer {
    public static final String CLOSE = "Close";
    private JButton closeButton;
    private AbstractPane pane;
    private static final String PREF = "ctc.SpanCircuitsDialog";
    private static final String XPOS = "x";
    private static final String YPOS = "y";
    private static final String WIDTH = "w";
    private static final String HEIGHT = "h";
    private static final Dimension INIT_DIM = new Dimension(500, 400);
    private static HashMap allSpanCircuitFrames = new HashMap();
    private String linkName;
    private INetLink netLink;
    private static final SDebug db = new SDebug("SpanCircuitsDialog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpanCircuitsDialog instance(JComponent jComponent, INetLink iNetLink, String string) {
        SpanCircuitsDialog spanCircuitsDialog;
        String string2 = "Circuits on Span " + string;
        HashMap hashMap = allSpanCircuitFrames;
        synchronized (hashMap) {
            spanCircuitsDialog = (SpanCircuitsDialog)allSpanCircuitFrames.get(string);
            if (spanCircuitsDialog == null) {
                spanCircuitsDialog = new SpanCircuitsDialog(string2, iNetLink, string);
            }
        }
        allSpanCircuitFrames.put(string, spanCircuitsDialog);
        try {
            Preferences preferences = Preferences.instance();
            int n = preferences.getInt(PREF, XPOS, -1);
            int n2 = preferences.getInt(PREF, YPOS, 0);
            int n3 = preferences.getInt(PREF, WIDTH, SpanCircuitsDialog.INIT_DIM.width);
            int n4 = preferences.getInt(PREF, HEIGHT, SpanCircuitsDialog.INIT_DIM.height);
            if (n == -1) {
                spanCircuitsDialog.setSize(new Dimension(n3, n4));
            } else {
                spanCircuitsDialog.setBounds(n, n2, n3, n4);
            }
        }
        catch (Exception exception) {
            spanCircuitsDialog.setSize(INIT_DIM);
        }
        return spanCircuitsDialog;
    }

    private SpanCircuitsDialog(String string, INetLink iNetLink, String string2) {
        super(null, string);
        this.initContentPane(iNetLink);
        this.linkName = string2;
        this.netLink = iNetLink;
        EventBus.instance().addObserver((Observer)this, (Object)"BLSR_CREATED_ON_PORT");
        EventBus.instance().addObserver((Observer)this, (Object)"BLSR_DELETED_ON_PORT");
        EventBus.instance().addObserver((Observer)this, (Object)"UNPROTECTED_LINE_CREATED_ON_PORT");
        EventBus.instance().addObserver((Observer)this, (Object)"UNPROTECTED_LINE_DELETED_ON_PORT");
        EventBus.instance().addObserver((Observer)this, (Object)"ONE_PLUS_ONE_CREATED_ON_PORT");
        EventBus.instance().addObserver((Observer)this, (Object)"ONE_PLUS_ONE_DELETED_ON_PORT");
        this.setLink(iNetLink);
    }

    protected void initContentPane(INetLink iNetLink) {
        Container container = this.getContentPane();
        container.add((Component)this.getCircuitTable(iNetLink), "Center");
    }

    private JComponent getCircuitTable(INetLink iNetLink) {
        this.pane = iNetLink instanceof DwdmNetLink || iNetLink instanceof VirtualNetLink ? new OchncSpanCircuitsPane() : new SpanCircuitsPane();
        JTable jTable = this.pane.getTable();
        if (jTable != null) {
            this.setTable(jTable);
            this.initAdapter(jTable);
        } else {
            db.println("The Span Circuits Pane table is null!");
        }
        return this.pane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Cloneable cloneable;
        EventBus.instance().deleteObserver((Observer)this);
        if (this.pane != null) {
            this.pane.destroy();
            this.pane = null;
        }
        if (allSpanCircuitFrames != null) {
            cloneable = allSpanCircuitFrames;
            synchronized (cloneable) {
                allSpanCircuitFrames.remove(this.linkName);
            }
        }
        cloneable = this.getBounds();
        Preferences preferences = Preferences.instance();
        preferences.setProperty(PREF, XPOS, Integer.toString(((Rectangle)cloneable).x));
        preferences.setProperty(PREF, YPOS, Integer.toString(((Rectangle)cloneable).y));
        preferences.setProperty(PREF, WIDTH, Integer.toString(((Rectangle)cloneable).width));
        preferences.setProperty(PREF, HEIGHT, Integer.toString(((Rectangle)cloneable).height));
        this.getContentPane().removeAll();
        this.getRootPane().removeAll();
        this.removeAll();
        super.dispose();
    }

    public void hide() {
        this.forceRepaint();
        super.hide();
    }

    private void forceRepaint() {
        Point point = this.getLocation();
        this.setLocation(point.x + 1, point.y + 1);
        this.setLocation(point.x, point.y);
    }

    private void setLink(INetLink iNetLink) {
        if (iNetLink instanceof DwdmNetLink || iNetLink instanceof VirtualNetLink) {
            ((OchncSpanCircuitsPane)this.pane).setLink(iNetLink);
        } else {
            ((SpanCircuitsPane)this.pane).setLink(iNetLink);
        }
    }

    protected Printable getPrintableObject() {
        TablePrintRegionDialog tablePrintRegionDialog = new TablePrintRegionDialog(null, "PRINT", true, false, this.getTable());
        tablePrintRegionDialog.pack();
        int n = tablePrintRegionDialog.showDialog();
        if (n == 0) {
            int n2 = tablePrintRegionDialog.getPrintRegionSelection();
            if (n2 == 0) {
                return new ComponentPrinter((Component)this);
            }
            if (n2 == 1) {
                return null;
            }
            return this.getTableContentPrinter();
        }
        return null;
    }

    protected void initAdapter(JTable jTable) {
        class SpanCircuitTableAdapter
        extends TableModelAdapter {
            private final /* synthetic */ JTable val$myTable;

            SpanCircuitTableAdapter(TableModel tableModel, JTable jTable, JTable jTable2) {
                this.val$myTable = jTable2;
                super(tableModel, jTable);
            }

            public String getColumnName(int n) {
                return this.val$myTable.getColumnName(n);
            }

            public Object getValueAt(int n, int n2) {
                Object object = this.val$myTable.getValueAt(n, n2);
                String string = object != null ? object.toString() : "<null>";
                TableCellRenderer tableCellRenderer = this.val$myTable.getCellRenderer(n, n2);
                try {
                    Component component = this.val$myTable.getCellRenderer(n, n2).getTableCellRendererComponent(this.val$myTable, object, false, false, n, n2);
                    if (component instanceof JLabel) {
                        JLabel jLabel = (JLabel)component;
                        if (jLabel.getText() != null) {
                            string = jLabel.getText() + " " + (this.val$myTable.getColumnName(n2).equals("Circuit") ? CircuitColumnRenderer.getStateStringFromColor(jLabel.getBackground()) : "");
                        } else {
                            Icon icon = jLabel.getIcon();
                            if (icon != null && icon instanceof ImageIcon) {
                                ImageIcon imageIcon = (ImageIcon)icon;
                                string = imageIcon.getDescription();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    db;
                    SDebug.printStackTrace((Throwable)exception);
                }
                return string;
            }
        }
        this.setAdapter(new SpanCircuitTableAdapter(jTable.getModel(), jTable, jTable));
    }

    public void update(Observable observable, Object object) {
        if (SpanCircuitsDialog.db.on) {
            db.finest("from: " + observable);
            db.finest("arg: " + object);
        }
        if (object instanceof BusEvent) {
            BusEvent busEvent = (BusEvent)object;
            Object object2 = busEvent.getSource();
            Object object3 = busEvent.getEvent();
            if (SpanCircuitsDialog.db.on) {
                db.finest("busEventSource is: " + object2);
                db.finest("busEventEvent is: " + object3);
            }
            if (object2 instanceof String) {
                String string = (String)object2;
                if (string.equals("BLSR_CREATED_ON_PORT") || string.equals("BLSR_DELETED_ON_PORT") || string.equals("ONE_PLUS_ONE_CREATED_ON_PORT") || string.equals("ONE_PLUS_ONE_DELETED_ON_PORT") || string.equals("UNPROTECTED_LINE_CREATED_ON_PORT") || string.equals("UNPROTECTED_LINE_DELETED_ON_PORT")) {
                    boolean bl = false;
                    IEntityModel iEntityModel = (IEntityModel)object3;
                    INodeModel iNodeModel = Network.instance().getNodeModel(iEntityModel.getNodeModel().getNodeId());
                    int n = iEntityModel.getIndex();
                    if (this.netLink.getSrc().getNodeModel().equals(iNodeModel)) {
                        if (this.netLink.getSrcEntityIndex() == n) {
                            if (SpanCircuitsDialog.db.on) {
                                db.println("Hit!  The Src of this netlink is gone! Close window now!!!");
                            }
                            bl = true;
                        } else if (SpanCircuitsDialog.db.on) {
                            db.finest("Src node is same, but index is different.");
                        }
                    } else if (this.netLink.getDst().getNodeModel().equals(iNodeModel)) {
                        if (this.netLink.getDstEntityIndex() == n) {
                            if (SpanCircuitsDialog.db.on) {
                                db.println("Hit!  The Dst of this netlink is gone! Close window now!!!");
                            }
                            bl = true;
                        } else if (SpanCircuitsDialog.db.on) {
                            db.finest("Dst node is same, but index is different.");
                        }
                    }
                    if (bl) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SpanCircuitsDialog.this.setVisible(false);
                                SpanCircuitsDialog.this.dispose();
                            }
                        });
                    }
                } else if (SpanCircuitsDialog.db.on) {
                    db.finest("busEventSource is a String - but not what we expected: " + object2);
                }
            } else if (SpanCircuitsDialog.db.on) {
                db.finest("busEventSource is not a String");
            }
        }
    }
}

