/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.FramingType;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.SpanDataSource;
import cerent.cms.model.circuits.SpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.ProtectionSwitchError;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitEditDialog;
import cerent.cms.ui.circuits.SpanColumnRenderer;
import cerent.util.ErrorMsg;
import cerent.util.IAsyncObserver;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowTableModel;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class SpanCircuitsPane
extends AbstractPane
implements ActionListener,
MouseListener,
PropertyChangeListener,
IAsyncObserver {
    public String UPSR_TERM;
    public String SWITCH;
    public static final String APPLY = "Apply";
    RowTableModel model;
    SpanDataSource source;
    private JComboBox swTypeCB;
    private JButton applyPB;
    private JPanel switchPanel;
    ImageIcon INFO_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/informational32.gif"));
    private ColumnRenderer[] upsrRenderers;
    private ColumnRenderer[] nonUpsrRenderers;
    private static final SDebug db = new SDebug("SpanCircuitsPane");

    public SpanCircuitsPane() {
        super("SpanCircuitsPane", (IModel)NetworkModel.instance().getCmsHostModel(), null);
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        CircuitColumnRenderer.loadColors();
        INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel().getNodeModel();
        int n = iNodeModel.getFramingType();
        this.UPSR_TERM = iNodeModel.getTDMTerminology().getRingTerms(0);
        this.SWITCH = "Perform " + this.UPSR_TERM + " span switching: ";
        this.upsrRenderers = SpanColumnRenderer.createTableRenderers(0, n, true);
        this.nonUpsrRenderers = SpanColumnRenderer.createTableRenderers(0, n, false);
        this.source = new SpanDataSource(this);
        this.model = new RowTableModel((RowDataSource)this.source, this.nonUpsrRenderers);
        this.table = new UTable((TableModel)this.model);
        this.model.initTable(this.table);
        this.initPane();
        this.table.addMouseListener(this);
        if (!FramingType.getFramingType((int)n).isSonet()) {
            this.setSize(this.getWidth() + 100, this.getHeight());
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void initPane() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        this.switchPanel = this.getButtonBar();
        jPanel2.add(this.switchPanel);
        this.switchPanel.setVisible(false);
        jPanel3.add(new CSHelpButton(NetCSHelpConst.SpanCircuitsPane));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        this.add(jPanel, "South");
    }

    public void setLink(INetLink iNetLink) {
        this.source.setNetLink(iNetLink);
    }

    public void showUpsrObjects(boolean bl) {
        this.switchPanel.setVisible(bl);
        if (bl) {
            this.model.setColumnRenderers(this.upsrRenderers);
        } else {
            this.model.setColumnRenderers(this.nonUpsrRenderers);
        }
    }

    protected void setApplyButtonEnabled(int n) {
        int n2 = 4;
        int n3 = this.source.getRowCount();
        for (int i = 0; i < n3; ++i) {
            int n4;
            SpanRow spanRow = (SpanRow)this.source.getObjectAtRow(i);
            INetCircuitSpan iNetCircuitSpan = spanRow.span;
            if (iNetCircuitSpan == null || !iNetCircuitSpan.isUpsr() || (n4 = iNetCircuitSpan.getProtectionOp()) >= n2) continue;
            n2 = n4;
        }
        if (n2 == 1 && n == 1) {
            this.applyPB.setEnabled(false);
        } else if (n2 == 3 && (n == 1 || n == 3)) {
            this.applyPB.setEnabled(false);
        } else if (n2 == 4 && n != 0) {
            this.applyPB.setEnabled(false);
        } else {
            this.applyPB.setEnabled(true);
        }
    }

    private boolean displaySwitchDialog(int n) {
        String string = "Traffic may not switch away from this span.  Verify\nproper switch of traffic prior to performing potential\nservice affecting work on this span.\n\nOK to continue?\n";
        String string2 = "Lockout of protection does not switch traffic off \nthis span.  It disables " + this.UPSR_TERM + " protection \n" + "and should be applied for a limited time only.\n\n" + "OK to continue?\n";
        return n != 0 && n != 4 ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)("Confirm " + this.UPSR_TERM + " switch")) : (n == 4 ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)("Confirm " + this.UPSR_TERM + " switch")) : CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure?\n", (String)("Confirm " + this.UPSR_TERM + " switch")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = -1;
        Object object = actionEvent.getSource();
        Attribute attribute = (Attribute)this.swTypeCB.getSelectedItem();
        if (attribute != null) {
            n = attribute.getValue();
            if (object == this.swTypeCB) {
                this.setApplyButtonEnabled(n);
            } else if (object == this.applyPB && this.displaySwitchDialog(n)) {
                ArrayList arrayList = new ArrayList(this.source.getAllObjects());
                this.switchCircuits(arrayList, n);
                this.swTypeCB.setSelectedItem(null);
            }
        }
    }

    private void switchCircuits(List list, int n) {
        int n2 = n;
        String string = NetworkDefaults.spanProtectionOPToString(n2);
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        LinkedList<INetCircuitSpan> linkedList = new LinkedList<INetCircuitSpan>();
        INetCircuitSpan[] iNetCircuitSpanArray = list.iterator();
        while (iNetCircuitSpanArray.hasNext()) {
            SpanRow spanRow = (SpanRow)iNetCircuitSpanArray.next();
            if (spanRow.circuit == null || spanRow.span == null || !spanRow.span.isUpsr()) continue;
            linkedList.add(spanRow.span);
        }
        if (linkedList.size() > 0) {
            iNetCircuitSpanArray = new INetCircuitSpan[]{};
            iNetCircuitSpanArray = linkedList.toArray(iNetCircuitSpanArray);
            try {
                NetCircuitManager.instance().performProtectionOp(iNetCircuitSpanArray, n2, string, this);
            }
            catch (ProtectionSwitchError protectionSwitchError) {
                String string4 = "Failed to apply " + string + " request.";
                SDebug.printStackTrace((Throwable)protectionSwitchError);
                ErrorMsg.displayError((Component)((Object)this), NEMC.EID_FAILED_TO_APPLY_UPSR_REQUEST_PARAM_2, this.UPSR_TERM, string4);
            }
        } else {
            CerentDialog.infoDialog((Component)((Object)this), (String)("No " + this.UPSR_TERM + "-protected circuits on this span"), (String)("No " + string + " request applied"));
        }
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        final String string = (String)object;
        final String string2 = (String)jobStatus.getResult();
        Runnable runnable = new Runnable(){

            public void run() {
                DetailedDialog detailedDialog = DetailedDialog.instance((Frame)new JFrame(), (String)"Protection Switch Result");
                detailedDialog.setText(string, SpanCircuitsPane.this.INFO_ICON);
                detailedDialog.append(string2);
                detailedDialog.show();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        this.model.release();
        this.model = null;
        this.source.dispose();
        this.source = null;
        super.destroy();
    }

    public void enteringPage() throws Exception {
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
    }

    private JPanel getButtonBar() {
        this.swTypeCB = new JComboBox<Attribute>(NetworkDefaults.getAttributeMap().getAttributeArray("spanProtectionOp"));
        this.swTypeCB.setSelectedItem(null);
        this.swTypeCB.addActionListener(this);
        this.enableComponent(this.swTypeCB);
        this.applyPB = new JButton(APPLY);
        this.applyPB.addActionListener(this);
        this.applyPB.setAlignmentY(0.5f);
        this.applyPB.setEnabled(false);
        JPanel jPanel = SpanCircuitsPane.createHorizontalPanel(null);
        jPanel.add(new JLabel(this.SWITCH));
        jPanel.add(this.swTypeCB);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.applyPB);
        return jPanel;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            SpanRow spanRow = (SpanRow)this.source.getObjectAtRow(n);
            INetCircuit iNetCircuit = spanRow.circuit;
            if (iNetCircuit != null) {
                CircuitEditDialog.instance(iNetCircuit).show();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CircuitColumnRenderer.loadColors();
        this.table.repaint();
    }
}

